/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.MolfileParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.UniqueStringList;
import com.actelion.research.chem.io.CompoundFileParser;
import com.actelion.research.io.BOMSkipper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class SDFileParser
extends CompoundFileParser {
    private static final int DEFAULT_RECORDS_TO_INSPECT = 10240;
    private static final String[] cIDFieldNames = new String[]{"Idorsia No", "Actelion No", "ID", "IDNUMBER", "COMPOUND_ID", "NAME", "COMPND"};
    public static final String cNewLineString = "\n";
    private StringBuilder mMolfileBuffer;
    private StringBuilder mDataBuffer;
    private StereoMolecule mMol;
    private String[] mFieldName;
    private String[] mFieldData;
    private int mNoOfRecords = -1;
    private int mIDFieldIndex;

    public SDFileParser(String string) {
        this(string, null);
    }

    public SDFileParser(String string, String[] stringArray) {
        this.mFieldName = stringArray;
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            BOMSkipper.skip(this.mReader);
        }
        catch (IOException iOException) {
            this.mReader = null;
        }
        this.init();
    }

    public SDFileParser(File file) {
        this(file, null);
    }

    public SDFileParser(File file, String[] stringArray) {
        this.mFieldName = stringArray;
        try {
            this.mReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BOMSkipper.skip(this.mReader);
        }
        catch (IOException iOException) {
            this.mReader = null;
        }
        this.init();
    }

    public SDFileParser(Reader reader) {
        this(reader, null);
    }

    public SDFileParser(Reader reader, String[] stringArray) {
        this.mFieldName = stringArray;
        this.mReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.init();
    }

    private void init() {
        this.mMolfileBuffer = new StringBuilder(10240);
        this.mDataBuffer = new StringBuilder(10240);
    }

    private void extractAllFieldNames(int n) {
        int n2 = 0;
        UniqueStringList uniqueStringList = new UniqueStringList();
        while (n2 < n) {
            String string;
            String string2;
            try {
                string2 = this.mReader.readLine();
            }
            catch (IOException iOException) {
                if (n2 >= n) break;
                this.mNoOfRecords = n2;
                break;
            }
            if (string2 == null) {
                if (n2 >= n) break;
                this.mNoOfRecords = n2;
                break;
            }
            if (string2.startsWith("$$$$")) {
                ++n2;
            }
            if (!string2.startsWith(">") || (string = this.extractFieldName(string2)) == null) continue;
            uniqueStringList.addString(string);
        }
        try {
            this.mReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mFieldName = uniqueStringList.toArray();
    }

    @Override
    public int getRowCount() {
        return this.mNoOfRecords;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean advanceToNext() {
        String string;
        if (this.mReader == null) {
            return false;
        }
        this.mMolfileBuffer.setLength(0);
        this.mDataBuffer.setLength(0);
        this.mMol = null;
        boolean bl = false;
        int n = -1;
        String string2 = null;
        this.mFieldData = this.mFieldName == null ? null : new String[this.mFieldName.length];
        this.mIDFieldIndex = -1;
        block2: do {
            block14: {
                try {
                    string = this.mReader.readLine();
                    if (string == null) {
                        this.mMolfileBuffer.setLength(0);
                        this.mReader.close();
                        return false;
                    }
                }
                catch (IOException iOException) {
                    this.mMolfileBuffer.setLength(0);
                    return false;
                }
                if (!bl) {
                    if (string.startsWith(">")) {
                        bl = true;
                        this.mMolfileBuffer.append("M  END");
                        this.mMolfileBuffer.append('\n');
                        this.mDataBuffer.append(string);
                        this.mDataBuffer.append('\n');
                        break block14;
                    } else {
                        this.mMolfileBuffer.append(string);
                        this.mMolfileBuffer.append('\n');
                        if (!string.startsWith("M  END")) continue;
                        bl = true;
                        continue;
                    }
                }
                this.mDataBuffer.append(string);
                this.mDataBuffer.append('\n');
            }
            if (this.mFieldName == null) continue;
            if (string.length() == 0) {
                n = -1;
                continue;
            }
            if (n == -1) {
                string2 = this.extractFieldName(string);
                if (string2 == null) continue;
                n = -1;
            } else {
                if (this.mFieldData[n] == null) {
                    this.mFieldData[n] = string;
                    continue;
                }
                this.mFieldData[n] = this.mFieldData[n].concat(cNewLineString).concat(string);
                continue;
            }
            for (int i = 0; i < this.mFieldName.length; ++i) {
                if (!string2.equals(this.mFieldName[i])) continue;
                n = i;
                break;
            }
            if (this.mIDFieldIndex != -1) continue;
            for (String string3 : cIDFieldNames) {
                if (!string2.equals(string3)) continue;
                this.mIDFieldIndex = n;
                continue block2;
            }
        } while (!string.startsWith("$$$$"));
        return true;
    }

    @Override
    public StereoMolecule getMolecule() {
        if (this.mMol != null) {
            return this.mMol;
        }
        this.mMol = new MolfileParser().getCompactMolecule(this.getNextMolFile());
        if (this.mMol != null && (this.mMol.getName() == null || this.mMol.getName().length() == 0)) {
            this.mMol.setName(this.getMoleculeName());
        }
        return this.mMol;
    }

    @Override
    public String getMoleculeName() {
        return this.mIDFieldIndex != -1 && this.mFieldData != null ? this.mFieldData[this.mIDFieldIndex] : (this.mMol != null ? this.mMol.getName() : null);
    }

    public String getNextMolFile() {
        String string = this.mMolfileBuffer.toString();
        return string;
    }

    public String getNextFieldData() {
        String string = this.mDataBuffer.toString();
        return string;
    }

    @Override
    public String[] getFieldNames() {
        if (this.mFieldName == null) {
            this.extractAllFieldNames(10240);
        }
        return this.mFieldName;
    }

    public String[] getFieldNames(int n) {
        if (this.mFieldName == null) {
            this.extractAllFieldNames(n);
        }
        return this.mFieldName;
    }

    @Override
    public String getFieldData(int n) {
        if (this.mFieldData == null) {
            return null;
        }
        return this.mFieldData[n];
    }

    protected String extractFieldName(String string) {
        int n;
        int n2;
        if (string.length() == 0 || string.charAt(0) != '>') {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = 1; n2 < string.length(); ++n2) {
            if (string.charAt(n2) == '<') {
                if (n3 != 0) {
                    return null;
                }
                n3 = n2;
                continue;
            }
            if (string.charAt(n2) != '>') continue;
            if (n4 != 0) {
                return null;
            }
            n4 = n2;
        }
        if (n3 != 0 && n3 < n4) {
            return string.substring(n3 + 1, n4);
        }
        n2 = string.indexOf("DT", 1);
        if (n2 == -1) {
            return null;
        }
        for (n = n2 + 2; string.length() > n && Character.isDigit(string.charAt(n)); ++n) {
        }
        return n == n2 + 2 ? null : string.substring(n2, n);
    }
}

