/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.io.CompoundFileParser;
import com.actelion.research.chem.io.CompoundTableConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeMap;

public class ODEFileParser
extends CompoundFileParser
implements CompoundTableConstants,
DescriptorConstants {
    private BufferedReader mReader;
    private String[] mFieldName;
    private String[] mFieldData;
    private String mIDCodeColumnName;
    private String mCoordinateColumnName;
    private String mFragFpColumnName;
    private int[] mFieldIndex;
    private int mIDCodeColumn;
    private int mCoordinateColumn;
    private int mIndexColumn;
    private int mOutdatedIndexColumn;

    public ODEFileParser(String string) {
        try {
            this.mReader = new BufferedReader(new FileReader(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.init();
    }

    public ODEFileParser(File file) {
        try {
            this.mReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.init();
    }

    public ODEFileParser(Reader reader) {
        this.mReader = new BufferedReader(reader);
        this.init();
    }

    private void init() {
        Object object;
        this.mIDCodeColumn = -1;
        this.mCoordinateColumn = -1;
        this.mIndexColumn = -1;
        this.mOutdatedIndexColumn = -1;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        String string = null;
        if (this.mReader != null) {
            try {
                string = this.mReader.readLine();
                if (string != null && string.equals("<datawarrior-fileinfo>")) {
                    string = this.mReader.readLine();
                    while (string != null && !string.equals("</datawarrior-fileinfo>")) {
                        string = this.mReader.readLine();
                    }
                    string = this.mReader.readLine();
                }
                if (string != null && string.equals("<column properties>")) {
                    TreeMap<String, Properties> treeMap = new TreeMap<String, Properties>();
                    string = this.mReader.readLine();
                    Properties properties = null;
                    String string2 = null;
                    while (string != null && !string.equals("</column properties>")) {
                        if (string.startsWith("<columnName")) {
                            string2 = ODEFileParser.extractValue(string);
                            properties = new Properties();
                        } else if (string.startsWith("<columnProperty")) {
                            object = ODEFileParser.extractValue(string);
                            if (((String)object).equals("isIDCode\ttrue") || ((String)object).equals("specialType\tidcode")) {
                                this.mIDCodeColumnName = string2;
                            } else {
                                int n = ((String)object).indexOf(9);
                                properties.put(((String)object).substring(0, n), ((String)object).substring(n + 1));
                            }
                        }
                        if (!(string = this.mReader.readLine()).startsWith("<columnName") && !string.equals("</column properties>")) continue;
                        treeMap.put(string2, properties);
                    }
                    if (this.mIDCodeColumnName != null) {
                        for (String string3 : treeMap.keySet()) {
                            Properties properties2 = (Properties)treeMap.get(string3);
                            if ("idcoordinates2D".equals(properties2.get("specialType")) && this.mIDCodeColumnName.equals(properties2.get("parent"))) {
                                this.mCoordinateColumnName = string3;
                                continue;
                            }
                            if (!ODEFileParser.DESCRIPTOR_FFP512.shortName.equals(properties2.get("specialType")) || !"1.2.1".equals(properties2.get("version")) || !this.mIDCodeColumnName.equals(properties2.get("parent"))) continue;
                            this.mFragFpColumnName = string3;
                        }
                    }
                    string = this.mReader.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (string == null) {
            this.mReader = null;
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        do {
            if ((n2 = string.indexOf(9, n)) == -1) {
                object = string.substring(n);
            } else {
                object = string.substring(n, n2);
                n = n2 + 1;
            }
            if (this.mIDCodeColumn == -1 && ((String)object).equals(this.mIDCodeColumnName)) {
                this.mIDCodeColumn = n3;
            } else if (this.mCoordinateColumn == -1 && ((String)object).equals(this.mCoordinateColumnName)) {
                this.mCoordinateColumn = n3;
            } else if (this.mIndexColumn == -1 && ((String)object).equals(this.mFragFpColumnName)) {
                this.mIndexColumn = n3;
            } else if (((String)object).equalsIgnoreCase("idcode") && this.mIDCodeColumn == -1) {
                this.mIDCodeColumn = n3;
            } else if (((String)object).equalsIgnoreCase("idcoordinates") && this.mCoordinateColumn == -1) {
                this.mCoordinateColumn = n3;
            } else if (((String)object).startsWith("fingerprint") && this.mIndexColumn == -1) {
                if (((String)object).endsWith("1.2.1")) {
                    this.mIndexColumn = n3;
                } else {
                    this.mOutdatedIndexColumn = n3;
                }
            }
            if (n3 != this.mIDCodeColumn && n3 != this.mCoordinateColumn && n3 != this.mIndexColumn && n3 != this.mOutdatedIndexColumn) {
                arrayList.add(object);
                arrayList2.add(new Integer(n3));
            }
            ++n3;
        } while (n2 != -1);
        this.mFieldName = new String[arrayList.size()];
        this.mFieldIndex = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.mFieldName[i] = (String)arrayList.get(i);
            this.mFieldIndex[i] = (Integer)arrayList2.get(i);
        }
        this.mFieldData = new String[n3];
    }

    @Override
    public String[] getFieldNames() {
        return this.mFieldName;
    }

    @Override
    protected boolean advanceToNext() {
        return this.moreRecordsAvailable();
    }

    @Override
    public String getMoleculeName() {
        return null;
    }

    @Override
    public int getRowCount() {
        return -1;
    }

    public boolean moreRecordsAvailable() {
        if (this.mReader == null) {
            return false;
        }
        String string = null;
        try {
            string = this.mReader.readLine();
            if (string == null || string.equals("<datawarrior properties>") || string.equals("<column properties>") || string.equals("<hitlist data>") || string.equals("<detail data>")) {
                this.mReader.close();
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf(9);
        while (n3 != -1) {
            this.mFieldData[n] = string.substring(n2, n3);
            ++n;
            n2 = n3 + 1;
            n3 = string.indexOf(9, n2);
        }
        this.mFieldData[n] = string.substring(n2);
        return true;
    }

    @Override
    public String getIDCode() {
        if (this.mIDCodeColumn == -1) {
            return null;
        }
        String string = this.mFieldData[this.mIDCodeColumn];
        return string == null || string.length() == 0 ? null : string;
    }

    @Override
    public String getCoordinates() {
        if (this.mCoordinateColumn == -1) {
            return null;
        }
        String string = this.mFieldData[this.mCoordinateColumn];
        return string == null || string.length() == 0 ? null : string;
    }

    public String getIndex() {
        if (this.mIndexColumn == -1) {
            return null;
        }
        String string = this.mFieldData[this.mIndexColumn];
        return string == null || string.length() == 0 ? null : string;
    }

    @Override
    public String getFieldData(int n) {
        return this.mFieldData[this.mFieldIndex[n]];
    }

    public static String extractValue(String string) {
        int n = string.indexOf("=\"") + 2;
        int n2 = string.indexOf("\"", n);
        return string.substring(n, n2);
    }
}

