/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.io;

import com.actelion.research.chem.AromaticityResolver;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.io.DTP;
import com.actelion.research.chem.io.SBF;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.util.DoubleFormat;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class NativeMDLReactionReader {
    private static final int BUFFER_SIZE = 512;
    private static final int kErrNoError = 0;
    private static final int kErrGetBranchNoData = -1;
    private static final int kErrGetMolInfoNoParent = -2;
    private static final int kErrGetMolInfoNoData = -3;
    private static final int kErrVariationUnavailable = -4;
    private static final int kMaxReactants = 16;
    private static final int kMaxSolvents = 40;
    private static final int kMaxCatalysts = 40;
    private String mDirectory;
    private DTP[] mDTPDir;
    private SBF[] mSBFDir;
    private DTP mRootDTP;
    private int mReactionCount;
    private int[] mBuffer;
    private int mBufferIndex;
    private int mBitmask;
    private double mYield;
    private Reaction mReaction;
    private StringBuffer mReactantData;
    private StringBuffer mProductData;
    private StringBuffer mSolventData;
    private StringBuffer mCatalystData;
    private int mSolventCount;
    private int mCatalystCount;
    private int mPointerErrors;
    private int mFieldCount;
    private int[] mMolRegNo;
    private int[] mSolventRegNo;
    private int[] mCatalystRegNo;
    private ArrayList<ExtendedMolecule> mSolvents;
    private ArrayList<ExtendedMolecule> mCatalysts;

    public NativeMDLReactionReader(String string) throws IOException {
        this.mDirectory = string + File.separator;
        this.readDTP("DTPDIR.DAT");
        this.readSBF("SBFDIR.DAT");
        if (this.mDTPDir != null && this.mSBFDir != null) {
            for (int i = 0; i < this.mDTPDir.length; ++i) {
                if (!this.mDTPDir[i].dtpnam.equals("VARIATION")) continue;
                this.mRootDTP = this.mDTPDir[i];
                DataInputStream dataInputStream = this.getDataInputStream(this.pointerfile(this.mRootDTP.drpoin));
                this.mReactionCount = this.readFileSize(dataInputStream) / 4 - 2;
            }
        }
        this.mBuffer = new int[512];
        this.mSolvents = new ArrayList();
        this.mCatalysts = new ArrayList();
        this.mMolRegNo = new int[16];
        this.mSolventRegNo = new int[40];
        this.mCatalystRegNo = new int[40];
        this.mPointerErrors = 0;
    }

    public int getReactionCount() {
        return this.mReactionCount;
    }

    public int getPointerErrors() {
        return this.mPointerErrors;
    }

    public int getVariationCount(int n) throws IOException {
        for (int i = 0; i < this.mDTPDir.length; ++i) {
            DTP dTP = this.mDTPDir[i];
            if (!dTP.dtpnam.equals("VARIATION")) continue;
            int n2 = this.getData(n, this.mBuffer, dTP);
            return n2;
        }
        throw new IOException("no VARIATION data type");
    }

    private String pointerfile(int n) {
        if (n < 10) {
            return "DR000" + n + ".DAT";
        }
        if (n < 100) {
            return "DR00" + n + ".DAT";
        }
        return "DR0" + n + ".DAT";
    }

    private String datafile(int n) {
        if (n < 10) {
            return "FL000" + n + ".DAT";
        }
        if (n < 100) {
            return "FL00" + n + ".DAT";
        }
        return "FL0" + n + ".DAT";
    }

    private void readDTP(String string) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(string);
        int n = this.readFileSize(dataInputStream) / 188;
        this.mDTPDir = new DTP[n];
        byte[] byArray = new byte[20];
        for (int i = 0; i < n; ++i) {
            int n2;
            DTP dTP = this.mDTPDir[i] = new DTP();
            dTP.lnum = this.readInt(dataInputStream);
            dTP.drpoin = this.readInt(dataInputStream);
            dTP.parentID = this.readInt(dataInputStream);
            dTP.length = this.readInt(dataInputStream);
            dTP.typno = this.readInt(dataInputStream);
            dTP.security = this.readInt(dataInputStream);
            dTP.sbfpoin = this.readInt(dataInputStream);
            dTP.sbfnum = this.readInt(dataInputStream);
            dTP.hash = this.readInt(dataInputStream);
            dTP.unk5 = this.readInt(dataInputStream);
            dTP.unk6 = this.readInt(dataInputStream);
            dTP.unk7 = this.readInt(dataInputStream);
            dataInputStream.read(byArray, 0, 20);
            dTP.dtpnam = new String(byArray).trim();
            dTP.access1 = dataInputStream.readByte();
            dTP.access2 = dataInputStream.readByte();
            dTP.empty = new byte[2];
            dataInputStream.read(dTP.empty, 0, 2);
            dTP.isparent = this.readInt(dataInputStream);
            dTP.depdata = new int[20];
            for (n2 = 0; n2 < 20; ++n2) {
                dTP.depdata[n2] = this.readInt(dataInputStream);
            }
            dTP.rootID = new int[4];
            for (n2 = 0; n2 < 4; ++n2) {
                dTP.rootID[n2] = this.readInt(dataInputStream);
            }
            dTP.unk9 = this.readInt(dataInputStream);
            dTP.unk10 = this.readInt(dataInputStream);
            dTP.drsize = this.readInt(dataInputStream);
            dTP.unk11 = this.readInt(dataInputStream);
        }
        dataInputStream.close();
    }

    private void readSBF(String string) throws IOException {
        DataInputStream dataInputStream = this.getDataInputStream(string);
        int n = this.readInt(dataInputStream);
        n = n < 0 ? -n / 160 : dataInputStream.available() / 160;
        this.mSBFDir = new SBF[n];
        byte[] byArray = new byte[20];
        for (int i = 0; i < n; ++i) {
            SBF sBF = this.mSBFDir[i] = new SBF();
            dataInputStream.read(byArray, 0, 20);
            sBF.shortnam = new String(byArray).trim();
            dataInputStream.read(byArray, 0, 20);
            sBF.format1 = new String(byArray).trim();
            dataInputStream.read(byArray, 0, 20);
            sBF.format2 = new String(byArray).trim();
            dataInputStream.read(byArray, 0, 20);
            sBF.name = new String(byArray).trim();
            sBF.lnum = this.readInt(dataInputStream);
            sBF.type = this.readInt(dataInputStream);
            sBF.a2 = this.readInt(dataInputStream);
            sBF.a3 = this.readInt(dataInputStream);
            sBF.datalen = this.readInt(dataInputStream);
            sBF.datatyp = this.readInt(dataInputStream);
            sBF.a5 = this.readInt(dataInputStream);
            sBF.dtppoin = this.readInt(dataInputStream);
            sBF.a7 = this.readInt(dataInputStream);
            sBF.begin = this.readInt(dataInputStream);
            sBF.a8 = this.readInt(dataInputStream);
            sBF.a9 = this.readInt(dataInputStream);
            sBF.a10 = this.readInt(dataInputStream);
            sBF.a11 = this.readInt(dataInputStream);
            sBF.a12 = this.readInt(dataInputStream);
            sBF.a13 = this.readInt(dataInputStream);
            sBF.a14 = this.readInt(dataInputStream);
            sBF.a15 = this.readInt(dataInputStream);
            sBF.a16 = this.readInt(dataInputStream);
            sBF.a17 = this.readInt(dataInputStream);
            sBF.fieldNo = -1;
        }
        dataInputStream.close();
    }

    public Reaction getReaction(int n, int n2) throws IOException {
        block25: {
            int n3;
            int n4;
            int n5 = n + 1;
            this.mReaction = null;
            this.mYield = -1.0;
            int n6 = -1;
            this.mCatalysts.clear();
            this.mSolvents.clear();
            this.mSolventCount = 0;
            this.mCatalystCount = 0;
            for (n4 = 0; n4 < this.mDTPDir.length; ++n4) {
                DTP dTP = this.mDTPDir[n4];
                if (!dTP.dtpnam.equals("VARIATION")) continue;
                n3 = this.getData(n5, this.mBuffer, dTP);
                if (n3 == 0) {
                    throw new IOException("invalid regNo");
                }
                if (n2 >= n3) {
                    throw new IOException("invalid variation");
                }
                n6 = this.mBuffer[n2];
                break;
            }
            if (n6 == -1) {
                throw new IOException("no VARIATION data type");
            }
            for (n4 = 0; n4 < this.mDTPDir.length; ++n4) {
                if (this.mDTPDir[n4].typno != 3) continue;
                this.getReaction(n5, this.mDTPDir[n4]);
            }
            for (n4 = 0; n4 < this.mDTPDir.length; ++n4) {
                if (this.mDTPDir[n4].typno == 24) {
                    this.getMapping(n5, this.mDTPDir[n4]);
                }
                if (this.mDTPDir[n4].typno == -19 || this.mDTPDir[n4].typno == -20) {
                    if (this.mDTPDir[n4].rootID[2] - 1 == n4) {
                        this.getDeepCatalysts(n6, this.mDTPDir[n4]);
                    } else {
                        this.getCatalysts(n6, this.mDTPDir[n4]);
                    }
                }
                try {
                    int n7;
                    if (!this.mDTPDir[n4].dtpnam.equals("RXNYIELD") || (n7 = this.getData(n6, this.mBuffer, this.mDTPDir[n4])) != 1) continue;
                    this.extractFloatYield();
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                int n8;
                if (this.mYield != -1.0) break block25;
                int[] nArray = null;
                for (n8 = 0; n8 < this.mDTPDir.length; ++n8) {
                    if (this.mDTPDir[n8].typno != -14) continue;
                    n3 = this.getData(n6, this.mBuffer, this.mDTPDir[n8]);
                    if (n3 == 0) break;
                    nArray = new int[n3];
                    for (int i = 0; i < n3; ++i) {
                        nArray[i] = this.mBuffer[i];
                    }
                    break;
                }
                if (nArray == null) break block25;
                for (n8 = 0; n8 < this.mDTPDir.length; ++n8) {
                    if (this.mDTPDir[n8].dtpnam.equals("YIELD")) {
                        for (n3 = 0; n3 < nArray.length; ++n3) {
                            if (this.getData(nArray[n3], this.mBuffer, this.mDTPDir[n8]) != 1) continue;
                            this.extractFloatYield();
                            if (this.mYield == -1.0) {
                                continue;
                            }
                            break block25;
                        }
                        break;
                    }
                    if (!this.mDTPDir[n8].dtpnam.equals("PRODAT") || !this.mSBFDir[this.mDTPDir[n8].sbfpoin - 1].name.equals("PERCENT YIELD:") && !this.mSBFDir[this.mDTPDir[n8].sbfpoin - 1].name.equals("Percent Yield:")) continue;
                    for (n3 = 0; n3 < nArray.length; ++n3) {
                        if (this.getData(nArray[n3], this.mBuffer, this.mDTPDir[n8]) != 1) continue;
                        if (this.mSBFDir[this.mDTPDir[n8].sbfpoin - 1].type == 1) {
                            this.extractFloatYield();
                        } else if (this.mSBFDir[this.mDTPDir[n8].sbfpoin - 1].type == 4) {
                            this.extractIntYield();
                        }
                        if (this.mYield == -1.0) {
                            continue;
                        }
                        break block25;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.mReaction;
    }

    public ArrayList<ExtendedMolecule> getCatalysts() {
        return this.mCatalysts;
    }

    public ArrayList<ExtendedMolecule> getSolvents() {
        return this.mSolvents;
    }

    public String getReactantData() {
        return this.mReactantData.length() == 0 ? null : this.mReactantData.toString();
    }

    public String getProductData() {
        return this.mProductData.length() == 0 ? null : this.mProductData.toString();
    }

    public String getSolventData() {
        return this.mSolventData.length() == 0 ? null : this.mSolventData.toString();
    }

    public String getCatalystData() {
        return this.mCatalystData.length() == 0 ? null : this.mCatalystData.toString();
    }

    public String[] getFieldNames() {
        this.mFieldCount = 0;
        for (int i = 0; i < this.mDTPDir.length; ++i) {
            if (this.mDTPDir[i].parentID != -2 || this.mDTPDir[i].typno != 0) continue;
            this.getFieldNameBranch(this.mDTPDir[i]);
        }
        String[] stringArray = new String[this.mFieldCount];
        for (int i = 0; i < this.mSBFDir.length; ++i) {
            if (this.mSBFDir[i].fieldNo == -1) continue;
            stringArray[this.mSBFDir[i].fieldNo] = this.mDTPDir[this.mSBFDir[i].dtppoin - 1].dtpnam + (this.mSBFDir[i].name.length() != 0 ? "." + this.mSBFDir[i].name : (this.mSBFDir[i].shortnam.equals("*") ? "" : "." + this.mSBFDir[i].shortnam));
        }
        return stringArray;
    }

    private void getFieldNameBranch(DTP dTP) {
        if (dTP.isparent != 0) {
            int n;
            for (int i = 0; i < 20 && (n = dTP.depdata[i] - 1) != -1; ++i) {
                if (dTP.typno != 0) continue;
                this.getFieldNameBranch(this.mDTPDir[n]);
            }
        } else {
            for (int i = 0; i < dTP.sbfnum; ++i) {
                int n = dTP.sbfpoin + i - 1;
                ++this.mFieldCount;
                this.mSBFDir[n].fieldNo = this.mSBFDir[n].fieldNo;
            }
        }
    }

    public String[] getFieldData(int n, int n2) {
        int n3;
        this.mReactantData = new StringBuffer();
        this.mProductData = new StringBuffer();
        this.mSolventData = new StringBuffer();
        this.mCatalystData = new StringBuffer();
        int n4 = n + 1;
        String[] stringArray = new String[this.mFieldCount];
        for (n3 = 0; n3 < this.mDTPDir.length; ++n3) {
            if (this.mDTPDir[n3].parentID != -2 || this.mDTPDir[n3].typno != 0) continue;
            this.getBranch(n4, this.mDTPDir[n3], n2, stringArray);
        }
        for (n3 = 0; n3 < this.mDTPDir.length; ++n3) {
            int n5;
            if (this.mDTPDir[n3].parentID != -1 || this.mDTPDir[n3].typno != 0) continue;
            for (n5 = 0; n5 < this.mReaction.getReactants(); ++n5) {
                if (this.mMolRegNo[n5] == 0) continue;
                this.putMolText(this.mMolRegNo[n5], this.mReactantData, n5, this.mDTPDir[n3]);
            }
            for (n5 = 0; n5 < this.mReaction.getProducts(); ++n5) {
                if (this.mMolRegNo[this.mReaction.getReactants() + n5] == 0) continue;
                this.putMolText(this.mMolRegNo[this.mReaction.getReactants() + n5], this.mProductData, n5, this.mDTPDir[n3]);
            }
            for (n5 = 0; n5 < this.mSolventCount; ++n5) {
                if (this.mSolventRegNo[n5] == 0) continue;
                this.putMolText(this.mSolventRegNo[n5], this.mSolventData, n5, this.mDTPDir[n3]);
            }
            for (n5 = 0; n5 < this.mCatalystCount; ++n5) {
                if (this.mCatalystRegNo[n5] == 0) continue;
                this.putMolText(this.mCatalystRegNo[n5], this.mCatalystData, n5, this.mDTPDir[n3]);
            }
        }
        return stringArray;
    }

    private int getBranch(int n, DTP dTP, int n2, String[] stringArray) {
        int n3;
        int[] nArray = new int[1024];
        int n4 = 0;
        try {
            n4 = this.getData(n, nArray, dTP);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n4 == 0) {
            return -1;
        }
        if (dTP.dtpnam.equals("VARIATION")) {
            if (n2 >= n4) {
                return -4;
            }
            nArray[0] = nArray[n2];
            n4 = 1;
        }
        int n5 = 0;
        for (n3 = 1; n3 < 4; ++n3) {
            if (dTP.rootID[n3] == 0) continue;
            ++n5;
        }
        if (dTP.isparent != 0) {
            for (n3 = 0; n3 < n4; ++n3) {
                int n6;
                for (int i = 0; i < 20 && (n6 = dTP.depdata[i] - 1) != -1; ++i) {
                    if (dTP.typno == 0) {
                        this.getBranch(nArray[2 * n3], this.mDTPDir[n6], n2, stringArray);
                        continue;
                    }
                    if (dTP.typno == -13) {
                        this.putMolText(nArray[2 * n3], this.mReactantData, n3, this.mDTPDir[n6]);
                        continue;
                    }
                    if (dTP.typno == -14) {
                        this.putMolText(nArray[2 * n3], this.mProductData, n3, this.mDTPDir[n6]);
                        continue;
                    }
                    if (dTP.typno == -19) {
                        this.putMolText(nArray[2 * n3], this.mSolventData, n3, this.mDTPDir[n6]);
                        continue;
                    }
                    if (dTP.typno != -20) continue;
                    this.putMolText(nArray[2 * n3], this.mCatalystData, n3, this.mDTPDir[n6]);
                }
            }
            if (dTP.typno == -19) {
                this.mSolventCount = Math.min(this.mSolventCount + n4, 40);
            }
            if (dTP.typno == -20) {
                this.mCatalystCount = Math.min(this.mCatalystCount + n4, 40);
            }
        } else {
            n3 = 0;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < dTP.sbfnum; ++j) {
                    int n7 = dTP.sbfpoin + j - 1;
                    if (dTP.length == 0 && this.mSBFDir[n7].begin > nArray[n3]) break;
                    int n8 = n3 + this.mSBFDir[n7].begin - (dTP.length == 0 ? 0 : 1);
                    if (this.mSBFDir[n7].type == 1) {
                        if (this.mSBFDir[n7].format2.length() == 0 || nArray[n8] == 0x20202020) continue;
                        String string = this.filterText(this.formatedString(nArray, n8, this.mSBFDir[n7]));
                        this.appendFieldData(stringArray, this.mSBFDir[n7].fieldNo, string);
                        continue;
                    }
                    if (this.mSBFDir[n7].type == 2) {
                        if (nArray[n8] == -2139062144) continue;
                        StringBuffer stringBuffer = new StringBuffer();
                        int n9 = 0;
                        for (int k = 0; k < this.mSBFDir[n7].datalen; ++k) {
                            n9 = (k & 3) == 0 ? nArray[n8 + (k >> 2)] : n9 >>> 8;
                            stringBuffer.append((char)(n9 & 0xFF));
                        }
                        String string = this.filterText(stringBuffer.toString());
                        this.appendFieldData(stringArray, this.mSBFDir[n7].fieldNo, string);
                        continue;
                    }
                    if (this.mSBFDir[n7].type == 4) {
                        if (nArray[n8] == 0x20202020) continue;
                        String string = "" + nArray[n8];
                        this.appendFieldData(stringArray, this.mSBFDir[n7].fieldNo, string);
                        continue;
                    }
                    if (this.mSBFDir[n7].type != 5 || nArray[n8] == 0 || nArray[n8] == -2139062144) continue;
                    int n10 = 4 * (nArray[n3] + 1 - this.mSBFDir[n7].begin);
                    StringBuffer stringBuffer = new StringBuffer();
                    int n11 = 0;
                    for (int k = 0; k < n10; ++k) {
                        n11 = (k & 3) == 0 ? nArray[n8 + (k >> 2)] : n11 >>> 8;
                        stringBuffer.append((char)(n11 & 0xFF));
                    }
                    String string = this.filterText(stringBuffer.toString());
                    this.appendFieldData(stringArray, this.mSBFDir[n7].fieldNo, string);
                }
                n3 += dTP.length != 0 ? dTP.length + 1 : nArray[n3] + 2;
            }
        }
        return 0;
    }

    private void appendFieldData(String[] stringArray, int n, String string) {
        stringArray[n] = stringArray[n] == null ? string : stringArray[n] + '\n' + string;
    }

    private int putMolText(int n, StringBuffer stringBuffer, int n2, DTP dTP) {
        int[] nArray = new int[512];
        if (dTP.isparent == 1) {
            return -2;
        }
        int n3 = 0;
        try {
            n3 = this.getData(n, nArray, dTP);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n3 == 0) {
            return -3;
        }
        if (dTP.typno == 0) {
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < dTP.sbfnum; ++j) {
                    int n5;
                    String string = null;
                    String string2 = null;
                    int n6 = dTP.sbfpoin + j - 1;
                    if (dTP.length == 0 && this.mSBFDir[n6].begin > nArray[n4]) break;
                    string = this.mSBFDir[n6].name;
                    int n7 = n4 + this.mSBFDir[n6].begin - (dTP.length == 0 ? 0 : 1);
                    if (this.mSBFDir[n6].type == 1) {
                        if (this.mSBFDir[n6].format2.length() == 0 || nArray[n7] == 0x20202020) {
                            string2 = "";
                            continue;
                        }
                        string2 = this.filterText(this.formatedString(nArray, n7, this.mSBFDir[n6]));
                    } else if (this.mSBFDir[n6].type == 2) {
                        if (nArray[n7] == -2139062144) {
                            string2 = "";
                            continue;
                        }
                        StringBuffer stringBuffer2 = new StringBuffer();
                        int n8 = 0;
                        for (n5 = 0; n5 < this.mSBFDir[n6].datalen; ++n5) {
                            n8 = (n5 & 3) == 0 ? nArray[n7 + (n5 >> 2)] : n8 >>> 8;
                            stringBuffer2.append((char)(n8 & 0xFF));
                        }
                        string2 = this.filterText(stringBuffer2.toString());
                    } else if (this.mSBFDir[n6].type == 4) {
                        if (nArray[n7] == 0x20202020) {
                            string2 = "";
                            continue;
                        }
                        string2 = "" + nArray[n7];
                    } else if (this.mSBFDir[n6].type == 5) {
                        if (nArray[n7] == 0 || nArray[n7] == -2139062144) {
                            string2 = "";
                            continue;
                        }
                        int n9 = 4 * (nArray[n4] + 1 - this.mSBFDir[n6].begin);
                        StringBuffer stringBuffer3 = new StringBuffer();
                        n5 = 0;
                        for (int k = 0; k < n9; ++k) {
                            n5 = (k & 3) == 0 ? nArray[n7 + (k >> 2)] : n5 >>> 8;
                            stringBuffer3.append((char)(n5 & 0xFF));
                        }
                        string2 = this.filterText(stringBuffer3.toString());
                    }
                    if (string2 == null) continue;
                    if (stringBuffer.length() != 0) {
                        stringBuffer.append('\n');
                    }
                    stringBuffer.append("" + (n2 + 1) + ") " + string);
                    if (!string.endsWith(":")) {
                        stringBuffer.append(":");
                    }
                    stringBuffer.append(string2);
                }
                n4 += dTP.length != 0 ? dTP.length + 1 : nArray[n4] + 2;
            }
        }
        return 0;
    }

    private String formatedString(int[] nArray, int n, SBF sBF) {
        double[] dArray = new double[2];
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < sBF.format2.length()) {
            if (sBF.format2.charAt(n3) == 'R') {
                char c;
                if (n2 > 1) {
                    return stringBuffer.toString();
                }
                if (n2 == 1 && (c = stringBuffer.charAt(stringBuffer.length() - 1)) >= '0' && c <= '\t') {
                    stringBuffer.append(' ');
                }
                dArray[n2] = this.convertFloat(nArray[n]);
                if (n2 != 0 && dArray[0] == dArray[1]) {
                    stringBuffer.setLength(n4);
                    ++n3;
                    continue;
                }
                stringBuffer.append(DoubleFormat.toString(1.00000001 * dArray[n2]));
                if (n2 == 0) {
                    n4 = stringBuffer.length();
                }
                ++n2;
                ++n;
            }
            if (sBF.format2.charAt(n3) == '\'') {
                ++n3;
                while (sBF.format2.charAt(n3) != '\'' && n3 < 20) {
                    if (sBF.format2.charAt(n3) == '-') {
                        stringBuffer.append(" - ");
                    } else {
                        stringBuffer.append(sBF.format2.charAt(n3));
                    }
                    ++n3;
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private String filterText(String string) {
        return string;
    }

    private void getDeepCatalysts(int n, DTP dTP) throws IOException {
        int[] nArray = new int[50];
        int n2 = this.getData(n, nArray, this.mDTPDir[dTP.rootID[1] - 1]);
        for (int i = 0; i < n2; ++i) {
            this.getCatalysts(nArray[i * 2], dTP);
        }
    }

    private void getCatalysts(int n, DTP dTP) throws IOException {
        int[] nArray = new int[100];
        int[] nArray2 = new int[4];
        int n2 = this.getData(n, nArray, dTP);
        if (n2 == 0) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = 0;
            if (n4 >= 20 || (n3 = dTP.depdata[n4] - 1) == -1) continue;
            try {
                if (this.mDTPDir[n3].typno == -5 && this.getData(nArray[i * 2], nArray2, this.mDTPDir[n3]) == 1) {
                    this.mSolvents.add(this.getMolecule(nArray2[0]));
                    this.mSolventRegNo[this.mSolventCount] = nArray2[0];
                    ++this.mSolventCount;
                }
                if (this.mDTPDir[n3].typno != -6 || this.getData(nArray[i * 2], nArray2, this.mDTPDir[n3]) != 1) continue;
                this.mCatalysts.add(this.getMolecule(nArray2[0]));
                this.mCatalystRegNo[this.mCatalystCount] = nArray2[0];
                ++this.mCatalystCount;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private int getData(int n, int[] nArray, DTP dTP) throws IOException {
        int n2 = this.getPointer(n, dTP);
        if (n2 == 0) {
            return 0;
        }
        if (n2 < 0) {
            throw new IOException("getData() pointer < 0");
        }
        String string = this.datafile(dTP.drpoin);
        DataInputStream dataInputStream = this.getDataInputStream(string);
        int n3 = this.readFileSize(dataInputStream);
        if (4 + 4 * n2 >= n3) {
            dataInputStream.close();
            throw new IOException("pointer >= filesize");
        }
        dataInputStream.skipBytes(4 * n2);
        int n4 = 0;
        int n5 = 0;
        switch (dTP.length) {
            case 0: {
                do {
                    nArray[n4] = this.readInt(dataInputStream);
                    if (nArray[n4] < 0 || nArray[n4] >= 512 - n4 - 2) {
                        dataInputStream.close();
                        throw new IOException("getData() unexpected value");
                    }
                    for (int i = 0; i <= nArray[n4]; ++i) {
                        nArray[n4 + i + 1] = this.readInt(dataInputStream);
                    }
                    n4 += nArray[n4] + 2;
                    ++n5;
                } while (dTP.access2 == 77 && nArray[n4 - 1] == n2 + n4);
                break;
            }
            default: {
                do {
                    if (dTP.length < 0 || n4 + dTP.length > 510) {
                        dataInputStream.close();
                        throw new IOException("getData() unexpected value");
                    }
                    for (int i = 0; i <= dTP.length; ++i) {
                        nArray[n4 + i] = this.readInt(dataInputStream);
                    }
                    ++n5;
                } while (dTP.access2 == 77 && nArray[(n4 += dTP.length + 1) - 1] == n2 + n4);
            }
        }
        dataInputStream.close();
        return n5;
    }

    private void getReaction(int n, DTP dTP) throws IOException {
        int[] nArray = new int[20];
        if (this.getData(n, nArray, dTP) != 1) {
            throw new IOException("getReaction() no molecules");
        }
        this.mReaction = new Reaction();
        for (int i = 1; i <= nArray[0]; ++i) {
            this.mMolRegNo[i - 1] = Math.abs(nArray[i]);
            if (nArray[i] < 0) {
                this.mReaction.addReactant(this.getMolecule(-nArray[i]));
                continue;
            }
            this.mReaction.addProduct(this.getMolecule(nArray[i]));
        }
    }

    private StereoMolecule getMolecule(int n) throws IOException {
        StereoMolecule stereoMolecule = new StereoMolecule();
        for (int i = 0; i < this.mDTPDir.length; ++i) {
            DTP dTP = this.mDTPDir[i];
            if (dTP.parentID != -1) continue;
            if (dTP.typno == 1) {
                this.getSema(stereoMolecule, n, dTP);
                continue;
            }
            if (dTP.typno != 2) continue;
            this.getCoords(stereoMolecule, n, dTP);
        }
        new AromaticityResolver(stereoMolecule).locateDelocalizedDoubleBonds(null);
        stereoMolecule.setStereoBondsFromParity();
        return stereoMolecule;
    }

    private void getSema(Molecule molecule, int n, DTP dTP) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.getData(n, this.mBuffer, dTP) != 1) {
            throw new IOException("getSema() no sema data");
        }
        if (this.mBuffer[1] == -1) {
            throw new IOException("getSema() empty sema data");
        }
        this.mBufferIndex = 2;
        this.mBitmask = Integer.MIN_VALUE;
        int n8 = 1 + this.readBits(4);
        molecule.setAllAtoms(this.readBits(n8));
        molecule.setAllBonds(this.readBits(n8));
        if (molecule.getAllAtoms() > molecule.getMaxAtoms() || molecule.getAllBonds() > molecule.getMaxBonds()) {
            throw new IOException("getSema() max atoms or bonds exceeded");
        }
        int n9 = this.readBits(n8);
        if (molecule.getAllBonds() < molecule.getAllAtoms() - n9) {
            throw new IOException("getSema() unexpected few bonds");
        }
        int n10 = 0;
        for (n7 = 0; n7 < molecule.getAllAtoms() - 1; ++n7) {
            n6 = this.readBits(n8) - 1;
            if (n6 == -1) continue;
            n5 = n7 + 1;
            molecule.setBondAtom(0, n10, n6);
            molecule.setBondAtom(1, n10, n5);
            ++n10;
        }
        for (n7 = molecule.getAllAtoms() - 1; n7 < molecule.getAllBonds(); ++n7) {
            n6 = this.readBits(n8) - 1;
            if (n6 == -1) continue;
            n5 = this.readBits(n8) - 1;
            molecule.setBondAtom(0, n10, n6);
            molecule.setBondAtom(1, n10, n5);
            ++n10;
        }
        for (n7 = 0; n7 < molecule.getAllAtoms(); ++n7) {
            molecule.setAtomicNo(n7, this.readBits(8));
        }
        n7 = this.readBits(n8);
        for (n6 = 0; n6 < n7; ++n6) {
            this.readBits(n8 + 4);
        }
        n6 = this.readBits(n8);
        for (n5 = 0; n5 < n6; ++n5) {
            n4 = this.readBits(n8) - 1;
            n3 = this.readBits(5);
            molecule.setAtomMass(n4, n3 - 18);
        }
        n5 = this.readBits(n8);
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = this.readBits(n8) - 1;
            molecule.setAtomCharge(n3, 16 - this.readBits(5));
        }
        n4 = this.readBits(n8);
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = this.readBits(n8) - 1;
            molecule.setAtomRadical(n2, this.readBits(2));
        }
        n10 = 0;
        for (n3 = 0; n3 < molecule.getAllBonds(); ++n3) {
            n2 = this.readBits(3);
            if (n2 == 0) continue;
            molecule.setBondType(n10, (n2 &= 3) == 0 ? 64 : (n2 == 1 ? 1 : (n2 == 2 ? 2 : 4)));
            ++n10;
        }
        molecule.setAllBonds(n10);
        n3 = this.readBits(n8);
        for (n2 = 0; n2 < n3; ++n2) {
            this.readBits(3);
        }
        n3 = this.readBits(2);
        if ((n3 & 2) != 0) {
            for (n2 = 0; n2 < molecule.getAllAtoms(); ++n2) {
                int n11 = this.readBits(3);
                if (n11 != 4 && n11 != 5) continue;
                molecule.setAtomParity(n2, n11 - 3, false);
            }
        }
    }

    private void getCoords(Molecule molecule, int n, DTP dTP) throws IOException {
        if (this.getData(n, this.mBuffer, dTP) != 1) {
            throw new IOException("getCoords() no coordinates");
        }
        this.mBufferIndex = 1;
        this.mBitmask = Integer.MIN_VALUE;
        for (int i = 0; i < molecule.getAllAtoms(); ++i) {
            molecule.setAtomY(i, -((short)this.readBits(16)));
            molecule.setAtomX(i, (short)this.readBits(16));
        }
    }

    private void getMapping(int n, DTP dTP) throws IOException {
        int n2;
        if (this.getData(n, this.mBuffer, dTP) != 1) {
            throw new IOException("getMapping() no mapping");
        }
        this.mBitmask = Integer.MIN_VALUE;
        this.mBufferIndex = 1;
        int n3 = 1 + this.readBits(8) >> 1;
        int n4 = 1 + this.readBits(8) >> 1;
        this.readBits(12);
        int n5 = this.readBits(4);
        this.mBufferIndex = 2 + n3;
        int[] nArray = new int[this.mReaction.getMolecules()];
        for (n2 = 0; n2 < this.mReaction.getMolecules(); ++n2) {
            nArray[n2] = this.readBits(8);
        }
        if (this.mReaction.getMolecules() % 4 != 0) {
            ++this.mBufferIndex;
            this.mBitmask = Integer.MIN_VALUE;
        }
        this.mBufferIndex += n4;
        for (n2 = 0; n2 < this.mReaction.getMolecules(); ++n2) {
            for (int i = 0; i < nArray[n2]; ++i) {
                this.mReaction.getMolecule(n2).setAtomMapNo(i, this.readBits(n5), false);
            }
        }
    }

    private int getPointer(int n, DTP dTP) throws IOException {
        if (n == -2139062144) {
            return 0;
        }
        DataInputStream dataInputStream = this.getDataInputStream(this.pointerfile(dTP.drpoin));
        dataInputStream.skipBytes(4 + (1 + n) * dTP.drsize * 4);
        try {
            int n2 = this.readInt(dataInputStream);
            dataInputStream.close();
            return n2;
        }
        catch (EOFException eOFException) {
            File file = this.getFile(this.pointerfile(dTP.drpoin));
            dataInputStream.close();
            ++this.mPointerErrors;
            return 0;
        }
        catch (IOException iOException) {
            dataInputStream.close();
            ++this.mPointerErrors;
            return 0;
        }
    }

    private int readFileSize(DataInputStream dataInputStream) throws IOException {
        int n = this.readInt(dataInputStream);
        return n < 0 ? -n : dataInputStream.available();
    }

    private int readInt(DataInputStream dataInputStream) throws IOException {
        return this.invertInt(dataInputStream.readInt());
    }

    private int invertInt(int n) {
        return ((n & 0xFF) << 24) + ((n & 0xFF00) << 8) + ((n & 0xFF0000) >>> 8) + ((n & 0xFF000000) >>> 24);
    }

    private void extractFloatYield() {
        if (this.mBuffer[0] != 0x20202020) {
            double d = this.convertFloat(this.mBuffer[0]);
            double d2 = this.convertFloat(this.mBuffer[1]);
            if (d >= 0.0 && d <= 100.1) {
                if (d2 >= 0.0 && d2 <= 100.1) {
                    d = (d + d2) / 2.0;
                }
                this.mYield = (int)(d + 0.5);
            }
        }
    }

    private void extractIntYield() {
        if (this.mBuffer[0] >= 0 && this.mBuffer[0] <= 100) {
            this.mYield = this.mBuffer[0];
        }
    }

    private double convertFloat(int n) {
        if (n == 0) {
            return 0.0;
        }
        int n2 = (n & 0x7F80) >> 7;
        int n3 = (n & 0x7F) << 16 | (n & 0xFFFF0000) >>> 16 | 0x800000;
        double d = (double)n3 / 1.6777216E7 * Math.pow(2.0, n2 - 128);
        return (n & 0x8000) == 0 ? d : -d;
    }

    private int readBits(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 <<= 1;
            if ((this.mBitmask & this.mBuffer[this.mBufferIndex]) != 0) {
                n2 |= 1;
            }
            this.mBitmask >>>= 1;
            if (this.mBitmask != 0) continue;
            this.mBitmask = Integer.MIN_VALUE;
            ++this.mBufferIndex;
        }
        return n2;
    }

    private File getFile(String string) throws IOException {
        File file = new File(this.mDirectory + string);
        if (!file.exists()) {
            file = new File(this.mDirectory + string.toLowerCase());
        }
        return file;
    }

    private DataInputStream getDataInputStream(String string) throws IOException {
        if (new File(this.mDirectory + string).exists()) {
            return new DataInputStream(new FileInputStream(this.mDirectory + string));
        }
        return new DataInputStream(new FileInputStream(this.mDirectory + string.toLowerCase()));
    }
}

