/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.interactionstatistics;

import com.actelion.research.util.ArrayUtils;
import com.actelion.research.util.FastSpline;

public class SplineFunction {
    private int[] occurencesArray;
    private FastSpline spline;
    private FastSpline derivate;
    private double[] discreteFunction;

    public int[] getOccurencesArray() {
        return this.occurencesArray;
    }

    public void setOccurencesArray(int[] nArray) {
        this.occurencesArray = nArray;
    }

    public void setDiscreteFunction(double[] dArray) {
        this.discreteFunction = dArray;
    }

    public void setSplineFunction(FastSpline fastSpline) {
        this.spline = fastSpline;
        this.derivate = fastSpline.derivative();
    }

    public int getTotalOccurences() {
        return ArrayUtils.sum(this.occurencesArray);
    }

    public double[] getFGValue(double d) {
        if (this.spline == null) {
            return new double[]{0.0, 0.0};
        }
        try {
            double d2 = this.spline.value(d);
            double d3 = this.derivate.value(d);
            return new double[]{d2, d3};
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new double[]{0.0, 0.0};
        }
    }

    public double getDiscreteValue(double d) {
        int n = (int)(0.5 + d / 0.2);
        return this.discreteFunction[n];
    }

    public FastSpline getSpline() {
        return this.spline;
    }
}

