/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.forcefield.mmff.table;

import com.actelion.research.chem.forcefield.mmff.Csv;
import com.actelion.research.chem.forcefield.mmff.MMFFMolecule;
import com.actelion.research.chem.forcefield.mmff.PeriodicTable;
import com.actelion.research.chem.forcefield.mmff.Search;
import com.actelion.research.chem.forcefield.mmff.Searchable;
import com.actelion.research.chem.forcefield.mmff.Tables;

public final class Bond
implements Searchable {
    private final Object[][] table;
    private final Tables t;

    public Bond(Tables tables, String string) {
        this.table = Csv.readFile(string);
        this.t = tables;
    }

    @Override
    public int get(int n, int n2) {
        return ((Number)this.table[n][n2]).intValue();
    }

    @Override
    public int length() {
        return this.table.length;
    }

    public double r0(int n) {
        return ((Number)this.table[n][4]).doubleValue();
    }

    public double kb(int n) {
        return ((Number)this.table[n][3]).doubleValue();
    }

    public double r0(MMFFMolecule mMFFMolecule, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = com.actelion.research.chem.forcefield.mmff.type.Bond.getType(this.t, mMFFMolecule, mMFFMolecule.getBond(n, n2));
        int n7 = mMFFMolecule.getAtomType(n);
        if (n7 > (n5 = mMFFMolecule.getAtomType(n2))) {
            Integer n8 = n5;
            n5 = n7;
            n7 = Search.s(n8, n5);
        }
        if ((n4 = Search.binary(new int[]{1, 2, 0}, new int[]{n7, n5, n6}, (Searchable)this)) >= 0) {
            return this.r0(n4);
        }
        int n9 = mMFFMolecule.getAtomicNo(n);
        if (n9 > (n3 = mMFFMolecule.getAtomicNo(n2))) {
            Integer n10 = n3;
            n3 = n9;
            n9 = Search.s(n10, n3);
        }
        int n11 = Search.binary(0, n9, (Searchable)this.t.covrad);
        int n12 = Search.binary(0, n3, (Searchable)this.t.covrad);
        double d = this.t.covrad.r0(n11);
        double d2 = this.t.covrad.r0(n12);
        double d3 = this.t.covrad.chi(n11);
        double d4 = this.t.covrad.chi(n12);
        double d5 = n9 == 1 || n3 == 1 ? 0.05 : 0.085;
        return d + d2 - d5 * Math.pow(Math.abs(d3 - d4), 1.4);
    }

    public double kb(MMFFMolecule mMFFMolecule, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = com.actelion.research.chem.forcefield.mmff.type.Bond.getType(this.t, mMFFMolecule, mMFFMolecule.getBond(n, n2));
        int n7 = mMFFMolecule.getAtomType(n);
        if (n7 > (n5 = mMFFMolecule.getAtomType(n2))) {
            Integer n8 = n5;
            n5 = n7;
            n7 = Search.s(n8, n5);
        }
        if ((n4 = Search.binary(new int[]{1, 2, 0}, new int[]{n7, n5, n6}, (Searchable)this)) >= 0) {
            return this.kb(n4);
        }
        int n9 = mMFFMolecule.getAtomicNo(n);
        if (n9 > (n3 = mMFFMolecule.getAtomicNo(n2))) {
            Integer n10 = n3;
            n3 = n9;
            n9 = Search.s(n10, n3);
        }
        double d = this.r0(mMFFMolecule, n, n2);
        int n11 = Search.binary(new int[]{0, 1}, new int[]{n9, n3}, (Searchable)this.t.bndk);
        if (n11 >= 0) {
            double d2 = Math.pow(this.t.bndk.r0(n11) / d, 6.0);
            return this.t.bndk.kb(n11) * d2;
        }
        int n12 = Search.binary(new int[]{0, 1}, new int[]{PeriodicTable.rowtm(n9), PeriodicTable.rowtm(n3)}, (Searchable)this.t.hblaurie);
        return Math.pow(10.0, -(d - this.t.hblaurie.fget(n12, 2)) / this.t.hblaurie.fget(n12, 3));
    }
}

