/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.docking.shape;

import com.actelion.research.calc.ThreadMaster;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.PheSAAlignmentOptimizer;
import com.actelion.research.chem.alignment3d.transformation.Transformation;
import com.actelion.research.chem.phesa.DescriptorHandlerShape;
import com.actelion.research.chem.phesa.PheSAMolecule;
import com.actelion.research.chem.phesa.ShapeVolume;
import java.util.ArrayList;
import java.util.List;

public class ShapeDocking {
    private static final double DEFAULT_PP_WEIGHT = 0.5;
    private Transformation transformation;
    private ShapeVolume negRecImage;
    private DescriptorHandlerShape dhs;
    private ThreadMaster threadMaster;
    private PheSAAlignmentOptimizer.PheSASetting phesaSetting;

    public ShapeDocking(ShapeVolume shapeVolume, Transformation transformation) {
        this.negRecImage = shapeVolume;
        this.transformation = transformation;
        this.dhs = new DescriptorHandlerShape(500, 0.5);
        this.phesaSetting = new PheSAAlignmentOptimizer.PheSASetting();
        this.phesaSetting.setNrOptimizationsPMI(2 * PheSAAlignmentOptimizer.PMI_OPTIMIZATIONS);
        this.phesaSetting.setNrOptimizationsTriangle(2 * PheSAAlignmentOptimizer.TRIANGLE_OPTIMIZATIONS);
        this.phesaSetting.setUseDirectionality(false);
        this.phesaSetting.setSimMode(PheSAAlignmentOptimizer.SimilarityMode.TVERSKY);
    }

    public PheSAAlignmentOptimizer.PheSASetting getPhesaSetting() {
        return this.phesaSetting;
    }

    public void setThreadMaster(ThreadMaster threadMaster) {
        this.threadMaster = threadMaster;
    }

    public List<StereoMolecule> dock(StereoMolecule stereoMolecule) {
        ArrayList<StereoMolecule> arrayList = new ArrayList<StereoMolecule>();
        PheSAMolecule pheSAMolecule = this.dhs.createDescriptor(stereoMolecule);
        List<PheSAAlignmentOptimizer.AlignmentResult> list = PheSAAlignmentOptimizer.alignToNegRecImg(this.negRecImage, pheSAMolecule.getVolumes(), this.phesaSetting);
        for (PheSAAlignmentOptimizer.AlignmentResult alignmentResult : list) {
            if (alignmentResult.getSimilarity() == 0.0) {
                return arrayList;
            }
            StereoMolecule stereoMolecule2 = pheSAMolecule.getConformer(pheSAMolecule.getVolumes().get(alignmentResult.getConformerIndex()));
            alignmentResult.getTransform().apply(stereoMolecule2);
            this.transformation.apply(stereoMolecule2);
            arrayList.add(stereoMolecule2);
        }
        return arrayList;
    }
}

