/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.pharmacophoretree;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.pharmacophoretree.IonizableGroupDetector2D;
import com.actelion.research.chem.phesa.pharmacophore.PharmacophoreCalculator;
import java.util.HashSet;
import java.util.Set;

public class FeatureCalculator {
    StereoMolecule mol;
    private Set<Integer> donorAtoms;
    private Set<Integer> acceptorAtoms;
    private Set<Integer> negChargeAtoms;
    private Set<Integer> posChargeAtoms;
    private Set<Integer> aromAtoms;
    private Set<Integer> lipoAtoms;

    public FeatureCalculator(StereoMolecule stereoMolecule) {
        this.mol = stereoMolecule;
        this.donorAtoms = new HashSet<Integer>();
        this.acceptorAtoms = new HashSet<Integer>();
        this.negChargeAtoms = new HashSet<Integer>();
        this.posChargeAtoms = new HashSet<Integer>();
        this.aromAtoms = new HashSet<Integer>();
        this.lipoAtoms = new HashSet<Integer>();
    }

    public void calculate() {
        IonizableGroupDetector2D ionizableGroupDetector2D = new IonizableGroupDetector2D(this.mol);
        ionizableGroupDetector2D.detect();
        this.negChargeAtoms = ionizableGroupDetector2D.getNegIonizableAtoms();
        this.posChargeAtoms = ionizableGroupDetector2D.getPosIonizableAtoms();
        this.getAtomFeatures();
    }

    private void getAtomFeatures() {
        for (int i = 0; i < this.mol.getAtoms(); ++i) {
            if (this.mol.isAromaticAtom(i)) {
                this.aromAtoms.add(i);
            } else {
                for (int j = 0; j < this.mol.getConnAtoms(i); ++j) {
                    if (this.mol.getConnBondOrder(i, j) != 2) continue;
                    this.aromAtoms.add(i);
                }
            }
            if (this.mol.getAtomicNo(i) == 7 || this.mol.getAtomicNo(i) == 8) {
                if (PharmacophoreCalculator.isAcceptor(this.mol, i)) {
                    this.acceptorAtoms.add(i);
                }
                if (PharmacophoreCalculator.isDonorHeavyAtom(this.mol, i)) {
                    this.donorAtoms.add(i);
                    continue;
                }
                this.lipoAtoms.add(i);
                continue;
            }
            this.lipoAtoms.add(i);
        }
    }

    public int[][] getAtomFunctionalities() {
        int[][] nArray = new int[this.mol.getAtoms()][6];
        for (int i = 0; i < this.mol.getAtoms(); ++i) {
            int[] nArray2 = nArray[i];
            if (this.donorAtoms.contains(i)) {
                nArray2[1] = nArray2[1] + 1;
            }
            if (this.acceptorAtoms.contains(i)) {
                nArray2[0] = nArray2[0] + 1;
            }
            if (this.negChargeAtoms.contains(i)) {
                nArray2[2] = nArray2[2] + 1;
            }
            if (this.posChargeAtoms.contains(i)) {
                nArray2[3] = nArray2[3] + 1;
            }
            if (this.lipoAtoms.contains(i)) {
                nArray2[5] = nArray2[5] + 1;
            }
            if (!this.aromAtoms.contains(i)) continue;
            nArray2[4] = nArray2[4] + 1;
        }
        return nArray;
    }
}

