/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor.flexophore;

import com.actelion.research.calc.ArrayUtilsCalc;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.IDCodeParser;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.Molecule3D;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.DescriptorEncoder;
import com.actelion.research.chem.descriptor.flexophore.MolDistHist;
import com.actelion.research.chem.descriptor.flexophore.MolDistHistEncoder;
import com.actelion.research.chem.descriptor.flexophore.MolDistHistViz;
import com.actelion.research.chem.descriptor.flexophore.PPNode;
import com.actelion.research.chem.descriptor.flexophore.PPNodeViz;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public class MolDistHistVizEncoder {
    public static final String SEP = "-1";
    private static MolDistHistVizEncoder INSTANCE;
    private MolDistHistEncoder molDistHistEncoder = new MolDistHistEncoder();

    public MolDistHistViz readEncoded(String string, String string2) {
        int n;
        Object object;
        Comparable<PPNode> comparable;
        Object object2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        MolDistHist molDistHist = this.molDistHistEncoder.decode(string2);
        IDCodeParser iDCodeParser = new IDCodeParser();
        StereoMolecule stereoMolecule = iDCodeParser.getCompactMolecule(string3, string4);
        stereoMolecule.ensureHelperArrays(7);
        int n2 = 0;
        ArrayList<Comparable<PPNode>> arrayList = new ArrayList<Comparable<PPNode>>();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            if (((String)object2).equals(SEP)) {
                bl = true;
                break;
            }
            int[] nArray = ArrayUtilsCalc.readIntArray((String)object2);
            comparable = new PPNodeViz(molDistHist.getNode(n2));
            Coordinates[] coordinatesArray = new Coordinates[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                double d = stereoMolecule.getAtomX(nArray[i]);
                double d2 = stereoMolecule.getAtomY(nArray[i]);
                double d3 = stereoMolecule.getAtomZ(nArray[i]);
                coordinatesArray[i] = new Coordinates(d, d2, d3);
                ((PPNodeViz)comparable).addIndexOriginalAtom(nArray[i]);
            }
            object = Coordinates.createBarycenter(coordinatesArray);
            ((PPNodeViz)comparable).setCoordinates(((Coordinates)object).x, ((Coordinates)object).y, ((Coordinates)object).z);
            arrayList.add(comparable);
            ++n2;
        }
        object2 = new Molecule3D(stereoMolecule);
        for (int i = 0; i < ((Molecule)object2).getAllAtoms(); ++i) {
            comparable = new Coordinates(stereoMolecule.getAtomX(i), stereoMolecule.getAtomY(i), stereoMolecule.getAtomZ(i));
            ((Molecule3D)object2).setCoordinates(i, (Coordinates)comparable);
        }
        MolDistHistViz molDistHistViz = new MolDistHistViz(molDistHist.getNumPPNodes(), (Molecule3D)object2);
        for (n = 0; n < molDistHist.getNumPPNodes(); ++n) {
            molDistHistViz.addNode((PPNodeViz)arrayList.get(n));
        }
        for (n = 0; n < molDistHist.getNumPPNodes(); ++n) {
            for (int i = n + 1; i < molDistHist.getNumPPNodes(); ++i) {
                molDistHistViz.setDistHist(n, i, molDistHist.getDistHist(n, i));
            }
        }
        if (bl) {
            String string5 = stringTokenizer.nextToken();
            DescriptorEncoder descriptorEncoder = new DescriptorEncoder();
            object = descriptorEncoder.decodeCounts(string5);
            for (int i = 0; i < ((Object)object).length; ++i) {
                molDistHistViz.addInevitablePharmacophorePoint((int)object[i]);
            }
        }
        molDistHistViz.realize();
        return molDistHistViz;
    }

    public static String toStringVizInfoEncoded(MolDistHistViz molDistHistViz) {
        int n;
        Object object;
        int n2;
        Object object2;
        Object object3;
        StringBuilder stringBuilder = new StringBuilder();
        if (molDistHistViz.molecule3D == null) {
            return null;
        }
        Molecule3D molecule3D = MolDistHistViz.finalizeMolecule(molDistHistViz.molecule3D);
        ArrayList<List<Integer>> arrayList = new ArrayList<List<Integer>>();
        for (int i = 0; i < molDistHistViz.getNumPPNodes(); ++i) {
            object3 = molDistHistViz.getNode(i);
            object2 = ((PPNodeViz)object3).getListIndexOriginalAtoms();
            arrayList.add((List<Integer>)object2);
        }
        Molecule3D molecule3D2 = new Molecule3D(molecule3D);
        molecule3D2.ensureHelperArrays(7);
        object3 = new Canonizer(molecule3D2);
        object2 = ((Canonizer)object3).getIDCode();
        String string = ((Canonizer)object3).getEncodedCoordinates(true);
        int[] nArray = ((Canonizer)object3).getGraphIndexes();
        int n3 = molecule3D2.getAtoms();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object = (List)arrayList.get(n2);
            for (int i = 0; i < object.size(); ++i) {
                n = (Integer)object.get(i);
                try {
                    if (n < n3) {
                        object.set(i, nArray[n]);
                        continue;
                    }
                    object.set(i, n);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        stringBuilder.append((String)object2);
        stringBuilder.append(" ");
        stringBuilder.append(string);
        stringBuilder.append(" ");
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            stringBuilder.append(ArrayUtilsCalc.toString((Collection)arrayList.get(n2)));
            if (n2 >= arrayList.size() - 1) continue;
            stringBuilder.append(" ");
        }
        HashSet<Integer> hashSet = molDistHistViz.getHashSetIndexInevitablePPPoints();
        if (hashSet.size() > 0) {
            stringBuilder.append(" -1 ");
            object = new DescriptorEncoder();
            byte[] byArray = new byte[hashSet.size()];
            n = 0;
            Object object4 = hashSet.iterator();
            while (object4.hasNext()) {
                int n4 = object4.next();
                byArray[n++] = (byte)n4;
            }
            object4 = new String(((DescriptorEncoder)object).encodeCounts(byArray));
            stringBuilder.append((String)object4);
        }
        return stringBuilder.toString();
    }

    public static MolDistHistVizEncoder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MolDistHistVizEncoder();
        }
        return INSTANCE;
    }
}

