/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.calc.ThreadMaster;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.ConformerSet;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.descriptor.flexophore.ExceptionConformationGenerationFailed;
import com.actelion.research.chem.descriptor.flexophore.IDescriptorHandlerFlexophore;
import com.actelion.research.chem.descriptor.flexophore.IMolDistHist;
import com.actelion.research.chem.descriptor.flexophore.ModelSolutionSimilarity;
import com.actelion.research.chem.descriptor.flexophore.MolDistHist;
import com.actelion.research.chem.descriptor.flexophore.MolDistHistEncoder;
import com.actelion.research.chem.descriptor.flexophore.MolDistHistViz;
import com.actelion.research.chem.descriptor.flexophore.PPNodeViz;
import com.actelion.research.chem.descriptor.flexophore.completegraphmatcher.ObjectiveBlurFlexophoreHardMatchUncovered;
import com.actelion.research.chem.descriptor.flexophore.generator.CreatorMolDistHistViz;
import com.actelion.research.util.ArrayUtils;
import com.actelion.research.util.CommandLineParser;
import com.actelion.research.util.graph.complete.CompleteGraphMatcher;
import com.actelion.research.util.graph.complete.SolutionCompleteGraph;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class DescriptorHandlerFlexophore
implements IDescriptorHandlerFlexophore {
    public static final boolean DEBUG = false;
    public static final String SEP_PARAMETER = ",";
    public static final String PARA_TAG_PPNODE_SIMILARITY_THRESH = "ThreshNodeSimilarity";
    public static final String PARA_TAG_HISTOGRAM_SIMILARITY_THRESH = "ThreshHistogramSimilarity";
    public static final String PARA_TAG_MODE_MATCH = "PPNodeMatchMode";
    public static final String PARA_TAG_MODE_SINGLE_CONFORMATION_QUERY = "SingleConfQuery";
    protected static final int MAX_NUM_HEAVY_ATOMS = 70;
    private static final double CORRECTION_FACTOR = 0.4;
    private static final int MAX_TRIES_TO_GENERATE_CONFORMER = 25;
    private static final int MAX_TRIES_TO_GENERATE_CONFORMER_ONE_CONF = 11;
    protected static final int MIN_NUM_ATOMS = 6;
    public static final int NUM_CONFORMATIONS = 250;
    public static final int MAX_NUM_SOLUTIONS = 1000;
    public static final MolDistHist FAILED_OBJECT = new MolDistHist();
    public static final int VERSION_INTERACTION_TABLES = -1;
    public static final int MODE_PPNODE_SIMILARITY_COMPARISON = 1;
    public static final double THRESH_SIMILARITY_COMPARISON_NODE = 0.9;
    public static final double THRESH_HISTOGRAM_SIMILARITY = 0.15;
    private static DescriptorHandlerFlexophore INSTANCE;
    private ConcurrentLinkedQueue<CompleteGraphMatcher<IMolDistHist>> queueCGM;
    private MolDistHistEncoder molDistHistEncoder;
    protected CreatorMolDistHistViz creatorMolDistHistViz;
    private ObjectiveBlurFlexophoreHardMatchUncovered objectiveCompleteGraphHard;
    protected Exception recentException;
    private int versionInteractionTable;
    private int modePPNodeSimilarityComparison;
    private double threshSimilarityHardMatch;
    private double threshHistogramSimilarity;
    private boolean singleConformationModeQuery;
    private boolean includeNodeAtoms;
    private ThreadMaster threadMaster;

    public DescriptorHandlerFlexophore(String string) {
        CommandLineParser commandLineParser = new CommandLineParser(string, SEP_PARAMETER);
        int n = -1;
        int n2 = 1;
        double d = 0.9;
        double d2 = 0.15;
        boolean bl = false;
        if (commandLineParser.contains(PARA_TAG_PPNODE_SIMILARITY_THRESH)) {
            d = commandLineParser.getAsDouble(PARA_TAG_PPNODE_SIMILARITY_THRESH);
        }
        if (commandLineParser.contains(PARA_TAG_MODE_MATCH)) {
            n2 = commandLineParser.getAsInt(PARA_TAG_MODE_MATCH);
        }
        if (commandLineParser.contains(PARA_TAG_HISTOGRAM_SIMILARITY_THRESH)) {
            d2 = commandLineParser.getAsDouble(PARA_TAG_HISTOGRAM_SIMILARITY_THRESH);
        }
        if (commandLineParser.contains(PARA_TAG_MODE_SINGLE_CONFORMATION_QUERY)) {
            bl = commandLineParser.getAsBoolean(PARA_TAG_MODE_SINGLE_CONFORMATION_QUERY);
        }
        this.init(n, n2, d, d2, bl);
    }

    public DescriptorHandlerFlexophore() {
        this.init(-1, 1, 0.9, 0.15, false);
    }

    public DescriptorHandlerFlexophore(int n, int n2, double d, double d2, boolean bl) {
        this.init(n, n2, d, d2, bl);
    }

    private void init(int n, int n2, double d, double d2, boolean bl) {
        this.versionInteractionTable = n;
        this.modePPNodeSimilarityComparison = n2;
        this.threshSimilarityHardMatch = d;
        this.threshHistogramSimilarity = d2;
        this.singleConformationModeQuery = bl;
        MolDistHistViz.createIndexTables();
        this.queueCGM = new ConcurrentLinkedQueue();
        this.objectiveCompleteGraphHard = new ObjectiveBlurFlexophoreHardMatchUncovered(n, n2, d, d2);
        this.queueCGM.add(this.getNewCompleteGraphMatcher());
        this.molDistHistEncoder = new MolDistHistEncoder();
        this.creatorMolDistHistViz = new CreatorMolDistHistViz();
    }

    public void setIncludeNodeAtoms(boolean bl) {
        this.includeNodeAtoms = bl;
    }

    public void setModeQuery(boolean bl) {
        this.objectiveCompleteGraphHard.setModeQuery(bl);
        this.queueCGM.clear();
    }

    public void setThreadMaster(ThreadMaster threadMaster) {
        this.threadMaster = threadMaster;
        this.creatorMolDistHistViz.setThreadMaster(threadMaster);
    }

    public boolean isSingleConformationModeQuery() {
        return this.singleConformationModeQuery;
    }

    public void setSingleConformationModeQuery(boolean bl) {
        this.singleConformationModeQuery = bl;
    }

    public CompleteGraphMatcher<IMolDistHist> getNewCompleteGraphMatcher() {
        ObjectiveBlurFlexophoreHardMatchUncovered objectiveBlurFlexophoreHardMatchUncovered = new ObjectiveBlurFlexophoreHardMatchUncovered(this.versionInteractionTable, this.modePPNodeSimilarityComparison, this.threshSimilarityHardMatch, this.threshHistogramSimilarity);
        objectiveBlurFlexophoreHardMatchUncovered.setModeQuery(this.objectiveCompleteGraphHard.isModeQuery());
        CompleteGraphMatcher<IMolDistHist> completeGraphMatcher = new CompleteGraphMatcher<IMolDistHist>(objectiveBlurFlexophoreHardMatchUncovered);
        completeGraphMatcher.setMaxNumSolutions(1000);
        return completeGraphMatcher;
    }

    @Override
    public ObjectiveBlurFlexophoreHardMatchUncovered getObjectiveCompleteGraph() {
        return this.objectiveCompleteGraphHard;
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_Flexophore;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_Flexophore.version;
    }

    public String toStringParameter() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DescriptorHandlerFlexophoreV5");
        stringBuilder.append(" ");
        if (this.singleConformationModeQuery) {
            stringBuilder.append("singleConformationModeQuery=true");
        } else {
            stringBuilder.append("singleConformationModeQuery=false");
        }
        stringBuilder.append(", ");
        stringBuilder.append(this.objectiveCompleteGraphHard.toStringParameter());
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DescriptorHandlerFlexophore getDefaultInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DescriptorHandlerFlexophore> clazz = DescriptorHandlerFlexophore.class;
        synchronized (DescriptorHandlerFlexophore.class) {
            INSTANCE = new DescriptorHandlerFlexophore();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public String encode(Object object) {
        if (this.calculationFailed(object)) {
            return "Calculation Failed";
        }
        MolDistHist molDistHist = null;
        if (object instanceof MolDistHist) {
            molDistHist = (MolDistHist)object;
        } else if (object instanceof MolDistHistViz) {
            molDistHist = ((MolDistHistViz)object).getMolDistHist();
        } else {
            return "Calculation Failed";
        }
        return this.molDistHistEncoder.encode(molDistHist);
    }

    public MolDistHist decode(byte[] byArray) {
        try {
            return byArray == null || byArray.length == 0 ? null : (Arrays.equals(byArray, FAILED_BYTES) ? FAILED_OBJECT : this.molDistHistEncoder.decode(byArray));
        }
        catch (RuntimeException runtimeException) {
            return FAILED_OBJECT;
        }
    }

    public MolDistHist decode(String string) {
        try {
            return string == null || string.length() == 0 ? null : (string.equals("Calculation Failed") ? FAILED_OBJECT : this.molDistHistEncoder.decode(string));
        }
        catch (RuntimeException runtimeException) {
            return FAILED_OBJECT;
        }
    }

    public MolDistHist createDescriptorSingleConf(StereoMolecule stereoMolecule) {
        MolDistHistViz molDistHistViz = this.creatorMolDistHistViz.createFromGivenConformation(stereoMolecule);
        return molDistHistViz.getMolDistHist();
    }

    public MolDistHist createDescriptorSingleConf(ConformerSet conformerSet) {
        if (conformerSet == null) {
            return FAILED_OBJECT;
        }
        MolDistHistViz molDistHistViz = this.createVisualDescriptorSingleConf(conformerSet);
        return molDistHistViz.getMolDistHist();
    }

    public MolDistHistViz createVisualDescriptorSingleConf(ConformerSet conformerSet) {
        if (conformerSet == null) {
            return new MolDistHistViz();
        }
        StereoMolecule stereoMolecule = ((Conformer)conformerSet.first()).toMolecule();
        MolDistHistViz molDistHistViz = this.creatorMolDistHistViz.createFromGivenConformation(stereoMolecule);
        return molDistHistViz;
    }

    public MolDistHist createDescriptor(Object object) {
        StereoMolecule stereoMolecule = (StereoMolecule)object;
        int[] nArray = stereoMolecule.stripSmallFragments();
        stereoMolecule.ensureHelperArrays(31);
        if (stereoMolecule.getAtoms() < 6) {
            return FAILED_OBJECT;
        }
        if (stereoMolecule.getAtoms() > 70) {
            return FAILED_OBJECT;
        }
        MolDistHistViz molDistHistViz = this.createVisualDescriptor(stereoMolecule);
        MolDistHist molDistHist = molDistHistViz == null ? null : molDistHistViz.getMolDistHist();
        this.recentException = null;
        if (molDistHist == null) {
            molDistHist = FAILED_OBJECT;
        } else if (molDistHist.getNumPPNodes() > 64) {
            String string = "Flexophore exceeded maximum number of nodes.";
            this.recentException = new RuntimeException(string);
            molDistHist = FAILED_OBJECT;
        } else if (this.includeNodeAtoms) {
            List<PPNodeViz> list = molDistHistViz.getNodes();
            int[][] nArrayArray = new int[list.size()][];
            for (int i = 0; i < list.size(); ++i) {
                int n;
                nArrayArray[i] = ArrayUtils.toIntArray(list.get(i).getListIndexOriginalAtoms());
                if (nArray == null) continue;
                int[] nArray2 = new int[stereoMolecule.getAtoms()];
                for (n = 0; n < nArray.length; ++n) {
                    if (nArray[n] == -1) continue;
                    nArray2[nArray[n]] = n;
                }
                for (n = 0; n < nArrayArray[i].length; ++n) {
                    nArrayArray[i][n] = nArray2[nArrayArray[i][n]];
                }
            }
            molDistHist.setNodeAtoms(nArrayArray);
        }
        return molDistHist;
    }

    @Override
    public MolDistHistViz createVisualDescriptor(StereoMolecule stereoMolecule) {
        MolDistHistViz molDistHistViz = null;
        boolean bl = true;
        int n = 0;
        this.recentException = null;
        while (bl) {
            bl = true;
            try {
                molDistHistViz = this.creatorMolDistHistViz.create(stereoMolecule);
                bl = this.creatorMolDistHistViz.isOnlyOneConformer() && n < 11;
            }
            catch (ExceptionConformationGenerationFailed exceptionConformationGenerationFailed) {
                this.recentException = exceptionConformationGenerationFailed;
            }
            catch (Exception exception) {
                this.recentException = exception;
                break;
            }
            if (this.threadMaster != null && this.threadMaster.threadMustDie()) break;
            if (bl) {
                this.creatorMolDistHistViz.injectNewSeed();
                ++n;
            }
            if (n != 25) continue;
            break;
        }
        return molDistHistViz;
    }

    public Exception getRecentException() {
        return this.recentException;
    }

    @Override
    public float getSimilarity(Object object, Object object2) {
        float f = 0.0f;
        if (object2 == null || object == null || ((IMolDistHist)object2).getNumPPNodes() == 0 || ((IMolDistHist)object).getNumPPNodes() == 0) {
            f = 0.0f;
        } else {
            IMolDistHist iMolDistHist = (IMolDistHist)object2;
            IMolDistHist iMolDistHist2 = (IMolDistHist)object;
            if (iMolDistHist.getNumPPNodes() > 64) {
                System.out.println("DescriptorHandlerFlexophore getSimilarity(...) mdhvBase.getNumPPNodes() " + iMolDistHist.getNumPPNodes());
                return 0.0f;
            }
            if (iMolDistHist2.getNumPPNodes() > 64) {
                System.out.println("DescriptorHandlerFlexophore getSimilarity(...) mdhvQuery.getNumPPNodes() " + iMolDistHist2.getNumPPNodes());
                return 0.0f;
            }
            f = (float)this.getSimilarity(iMolDistHist, iMolDistHist2);
        }
        return DescriptorHandlerFlexophore.normalizeValue(f);
    }

    private double getSimilarity(IMolDistHist iMolDistHist, IMolDistHist iMolDistHist2) {
        MolDistHistViz molDistHistViz = null;
        if (iMolDistHist instanceof MolDistHist) {
            molDistHistViz = new MolDistHistViz((MolDistHist)iMolDistHist);
        } else if (iMolDistHist instanceof MolDistHistViz) {
            molDistHistViz = new MolDistHistViz((MolDistHistViz)iMolDistHist);
        }
        MolDistHistViz molDistHistViz2 = null;
        if (iMolDistHist2 instanceof MolDistHist) {
            molDistHistViz2 = new MolDistHistViz((MolDistHist)iMolDistHist2);
        } else if (iMolDistHist2 instanceof MolDistHistViz) {
            molDistHistViz2 = new MolDistHistViz((MolDistHistViz)iMolDistHist2);
        }
        CompleteGraphMatcher<IMolDistHist> completeGraphMatcher = this.queueCGM.poll();
        if (completeGraphMatcher == null) {
            completeGraphMatcher = this.getNewCompleteGraphMatcher();
        }
        completeGraphMatcher.set(molDistHistViz, molDistHistViz2);
        double d = (float)completeGraphMatcher.calculateSimilarity();
        this.queueCGM.add(completeGraphMatcher);
        return d;
    }

    @Override
    public ModelSolutionSimilarity getBestMatch(MolDistHistViz molDistHistViz, MolDistHistViz molDistHistViz2) {
        CompleteGraphMatcher<IMolDistHist> completeGraphMatcher = this.queueCGM.poll();
        if (completeGraphMatcher == null) {
            completeGraphMatcher = this.getNewCompleteGraphMatcher();
        }
        completeGraphMatcher.set(molDistHistViz, molDistHistViz2);
        completeGraphMatcher.calculateSimilarity();
        SolutionCompleteGraph solutionCompleteGraph = completeGraphMatcher.getBestMatchingSolution();
        int n = solutionCompleteGraph.getSizeHeap();
        if (n == 0) {
            return null;
        }
        float[] fArray = new float[solutionCompleteGraph.getNodesQuery()];
        Arrays.fill(fArray, -1.0f);
        ObjectiveBlurFlexophoreHardMatchUncovered objectiveBlurFlexophoreHardMatchUncovered = (ObjectiveBlurFlexophoreHardMatchUncovered)completeGraphMatcher.getObjectiveCompleteGraph();
        objectiveBlurFlexophoreHardMatchUncovered.setMatchingInfoInQueryAndBase(solutionCompleteGraph);
        for (int i = 0; i < n; ++i) {
            byte by = solutionCompleteGraph.getIndexQueryFromHeap(i);
            fArray[by] = molDistHistViz2.getNode(by).getSimilarityMappingNodes();
        }
        ModelSolutionSimilarity modelSolutionSimilarity = new ModelSolutionSimilarity(solutionCompleteGraph, fArray);
        return modelSolutionSimilarity;
    }

    public ModelSolutionSimilarity getBestMatch(MolDistHist molDistHist, MolDistHist molDistHist2) {
        MolDistHistViz molDistHistViz = new MolDistHistViz(molDistHist);
        MolDistHistViz molDistHistViz2 = new MolDistHistViz(molDistHist2);
        CompleteGraphMatcher<IMolDistHist> completeGraphMatcher = this.queueCGM.poll();
        if (completeGraphMatcher == null) {
            completeGraphMatcher = this.getNewCompleteGraphMatcher();
        }
        completeGraphMatcher.set(molDistHistViz, molDistHistViz2);
        completeGraphMatcher.calculateSimilarity();
        SolutionCompleteGraph solutionCompleteGraph = completeGraphMatcher.getBestMatchingSolution();
        int n = solutionCompleteGraph.getSizeHeap();
        if (n == 0) {
            return null;
        }
        float[] fArray = new float[solutionCompleteGraph.getNodesQuery()];
        Arrays.fill(fArray, -1.0f);
        ObjectiveBlurFlexophoreHardMatchUncovered objectiveBlurFlexophoreHardMatchUncovered = (ObjectiveBlurFlexophoreHardMatchUncovered)completeGraphMatcher.getObjectiveCompleteGraph();
        objectiveBlurFlexophoreHardMatchUncovered.setMatchingInfoInQueryAndBase(solutionCompleteGraph);
        for (int i = 0; i < n; ++i) {
            byte by = solutionCompleteGraph.getIndexQueryFromHeap(i);
            fArray[by] = molDistHistViz2.getNode(by).getSimilarityMappingNodes();
        }
        ModelSolutionSimilarity modelSolutionSimilarity = new ModelSolutionSimilarity(solutionCompleteGraph, fArray);
        return modelSolutionSimilarity;
    }

    public static float normalizeValue(double d) {
        return d <= 0.0 ? 0.0f : (d >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(d, 0.4), 2.5)));
    }

    public boolean calculationFailed(Object object) {
        if (object instanceof MolDistHist) {
            return ((MolDistHist)object).getNumPPNodes() == 0;
        }
        if (object instanceof MolDistHistViz) {
            return ((MolDistHistViz)object).getNumPPNodes() == 0;
        }
        return true;
    }

    @Override
    public DescriptorHandlerFlexophore getThreadSafeCopy() {
        DescriptorHandlerFlexophore descriptorHandlerFlexophore = new DescriptorHandlerFlexophore(this.versionInteractionTable, this.modePPNodeSimilarityComparison, this.threshSimilarityHardMatch, this.threshHistogramSimilarity, this.singleConformationModeQuery);
        descriptorHandlerFlexophore.setModeQuery(this.objectiveCompleteGraphHard.isModeQuery());
        descriptorHandlerFlexophore.setIncludeNodeAtoms(this.includeNodeAtoms);
        return descriptorHandlerFlexophore;
    }

    public void setObjectiveQueryBiased(boolean bl) {
        throw new RuntimeException("setObjectiveQueryBiased(...) is not implemented");
    }
}

