/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerFP;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;

public class DescriptorHandlerFFP512
extends AbstractDescriptorHandlerFP<StereoMolecule> {
    public static final String VERSION = "1.2.1";
    private static DescriptorHandlerFFP512 sDefaultInstance;
    private static final int sIntCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerFFP512 getDefaultInstance() {
        Class<DescriptorHandlerFFP512> clazz = DescriptorHandlerFFP512.class;
        synchronized (DescriptorHandlerFFP512.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerFFP512();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_FFP512;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public int[] decode(String string) {
        int[] nArray = string != null && string.length() == 128 ? SSSearcherWithIndex.getIndexFromHexString(string) : super.decode(string);
        return nArray != null && nArray.length == sIntCount ? nArray : null;
    }

    @Override
    public int[] decode(byte[] byArray) {
        int[] nArray = byArray != null && byArray.length == 128 ? SSSearcherWithIndex.getIndexFromHexString(byArray) : super.decode(byArray);
        return nArray != null && nArray.length == sIntCount ? nArray : null;
    }

    @Override
    public int[] createDescriptor(StereoMolecule stereoMolecule) {
        int[] nArray = new SSSearcherWithIndex().createIndex(stereoMolecule);
        return nArray == null ? FAILED_OBJECT : nArray;
    }

    @Override
    public DescriptorHandler<int[], StereoMolecule> getThreadSafeCopy() {
        return this;
    }

    static {
        sIntCount = (SSSearcherWithIndex.getNoOfKeys() + 31) / 32;
    }
}

