/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.descriptor;

import com.actelion.research.chem.SSSearcherWithIndex;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.descriptor.AbstractDescriptorHandlerLongFP;
import com.actelion.research.chem.descriptor.BondSet;
import com.actelion.research.chem.descriptor.DescriptorConstants;
import com.actelion.research.chem.descriptor.DescriptorHandler;
import com.actelion.research.chem.descriptor.DescriptorInfo;
import com.actelion.research.chem.descriptor.SimpleFragmentGraph;
import com.actelion.research.util.SortedList;

public class DescriptorHandlerAllFragmentsFP
extends AbstractDescriptorHandlerLongFP<StereoMolecule> {
    private static final double CORRECTION_FACTOR = 0.68;
    public static boolean skipIDCodes;
    private static DescriptorHandlerAllFragmentsFP sDefaultInstance;
    private static final int MAX_BOND_COUNT = 6;
    private static final int HASH_BITS = 11;
    private static final int DESCRIPTOR_SIZE = 2048;
    private static final int DESCRIPTOR_LEN = 32;
    private StereoMolecule mMol;
    private boolean[] mIsAtomMember;
    private boolean[] mIsBondMember;
    private int[] mMemberBond;
    private int[] mMemberAtom;
    private long[] mDescriptor;
    private SortedList<BondSet> mBondSets;
    private SimpleFragmentGraph mFragmentGraph;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorHandlerAllFragmentsFP getDefaultInstance() {
        Class<DescriptorHandlerAllFragmentsFP> clazz = DescriptorHandlerAllFragmentsFP.class;
        synchronized (DescriptorHandlerAllFragmentsFP.class) {
            if (sDefaultInstance == null) {
                sDefaultInstance = new DescriptorHandlerAllFragmentsFP();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultInstance;
        }
    }

    @Override
    public DescriptorInfo getInfo() {
        return DescriptorConstants.DESCRIPTOR_ALLFRAG;
    }

    @Override
    public String getVersion() {
        return DescriptorConstants.DESCRIPTOR_ALLFRAG.version;
    }

    private StereoMolecule preprocessStructure(StereoMolecule stereoMolecule) {
        if (stereoMolecule.isFragment()) {
            int n;
            stereoMolecule.ensureHelperArrays(1);
            boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
            for (n = 0; n < stereoMolecule.getAtoms(); ++n) {
                blArray[n] = (stereoMolecule.getAtomQueryFeatures(n) & 0xFFFF8000F0000001L) != 0L || stereoMolecule.getAtomList(n) != null;
            }
            n = 0;
            boolean[] blArray2 = new boolean[stereoMolecule.getBonds()];
            for (int i = 0; i < stereoMolecule.getBonds(); ++i) {
                blArray2[i] = !blArray[stereoMolecule.getBondAtom(0, i)] && !blArray[stereoMolecule.getBondAtom(1, i)] && (stereoMolecule.getBondQueryFeatures(i) & 0xFF9FFE7F) == 0;
                n |= !blArray2[i] ? 1 : 0;
            }
            if (n != 0) {
                StereoMolecule stereoMolecule2 = new StereoMolecule(stereoMolecule.getAllBonds(), stereoMolecule.getAllBonds());
                stereoMolecule.copyMoleculeByBonds(stereoMolecule2, blArray2, true, null);
                stereoMolecule = stereoMolecule2;
            }
        }
        return stereoMolecule;
    }

    @Override
    public long[] createDescriptor(StereoMolecule stereoMolecule) {
        int n;
        if (stereoMolecule == null) {
            return null;
        }
        this.mMol = this.preprocessStructure(stereoMolecule);
        this.mMol.ensureHelperArrays(7);
        this.mFragmentGraph = new SimpleFragmentGraph(6);
        this.mBondSets = new SortedList();
        this.mIsAtomMember = new boolean[this.mMol.getAtoms()];
        this.mIsBondMember = new boolean[this.mMol.getBonds()];
        this.mDescriptor = new long[32];
        this.mMemberAtom = new int[this.mMol.getAtoms()];
        this.mMemberBond = new int[this.mMol.getBonds()];
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            this.mMemberAtom[0] = this.mMol.getBondAtom(0, n);
            this.mMemberAtom[1] = this.mMol.getBondAtom(1, n);
            this.mMemberBond[0] = n;
            this.mIsAtomMember[this.mMemberAtom[0]] = true;
            this.mIsAtomMember[this.mMemberAtom[1]] = true;
            this.mIsBondMember[n] = true;
            this.setHashBitIfNew(1);
            this.processOneMoreBond(2, 1);
            this.mIsAtomMember[this.mMemberAtom[0]] = false;
            this.mIsAtomMember[this.mMemberAtom[1]] = false;
            this.mIsBondMember[n] = false;
        }
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (this.mMol.getConnAtoms(n) != 0) continue;
            int n2 = this.mMol.getAtomicNo(n);
            int n3 = n2 < 64 ? 0 : 1;
            this.mDescriptor[n3] = this.mDescriptor[n3] | 1L << n2 % 64;
        }
        return this.mDescriptor;
    }

    public void processOneMoreBond(int n, int n2) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.mMol.getConnAtoms(this.mMemberAtom[i]); ++j) {
                int n3 = this.mMol.getConnBond(this.mMemberAtom[i], j);
                if (this.mIsBondMember[n3]) continue;
                int n4 = this.mMol.getConnAtom(this.mMemberAtom[i], j);
                this.mMemberBond[n2] = n3;
                this.mIsBondMember[n3] = true;
                boolean bl = this.mIsAtomMember[n4];
                if (!bl) {
                    this.mIsAtomMember[n4] = true;
                    this.mMemberAtom[n] = n4;
                    ++n;
                }
                this.setHashBitIfNew(++n2);
                if (n2 < 6) {
                    this.processOneMoreBond(n, n2);
                }
                --n2;
                this.mIsBondMember[n3] = false;
                if (bl) continue;
                --n;
                this.mIsAtomMember[n4] = false;
            }
        }
    }

    private void setHashBitIfNew(int n) {
        BondSet bondSet = new BondSet(this.mMemberBond, n, this.mMol.getBonds());
        if (this.mBondSets.addIfNew(bondSet)) {
            this.mFragmentGraph.set(this.mMol, this.mMemberBond, n);
            int n2 = this.mFragmentGraph.createHashValue(11);
            int n3 = 32 - n2 / 64 - 1;
            int n4 = n2 % 64;
            int n5 = n3;
            this.mDescriptor[n5] = this.mDescriptor[n5] | 1L << n4;
        }
    }

    @Override
    public float getSimilarity(long[] lArray, long[] lArray2) {
        return lArray == null || lArray2 == null || lArray.length == 0 || lArray2.length == 0 ? 0.0f : this.normalizeValue(SSSearcherWithIndex.getSimilarityTanimoto(lArray, lArray2));
    }

    private float normalizeValue(double d) {
        return d <= 0.0 ? 0.0f : (d >= 1.0 ? 1.0f : (float)(1.0 - Math.pow(1.0 - Math.pow(d, 0.68), 1.4705882352941175)));
    }

    @Override
    public DescriptorHandler<long[], StereoMolecule> getThreadSafeCopy() {
        return new DescriptorHandlerAllFragmentsFP();
    }
}

