/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf.torsionstrain;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.torsionstrain.StatisticalTorsionPotential;
import com.actelion.research.chem.interactionstatistics.SplineFunction;
import com.actelion.research.chem.potentialenergy.PotentialEnergyTerm;

public class StatisticalTorsionTerm
implements PotentialEnergyTerm {
    private static final double EPS = 1.0E-5;
    public double rik2;
    private Conformer conf;
    private int[] atoms;
    private int[][] rearAtoms;
    private final SplineFunction f;

    private StatisticalTorsionTerm(Conformer conformer, int[] nArray, SplineFunction splineFunction) {
        this.conf = conformer;
        this.f = splineFunction;
        this.atoms = nArray;
        this.assessRearAtoms();
    }

    private void assessRearAtoms() {
        int n;
        int n2;
        StereoMolecule stereoMolecule = this.conf.getMolecule();
        this.rearAtoms = new int[2][];
        if (this.atoms[0] == -1) {
            this.rearAtoms[0] = new int[2];
            n2 = 0;
            for (n = 0; n < stereoMolecule.getConnAtoms(this.atoms[1]); ++n) {
                if (stereoMolecule.getConnAtom(this.atoms[1], n) == this.atoms[2]) continue;
                this.rearAtoms[0][n2] = stereoMolecule.getConnAtom(this.atoms[1], n);
                ++n2;
            }
        }
        if (this.atoms[3] == -1) {
            this.rearAtoms[1] = new int[2];
            n2 = 0;
            for (n = 0; n < stereoMolecule.getConnAtoms(this.atoms[2]); ++n) {
                if (stereoMolecule.getConnAtom(this.atoms[2], n) == this.atoms[1]) continue;
                this.rearAtoms[1][n2] = stereoMolecule.getConnAtom(this.atoms[2], n);
                ++n2;
            }
        }
    }

    public static StatisticalTorsionTerm create(Conformer conformer, int[] nArray, String string) {
        SplineFunction splineFunction = StatisticalTorsionPotential.getInstance().getFunction(string);
        if (splineFunction == null) {
            return null;
        }
        return new StatisticalTorsionTerm(conformer, nArray, splineFunction);
    }

    public static void getCartesianTorsionGradient(int[] nArray, Conformer conformer, double[] dArray, double d, Coordinates[] coordinatesArray, int[][] nArray2) {
        double d2;
        double d3;
        double d4;
        Coordinates coordinates = coordinatesArray[0];
        Coordinates coordinates2 = coordinatesArray[1];
        Coordinates coordinates3 = coordinatesArray[2];
        Coordinates coordinates4 = coordinatesArray[3];
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        Coordinates[] coordinatesArray2 = new Coordinates[]{coordinates.subC(coordinates2), coordinates3.subC(coordinates2), coordinates2.subC(coordinates3), coordinates4.subC(coordinates3)};
        Coordinates[] coordinatesArray3 = new Coordinates[]{coordinatesArray2[0].cross(coordinatesArray2[1]), coordinatesArray2[2].cross(coordinatesArray2[3])};
        double[] dArray2 = new double[]{coordinatesArray3[0].dist(), coordinatesArray3[1].dist()};
        if (Math.abs(dArray2[0]) < 1.0E-5 || Math.abs(dArray2[1]) < 1.0E-5) {
            return;
        }
        coordinatesArray3[0].unit();
        coordinatesArray3[1].unit();
        double d5 = coordinatesArray3[0].dot(coordinatesArray3[1]);
        double d6 = 1.0 - d5 * d5;
        double d7 = d6 > 0.0 ? Math.sqrt(d6) : 0.0;
        double d8 = -d * (Math.abs(d7) < 1.0E-5 ? 1.0 / d5 : 1.0 / d7);
        double[] dArray3 = new double[]{1.0 / dArray2[0] * (coordinatesArray3[1].x - d5 * coordinatesArray3[0].x), 1.0 / dArray2[0] * (coordinatesArray3[1].y - d5 * coordinatesArray3[0].y), 1.0 / dArray2[0] * (coordinatesArray3[1].z - d5 * coordinatesArray3[0].z), 1.0 / dArray2[1] * (coordinatesArray3[0].x - d5 * coordinatesArray3[1].x), 1.0 / dArray2[1] * (coordinatesArray3[0].y - d5 * coordinatesArray3[1].y), 1.0 / dArray2[1] * (coordinatesArray3[0].z - d5 * coordinatesArray3[1].z)};
        if (nArray2 != null) {
            if (nArray2[0] != null) {
                d4 = d8 * (dArray3[2] * coordinatesArray2[1].y - dArray3[1] * coordinatesArray2[1].z);
                d3 = d8 * (dArray3[0] * coordinatesArray2[1].z - dArray3[2] * coordinatesArray2[1].x);
                d2 = d8 * (dArray3[1] * coordinatesArray2[1].x - dArray3[0] * coordinatesArray2[1].y);
                int n5 = 3 * nArray2[0][0];
                dArray[n5] = dArray[n5] - d4;
                int n6 = 3 * nArray2[0][0] + 1;
                dArray[n6] = dArray[n6] - d3;
                int n7 = 3 * nArray2[0][0] + 2;
                dArray[n7] = dArray[n7] - d2;
                int n8 = 3 * nArray2[0][1];
                dArray[n8] = dArray[n8] - d4;
                int n9 = 3 * nArray2[0][1] + 1;
                dArray[n9] = dArray[n9] - d3;
                int n10 = 3 * nArray2[0][1] + 2;
                dArray[n10] = dArray[n10] - d2;
            } else {
                int n11 = 3 * n + 0;
                dArray[n11] = dArray[n11] + d8 * (dArray3[2] * coordinatesArray2[1].y - dArray3[1] * coordinatesArray2[1].z);
                int n12 = 3 * n + 1;
                dArray[n12] = dArray[n12] + d8 * (dArray3[0] * coordinatesArray2[1].z - dArray3[2] * coordinatesArray2[1].x);
                int n13 = 3 * n + 2;
                dArray[n13] = dArray[n13] + d8 * (dArray3[1] * coordinatesArray2[1].x - dArray3[0] * coordinatesArray2[1].y);
            }
        }
        int n14 = 3 * n2 + 0;
        dArray[n14] = dArray[n14] + d8 * (dArray3[1] * (coordinatesArray2[1].z - coordinatesArray2[0].z) + dArray3[2] * (coordinatesArray2[0].y - coordinatesArray2[1].y) + dArray3[4] * -coordinatesArray2[3].z + dArray3[5] * coordinatesArray2[3].y);
        int n15 = 3 * n2 + 1;
        dArray[n15] = dArray[n15] + d8 * (dArray3[0] * (coordinatesArray2[0].z - coordinatesArray2[1].z) + dArray3[2] * (coordinatesArray2[1].x - coordinatesArray2[0].x) + dArray3[3] * coordinatesArray2[3].z + dArray3[5] * -coordinatesArray2[3].x);
        int n16 = 3 * n2 + 2;
        dArray[n16] = dArray[n16] + d8 * (dArray3[0] * (coordinatesArray2[1].y - coordinatesArray2[0].y) + dArray3[1] * (coordinatesArray2[0].x - coordinatesArray2[1].x) + dArray3[3] * -coordinatesArray2[3].y + dArray3[4] * coordinatesArray2[3].x);
        int n17 = 3 * n3 + 0;
        dArray[n17] = dArray[n17] + d8 * (dArray3[1] * coordinatesArray2[0].z + dArray3[2] * -coordinatesArray2[0].y + dArray3[4] * (coordinatesArray2[3].z - coordinatesArray2[2].z) + dArray3[5] * (coordinatesArray2[2].y - coordinatesArray2[3].y));
        int n18 = 3 * n3 + 1;
        dArray[n18] = dArray[n18] + d8 * (dArray3[0] * -coordinatesArray2[0].z + dArray3[2] * coordinatesArray2[0].x + dArray3[3] * (coordinatesArray2[2].z - coordinatesArray2[3].z) + dArray3[5] * (coordinatesArray2[3].x - coordinatesArray2[2].x));
        int n19 = 3 * n3 + 2;
        dArray[n19] = dArray[n19] + d8 * (dArray3[0] * coordinatesArray2[0].y + dArray3[1] * -coordinatesArray2[0].x + dArray3[3] * (coordinatesArray2[3].y - coordinatesArray2[2].y) + dArray3[4] * (coordinatesArray2[2].x - coordinatesArray2[3].x));
        if (nArray2 != null) {
            if (nArray2[1] != null) {
                d4 = d8 * (dArray3[4] * coordinatesArray2[2].z - dArray3[5] * coordinatesArray2[2].y);
                d3 = d8 * (dArray3[5] * coordinatesArray2[2].x - dArray3[3] * coordinatesArray2[2].z);
                d2 = d8 * (dArray3[3] * coordinatesArray2[2].y - dArray3[4] * coordinatesArray2[2].x);
                int n20 = 3 * nArray2[1][0];
                dArray[n20] = dArray[n20] - d4;
                int n21 = 3 * nArray2[1][0] + 1;
                dArray[n21] = dArray[n21] - d3;
                int n22 = 3 * nArray2[1][0] + 2;
                dArray[n22] = dArray[n22] - d2;
                int n23 = 3 * nArray2[1][1];
                dArray[n23] = dArray[n23] - d4;
                int n24 = 3 * nArray2[1][1] + 1;
                dArray[n24] = dArray[n24] - d3;
                int n25 = 3 * nArray2[1][1] + 2;
                dArray[n25] = dArray[n25] - d2;
            } else {
                int n26 = 3 * n4 + 0;
                dArray[n26] = dArray[n26] + d8 * (dArray3[4] * coordinatesArray2[2].z - dArray3[5] * coordinatesArray2[2].y);
                int n27 = 3 * n4 + 1;
                dArray[n27] = dArray[n27] + d8 * (dArray3[5] * coordinatesArray2[2].x - dArray3[3] * coordinatesArray2[2].z);
                int n28 = 3 * n4 + 2;
                dArray[n28] = dArray[n28] + d8 * (dArray3[3] * coordinatesArray2[2].y - dArray3[4] * coordinatesArray2[2].x);
            }
        }
    }

    @Override
    public final double getFGValue(double[] dArray) {
        Coordinates coordinates;
        Coordinates coordinates2;
        Coordinates coordinates3;
        Coordinates coordinates4;
        Object object;
        Coordinates coordinates5;
        Coordinates coordinates6;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
        int n = this.atoms[0];
        int n2 = this.atoms[1];
        int n3 = this.atoms[2];
        int n4 = this.atoms[3];
        if (n == -1) {
            coordinates6 = this.conf.getCoordinates(n2);
            coordinates5 = this.conf.getCoordinates(this.rearAtoms[0][0]);
            object = this.conf.getCoordinates(this.rearAtoms[0][1]);
            coordinates4 = coordinates5.subC(coordinates6);
            coordinates3 = ((Coordinates)object).subC(coordinates6);
            coordinates2 = coordinates4.addC(coordinates3);
            coordinates2.scale(-1.0);
        } else {
            coordinates2 = this.conf.getCoordinates(n);
        }
        if (n4 == -1) {
            coordinates6 = this.conf.getCoordinates(n3);
            coordinates5 = this.conf.getCoordinates(this.rearAtoms[1][0]);
            object = this.conf.getCoordinates(this.rearAtoms[1][1]);
            coordinates4 = coordinates5.subC(coordinates6);
            coordinates3 = ((Coordinates)object).subC(coordinates6);
            coordinates = coordinates4.addC(coordinates3);
            coordinates.scale(-1.0);
        } else {
            coordinates = this.conf.getCoordinates(n4);
        }
        Coordinates coordinates7 = this.conf.getCoordinates(this.atoms[1]);
        Coordinates coordinates8 = this.conf.getCoordinates(this.atoms[2]);
        double d = Coordinates.getDihedral(coordinates2, coordinates7, coordinates8, coordinates);
        if (d < 0.0) {
            d += Math.PI * 2;
        }
        object = this.f.getFGValue(360.0 * d / 2.0 * Math.PI);
        Object object2 = object[0];
        Object object3 = object[1];
        StatisticalTorsionTerm.getCartesianTorsionGradient(this.atoms, this.conf, dArray, (double)object3, new Coordinates[]{coordinates2, coordinates7, coordinates8, coordinates}, this.rearAtoms);
        return (double)object2;
    }
}

