/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

class TorsionInfo {
    short[] angle;
    short[][] range;
    short[] frequency;
    byte[] binSize;
    int symmetryClass;

    public TorsionInfo(int n) {
        this.symmetryClass = n;
    }

    public TorsionInfo(TorsionInfo torsionInfo) {
        int n;
        this.symmetryClass = torsionInfo.symmetryClass;
        if (torsionInfo.angle != null) {
            this.angle = new short[torsionInfo.angle.length];
            for (n = 0; n < this.angle.length; ++n) {
                this.angle[n] = (short)(360 - torsionInfo.angle[this.angle.length - n - 1]);
            }
        }
        if (torsionInfo.range != null) {
            this.range = new short[torsionInfo.range.length][2];
            for (n = 0; n < this.range.length; ++n) {
                this.range[n][0] = (short)(360 - torsionInfo.range[this.angle.length - n - 1][1]);
                this.range[n][1] = (short)(360 - torsionInfo.range[this.angle.length - n - 1][0]);
            }
        }
        if (torsionInfo.frequency != null) {
            this.frequency = new short[torsionInfo.frequency.length];
            for (n = 0; n < this.frequency.length; ++n) {
                this.frequency[n] = torsionInfo.frequency[this.frequency.length - n - 1];
            }
        }
        if (torsionInfo.binSize != null) {
            this.binSize = new byte[torsionInfo.binSize.length];
            for (n = 0; n < this.binSize.length; ++n) {
                this.binSize[n] = torsionInfo.binSize[this.binSize.length - n - 1];
            }
        }
    }

    public short[] get360DegreeAngles() {
        short[] sArray = null;
        switch (this.symmetryClass) {
            case 1: {
                sArray = new short[2 * this.angle.length];
                for (int i = 0; i < this.angle.length; ++i) {
                    sArray[i] = this.angle[i];
                    sArray[this.angle.length + i] = (short)(180 + this.angle[i]);
                }
                return sArray;
            }
            case 2: {
                int n;
                int n2 = this.angle[0] == 0 ? 1 : 0;
                int n3 = this.angle[this.angle.length - 1] == 180 ? this.angle.length - 1 : this.angle.length;
                int n4 = n3 - n2;
                sArray = new short[this.angle.length + n4];
                for (n = 0; n < this.angle.length; ++n) {
                    sArray[n] = this.angle[n];
                }
                for (n = n2; n < n3; ++n) {
                    sArray[sArray.length - 1 - n + n2] = (short)(360 - this.angle[n]);
                }
                return sArray;
            }
            case 3: {
                int n;
                int n5 = this.angle[0] == 0 ? 1 : 0;
                int n6 = this.angle[this.angle.length - 1] == 90 ? this.angle.length - 1 : this.angle.length;
                int n7 = n6 - n5;
                sArray = new short[2 * this.angle.length + 2 * n7];
                for (n = 0; n < this.angle.length; ++n) {
                    sArray[n] = this.angle[n];
                    sArray[this.angle.length + n7 + n] = (short)(180 + this.angle[n]);
                }
                for (n = n5; n < n6; ++n) {
                    sArray[this.angle.length + n7 - 1 - n + n5] = (short)(180 - this.angle[n]);
                    sArray[sArray.length - 1 - n + n5] = (short)(360 - this.angle[n]);
                }
                return sArray;
            }
        }
        return this.angle;
    }

    public short[][] get360DegreeRanges() {
        short[][] sArray = null;
        int n = this.range.length;
        switch (this.symmetryClass) {
            case 1: {
                sArray = new short[2 * n][2];
                for (int i = 0; i < n; ++i) {
                    sArray[i][0] = this.range[i][0];
                    sArray[i][1] = this.range[i][1];
                    sArray[n + i][0] = (short)(180 + this.range[i][0]);
                    sArray[n + i][1] = (short)(180 + this.range[i][1]);
                }
                return sArray;
            }
            case 2: {
                int n2;
                int n3 = this.angle[0] == 0 ? 1 : 0;
                int n4 = this.angle[n - 1] == 180 ? n - 1 : n;
                int n5 = n4 - n3;
                sArray = new short[n + n5][2];
                for (n2 = 0; n2 < n; ++n2) {
                    sArray[n2][0] = this.range[n2][0];
                    sArray[n2][1] = this.range[n2][1];
                }
                for (n2 = n3; n2 < n4; ++n2) {
                    sArray[sArray.length - 1 - n2 + n3][0] = (short)(360 - this.range[n2][1]);
                    sArray[sArray.length - 1 - n2 + n3][1] = (short)(360 - this.range[n2][0]);
                }
                return sArray;
            }
            case 3: {
                int n6;
                int n7 = this.angle[0] == 0 ? 1 : 0;
                int n8 = this.angle[n - 1] == 90 ? n - 1 : n;
                int n9 = n8 - n7;
                sArray = new short[2 * n + 2 * n9][2];
                for (n6 = 0; n6 < n; ++n6) {
                    sArray[n6][0] = this.range[n6][0];
                    sArray[n6][1] = this.range[n6][1];
                    sArray[n + n9 + n6][0] = (short)(180 + this.range[n6][0]);
                    sArray[n + n9 + n6][1] = (short)(180 + this.range[n6][1]);
                }
                for (n6 = n7; n6 < n8; ++n6) {
                    sArray[n + n9 - 1 - n6 + n7][0] = (short)(180 - this.range[n6][1]);
                    sArray[n + n9 - 1 - n6 + n7][1] = (short)(180 - this.range[n6][0]);
                    sArray[sArray.length - 1 - n6 + n7][0] = (short)(360 - this.range[n6][1]);
                    sArray[sArray.length - 1 - n6 + n7][1] = (short)(360 - this.range[n6][0]);
                }
                return sArray;
            }
        }
        return this.range;
    }

    public short[] get360DegreeFrequencies() {
        short[] sArray = null;
        int n = this.frequency.length;
        switch (this.symmetryClass) {
            case 1: {
                sArray = new short[2 * n];
                for (int i = 0; i < n; ++i) {
                    sArray[i] = this.frequency[i];
                    sArray[n + i] = this.frequency[i];
                }
                return sArray;
            }
            case 2: {
                int n2;
                int n3 = this.angle[0] == 0 ? 1 : 0;
                int n4 = this.angle[n - 1] == 180 ? n - 1 : n;
                int n5 = n4 - n3;
                sArray = new short[n + n5];
                for (n2 = 0; n2 < n; ++n2) {
                    sArray[n2] = this.frequency[n2];
                }
                for (n2 = n3; n2 < n4; ++n2) {
                    sArray[sArray.length - 1 - n2 + n3] = this.frequency[n2];
                }
                return sArray;
            }
            case 3: {
                int n6;
                int n7 = this.angle[0] == 0 ? 1 : 0;
                int n8 = this.angle[n - 1] == 90 ? n - 1 : n;
                int n9 = n8 - n7;
                sArray = new short[2 * n + 2 * n9];
                for (n6 = 0; n6 < n; ++n6) {
                    sArray[n6] = this.frequency[n6];
                    sArray[n + n9 + n6] = this.frequency[n6];
                }
                for (n6 = n7; n6 < n8; ++n6) {
                    sArray[n + n9 - 1 - n6 + n7] = this.frequency[n6];
                    sArray[sArray.length - 1 - n6 + n7] = this.frequency[n6];
                }
                return sArray;
            }
        }
        return this.frequency;
    }

    public byte[] get72BinCounts() {
        if (this.binSize.length == 72) {
            return this.binSize;
        }
        byte[] byArray = new byte[72];
        switch (this.symmetryClass) {
            case 1: {
                for (int i = 0; i < 36; ++i) {
                    byArray[i] = this.binSize[i];
                    byArray[i + 36] = this.binSize[i];
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 36; ++i) {
                    byArray[i] = this.binSize[i];
                    byArray[i + 36] = this.binSize[36 - i];
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 18; ++i) {
                    byArray[i] = this.binSize[i];
                    byArray[i + 18] = this.binSize[18 - i];
                    byArray[i + 36] = this.binSize[i];
                    byArray[i + 54] = this.binSize[18 - i];
                }
                break;
            }
        }
        return byArray;
    }

    public void mergeTorsions(int n) {
        int n2;
        int n3 = 0;
        while (this.angle.length != 0 && (this.angle.length != 1 || this.symmetryClass != 1 && this.symmetryClass != 0 && (this.symmetryClass != 2 || this.angle[0] != 0 && this.angle[0] != 180) && (this.symmetryClass != 3 || this.angle[0] != 0 && this.angle[0] != 90))) {
            int n4;
            int n5;
            int n6;
            n2 = this.angle[0] != 0 && (this.symmetryClass == 2 || this.symmetryClass == 3) ? -1 : 0;
            int n7 = -1;
            int n8 = Integer.MAX_VALUE;
            for (n6 = n2; n6 < this.angle.length; ++n6) {
                int n9;
                n5 = n6 + 1;
                int n10 = n4 = n6 >= 0 ? this.angle[n6] : -this.angle[0];
                int n11 = n5 < this.angle.length ? this.angle[n5] : (this.symmetryClass == 1 ? this.angle[0] + 180 : (this.symmetryClass == 2 ? 360 - this.angle[this.angle[n6] == 180 ? n6 - 1 : n6] : (this.symmetryClass == 3 ? 180 - this.angle[this.angle[n6] == 90 ? n6 - 1 : n6] : (n9 = this.angle[0] + 360))));
                if (n8 <= n9 - n4) continue;
                n8 = n9 - n4;
                n7 = n6;
            }
            if (n8 > n) break;
            n6 = n7;
            n5 = n6 + 1;
            if (n6 == -1) {
                n3 += this.frequency[0];
                this.angle[0] = 0;
                this.frequency[0] = (short)(this.frequency[0] * 2);
                this.range[0][0] = -this.range[0][1];
                continue;
            }
            if (n5 < this.angle.length) {
                n4 = this.mergedAngle(n6, n5, this.angle[n5]);
                this.mergeAngles(n4, n6, n5, this.range[n6][0], this.range[n5][1]);
                continue;
            }
            if (this.symmetryClass == 1) {
                n5 = 0;
                n4 = this.mergedAngle(n6, n5, this.angle[n5] + 180);
                if (n4 <= 180) {
                    this.mergeAngles(n4, n6, n5, this.range[n6][0], this.range[n5][1] + 180);
                    continue;
                }
                this.mergeAngles(n4 - 180, n5, n6, this.range[n5][0], this.range[n6][1] - 180);
                continue;
            }
            if (this.symmetryClass == 2) {
                int n12 = n5 = this.angle[n6] == 180 ? n6 - 1 : n6;
                if (this.angle[n6] < 180) {
                    n3 += this.frequency[n6];
                    this.angle[n6] = 180;
                    int n13 = n6;
                    this.frequency[n13] = (short)(this.frequency[n13] * 2);
                    this.range[n6][1] = (short)(360 - this.range[n6][0]);
                    continue;
                }
                System.out.println("WARNING: TorsionDB - Should have caught the symmetrical situation one peak earlier.");
                n4 = this.mergedAngle(n6, n5, this.angle[n5]);
                this.mergeAngles(n4, n5, n6, this.range[n5][0], this.range[n6][1]);
                continue;
            }
            if (this.symmetryClass == 3) {
                int n14 = n5 = this.angle[n6] == 90 ? n6 - 1 : n6;
                if (this.angle[n6] < 90) {
                    n3 += this.frequency[n6];
                    this.angle[n6] = 90;
                    int n15 = n6;
                    this.frequency[n15] = (short)(this.frequency[n15] * 2);
                    this.range[n6][1] = (short)(180 - this.range[n6][0]);
                    continue;
                }
                System.out.println("WARNING: TorsionDB - Should have caught the symmetrical situation one peak earlier.");
                n4 = this.mergedAngle(n6, n5, this.angle[n5]);
                this.mergeAngles(n4, n5, n6, this.range[n5][0], this.range[n6][1]);
                continue;
            }
            n5 = 0;
            n4 = this.mergedAngle(n6, n5, this.angle[n5] + 360);
            if (n4 <= 360) {
                this.mergeAngles(n4, n6, n5, this.range[n6][0], this.range[n5][1] + 360);
                continue;
            }
            this.mergeAngles(n4 - 360, n5, n6, this.range[n5][0], this.range[n6][1] - 360);
        }
        if (n3 != 0) {
            for (n2 = 0; n2 < this.frequency.length; ++n2) {
                this.frequency[n2] = (short)Math.round(100.0f * (float)this.frequency[n2] / (100.0f + (float)n3));
            }
        }
    }

    private int mergedAngle(int n, int n2, int n3) {
        return Math.round(((float)this.angle[n] * (float)this.frequency[n] + (float)n3 * (float)this.frequency[n2]) / (float)(this.frequency[n] + this.frequency[n2]));
    }

    private void mergeAngles(int n, int n2, int n3, int n4, int n5) {
        this.angle[n2] = (short)n;
        this.frequency[n2] = (short)(this.frequency[n2] + this.frequency[n3]);
        this.range[n2][0] = (short)n4;
        this.range[n2][1] = (short)n5;
        int n6 = this.angle.length - 1;
        short[] sArray = new short[n6];
        short[] sArray2 = new short[n6];
        short[][] sArrayArray = new short[n6][];
        int n7 = 0;
        for (int i = 0; i < this.angle.length; ++i) {
            if (i == n3) continue;
            sArray[n7] = this.angle[i];
            sArray2[n7] = this.frequency[i];
            sArrayArray[n7] = this.range[i];
            ++n7;
        }
        this.angle = sArray;
        this.frequency = sArray2;
        this.range = sArrayArray;
    }
}

