/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.TorsionDB;
import com.actelion.research.chem.conf.VDWRadii;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class BondLengthSet {
    private static final String cBondDataFile = "bondLengthData.txt";
    private static String sCustomBondDataFile = null;
    private static boolean isInitialized = false;
    private static int[] BOND_ID;
    private static int[] BOND_COUNT;
    private static float[] BOND_LENGTH;
    private static float[] BOND_STDDEV;
    public static final float DEFAULT_BOND_LENGTH = 2.0005f;
    public static final float DEFAULT_BOND_STDDEV = 1.0f;
    private static final boolean[] CONSIDER_PI;
    private final float[] mBondLength;
    private final float[] mBondStdDev;

    public BondLengthSet(StereoMolecule stereoMolecule) {
        stereoMolecule.ensureHelperArrays(7);
        this.mBondLength = new float[stereoMolecule.getAllBonds()];
        this.mBondStdDev = new float[stereoMolecule.getAllBonds()];
        for (int i = 0; i < stereoMolecule.getAllBonds(); ++i) {
            int n = BondLengthSet.getBondIndex(stereoMolecule, i);
            if (n == -1) {
                this.mBondLength[i] = BondLengthSet.getBondLengthFromCovalentRadii(stereoMolecule, i);
                this.mBondStdDev[i] = BondLengthSet.getStdDevFromCovalentRadii(stereoMolecule, i);
                continue;
            }
            this.mBondLength[i] = BondLengthSet.getBondLength(n);
            this.mBondStdDev[i] = BondLengthSet.getBondStdDev(n);
        }
    }

    public static void setCustomDataFile(String string) {
        sCustomBondDataFile = string;
        isInitialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initialize() {
        if (isInitialized) return;
        Class<BondLengthSet> clazz = BondLengthSet.class;
        synchronized (BondLengthSet.class) {
            try {
                BufferedReader bufferedReader = sCustomBondDataFile == null ? TorsionDB.openReader(cBondDataFile) : new BufferedReader(new FileReader(sCustomBondDataFile));
                String string = bufferedReader.readLine();
                int n = string == null ? 0 : Integer.parseInt(string);
                BOND_ID = new int[n];
                BOND_LENGTH = new float[n];
                BOND_STDDEV = new float[n];
                BOND_COUNT = new int[n];
                for (int i = 0; i < n; ++i) {
                    String[] stringArray;
                    String string2 = bufferedReader.readLine();
                    if (string2 == null || (stringArray = string2.split("\\t")).length != 4) continue;
                    try {
                        BondLengthSet.BOND_ID[i] = Integer.parseInt(stringArray[0]);
                        BondLengthSet.BOND_LENGTH[i] = Float.parseFloat(stringArray[1]);
                        BondLengthSet.BOND_STDDEV[i] = Float.parseFloat(stringArray[2]);
                        BondLengthSet.BOND_COUNT[i] = Integer.parseInt(stringArray[3]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        break;
                    }
                }
                bufferedReader.close();
                isInitialized = true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    public float getLength(int n) {
        return this.mBondLength[n];
    }

    public float getStdDev(int n) {
        return this.mBondStdDev[n];
    }

    public static String getBondIDString(int n) {
        String string;
        if (n == -1) {
            return "unknown";
        }
        int n2 = BOND_ID[n];
        int n3 = (n2 & 0xFF000000) >> 24;
        int n4 = (n2 & 0xF00000) >> 20;
        int n5 = (n2 & 0xF00) >> 8;
        int n6 = (n2 & 0xFF000) >> 12;
        int n7 = n2 & 0xFF;
        String string2 = BondLengthSet.isPiConsidered(n6) ? Integer.toString(n4) : "";
        String string3 = string = BondLengthSet.isPiConsidered(n7) ? Integer.toString(n5) : "";
        String string4 = n3 == 0 ? "d" : (n3 > 3 ? "a" : "") + (n3 & 3);
        return string4 + Molecule.cAtomLabel[n6] + string2 + Molecule.cAtomLabel[n7] + string;
    }

    public static int getBondIndex(int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5) {
        return BondLengthSet.lookupBondIndex(BondLengthSet.getBondID(n, bl, bl2, n2, n3, n4, n5));
    }

    private static int getBondID(int n, boolean bl, boolean bl2, int n2, int n3, int n4, int n5) {
        int n6 = n2 < CONSIDER_PI.length && CONSIDER_PI[n2] ? n4 << 8 : 0;
        int n7 = n3 < CONSIDER_PI.length && CONSIDER_PI[n3] ? n5 << 8 : 0;
        int n8 = n6 + n2;
        int n9 = n7 + n3;
        int n10 = bl2 ? 0 : (bl ? 4 + n : n);
        return (n10 << 24) + (n8 < n9 ? (n8 << 12) + n9 : (n9 << 12) + n8);
    }

    public static int getBondIndex(StereoMolecule stereoMolecule, int n) {
        int n2 = stereoMolecule.getBondAtom(0, n);
        int n3 = stereoMolecule.getBondAtom(1, n);
        int n4 = stereoMolecule.getAtomicNo(n2);
        int n5 = stereoMolecule.getAtomicNo(n3);
        return BondLengthSet.getBondIndex(stereoMolecule.getBondOrder(n), stereoMolecule.isAromaticBond(n), stereoMolecule.isDelocalizedBond(n), n4, n5, BondLengthSet.getAtomPi(stereoMolecule, n2), BondLengthSet.getAtomPi(stereoMolecule, n3));
    }

    public static int getBondID(StereoMolecule stereoMolecule, int n) {
        int n2 = stereoMolecule.getBondAtom(0, n);
        int n3 = stereoMolecule.getBondAtom(1, n);
        int n4 = stereoMolecule.getAtomicNo(n2);
        int n5 = stereoMolecule.getAtomicNo(n3);
        return BondLengthSet.getBondID(stereoMolecule.getBondOrder(n), stereoMolecule.isAromaticBond(n), stereoMolecule.isDelocalizedBond(n), n4, n5, BondLengthSet.getAtomPi(stereoMolecule, n2), BondLengthSet.getAtomPi(stereoMolecule, n3));
    }

    public static final boolean isPiConsidered(int n) {
        return n < CONSIDER_PI.length && CONSIDER_PI[n];
    }

    public static int getAtomPi(StereoMolecule stereoMolecule, int n) {
        if (n >= stereoMolecule.getAtoms()) {
            return 0;
        }
        if (stereoMolecule.isAromaticAtom(n) && stereoMolecule.getAtomicNo(n) == 6 && stereoMolecule.getAtomCharge(n) != 0) {
            return 1;
        }
        return stereoMolecule.getAtomPi(n);
    }

    public static float lookupBondLength(StereoMolecule stereoMolecule, int n) {
        int n2 = BondLengthSet.getBondIndex(stereoMolecule, n);
        return n2 == -1 ? BondLengthSet.getBondLengthFromCovalentRadii(stereoMolecule, n) : BondLengthSet.getBondLength(n2);
    }

    public static float getBondLengthFromCovalentRadii(StereoMolecule stereoMolecule, int n) {
        int n2 = stereoMolecule.getAtomicNo(stereoMolecule.getBondAtom(0, n));
        int n3 = stereoMolecule.getAtomicNo(stereoMolecule.getBondAtom(1, n));
        return BondLengthSet.getCovalentRadius(n2) + BondLengthSet.getCovalentRadius(n3);
    }

    public static float getStdDevFromCovalentRadii(StereoMolecule stereoMolecule, int n) {
        int n2 = stereoMolecule.getAtomicNo(stereoMolecule.getBondAtom(0, n));
        int n3 = stereoMolecule.getAtomicNo(stereoMolecule.getBondAtom(1, n));
        return (n2 < VDWRadii.COVALENT_RADIUS.length ? 0.05f : 0.125f) + (n3 < VDWRadii.COVALENT_RADIUS.length ? 0.05f : 0.125f);
    }

    private static float getCovalentRadius(int n) {
        return n < VDWRadii.COVALENT_RADIUS.length ? VDWRadii.COVALENT_RADIUS[n] : (n < VDWRadii.VDW_RADIUS.length ? 0.6f * VDWRadii.VDW_RADIUS[n] : 1.8f);
    }

    public static float getBondLength(int n) {
        return n == -1 ? 2.0005f : BOND_LENGTH[n];
    }

    public static float getBondCount(int n) {
        return n == -1 ? 0.0f : (float)BOND_COUNT[n];
    }

    public static float getBondStdDev(int n) {
        return n == -1 ? 1.0f : BOND_STDDEV[n];
    }

    private static int lookupBondIndex(int n) {
        if (!isInitialized) {
            BondLengthSet.initialize();
        }
        int n2 = 2048;
        int n3 = 1024;
        for (int i = 0; i < 12; ++i) {
            int n4;
            int n5 = n2 >= BOND_ID.length || n < BOND_ID[n2] ? -1 : (n4 = n == BOND_ID[n2] ? 0 : 1);
            if (n4 == 0) {
                return n2;
            }
            n2 = n4 < 0 ? n2 - n3 : n2 + n3;
            n3 /= 2;
        }
        return -1;
    }

    static {
        CONSIDER_PI = new boolean[]{false, false, false, false, false, true, true, true, true, false, false, false, false, false, false, true, true};
    }
}

