/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.conf;

import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.BondLengthSet;

public class BondAngleSet {
    private static float TO_RADIAN = (float)Math.PI / 180;
    private final StereoMolecule mMol;
    private final BondLengthSet mBondLengthSet;
    private final float[][][] mBondAngle;
    private final int[] mDefinedAngleCount;
    private final int[] mTinyRingSizeSum;
    private final float[] mDefinedAngleSum;

    public BondAngleSet(StereoMolecule stereoMolecule, BondLengthSet bondLengthSet) {
        int n;
        this.mBondLengthSet = bondLengthSet == null ? new BondLengthSet(stereoMolecule) : bondLengthSet;
        this.mMol = stereoMolecule;
        this.mBondAngle = new float[this.mMol.getAtoms()][][];
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            this.mBondAngle[i] = new float[this.mMol.getAllConnAtoms(i)][];
            for (n = 1; n < this.mMol.getAllConnAtoms(i); ++n) {
                this.mBondAngle[i][n] = new float[n];
            }
        }
        this.mDefinedAngleCount = new int[this.mMol.getAtoms()];
        this.mDefinedAngleSum = new float[this.mMol.getAtoms()];
        this.mTinyRingSizeSum = new int[this.mMol.getBonds()];
        this.calculateBondAnglesOfFlatRings();
        int[] nArray = new int[]{0, 0, 1, 3, 6, 10, 15, 21};
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            int n2;
            int n3;
            int[] nArray2 = new int[this.mMol.getAllConnAtoms(n)];
            int n4 = this.mMol.getAllConnAtoms(n);
            if (n4 > 4) {
                for (int i = 1; i < n4; ++i) {
                    for (n3 = 0; n3 < i; ++n3) {
                        this.mBondAngle[n][i][n3] = 1.5707964f;
                    }
                }
                this.mDefinedAngleCount[n] = nArray[n4];
                continue;
            }
            if (this.mDefinedAngleCount[n] == nArray[n4]) continue;
            if (this.mMol.isSmallRingAtom(n) && (this.mMol.isAromaticAtom(n) || this.mMol.getAtomRingSize(n) <= 4 && this.mMol.getAtomPi(n) > 0)) {
                float f;
                if (n4 <= 2) continue;
                if (this.mDefinedAngleCount[n] == 1) {
                    f = this.mMol.getAtomicNo(n) <= 14 ? ((float)Math.PI * 2 - this.mDefinedAngleSum[n]) / 2.0f : this.calculateRemainingTetrahedralAngle(this.mDefinedAngleSum[n]);
                } else {
                    f = (float)Math.PI * 2 - this.mDefinedAngleSum[n];
                    if (n4 > 3) {
                        if (this.mDefinedAngleCount[n] == 2) {
                            int n5;
                            boolean[] blArray = new boolean[this.mMol.getAllConnAtoms(n)];
                            for (n2 = 1; n2 < n4; ++n2) {
                                for (n5 = 0; n5 < n2; ++n5) {
                                    if ((double)this.mBondAngle[n][n2][n5] == 0.0) continue;
                                    blArray[n2] = !blArray[n2];
                                    blArray[n5] = !blArray[n5];
                                }
                            }
                            block27: for (n2 = 0; n2 < n4; ++n2) {
                                if (!blArray[n2]) continue;
                                for (n5 = n2 + 1; n5 < n4; ++n5) {
                                    if (!blArray[n5]) continue;
                                    this.mBondAngle[n][n5][n2] = f;
                                    break block27;
                                }
                                break;
                            }
                        }
                        f = 1.5707964f;
                    }
                }
                for (n3 = 1; n3 < n4; ++n3) {
                    for (n2 = 0; n2 < n3; ++n2) {
                        if ((double)this.mBondAngle[n][n3][n2] != 0.0) continue;
                        this.mBondAngle[n][n3][n2] = f;
                    }
                }
                continue;
            }
            if (this.mMol.isSmallRingAtom(n) && this.mMol.getAtomRingSize(n) <= 4) {
                switch (this.getRingStrainClass(n)) {
                    case 771: {
                        this.setRingStrainAngles(n, 0, 3, 2.0654f);
                        this.setRingStrainAngles(n, 0, 0, 113.53f * TO_RADIAN);
                        break;
                    }
                    case 1028: {
                        this.setRingStrainAngles(n, 0, 4, 1.9798f);
                        this.setRingStrainAngles(n, 0, 0, 111.55f * TO_RADIAN);
                        break;
                    }
                    case 393987: {
                        this.setRingStrainAngles(n, 0, 3, 2.264f);
                        this.setRingStrainAngles(n, 0, 6, 2.264f);
                        this.setRingStrainAngles(n, 3, 3, 98.715f * TO_RADIAN);
                        break;
                    }
                    case 459779: {
                        this.setRingStrainAngles(n, 0, 3, 2.1676f);
                        this.setRingStrainAngles(n, 0, 4, 2.1676f);
                        this.setRingStrainAngles(n, 0, 7, 2.1676f);
                        this.setRingStrainAngles(n, 3, 4, 110.71f * TO_RADIAN);
                        break;
                    }
                    case 525316: {
                        this.setRingStrainAngles(n, 0, 4, 2.0663f);
                        this.setRingStrainAngles(n, 0, 8, 2.0663f);
                        this.setRingStrainAngles(n, 4, 4, 114.56f * TO_RADIAN);
                    }
                    case 394758: {
                        this.setRingStrainAngles(n, 0, 6, 2.5261f);
                        break;
                    }
                    case 460550: {
                        this.setRingStrainAngles(n, 0, 6, 2.3562f);
                        this.setRingStrainAngles(n, 0, 7, 2.3562f);
                        break;
                    }
                    case 526087: {
                        this.setRingStrainAngles(n, 0, 7, 2.2845f);
                        this.setRingStrainAngles(n, 0, 8, 2.2845f);
                        break;
                    }
                    case 526344: {
                        this.setRingStrainAngles(n, 0, 8, 2.1863f);
                        break;
                    }
                    case 0x3030303: {
                        this.setRingStrainAngles(n, 3, 3, 2.4189f);
                        break;
                    }
                    case 0x4040303: {
                        this.setRingStrainAngles(n, 3, 4, 2.2299f);
                        break;
                    }
                    case 0x4040404: {
                        this.setRingStrainAngles(n, 4, 4, 2.0944f);
                        break;
                    }
                    case 0x6060303: {
                        this.setRingStrainAngles(n, 3, 6, 105.42f * TO_RADIAN);
                        this.setRingStrainAngles(n, 3, 3, 166.51f * TO_RADIAN);
                        break;
                    }
                    case 117834755: {
                        this.setRingStrainAngles(n, 3, 4, 161.13f * TO_RADIAN);
                        this.setRingStrainAngles(n, 3, 7, 102.62f * TO_RADIAN);
                        this.setRingStrainAngles(n, 4, 6, 121.61f * TO_RADIAN);
                        break;
                    }
                    case 134677507: {
                        this.setRingStrainAngles(n, 3, 4, 151.4f * TO_RADIAN);
                        this.setRingStrainAngles(n, 3, 8, 116.18f * TO_RADIAN);
                        this.setRingStrainAngles(n, 4, 7, 129.0f * TO_RADIAN);
                        break;
                    }
                    case 0x7070303: {
                        this.setRingStrainAngles(n, 3, 7, 120.88f * TO_RADIAN);
                        this.setRingStrainAngles(n, 3, 3, 177.92f * TO_RADIAN);
                        break;
                    }
                    case 0x7070404: {
                        this.setRingStrainAngles(n, 4, 7, 119.79f * TO_RADIAN);
                        this.setRingStrainAngles(n, 4, 4, 146.2f * TO_RADIAN);
                        break;
                    }
                    case 0x8080404: {
                        this.setRingStrainAngles(n, 4, 8, 122.57f * TO_RADIAN);
                        this.setRingStrainAngles(n, 4, 4, 134.76f * TO_RADIAN);
                    }
                }
                continue;
            }
            float f = this.mMol.getAtomicNo(n) > 10 ? 1.910612f : (this.mMol.getAtomPi(n) == 2 ? (float)Math.PI : (this.mMol.isFlatNitrogen(n) ? 2.0943952f : (this.mMol.getAtomPi(n) == 0 ? 1.910612f : 2.0943952f)));
            for (n3 = 1; n3 < n4; ++n3) {
                for (n2 = 0; n2 < n3; ++n2) {
                    this.mBondAngle[n][n3][n2] = f;
                }
            }
        }
    }

    public float getAngle(int n, int n2, int n3) {
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < this.mMol.getAllConnAtoms(n); ++i) {
            int n6 = this.mMol.getConnAtom(n, i);
            if (n6 != n2 && n6 != n3) continue;
            if (n5 == -1) {
                n5 = i;
                continue;
            }
            n4 = i;
            break;
        }
        return this.mBondAngle[n][n4][n5];
    }

    public float getConnAngle(int n, int n2, int n3) {
        return n2 < n3 ? this.mBondAngle[n][n3][n2] : this.mBondAngle[n][n2][n3];
    }

    private void calculateBondAnglesOfFlatRings() {
        RingCollection ringCollection = this.mMol.getRingSet();
        boolean[] blArray = new boolean[ringCollection.getSize()];
        ringCollection.determineAromaticity(blArray, new boolean[ringCollection.getSize()], new int[ringCollection.getSize()], true);
        for (int i = 3; i <= 7; ++i) {
            for (int j = 0; j < ringCollection.getSize(); ++j) {
                int n = ringCollection.getRingSize(j);
                if (n != i) continue;
                if (blArray[j]) {
                    this.calculateBondAnglesOfAromaticRing(j);
                    continue;
                }
                if (n > 4) continue;
                this.calculateBondAnglesOfSmallRing(j);
            }
        }
    }

    private void calculateBondAnglesOfSmallRing(int n) {
        RingCollection ringCollection = this.mMol.getRingSet();
        int n2 = ringCollection.getRingSize(n);
        int[] nArray = ringCollection.getRingBonds(n);
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            if (this.mTinyRingSizeSum[nArray[i]] != 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            int n3;
            float f = (180.0f * (float)n2 - 360.0f) / (float)n2 * TO_RADIAN;
            int[] nArray2 = ringCollection.getRingAtoms(n);
            for (n3 = 0; n3 < n2; ++n3) {
                this.setBondAngle(nArray2[n3], nArray[n3 == 0 ? n2 - 1 : n3 - 1], nArray[n3], f);
            }
            if (n2 <= 4) {
                for (n3 = 0; n3 < n2; ++n3) {
                    int n4 = nArray[n3];
                    this.mTinyRingSizeSum[n4] = this.mTinyRingSizeSum[n4] + n2;
                }
            }
        }
    }

    private void calculateBondAnglesOfAromaticRing(int n) {
        float f;
        int n2;
        RingCollection ringCollection = this.mMol.getRingSet();
        int n3 = ringCollection.getRingSize(n);
        int[] nArray = ringCollection.getRingAtoms(n);
        int[] nArray2 = ringCollection.getRingBonds(n);
        boolean bl = true;
        for (int i = 1; i < n3; ++i) {
            if (this.mBondLengthSet.getLength(nArray2[i]) == this.mBondLengthSet.getLength(nArray2[0])) continue;
            bl = false;
            break;
        }
        if (bl) {
            float f2 = ((float)n3 - 2.0f) * (float)Math.PI / (float)n3;
            for (int i = 0; i < n3; ++i) {
                this.setBondAngle(nArray[i], nArray2[i], nArray2[i == 0 ? n3 - 1 : i - 1], f2);
            }
            return;
        }
        float[] fArray = new float[n3];
        float f3 = 0.0f;
        for (int i = 0; i < n3; ++i) {
            fArray[i] = this.mMol.getAtomPi(nArray[i]) == 0 ? 109.47f * TO_RADIAN : (this.mMol.getAtomPi(nArray[i]) == 1 ? 2.0944998f : (float)Math.PI);
            f3 += fArray[i];
        }
        float f4 = (((float)n3 - 2.0f) * (float)Math.PI - f3) / (float)n3;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n4++;
            fArray[n5] = fArray[n5] + f4;
        }
        float[] fArray2 = new float[n3];
        for (int i = 1; i < n3; ++i) {
            fArray2[i] = fArray2[i - 1] + (float)Math.PI - fArray[i];
        }
        float[] fArray3 = new float[n3];
        for (n2 = 0; n2 < 100; ++n2) {
            float f5 = 0.0f;
            f = 0.0f;
            for (int i = 0; i < n3; ++i) {
                f5 = (float)((double)f5 + (double)this.mBondLengthSet.getLength(nArray2[i]) * Math.sin(fArray2[i]));
                f = (float)((double)f + (double)this.mBondLengthSet.getLength(nArray2[i]) * Math.cos(fArray2[i]));
            }
            float f6 = (float)Molecule.getAngle(0.0, 0.0, f5, f);
            float f7 = (float)Math.sqrt(f5 * f5 + f * f);
            int n6 = -1;
            float f8 = 0.0f;
            for (int i = 0; i < n3; ++i) {
                int n7 = i == 0 ? n3 - 1 : i - 1;
                int n8 = i + 1 == n3 ? 0 : i + 1;
                float f9 = (float)Molecule.getAngleDif(fArray2[i], fArray2[n7]);
                float f10 = (float)Molecule.getAngleDif(fArray2[n8], fArray2[i]);
                float f11 = (float)Molecule.getAngleDif(fArray[i], fArray[n8]);
                fArray3[i] = 2.0f * f9 - 2.0f * f10 + 2.0f * f11;
                float f12 = (float)Math.cos(fArray2[i] - 1.5707964f - f6);
                float f13 = f7 * f12 - 0.03f * fArray3[i];
                if (!(Math.abs(f13) > Math.abs(f8))) continue;
                f8 = f13;
                n6 = i;
            }
            float f14 = (float)Math.exp(-5.0f * (float)n2 / 100.0f);
            int n9 = n6;
            fArray2[n9] = fArray2[n9] + f14 * f8;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            int n10 = n2 == 0 ? n3 - 1 : n2 - 1;
            f = fArray2[n10] + (float)Math.PI - fArray2[n2];
            if ((double)f > Math.PI * 2) {
                f = (float)((double)f - Math.PI * 2);
            }
            this.setBondAngle(nArray[n2], nArray2[n10], nArray2[n2], f);
        }
    }

    private int getRingStrainClass(int n) {
        boolean[] blArray = new boolean[this.mMol.getConnAtoms(n)];
        int n2 = 0;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            int n3 = 0;
            int n4 = -1;
            for (int j = 0; j < this.mMol.getConnAtoms(n); ++j) {
                int n5;
                if (blArray[j] || n3 >= this.mTinyRingSizeSum[n5 = this.mMol.getConnBond(n, j)]) continue;
                n3 = this.mTinyRingSizeSum[n5];
                n4 = j;
            }
            if (n3 == 0) {
                return n2;
            }
            n2 <<= 8;
            n2 += n3;
            blArray[n4] = true;
        }
        return n2;
    }

    private void setRingStrainAngles(int n, int n2, int n3, float f) {
        int n4 = this.mMol.getAllConnAtoms(n);
        int n5 = this.mMol.getConnAtoms(n);
        for (int i = 1; i < n4; ++i) {
            int n6 = i < n5 ? this.mTinyRingSizeSum[this.mMol.getConnBond(n, i)] : 0;
            for (int j = 0; j < i; ++j) {
                int n7;
                if ((double)this.mBondAngle[n][i][j] != 0.0) continue;
                int n8 = n7 = j < n5 ? this.mTinyRingSizeSum[this.mMol.getConnBond(n, j)] : 0;
                if ((n6 != n2 || n7 != n3) && (n6 != n3 || n7 != n2)) continue;
                this.mBondAngle[n][i][j] = f;
            }
        }
    }

    private void setBondAngle(int n, int n2, int n3, float f) {
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < this.mMol.getAllConnAtoms(n); ++i) {
            int n6 = this.mMol.getConnBond(n, i);
            if (n6 != n2 && n6 != n3) continue;
            if (n4 == -1) {
                n4 = i;
                continue;
            }
            n5 = i;
            break;
        }
        if ((double)this.mBondAngle[n][n5][n4] == 0.0) {
            this.mBondAngle[n][n5][n4] = f;
            int n7 = n;
            this.mDefinedAngleSum[n7] = this.mDefinedAngleSum[n7] + f;
            int n8 = n;
            this.mDefinedAngleCount[n8] = this.mDefinedAngleCount[n8] + 1;
        }
    }

    private float calculateRemainingTetrahedralAngle(float f) {
        float f2 = 1.910612f;
        return f2 + (f2 - f) * 0.18f;
    }
}

