/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem.alignment3d.transformation;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.alignment3d.transformation.Quaternion;
import com.actelion.research.chem.alignment3d.transformation.Rotation;
import com.actelion.research.chem.alignment3d.transformation.Scaling;
import com.actelion.research.chem.alignment3d.transformation.Transformation;
import com.actelion.research.chem.alignment3d.transformation.Translation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class TransformationSequence
implements Transformation {
    public static final char DELIMITER_START = '{';
    public static final char DELIMITER_END = '}';
    private static final char DELIMITER = ',';
    List<Transformation> transformationSequence = new ArrayList<Transformation>();

    public TransformationSequence(Quaternion quaternion) {
        this();
        Rotation rotation = new Rotation(quaternion.getRotMatrix().getArray());
        double d = 1.0 / quaternion.normSquared();
        Scaling scaling = new Scaling(d);
        this.transformationSequence.add(rotation);
        this.transformationSequence.add(scaling);
    }

    public TransformationSequence() {
    }

    public void addTransformation(Transformation transformation) {
        this.transformationSequence.add(transformation);
    }

    public List<Transformation> getTransformations() {
        return this.transformationSequence;
    }

    @Override
    public void apply(Coordinates coordinates) {
        for (Transformation transformation : this.transformationSequence) {
            transformation.apply(coordinates);
        }
    }

    @Override
    public void apply(double[] dArray) {
        for (Transformation transformation : this.transformationSequence) {
            transformation.apply(dArray);
        }
    }

    @Override
    public void apply(StereoMolecule stereoMolecule) {
        for (Transformation transformation : this.transformationSequence) {
            transformation.apply(stereoMolecule);
        }
    }

    private static List<Transformation> processSubstring(List<Character> list) {
        String[] stringArray;
        ArrayList<Transformation> arrayList = new ArrayList<Transformation>();
        String string = list.stream().map(String::valueOf).collect(Collectors.joining());
        for (String string2 : stringArray = string.split(String.valueOf(','))) {
            String[] stringArray2 = string2.split(" ");
            String string3 = stringArray2[0];
            if (string3.equals("r")) {
                arrayList.add(Rotation.decode(stringArray2[1]));
                continue;
            }
            if (string3.equals("s")) {
                arrayList.add(Scaling.decode(stringArray2[1]));
                continue;
            }
            if (!string3.equals("t")) continue;
            arrayList.add(Translation.decode(stringArray2[1]));
        }
        return arrayList;
    }

    public static TransformationSequence decode(String string) {
        char[] cArray = string.toCharArray();
        ArrayList<Character> arrayList = new ArrayList<Character>();
        for (char c : cArray) {
            arrayList.add(Character.valueOf(c));
        }
        Object object = arrayList.iterator();
        object.next();
        return TransformationSequence.decode((Iterator<Character>)object);
    }

    private static TransformationSequence decode(Iterator<Character> iterator) {
        TransformationSequence transformationSequence = new TransformationSequence();
        ArrayList<Character> arrayList = new ArrayList<Character>();
        while (iterator.hasNext()) {
            List<Transformation> list;
            char c = iterator.next().charValue();
            if (c == '}') {
                list = TransformationSequence.processSubstring(arrayList);
                list.stream().forEach(transformation -> transformationSequence.addTransformation((Transformation)transformation));
                arrayList.clear();
                return transformationSequence;
            }
            if (c == '{') {
                list = TransformationSequence.processSubstring(arrayList);
                list.stream().forEach(transformation -> transformationSequence.addTransformation((Transformation)transformation));
                arrayList.clear();
                transformationSequence.addTransformation(TransformationSequence.decode(iterator));
                continue;
            }
            arrayList.add(Character.valueOf(c));
        }
        return transformationSequence;
    }

    @Override
    public String encode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (Transformation transformation : this.transformationSequence) {
            stringBuilder.append(transformation.encode());
            stringBuilder.append(',');
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

