/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AbstractDrawingObject;
import com.actelion.research.chem.DepictorTransformation;
import com.actelion.research.gui.generic.GenericDrawContext;
import com.actelion.research.gui.generic.GenericPoint;
import com.actelion.research.gui.generic.GenericRectangle;
import java.util.ArrayList;

public class TextDrawingObject
extends AbstractDrawingObject {
    public static final String TYPE_STRING = "text";
    public static final double DEFAULT_SIZE = 9.0;
    public static final int DEFAULT_STYLE = 0;
    private static final float LINE_SPACING = 1.4f;
    private double mSize;
    private double mZoomReferenceSize;
    private String mText;
    private int mStyle;
    private boolean mHilite;
    private GenericRectangle mLastBounds;

    public TextDrawingObject() {
        this("", new GenericPoint(), 9.0, 0);
    }

    public TextDrawingObject(String string, double d, double d2) {
        this(string, d, d2, 9.0, 0);
    }

    public TextDrawingObject(String string, double d, double d2, double d3, int n) {
        this(string, new GenericPoint(d, d2), d3, n);
    }

    public TextDrawingObject(String string) {
        this();
        int n;
        int n2 = 0;
        while (n2 != -1 && (n = string.indexOf("=\"", n2)) != -1) {
            String string2;
            String string3 = string.substring(n2 + 1, n);
            n2 = string.indexOf("\"", n + 2);
            String string4 = string2 = n2 == -1 ? string.substring(n + 1) : string.substring(n + 1, n2);
            if (string3.equals(TYPE_STRING)) {
                this.setText(string2);
                continue;
            }
            if (string3.equals("x")) {
                this.setX(string2);
                continue;
            }
            if (string3.equals("y")) {
                this.setY(string2);
                continue;
            }
            if (string3.equals("size")) {
                this.setSize(string2);
                continue;
            }
            if (!string3.equals("style")) continue;
            this.setStyle(string2);
        }
    }

    protected void setText(String string) {
        this.mText = this.decodeText(string);
    }

    protected void setX(String string) {
        try {
            this.mPoint[0].x = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setY(String string) {
        try {
            this.mPoint[0].y = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setSize(String string) {
        try {
            this.mSize = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void setStyle(String string) {
        try {
            this.mStyle = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private TextDrawingObject(String string, GenericPoint genericPoint, double d, int n) {
        this.mText = string;
        this.mSize = d;
        this.mStyle = n;
        this.mPoint = new GenericPoint[1];
        this.mPoint[0] = genericPoint;
    }

    @Override
    public String getTypeString() {
        return TYPE_STRING;
    }

    @Override
    public String getDescriptorDetail() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" text=\"" + this.encodeText(this.mText) + "\"");
        stringBuilder.append(" x=\"" + this.mPoint[0].x + "\"");
        stringBuilder.append(" y=\"" + this.mPoint[0].y + "\"");
        if (this.mSize != 9.0) {
            stringBuilder.append(String.format(" size=\"%.4f\"", new Double(this.mSize)));
        }
        if (this.mStyle != 0) {
            stringBuilder.append(" style=\"" + this.mStyle + "\"");
        }
        return stringBuilder.toString();
    }

    @Override
    public AbstractDrawingObject clone() {
        TextDrawingObject textDrawingObject = new TextDrawingObject();
        textDrawingObject.setValues(this.mText, this.mSize, this.mStyle);
        textDrawingObject.setCoordinates(this.mPoint[0].x, this.mPoint[0].y);
        textDrawingObject.mIsSelected = this.mIsSelected;
        return textDrawingObject;
    }

    public void setCoordinates(double d, double d2) {
        this.mPoint[0].x = d;
        this.mPoint[0].y = d2;
    }

    @Override
    public void scale(double d) {
        super.scale(d);
        this.mSize *= d;
    }

    @Override
    public void zoomAndRotateInit(double d, double d2) {
        super.zoomAndRotateInit(d, d2);
        this.mZoomReferenceSize = this.mSize;
    }

    @Override
    public void zoomAndRotate(double d, double d2) {
        super.zoomAndRotate(d, d2);
        this.mSize = this.mZoomReferenceSize * d;
    }

    @Override
    public void draw(GenericDrawContext genericDrawContext, DepictorTransformation depictorTransformation) {
        float f = (float)(depictorTransformation == null ? this.mSize : depictorTransformation.getScaling() * this.mSize);
        genericDrawContext.setFont(Math.round(f), (this.mStyle & 1) != 0, (this.mStyle & 2) != 0);
        genericDrawContext.setRGB(this.mIsSelected ? -65536 : (genericDrawContext.isDarkBackground() ? -1 : -16777216));
        ArrayList<String> arrayList = this.getTextLineList();
        this.mLastBounds = this.calculateBoundingRect(genericDrawContext, arrayList);
        if (depictorTransformation != null) {
            depictorTransformation.applyTo(this.mLastBounds);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            genericDrawContext.drawString(this.mLastBounds.x, this.mLastBounds.y + 1.0 + (double)(f * 5.0f / 6.0f) + (double)(f * 1.4f * (float)i), arrayList.get(i));
        }
    }

    private GenericRectangle calculateBoundingRect(GenericDrawContext genericDrawContext, ArrayList<String> arrayList) {
        double d = 0.0;
        for (String string : arrayList) {
            double d2;
            if (string.length() == 0 || !(d < (d2 = genericDrawContext.getBounds(string).getWidth()))) continue;
            d = d2;
        }
        double d3 = this.mSize * (double)1.4f * (double)(arrayList.size() - 1) + this.mSize;
        return new GenericRectangle(this.mPoint[0].x, this.mPoint[0].y - this.mSize / 2.0, d, d3);
    }

    @Override
    public GenericRectangle getBoundingRect(GenericDrawContext genericDrawContext) {
        ArrayList<String> arrayList = this.getTextLineList();
        return this.calculateBoundingRect(genericDrawContext, arrayList);
    }

    private ArrayList<String> getTextLineList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.mText.indexOf(10);
        if (n == -1) {
            arrayList.add(this.mText);
        } else {
            int n2 = 0;
            while (n != -1) {
                arrayList.add(this.mText.substring(n2, n));
                n2 = n + 1;
                n = this.mText.indexOf(10, n2);
            }
            arrayList.add(this.mText.substring(n2));
        }
        return arrayList;
    }

    @Override
    public void hilite(GenericDrawContext genericDrawContext) {
        GenericRectangle genericRectangle = this.getBoundingRect(genericDrawContext);
        genericDrawContext.setRGB(genericDrawContext.getSelectionBackgroundRGB());
        genericDrawContext.fillRectangle(genericRectangle.x, genericRectangle.y, genericRectangle.width, genericRectangle.height);
    }

    @Override
    public boolean checkHiliting(double d, double d2) {
        this.mHilite = this.contains(d, d2);
        return this.mHilite;
    }

    @Override
    public boolean contains(double d, double d2) {
        return this.mLastBounds != null && this.mLastBounds.contains(d, d2);
    }

    @Override
    public void clearHiliting() {
        this.mHilite = false;
    }

    public void setValues(String string, double d, int n) {
        this.mText = string;
        this.mSize = d;
        this.mStyle = n;
    }

    public String getText() {
        return this.mText;
    }

    public double getSize() {
        return this.mSize;
    }

    public int getStyle() {
        return this.mStyle;
    }

    private String encodeText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '&': {
                    stringBuffer.append("&&");
                    continue block6;
                }
                case '\t': {
                    stringBuffer.append("&09");
                    continue block6;
                }
                case '\n': {
                    stringBuffer.append("&0A");
                    continue block6;
                }
                case ' ': {
                    stringBuffer.append("&20");
                    continue block6;
                }
                default: {
                    stringBuffer.append(string.charAt(i));
                }
            }
        }
        return stringBuffer.toString();
    }

    private String decodeText(String string) {
        int n = string.indexOf(38);
        if (n == -1) {
            return string;
        }
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            if (string.charAt(n + 1) == '&') {
                stringBuffer.append('&');
                n2 = n + 2;
            } else {
                int n3;
                int n4 = string.charAt(n + 2);
                stringBuffer.append((char)(16 * (n3 -= (n3 = string.charAt(n + 1)) < 65 ? 48 : (n3 < 97 ? 65 : 97)) + (n4 -= n4 < 65 ? 48 : (n4 < 97 ? 65 : 97))));
                n2 = n + 3;
            }
            n = string.indexOf(38, n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }
}

