/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.IsomericSmilesCreator;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.SmilesRange;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import com.actelion.research.chem.reaction.Reaction;
import com.actelion.research.util.ArrayUtils;
import com.actelion.research.util.SortedList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;

public class SmilesParser {
    private static final int SMARTS_MODE_MASK = 3;
    public static final int SMARTS_MODE_IS_SMILES = 0;
    public static final int SMARTS_MODE_GUESS = 1;
    public static final int SMARTS_MODE_IS_SMARTS = 2;
    public static final int MODE_SKIP_COORDINATE_TEMPLATES = 4;
    public static final int MODE_MAKE_HYDROGEN_EXPLICIT = 8;
    public static final int MODE_NO_CACTUS_SYNTAX = 16;
    private static final int INITIAL_CONNECTIONS = 16;
    private static final int MAX_CONNECTIONS = 100;
    private static final int BRACKET_LEVELS = 32;
    private static final int MAX_AROMATIC_RING_SIZE = 15;
    private static final int HYDROGEN_ANY = -1;
    private static final int HYDROGEN_IMPLICIT_ZERO = 9;
    private StereoMolecule mMol;
    private boolean[] mIsAromaticBond;
    private int mAromaticAtoms;
    private int mAromaticBonds;
    private int mSmartsMode;
    private int mCoordinateMode;
    private long mRandomSeed;
    private boolean mCreateSmartsWarnings;
    private boolean mMakeHydrogenExplicit;
    private boolean mAllowCactvs;
    private StringBuilder mSmartsWarningBuffer;

    public SmilesParser() {
        this(0, false);
    }

    public SmilesParser(int n, boolean bl) {
        this.mSmartsMode = n & 3;
        this.mAllowCactvs = (n & 0x10) == 0;
        this.mCreateSmartsWarnings = bl;
        this.mMakeHydrogenExplicit = (n & 8) != 0;
        this.mCoordinateMode = 2;
        if ((n & 4) != 0) {
            this.mCoordinateMode |= 1;
        }
        if (this.mMakeHydrogenExplicit) {
            this.mCoordinateMode &= 0xFFFFFFFD;
        }
    }

    public void setRandomSeed(long l) {
        this.mRandomSeed = l;
    }

    public StereoMolecule parseMolecule(String string) {
        return string == null ? null : this.parseMolecule(string.getBytes());
    }

    public StereoMolecule parseMolecule(byte[] byArray) {
        StereoMolecule stereoMolecule = new StereoMolecule();
        try {
            this.parse(stereoMolecule, byArray);
        }
        catch (Exception exception) {
            return null;
        }
        return stereoMolecule;
    }

    public Reaction parseReaction(String string) throws Exception {
        return string == null ? null : this.parseReaction(string.getBytes());
    }

    public Reaction parseReaction(byte[] byArray) throws Exception {
        StereoMolecule stereoMolecule;
        StereoMolecule stereoMolecule2;
        int n;
        int n2;
        int n3 = ArrayUtils.indexOf(byArray, (byte)62);
        int n4 = n2 = n3 == -1 ? -1 : ArrayUtils.indexOf(byArray, (byte)62, n3 + 1);
        if (n2 == -1) {
            throw new Exception("Missing one or both separators ('>').");
        }
        if (ArrayUtils.indexOf(byArray, (byte)62, n2 + 1) != -1) {
            throw new Exception("Found more than 2 separators ('>').");
        }
        Reaction reaction = new Reaction();
        for (int i = n = 0; i < n3 - 1; ++i) {
            if (byArray[i] != 46 || byArray[i + 1] != 46) continue;
            if (i > n) {
                stereoMolecule2 = new StereoMolecule();
                this.parse(stereoMolecule2, byArray, n, i);
                reaction.addReactant(stereoMolecule2);
            }
            n = i + 2;
        }
        StereoMolecule stereoMolecule3 = new StereoMolecule();
        this.parse(stereoMolecule3, byArray, n, n3);
        reaction.addReactant(stereoMolecule3);
        if (n2 - n3 > 1) {
            for (int i = n = n3 + 1; i < n2 - 1; ++i) {
                if (byArray[i] != 46 || byArray[i + 1] != 46) continue;
                if (i > n) {
                    stereoMolecule = new StereoMolecule();
                    this.parse(stereoMolecule, byArray, n, i);
                    reaction.addCatalyst(stereoMolecule);
                }
                n = i + 2;
            }
            stereoMolecule2 = new StereoMolecule();
            this.parse(stereoMolecule2, byArray, n, n2);
            reaction.addCatalyst(stereoMolecule2);
        }
        for (int i = n = n2 + 1; i < byArray.length - 1; ++i) {
            if (byArray[i] != 46 || byArray[i + 1] != 46) continue;
            if (i > n) {
                stereoMolecule = new StereoMolecule();
                this.parse(stereoMolecule, byArray, n, i);
                reaction.addProduct(stereoMolecule);
            }
            n = i + 2;
        }
        StereoMolecule stereoMolecule4 = new StereoMolecule();
        this.parse(stereoMolecule4, byArray, n, byArray.length);
        reaction.addProduct(stereoMolecule4);
        return reaction;
    }

    public String getSmartsWarning() {
        return this.mSmartsWarningBuffer == null ? "" : "Unresolved SMARTS features:" + this.mSmartsWarningBuffer;
    }

    public void parse(StereoMolecule stereoMolecule, String string) throws Exception {
        this.parse(stereoMolecule, string.getBytes(), true, true);
    }

    public void parse(StereoMolecule stereoMolecule, byte[] byArray) throws Exception {
        this.parse(stereoMolecule, byArray, true, true);
    }

    public void parse(StereoMolecule stereoMolecule, byte[] byArray, int n, int n2) throws Exception {
        this.parse(stereoMolecule, byArray, n, n2, true, true);
    }

    public void parse(StereoMolecule stereoMolecule, byte[] byArray, boolean bl, boolean bl2) throws Exception {
        this.parse(stereoMolecule, byArray, 0, byArray.length, bl, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(StereoMolecule stereoMolecule, byte[] byArray, int n, int n2, boolean bl, boolean bl2) throws Exception {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        this.mMol = stereoMolecule;
        this.mMol.clear();
        if (this.mSmartsWarningBuffer != null) {
            this.mSmartsWarningBuffer.setLength(0);
        }
        this.mAromaticAtoms = 0;
        boolean bl3 = this.mSmartsMode != 0;
        TreeMap<Integer, THParity> treeMap = null;
        int[] nArray = new int[32];
        nArray[0] = -1;
        int[] nArray2 = new int[16];
        int[] nArray3 = new int[16];
        int[] nArray4 = new int[16];
        int[] nArray5 = new int[16];
        for (n7 = 0; n7 < 16; ++n7) {
            nArray2[n7] = -1;
        }
        n7 = 0;
        int n8 = -1;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n9 = 0;
        int n10 = 1;
        int n11 = 0;
        SortedList<Integer> sortedList = new SortedList<Integer>();
        SmilesRange smilesRange = new SmilesRange(byArray);
        while (byArray[n] <= 32) {
            ++n;
        }
        block12: while (n < n2) {
            int n12;
            char c;
            if (Character.isLetter(c = (char)byArray[n++]) || c == '*' || c == '?' || c == '!' && bl3 && bl4 || c == '#' && bl3 && bl4) {
                THParity tHParity;
                int n13;
                int n14;
                n6 = -1;
                n5 = 0;
                n12 = 0;
                n4 = -1;
                n3 = -1;
                boolean bl7 = false;
                int n15 = 0;
                int n16 = 0;
                if (bl4) {
                    int n17;
                    if (c == '*') {
                        n6 = 6;
                        n16 = (int)((long)n16 | 1L);
                    } else if (c == '?') {
                        n6 = 0;
                    } else if (c == '#') {
                        n14 = 0;
                        while (n < n2 && Character.isDigit(byArray[n])) {
                            n14 = 10 * n14 + byArray[n] - 48;
                            ++n;
                        }
                        if (n14 < 1 || n14 >= Molecule.cAtomLabel.length) {
                            throw new Exception("SmilesParser: Atomic number out of range.");
                        }
                        n6 = n14;
                    } else {
                        int n18 = n14 = c == '!' ? 1 : 0;
                        if (n14 != 0) {
                            bl6 = true;
                            n16 = (int)((long)n16 | 1L);
                            ++n;
                        }
                        if (byArray[n - 1] == 82 && bl3 && (Character.isDigit(byArray[n]) || this.mAllowCactvs && byArray[n] == 123)) {
                            n6 = 6;
                            n16 = (int)((long)n16 | 1L);
                            --n;
                            if (n14 != 0) {
                                --n;
                            }
                        } else {
                            n17 = Character.isLowerCase(byArray[n]) ? 2 : 1;
                            n6 = Molecule.getAtomicNoFromLabel(new String(byArray, n - 1, n17));
                            if (n6 == -1) {
                                n6 = 6;
                                n16 = (int)((long)n16 | 1L);
                                --n;
                            } else {
                                n3 = 9;
                                if (bl3 && (byArray[n += n17 - 1] == 44 || n14 != 0)) {
                                    int n19;
                                    n13 = 0;
                                    boolean bl8 = false;
                                    for (int i = n19 = n - n17; i < byArray.length; ++i) {
                                        if (Character.isLetter(byArray[i])) continue;
                                        int n20 = Molecule.getAtomicNoFromLabel(new String(byArray, n19, i - n19));
                                        if (n20 != 0) {
                                            sortedList.add(n20);
                                            if (Character.isUpperCase(byArray[n19])) {
                                                n13 = 1;
                                            } else {
                                                bl8 = true;
                                            }
                                        }
                                        n19 = i + 1;
                                        if (byArray[i] != 44) break;
                                        if (byArray[i + 1] != 33) continue;
                                        if (n14 == 0) {
                                            throw new Exception("SmilesParser: inconsistent '!' in atom list.");
                                        }
                                        ++i;
                                        ++n19;
                                    }
                                    if (sortedList.size() > 1) {
                                        n3 = -1;
                                        if (n13 == 0) {
                                            n16 = (int)((long)n16 | 2L);
                                        } else if (!bl8) {
                                            n16 = (int)((long)n16 | 4L);
                                        }
                                    }
                                    n = n19 - 1;
                                }
                            }
                        }
                    }
                    while (bl4) {
                        if (byArray[n] == 64) {
                            if (byArray[++n] == 64) {
                                n15 = 1;
                                ++n;
                            }
                            bl7 = true;
                            continue;
                        }
                        if (byArray[n] == 58) {
                            ++n;
                            while (Character.isDigit(byArray[n])) {
                                n12 = 10 * n12 + byArray[n] - 48;
                                ++n;
                            }
                            continue;
                        }
                        if (byArray[n] == 91) {
                            throw new Exception("SmilesParser: nested square brackets found");
                        }
                        if (byArray[n] == 93) {
                            ++n;
                            bl4 = false;
                            continue;
                        }
                        if (byArray[n] == 43) {
                            n5 = 1;
                            ++n;
                            while (byArray[n] == 43) {
                                ++n5;
                                ++n;
                            }
                            if (n5 == 1 && Character.isDigit(byArray[n])) {
                                n5 = byArray[n] - 48;
                                ++n;
                            }
                            if (n5 != 0) continue;
                            n16 = (int)((long)n16 | 0xA000000L);
                            continue;
                        }
                        if (byArray[n] == 45) {
                            n5 = -1;
                            ++n;
                            while (byArray[n] == 45) {
                                --n5;
                                ++n;
                            }
                            if (n5 == -1 && Character.isDigit(byArray[n])) {
                                n5 = 48 - byArray[n];
                                ++n;
                            }
                            if (n5 != 0) continue;
                            n16 = (int)((long)n16 | 0xA000000L);
                            continue;
                        }
                        int n21 = n14 = byArray[n] == 33 ? 1 : 0;
                        if (n14 != 0) {
                            ++n;
                        }
                        if (byArray[n] == 72) {
                            ++n;
                            n += smilesRange.parse(byArray, n, 1, 1);
                            n3 = smilesRange.min;
                            n17 = 0;
                            if (smilesRange.min <= 0 && smilesRange.max >= 0) {
                                n17 = (int)((long)n17 | 0x80L);
                            }
                            if (smilesRange.min <= 1 && smilesRange.max >= 1) {
                                n17 = (int)((long)n17 | 0x100L);
                            }
                            if (smilesRange.min <= 2 && smilesRange.max >= 2) {
                                n17 = (int)((long)n17 | 0x200L);
                            }
                            if (smilesRange.min <= 3 && smilesRange.max >= 3) {
                                n17 = (int)((long)n17 | 0x400L);
                            }
                            if (n14 != 0) {
                                n16 |= n17;
                                n3 = -1;
                                continue;
                            }
                            if (smilesRange.isSingle()) {
                                n3 = smilesRange.min;
                                continue;
                            }
                            n16 = (int)((long)n16 | 0x780L & (long)(~n17));
                            n3 = -1;
                            continue;
                        }
                        if (byArray[n] == 68) {
                            ++n;
                            n += smilesRange.parse(byArray, n, 1, 1);
                            long l = 0L;
                            if (smilesRange.min <= 0 && smilesRange.max >= 0) {
                                l |= 0x20000L;
                            }
                            if (smilesRange.min <= 1 && smilesRange.max >= 1) {
                                l |= 0x40000L;
                            }
                            if (smilesRange.min <= 2 && smilesRange.max >= 2) {
                                l |= 0x80000L;
                            }
                            if (smilesRange.min <= 3 && smilesRange.max >= 3) {
                                l |= 0x100000L;
                            }
                            if (smilesRange.min <= 4 && smilesRange.max >= 4) {
                                l |= 0x200000L;
                            }
                            if (l == 0L) continue;
                            if (n14 == 0) {
                                l ^= 0x3E0000L;
                            }
                            n16 = (int)((long)n16 | l);
                            continue;
                        }
                        if (byArray[n] == 122 && this.mAllowCactvs) {
                            ++n;
                            n += smilesRange.parse(byArray, n, 1, 4);
                            long l = 0L;
                            if (smilesRange.min <= 0 && smilesRange.max >= 0) {
                                l |= 0x8000000000L;
                            }
                            if (smilesRange.min <= 1 && smilesRange.max >= 1) {
                                l |= 0x10000000000L;
                            }
                            if (smilesRange.min <= 2 && smilesRange.max >= 2) {
                                l |= 0x20000000000L;
                            }
                            if (smilesRange.min <= 3 && smilesRange.max >= 3) {
                                l |= 0x40000000000L;
                            }
                            if (smilesRange.min <= 4 && smilesRange.max >= 4) {
                                l |= 0x80000000000L;
                            }
                            if (l == 0L) continue;
                            if (n14 == 0) {
                                l ^= 0xF8000000000L;
                            }
                            n16 = (int)((long)n16 | l);
                            continue;
                        }
                        if (byArray[n] == 88) {
                            ++n;
                            n += smilesRange.parse(byArray, n, 1, 1);
                            byte[] byArray2 = Molecule.cAtomValence[n6];
                            if (byArray2 == null) continue;
                            n13 = byArray2[0];
                            long l = 0L;
                            if (n13 - smilesRange.min <= 0 && n13 - smilesRange.max >= 0) {
                                l |= 0x4000L;
                            }
                            if (n13 - smilesRange.min <= 1 && n13 - smilesRange.max >= 1) {
                                l |= 0x8000L;
                            }
                            if (n13 - smilesRange.min <= 2 && n13 - smilesRange.max >= 2) {
                                l |= 0x10000L;
                            }
                            if (l == 0L) continue;
                            if (n14 == 0) {
                                l ^= 0x1C000L;
                            }
                            n16 = (int)((long)n16 | l);
                            continue;
                        }
                        if (byArray[n] == 65 || byArray[n] == 97) {
                            n16 = (int)((long)n16 | ((n14 ^ (byArray[++n] == 65 ? 1 : 0)) != 0 ? 4L : 2L));
                            continue;
                        }
                        if (byArray[n] == 82) {
                            ++n;
                            n += smilesRange.parse(byArray, n, 1, 3);
                            long l = 0L;
                            if (smilesRange.min <= 0 && smilesRange.max >= 0) {
                                l |= 8L;
                            }
                            if (smilesRange.min <= 1 && smilesRange.max >= 1) {
                                l |= 0x10L;
                            }
                            if (smilesRange.min <= 2 && smilesRange.max >= 2) {
                                l |= 0x20L;
                            }
                            if (smilesRange.min <= 3 && smilesRange.max >= 3) {
                                l |= 0x40L;
                            }
                            if (smilesRange.max > 3) {
                                this.smartsWarning((n14 != 0 ? "!R" : "R") + smilesRange.max);
                            }
                            if (l == 0L) continue;
                            if (n14 == 0) {
                                l ^= 0x78L;
                            }
                            n16 = (int)((long)n16 | l);
                            continue;
                        }
                        if (byArray[n] == 114) {
                            ++n;
                            n += smilesRange.parse(byArray, n, 1, 1);
                            if (smilesRange.isDefault) {
                                if (n14 != 0) {
                                    n16 = (int)((long)n16 | 0x180L);
                                    continue;
                                }
                                n16 = (int)((long)n16 | 8L);
                                continue;
                            }
                            n17 = smilesRange.min;
                            if (smilesRange.isRange()) {
                                this.smartsWarning((n14 != 0 ? "!r" : "r") + smilesRange.toString());
                            }
                            if (n14 == 0 && n17 >= 3 && n17 <= 7) {
                                n16 |= n17 << 22;
                                continue;
                            }
                            if (smilesRange.isRange()) continue;
                            this.smartsWarning((n14 != 0 ? "!r" : "r") + n17);
                            continue;
                        }
                        if (byArray[n] == 118) {
                            ++n;
                            n += smilesRange.parse(byArray, n, 1, 1);
                            n17 = smilesRange.min;
                            if (smilesRange.isRange()) {
                                this.smartsWarning((n14 != 0 ? "!v" : "v") + smilesRange.toString());
                            }
                            if (n14 == 0 && n17 <= 14) {
                                n4 = n17;
                                continue;
                            }
                            if (smilesRange.isRange()) continue;
                            this.smartsWarning((n14 != 0 ? "!v" : "v") + n17);
                            continue;
                        }
                        if (!bl3 || byArray[n] != 59 && byArray[n] != 38) throw new Exception("SmilesParser: unexpected character inside brackets: '" + (char)byArray[n] + "'");
                        bl6 = true;
                        ++n;
                    }
                } else if (c == '*') {
                    n6 = 6;
                    n16 = (int)((long)n16 | 1L);
                } else if (c == '?') {
                    n6 = 0;
                } else if ((c == 'A' || c == 'a') && bl3) {
                    n6 = 6;
                    n16 = (int)((long)n16 | 1L);
                    n16 = (int)((long)n16 | (c == 'A' ? 4L : 2L));
                    bl6 = true;
                } else {
                    switch (Character.toUpperCase(c)) {
                        case 'B': {
                            if (n < n2 && byArray[n] == 114) {
                                n6 = 35;
                                ++n;
                                break;
                            }
                            n6 = 5;
                            break;
                        }
                        case 'C': {
                            if (n < n2 && byArray[n] == 108) {
                                n6 = 17;
                                ++n;
                                break;
                            }
                            n6 = 6;
                            break;
                        }
                        case 'F': {
                            n6 = 9;
                            break;
                        }
                        case 'I': {
                            n6 = 53;
                            break;
                        }
                        case 'N': {
                            n6 = 7;
                            break;
                        }
                        case 'O': {
                            n6 = 8;
                            break;
                        }
                        case 'P': {
                            n6 = 15;
                            break;
                        }
                        case 'S': {
                            n6 = 16;
                        }
                    }
                }
                if (n6 == -1 && c != '?') {
                    throw new Exception("SmilesParser: unknown element label found");
                }
                n14 = this.mMol.addAtom(n6);
                this.mMol.setAtomCharge(n14, n5);
                this.mMol.setAtomMapNo(n14, n12, false);
                this.mMol.setAtomAbnormalValence(n14, n4);
                if (n16 != 0) {
                    bl6 = true;
                    if (((long)n16 & 2L) != 0L) {
                        n16 = (int)((long)n16 & 0xFFFFFFFFFFFFFFFDL);
                        this.mMol.setAtomMarker(n14, true);
                        ++this.mAromaticAtoms;
                    } else {
                        this.mMol.setAtomMarker(n14, false);
                    }
                    this.mMol.setAtomQueryFeature(n14, n16, true);
                }
                if (sortedList.size() != 0) {
                    bl6 = true;
                    int[] nArray6 = new int[sortedList.size()];
                    for (n13 = 0; n13 < sortedList.size(); ++n13) {
                        nArray6[n13] = (Integer)sortedList.get(n13);
                    }
                    this.mMol.setAtomList(n14, nArray6);
                    sortedList.removeAll();
                } else if (Character.isLowerCase(c)) {
                    if (n6 != 5 && n6 != 6 && n6 != 7 && n6 != 8 && n6 != 15 && n6 != 16 && n6 != 33 && n6 != 34) {
                        throw new Exception("SmilesParser: atomicNo " + n6 + " must not be aromatic");
                    }
                    this.mMol.setAtomMarker(n14, true);
                    ++this.mAromaticAtoms;
                } else {
                    this.mMol.setAtomMarker(n14, false);
                }
                if (n3 != -1 && n6 != 1) {
                    byte[] byArray3 = new byte[]{(byte)(n3 == 9 ? 0 : n3)};
                    this.mMol.setAtomCustomLabel(n14, byArray3);
                }
                n8 = nArray[n9];
                if (nArray[n9] != -1 && n10 != 512) {
                    int n22 = this.mMol.addBond(nArray[n9], n14, n10);
                    if (n11 != 0) {
                        bl6 = true;
                        this.mMol.setBondQueryFeature(n22, n11, true);
                    }
                }
                n10 = 1;
                n11 = 0;
                nArray[n9] = n14;
                if (n7 != 0) {
                    this.mMol.setAtomMass(n14, n7);
                    n7 = 0;
                }
                if (!bl2) continue;
                THParity tHParity2 = tHParity = treeMap == null ? null : (THParity)treeMap.get(n8);
                if (tHParity != null) {
                    tHParity.addNeighbor(n14, n, n6 == 1 && n7 == 0);
                }
                if (!bl7) continue;
                if (treeMap == null) {
                    treeMap = new TreeMap<Integer, THParity>();
                }
                n13 = n3 == 9 ? 0 : n3;
                treeMap.put(n14, new THParity(n14, n - 2, n8, n13, n - 1, n15 != 0));
                continue;
            }
            if (c == '.') {
                nArray[n9] = -1;
                n10 = 512;
                continue;
            }
            if (this.isBondSymbol(c)) {
                if (bl4) {
                    throw new Exception("SmilesParser: unexpected bond symbol inside square brackets: '" + c + "'");
                }
                n6 = 0;
                while (this.isBondSymbol(c)) {
                    if (c == '!') {
                        if ((c = (char)byArray[n++]) == '@') {
                            n11 |= 0x80;
                        }
                        if (c == '-' && byArray[n] == 62 || c == '<' && byArray[n] == 45) {
                            n6 |= 0x20;
                            ++n;
                        } else if (c == '-') {
                            n6 |= 1;
                        } else if (c == '=') {
                            n6 |= 2;
                        } else if (c == '#') {
                            n6 |= 4;
                        } else if (c == '$') {
                            n6 |= 0x20;
                        } else {
                            if (c != ':') throw new Exception("SmilesParser: bond symbol '" + c + "' not allowed after '!'.");
                            n6 |= 8;
                        }
                    } else {
                        if (c == '@') {
                            n11 |= 0x100;
                        } else if (c == '=') {
                            n10 = 2;
                        } else if (c == '#') {
                            n10 = 4;
                        } else if (c == '$') {
                            n10 = 8;
                        } else if (c == ':') {
                            n10 = 64;
                        } else if (c == '~') {
                            n11 |= 0x1F;
                        } else if (c == '/') {
                            if (bl2) {
                                n10 = 257;
                            }
                        } else if (c == '\\') {
                            if (bl2) {
                                n10 = 129;
                            }
                        } else if (c == '-' && byArray[n] == 62 || c == '<' && byArray[n] == 45) {
                            n10 = 32;
                            ++n;
                        }
                        if (byArray[n] == 44) {
                            n11 |= this.bondSymbolToQueryFeature(n10 == 32 ? (char)'>' : (char)c);
                            while (byArray[n] == 44) {
                                if (byArray[n + 1] == 60 && byArray[n + 2] == 45 || byArray[n + 1] == 45 && byArray[n + 2] == 62) {
                                    n11 |= this.bondSymbolToQueryFeature('>');
                                    n += 3;
                                    continue;
                                }
                                n11 |= this.bondSymbolToQueryFeature((char)byArray[n + 1]);
                                n += 2;
                            }
                        }
                    }
                    if (byArray[n] == 59) {
                        int n23 = ++n;
                        ++n;
                        c = (char)byArray[n23];
                        continue;
                    }
                    if (n6 == 0) continue block12;
                    n11 |= 0x1F & ~n6;
                    continue block12;
                }
                continue;
            }
            if (c <= ' ') {
                n = n2;
                continue;
            }
            if (Character.isDigit(c)) {
                n6 = c - 48;
                if (bl4) {
                    while (n < n2 && Character.isDigit(byArray[n])) {
                        n6 = 10 * n6 + byArray[n] - 48;
                        ++n;
                    }
                    n7 = n6;
                    continue;
                }
                int n24 = n5 = byArray[n - 2] == 45 || byArray[n - 2] == 47 || byArray[n - 2] == 92 || byArray[n - 2] == 61 || byArray[n - 2] == 35 || byArray[n - 2] == 36 || byArray[n - 2] == 58 || byArray[n - 2] == 62 || byArray[n - 2] == 126 ? 1 : 0;
                if (bl5 && n < n2 && Character.isDigit(byArray[n])) {
                    n6 = 10 * n6 + byArray[n] - 48;
                    bl5 = false;
                    ++n;
                }
                if (n6 >= nArray2.length) {
                    if (n6 >= 100) {
                        throw new Exception("SmilesParser: ringClosureAtom number out of range");
                    }
                    n12 = nArray2.length;
                    n4 = nArray2.length;
                    while (n4 <= n6) {
                        n4 = Math.min(100, n4 + 16);
                    }
                    nArray2 = Arrays.copyOf(nArray2, n4);
                    nArray3 = Arrays.copyOf(nArray3, n4);
                    nArray4 = Arrays.copyOf(nArray4, n4);
                    nArray5 = Arrays.copyOf(nArray5, n4);
                    for (n3 = n12; n3 < n4; ++n3) {
                        nArray2[n3] = -1;
                    }
                }
                if (nArray2[n6] == -1) {
                    nArray2[n6] = nArray[n9];
                    nArray3[n6] = n - 1;
                    nArray4[n6] = n5 != 0 ? n10 : -1;
                    nArray5[n6] = n5 != 0 ? n11 : 0;
                } else {
                    if (nArray2[n6] == nArray[n9]) {
                        throw new Exception("SmilesParser: ring closure to same atom");
                    }
                    if (bl2 && treeMap != null) {
                        THParity tHParity = (THParity)treeMap.get(nArray2[n6]);
                        if (tHParity != null) {
                            tHParity.addNeighbor(nArray[n9], nArray3[n6], false);
                        }
                        if ((tHParity = (THParity)treeMap.get(nArray[n9])) != null) {
                            tHParity.addNeighbor(nArray2[n6], n - 1, false);
                        }
                    }
                    if (nArray4[n6] != -1) {
                        n10 = nArray4[n6];
                    } else if (n10 == 257) {
                        n10 = 129;
                    } else if (n10 == 129) {
                        n10 = 257;
                    }
                    n12 = this.mMol.addBond(nArray2[n6], nArray[n9], n10);
                    if (nArray5[n6] != 0) {
                        n11 = nArray5[n6];
                    }
                    if (n11 != 0) {
                        bl6 = true;
                        this.mMol.setBondQueryFeature(n12, nArray5[n6], true);
                    }
                    nArray2[n6] = -1;
                }
                n10 = 1;
                n11 = 0;
                continue;
            }
            if (c == '+') {
                throw new Exception("SmilesParser: '+' found outside brackets");
            }
            if (c == '(') {
                if (nArray[n9] == -1) {
                    throw new Exception("Smiles with leading parenthesis are not supported");
                }
                if (nArray.length == ++n9) {
                    nArray = Arrays.copyOf(nArray, nArray.length + 32);
                }
                nArray[n9] = nArray[n9 - 1];
                continue;
            }
            if (c == ')') {
                --n9;
                continue;
            }
            if (c == '[') {
                bl4 = true;
                continue;
            }
            if (c == ']') {
                throw new Exception("SmilesParser: closing bracket at unexpected position");
            }
            if (c != '%') throw new Exception("SmilesParser: unexpected character outside brackets: '" + c + "'");
            bl5 = true;
        }
        if (n10 != 1) {
            throw new Exception("SmilesParser: dangling open bond");
        }
        for (int n12 : nArray2) {
            if (n12 == -1) continue;
            throw new Exception("SmilesParser: dangling ring closure");
        }
        int[] nArray7 = this.mMol.getHandleHydrogenMap();
        this.mMol.setHydrogenProtection(true);
        this.mMol.ensureHelperArrays(1);
        for (n6 = 0; n6 < this.mMol.getAllAtoms(); ++n6) {
            if (this.mMol.getAtomCustomLabel(n6) != null) {
                n5 = this.mMol.getAtomCustomLabelBytes(n6)[0];
                if (bl6 || this.mSmartsMode == 2) {
                    if (this.mMakeHydrogenExplicit) {
                        for (int i = 0; i < n5; ++i) {
                            this.mMol.addBond(n6, this.mMol.addAtom(1), 1);
                        }
                        continue;
                    }
                    if (n5 == 0) {
                        this.mMol.setAtomQueryFeature(n6, 1792L, true);
                    }
                    if (n5 == 1) {
                        this.mMol.setAtomQueryFeature(n6, 1664L, true);
                    }
                    if (n5 == 2) {
                        this.mMol.setAtomQueryFeature(n6, 1408L, true);
                    }
                    if (n5 != 3) continue;
                    this.mMol.setAtomQueryFeature(n6, 896L, true);
                    continue;
                }
                if (!this.mMol.isMetalAtom(n6) && (!this.mMol.isMarkedAtom(n6) || this.mMol.getAtomicNo(n6) == 6 && this.mMol.getAtomCharge(n6) == 0)) {
                    byte[] byArray4 = Molecule.getAllowedValences(this.mMol.getAtomicNo(n6));
                    n4 = 0;
                    n3 = this.mMol.getOccupiedValence(n6);
                    n3 -= this.mMol.getElectronValenceCorrection(n6, n3);
                    n3 += n5;
                    if (this.mMol.isMarkedAtom(n6)) {
                        ++n3;
                    }
                    for (byte by : byArray4) {
                        if (n3 > by) continue;
                        n4 = 1;
                        if (by == n3 + 2) {
                            this.mMol.setAtomRadical(n6, 48);
                            break;
                        }
                        if (by == n3 + 1) {
                            this.mMol.setAtomRadical(n6, 32);
                            break;
                        }
                        if (by == n3 && by == byArray4[0]) break;
                        this.mMol.setAtomAbnormalValence(n6, n3);
                        break;
                    }
                    if (n4 == 0) {
                        this.mMol.setAtomAbnormalValence(n6, n3);
                    }
                }
                if (!this.mMakeHydrogenExplicit && this.mMol.supportsImplicitHydrogen(n6)) continue;
                for (int i = 0; i < n5; ++i) {
                    this.mMol.addBond(n6, this.mMol.addAtom(1), 1);
                }
                continue;
            }
            if (this.mMakeHydrogenExplicit || !bl6 && this.mSmartsMode != 2) continue;
            n5 = this.mMol.getExplicitHydrogens(n6);
            if (n5 >= 1) {
                this.mMol.setAtomQueryFeature(n6, 128L, true);
            }
            if (n5 >= 2) {
                this.mMol.setAtomQueryFeature(n6, 256L, true);
            }
            if (n5 >= 3) {
                this.mMol.setAtomQueryFeature(n6, 512L, true);
            }
            if (n5 < 4) continue;
            this.mMol.setAtomQueryFeature(n6, 1024L, true);
        }
        if (!this.mMakeHydrogenExplicit && (bl6 || this.mSmartsMode == 2)) {
            this.mMol.removeExplicitHydrogens();
        }
        this.mMol.ensureHelperArrays(1);
        this.correctValenceExceededNitrogen();
        this.locateAromaticDoubleBonds(bl3);
        this.mMol.removeAtomCustomLabels();
        this.mMol.setHydrogenProtection(false);
        if (bl2) {
            this.assignKnownEZBondParities();
            if (treeMap != null) {
                for (THParity tHParity : treeMap.values()) {
                    this.mMol.setAtomParity(tHParity.mCentralAtom, tHParity.calculateParity(nArray7), false);
                }
                this.mMol.setParitiesValid(0);
            }
        }
        this.mMol.setParitiesValid(0);
        if (bl) {
            CoordinateInventor coordinateInventor = new CoordinateInventor(this.mCoordinateMode);
            if (this.mRandomSeed != 0L) {
                coordinateInventor.setRandomSeed(this.mRandomSeed);
            }
            coordinateInventor.invent(this.mMol);
            if (bl2) {
                this.mMol.setUnknownParitiesToExplicitlyUnknown();
            }
        }
        if (!bl6 && this.mSmartsMode != 2) return;
        this.mMol.setFragment(true);
    }

    private int parseAtomList(byte[] byArray, int n, SortedList<Integer> sortedList) {
        sortedList.removeAll();
        for (int i = n; i < byArray.length; ++i) {
            if (Character.isLetter(byArray[i])) continue;
            int n2 = Molecule.getAtomicNoFromLabel(new String(byArray, n, i - n));
            if (n2 != 0) {
                sortedList.add(n2);
            }
            n = i + 1;
            if (byArray[i] != 44) break;
        }
        return n - 1;
    }

    private boolean isBondSymbol(char c) {
        return c == '-' || c == '=' || c == '#' || c == '$' || c == ':' || c == '/' || c == '\\' || c == '<' || c == '~' || c == '!' || c == '@';
    }

    private int bondSymbolToQueryFeature(char c) {
        return c == '=' ? 2 : (c == '#' ? 4 : (c == '$' ? 32 : (c == ':' ? 8 : (c == '>' ? 16 : (c == '~' ? 31 : 1)))));
    }

    private void smartsWarning(String string) {
        if (this.mCreateSmartsWarnings) {
            if (this.mSmartsWarningBuffer == null) {
                this.mSmartsWarningBuffer = new StringBuilder();
            }
            this.mSmartsWarningBuffer.append(" ");
            this.mSmartsWarningBuffer.append(string);
        }
    }

    private void locateAromaticDoubleBonds(boolean bl) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.mMol.ensureHelperArrays(1);
        this.mIsAromaticBond = new boolean[this.mMol.getBonds()];
        this.mAromaticBonds = 0;
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            if (this.mMol.getBondType(i) != 64) continue;
            this.mMol.setBondType(i, 1);
            this.mIsAromaticBond[i] = true;
            ++this.mAromaticBonds;
        }
        boolean[] blArray = new boolean[this.mMol.getAtoms()];
        RingCollection ringCollection = new RingCollection(this.mMol, 3);
        boolean[] blArray2 = new boolean[ringCollection.getSize()];
        for (n8 = 0; n8 < ringCollection.getSize(); ++n8) {
            int[] nArray = ringCollection.getRingAtoms(n8);
            blArray2[n8] = true;
            for (n7 = 0; n7 < nArray.length; ++n7) {
                if (this.mMol.isMarkedAtom(nArray[n7])) continue;
                blArray2[n8] = false;
                break;
            }
            if (!blArray2[n8]) continue;
            for (n7 = 0; n7 < nArray.length; ++n7) {
                blArray[nArray[n7]] = true;
            }
            int[] nArray2 = ringCollection.getRingBonds(n8);
            for (n6 = 0; n6 < nArray2.length; ++n6) {
                if (this.mIsAromaticBond[nArray2[n6]]) continue;
                this.mIsAromaticBond[nArray2[n6]] = true;
                ++this.mAromaticBonds;
            }
        }
        for (n8 = 0; n8 < this.mMol.getBonds(); ++n8) {
            if (this.mIsAromaticBond[n8] || ringCollection.getBondRingSize(n8) == 0 || !this.mMol.isMarkedAtom(this.mMol.getBondAtom(0, n8)) || !this.mMol.isMarkedAtom(this.mMol.getBondAtom(1, n8))) continue;
            this.addLargeAromaticRing(n8);
        }
        for (n8 = 0; n8 < this.mMol.getBonds(); ++n8) {
            if (this.mIsAromaticBond[n8]) continue;
            int n9 = this.mMol.getBondAtom(0, n8);
            n7 = this.mMol.getBondAtom(1, n8);
            if (blArray[n9] || blArray[n7] || !this.mMol.isMarkedAtom(n9) || !this.mMol.isMarkedAtom(n7)) continue;
            this.mIsAromaticBond[n8] = true;
            ++this.mAromaticBonds;
        }
        this.mMol.ensureHelperArrays(7);
        boolean[] blArray3 = new boolean[this.mMol.getBonds()];
        for (n5 = 0; n5 < this.mMol.getBonds(); ++n5) {
            blArray3[n5] = this.mIsAromaticBond[n5];
        }
        for (n5 = 0; n5 < ringCollection.getSize(); ++n5) {
            if (!blArray2[n5]) continue;
            int[] nArray = ringCollection.getRingAtoms(n5);
            for (n6 = 0; n6 < nArray.length; ++n6) {
                if (this.qualifiesForPi(nArray[n6])) continue;
                if (this.mMol.isMarkedAtom(nArray[n6])) {
                    this.mMol.setAtomMarker(nArray[n6], false);
                    --this.mAromaticAtoms;
                }
                for (int i = 0; i < this.mMol.getConnAtoms(nArray[n6]); ++i) {
                    n4 = this.mMol.getConnBond(nArray[n6], i);
                    if (!this.mIsAromaticBond[n4]) continue;
                    this.mIsAromaticBond[n4] = false;
                    --this.mAromaticBonds;
                }
            }
        }
        this.promoteObviousBonds();
        for (n5 = 0; n5 < ringCollection.getSize(); ++n5) {
            if (!blArray2[n5] || ringCollection.getRingSize(n5) != 6) continue;
            int[] nArray = ringCollection.getRingBonds(n5);
            n6 = 1;
            int[] nArray3 = nArray;
            n4 = nArray3.length;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = nArray3[n3];
                if (this.mIsAromaticBond[n2]) continue;
                n6 = 0;
                break;
            }
            if (n6 == 0) continue;
            this.promoteBond(nArray[0]);
            this.promoteBond(nArray[2]);
            this.promoteBond(nArray[4]);
            this.promoteObviousBonds();
        }
        for (n = 5; n >= 4; --n) {
            block14: do {
                n5 = 0;
                for (n6 = 0; n6 < this.mMol.getBonds(); ++n6) {
                    if (!this.mIsAromaticBond[n6]) continue;
                    int n10 = 0;
                    for (n4 = 0; n4 < 2; ++n4) {
                        n3 = this.mMol.getBondAtom(n4, n6);
                        for (n2 = 0; n2 < this.mMol.getConnAtoms(n3); ++n2) {
                            if (!this.mIsAromaticBond[this.mMol.getConnBond(n3, n2)]) continue;
                            ++n10;
                        }
                    }
                    if (n10 != n) continue;
                    this.promoteBond(n6);
                    this.promoteObviousBonds();
                    n5 = 1;
                    continue block14;
                }
            } while (n5 != 0);
        }
        while (this.mAromaticAtoms >= 2 && this.connectConjugatedRadicalPairs(blArray3)) {
        }
        if (bl) {
            if (this.mAromaticAtoms != 0) {
                for (n = 0; n < this.mMol.getAtoms(); ++n) {
                    if (!this.mMol.isMarkedAtom(n)) continue;
                    this.mMol.setAtomMarker(n, false);
                    this.mMol.setAtomQueryFeature(n, 2L, true);
                    --this.mAromaticAtoms;
                }
            }
            if (this.mAromaticBonds != 0) {
                for (n = 0; n < this.mMol.getBonds(); ++n) {
                    if (!this.mIsAromaticBond[n]) continue;
                    this.mIsAromaticBond[n] = false;
                    this.mMol.setBondType(n, 64);
                    --this.mAromaticBonds;
                }
            }
        } else {
            for (n = 0; n < this.mMol.getAtoms(); ++n) {
                if (!this.mMol.isMarkedAtom(n) || this.mMol.getImplicitHydrogens(n) == 0) continue;
                this.mMol.setAtomMarker(n, false);
                this.mMol.setAtomRadical(n, 32);
                --this.mAromaticAtoms;
            }
        }
        if (this.mAromaticAtoms != 0) {
            throw new Exception("Assignment of aromatic double bonds failed");
        }
        if (this.mAromaticBonds != 0) {
            throw new Exception("Assignment of aromatic double bonds failed");
        }
    }

    private boolean connectConjugatedRadicalPairs(boolean[] blArray) {
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (!this.mMol.isMarkedAtom(i)) continue;
            int[] nArray = new int[this.mMol.getAtoms()];
            int[] nArray2 = new int[this.mMol.getAtoms()];
            int[] nArray3 = new int[this.mMol.getAtoms()];
            nArray2[0] = i;
            nArray[i] = 1;
            nArray3[i] = -1;
            int n = 0;
            for (int j = 0; j <= n; ++j) {
                int n2 = (nArray[nArray2[j]] & 1) == 1 ? 1 : 2;
                for (int k = 0; k < this.mMol.getConnAtoms(nArray2[j]); ++k) {
                    int n3;
                    int n4 = this.mMol.getConnBond(nArray2[j], k);
                    if (this.mMol.getBondOrder(n4) != n2 || !blArray[n4] || nArray[n3 = this.mMol.getConnAtom(nArray2[j], k)] != 0) continue;
                    if (n2 == 1 && this.mMol.isMarkedAtom(n3)) {
                        int n5 = nArray2[j];
                        while (n5 != -1) {
                            this.mMol.setBondType(this.mMol.getBond(n3, n5), n2 == 1 ? 2 : 1);
                            n2 = 3 - n2;
                            n3 = n5;
                            n5 = nArray3[n5];
                        }
                        this.mMol.setAtomMarker(i, false);
                        this.mMol.setAtomMarker(n3, false);
                        this.mAromaticAtoms -= 2;
                        return true;
                    }
                    nArray2[++n] = n3;
                    nArray3[n3] = nArray2[j];
                    nArray[n3] = nArray[nArray2[j]] + 1;
                }
            }
        }
        return false;
    }

    private void addLargeAromaticRing(int n) {
        int[] nArray = new int[this.mMol.getAtoms()];
        int[] nArray2 = new int[this.mMol.getAtoms()];
        int[] nArray3 = new int[this.mMol.getAtoms()];
        int[] nArray4 = new int[this.mMol.getAtoms()];
        int n2 = this.mMol.getBondAtom(0, n);
        int n3 = this.mMol.getBondAtom(1, n);
        nArray2[0] = n2;
        nArray2[1] = n3;
        nArray3[0] = -1;
        nArray3[1] = n;
        nArray[n2] = 1;
        nArray[n3] = 2;
        nArray4[n2] = -1;
        nArray4[n3] = n2;
        int n4 = 1;
        for (int i = 1; i <= n4 && nArray[nArray2[i]] < 15; ++i) {
            int n5 = nArray2[i];
            for (int j = 0; j < this.mMol.getConnAtoms(n5); ++j) {
                int n6 = this.mMol.getConnAtom(n5, j);
                if (n6 == nArray4[n5]) continue;
                int n7 = this.mMol.getConnBond(n5, j);
                if (n6 == n2) {
                    nArray3[0] = n7;
                    for (int k = 0; k <= n4; ++k) {
                        if (this.mIsAromaticBond[nArray3[j]]) continue;
                        this.mIsAromaticBond[nArray3[j]] = true;
                        ++this.mAromaticBonds;
                    }
                    return;
                }
                if (!this.mMol.isMarkedAtom(n6) || nArray[n6] != 0) continue;
                nArray2[++n4] = n6;
                nArray3[n4] = n7;
                nArray[n6] = nArray[n5] + 1;
                nArray4[n6] = n5;
            }
        }
    }

    private boolean qualifiesForPi(int n) {
        if (!RingCollection.qualifiesAsAromaticAtomicNo(this.mMol.getAtomicNo(n))) {
            return false;
        }
        if (this.mMol.getAtomicNo(n) == 6) {
            if (!this.mMol.isMarkedAtom(n)) {
                return false;
            }
            if (this.mMol.getAtomCharge(n) > 0) {
                return false;
            }
        }
        byte by = this.mMol.getAtomCustomLabel(n) == null ? (byte)0 : this.mMol.getAtomCustomLabelBytes(n)[0];
        int n2 = this.mMol.getFreeValence(n) - by;
        if (n2 < 1) {
            return false;
        }
        if (this.mMol.getAtomicNo(n) == 16 || this.mMol.getAtomicNo(n) == 34 || this.mMol.getAtomicNo(n) == 52) {
            if (this.mMol.getConnAtoms(n) == 2 && this.mMol.getAtomCharge(n) <= 0) {
                return false;
            }
            if (n2 == 2) {
                return false;
            }
        }
        return true;
    }

    private void promoteBond(int n) {
        if (this.mMol.getBondType(n) == 1) {
            this.mMol.setBondType(n, 2);
        }
        for (int i = 0; i < 2; ++i) {
            int n2 = this.mMol.getBondAtom(i, n);
            if (this.mMol.isMarkedAtom(n2)) {
                this.mMol.setAtomMarker(n2, false);
                --this.mAromaticAtoms;
            }
            for (int j = 0; j < this.mMol.getConnAtoms(n2); ++j) {
                int n3 = this.mMol.getConnBond(n2, j);
                if (!this.mIsAromaticBond[n3]) continue;
                this.mIsAromaticBond[n3] = false;
                --this.mAromaticBonds;
            }
        }
    }

    private void promoteObviousBonds() {
        boolean bl;
        do {
            bl = false;
            for (int i = 0; i < this.mMol.getBonds(); ++i) {
                if (!this.mIsAromaticBond[i]) continue;
                boolean bl2 = false;
                for (int j = 0; j < 2; ++j) {
                    boolean bl3 = false;
                    int n = this.mMol.getBondAtom(j, i);
                    for (int k = 0; k < this.mMol.getConnAtoms(n); ++k) {
                        if (i == this.mMol.getConnBond(n, k) || !this.mIsAromaticBond[this.mMol.getConnBond(n, k)]) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
                bl = true;
                this.promoteBond(i);
            }
        } while (bl);
    }

    private void correctValenceExceededNitrogen() {
        block0: for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (this.mMol.getAtomicNo(i) != 7 || this.mMol.getAtomCharge(i) != 0 || this.mMol.getOccupiedValence(i) <= 3 || this.mMol.getAtomPi(i) <= 0) continue;
            for (int j = 0; j < this.mMol.getConnAtoms(i); ++j) {
                int n = this.mMol.getConnAtom(i, j);
                int n2 = this.mMol.getConnBond(i, j);
                if (this.mMol.getBondOrder(n2) <= 1 || !this.mMol.isElectronegative(n)) continue;
                if (this.mMol.getBondType(n2) == 4) {
                    this.mMol.setBondType(n2, 2);
                } else {
                    this.mMol.setBondType(n2, 1);
                }
                this.mMol.setAtomCharge(i, this.mMol.getAtomCharge(i) + 1);
                this.mMol.setAtomCharge(n, this.mMol.getAtomCharge(n) - 1);
                this.mMol.setAtomAbnormalValence(i, -1);
                continue block0;
            }
        }
    }

    private boolean assignKnownEZBondParities() {
        int n;
        this.mMol.ensureHelperArrays(7);
        boolean bl = false;
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            int n2;
            int n3;
            if (this.mMol.isSmallRingBond(n) || this.mMol.getBondType(n) != 2) continue;
            for (n3 = 0; n3 < 2; ++n3) {
                nArray[n3] = -1;
                nArray3[n3] = -1;
                n2 = this.mMol.getBondAtom(n3, n);
                for (int i = 0; i < this.mMol.getConnAtoms(n2); ++i) {
                    int n4 = this.mMol.getConnBond(n2, i);
                    if (n4 == n) continue;
                    if (nArray[n3] == -1 && (this.mMol.getBondType(n4) == 257 || this.mMol.getBondType(n4) == 129)) {
                        nArray[n3] = this.mMol.getConnAtom(n2, i);
                        nArray2[n3] = n4;
                        continue;
                    }
                    nArray3[n3] = this.mMol.getConnAtom(n2, i);
                }
                if (nArray[n3] == -1) break;
            }
            if (nArray[0] == -1 || nArray[1] == -1) continue;
            n3 = this.mMol.getBondType(nArray2[0]) == this.mMol.getBondType(nArray2[1]) ? 1 : 0;
            for (n2 = 0; n2 < 2; ++n2) {
                if (nArray[n2] != this.mMol.getBondAtom(0, nArray2[n2])) continue;
                n3 = n3 == 0 ? 1 : 0;
            }
            for (n2 = 0; n2 < 2; ++n2) {
                if (nArray3[n2] == -1 || nArray3[n2] >= nArray[n2]) continue;
                n3 = n3 == 0 ? 1 : 0;
            }
            this.mMol.setBondParity(n, n3 != 0 ? 2 : 1, false);
            bl = true;
        }
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (this.mMol.getBondType(n) != 257 && this.mMol.getBondType(n) != 129) continue;
            this.mMol.setBondType(n, 1);
        }
        return bl;
    }

    private static void testStereo() {
        String[][] stringArrayArray = new String[][]{{"F/C=C/I", "F/C=C/I"}, {"F/C=C\\I", "F/C=C\\I"}, {"C(=C/I)/F", "F/C=C\\I"}, {"[H]C(/F)=C/I", "F/C=C\\I"}, {"C(=C\\1)/I.F1", "F/C=C/I"}, {"C(=C1)/I.F/1", "F/C=C/I"}, {"C(=C\\F)/1.I1", "F/C=C/I"}, {"C(=C\\F)1.I\\1", "F/C=C/I"}, {"C\\1=C/I.F1", "F/C=C/I"}, {"C1=C/I.F/1", "F/C=C/I"}, {"C(=C\\1)/2.F1.I2", "F/C=C/I"}, {"C/2=C\\1.F1.I2", "F/C=C/I"}, {"C/1=C/C=C/F.I1", "F/C=C/C=C\\I"}, {"C1=C/C=C/F.I\\1", "F/C=C/C=C\\I"}, {"C(/I)=C/C=C/1.F1", "F/C=C/C=C\\I"}, {"C(/I)=C/C=C1.F\\1", "F/C=C/C=C\\I"}, {"[C@](Cl)(F)(I)1.Br1", "F[C@](Cl)(Br)I"}, {"Br[C@](Cl)(I)1.F1", "F[C@](Cl)(Br)I"}, {"[C@H](F)(I)1.Br1", "F[C@H](Br)I"}, {"Br[C@@H](F)1.I1", "F[C@H](Br)I"}, {"C[S@@](CC)=O", "CC[S@](C)=O"}, {"[S@](=O)(C)CC", "CC[S](C)=O"}};
        StereoMolecule stereoMolecule = new StereoMolecule();
        for (String[] stringArray : stringArrayArray) {
            try {
                new SmilesParser().parse(stereoMolecule, stringArray[0]);
                String string = new IsomericSmilesCreator(stereoMolecule).getSmiles();
                System.out.print("IN:" + stringArray[0] + " OUT:" + string);
                if (!stringArray[1].equals(string)) {
                    System.out.println(" EXPECTED: " + stringArray[1] + " ERROR!");
                    continue;
                }
                System.out.println(" OK");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        SmilesParser.testStereo();
        System.out.println("ID-code equivalence test:");
        String[][] stringArrayArray = new String[][]{{"N[C@@]([H])(C)C(=O)O", "S-alanine", "gGX`BDdwMUM@@"}, {"N[C@@H](C)C(=O)O", "S-alanine", "gGX`BDdwMUM@@"}, {"N[C@H](C(=O)O)C", "S-alanine", "gGX`BDdwMUM@@"}, {"[H][C@](N)(C)C(=O)O", "S-alanine", "gGX`BDdwMUM@@"}, {"[C@H](N)(C)C(=O)O", "S-alanine", "gGX`BDdwMUM@@"}, {"N[C@]([H])(C)C(=O)O", "R-alanine", "gGX`BDdwMUL`@"}, {"N[C@H](C)C(=O)O", "R-alanine", "gGX`BDdwMUL`@"}, {"N[C@@H](C(=O)O)C", "R-alanine", "gGX`BDdwMUL`@"}, {"[H][C@@](N)(C)C(=O)O", "R-alanine", "gGX`BDdwMUL`@"}, {"[C@@H](N)(C)C(=O)O", "R-alanine", "gGX`BDdwMUL`@"}, {"C[C@H]1CCCCO1", "S-Methyl-pyran", "gOq@@eLm]UUH`@"}, {"O1CCCC[C@@H]1C", "S-Methyl-pyran", "gOq@@eLm]UUH`@"}, {"[C@H](F)(B)O", "S-Methyl-oxetan", "gCaDDICTBSURH@"}, {"C1CO[C@H]1C", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"C1CO[C@@H](C)1", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"[C@H]1(C)CCO1", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"[H][C@]1(C)CCO1", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"[H][C@@]1(CCO1)C", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"[C@@]1([H])(C)CCO1", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"[C@]1(C)([H])CCO1", "S-Methyl-oxetan", "gKQ@@eLmUTb@"}, {"C1[C@@H]2COC2=N1", "oxetan-azetin", "gGy@LDimDvfja`@"}, {"CC(C)[C@@]12C[C@@H]1[C@@H](C)C(=O)C2", "alpha-thujone", "dmLH@@RYe~IfyjjjkDaIh@"}, {"CN1CCC[C@H]1c2cccnc2", "Nicotine", "dcm@@@{IDeCEDUSh@UUECP@"}, {"CC[C@H](O1)CC[C@@]12CCCO2", "2S,5R-Chalcogran", "dmLD@@qJZY|fFZjjjdbH`@"}, {"CCCC", "butane", "gC`@Dij@@"}, {"C1C.CC1", "butane", "gC`@Dij@@"}, {"[CH3][CH2][CH2][CH3]", "butane", "gC`@Dij@@"}, {"C-C-C-C", "butane", "gC`@Dij@@"}, {"C12.C1.CC2", "butane", "gC`@Dij@@"}, {"[Na+].[Cl-]", "NaCl", "eDARHm@zd@@"}, {"[Na+]-[Cl-]", "NaCl", "error"}, {"[Na+]1.[Cl-]1", "NaCl", "error"}, {"c1ccccc1", "benzene", "gFp@DiTt@@@"}, {"C1=C-C=C-C=C1", "benzene", "gFp@DiTt@@@"}, {"C1:C:C:C:C:C:1", "benzene", "gFp@DiTt@@@"}, {"c1ccncc1", "pyridine", "gFx@@eJf`@@@"}, {"[nH]1cccc1", "pyrrole", "gKX@@eKcRp@"}, {"N1C=C-C=C1", "pyrrole", "gKX@@eKcRp@"}, {"[H]n1cccc1", "pyrrole", "gKX@@eKcRp@"}, {"[H]n1cccc1", "pyrrole", "gKX@@eKcRp@"}, {"c1cncc1", "pyrrole no [nH]", "error"}, {"[13CH4]", "C13-methane", "fH@FJp@"}, {"[35ClH]", "35-chlorane", "fHdP@qX`"}, {"[35Cl-]", "35-chloride", "fHtPxAbq@"}, {"[Na+].[O-]c1ccccc1", "Na-phenolate", "daxHaHCPBXyAYUn`@@@"}, {"c1cc([O-].[Na+])ccc1", "Na-phenolate", "daxHaHCPBXyAYUn`@@@"}, {"C[C@@](C)(O1)C[C@@H](O)[C@@]1(O2)[C@@H](C)[C@@H]3CC=C4[C@]3(C2)C(=O)C[C@H]5[C@H]4CC[C@@H](C6)[C@]5(C)Cc(n7)c6nc(C[C@@]89(C))c7C[C@@H]8CC[C@@H]%10[C@@H]9C[C@@H](O)[C@@]%11(C)C%10=C[C@H](O%12)[C@]%11(O)[C@H](C)[C@]%12(O%13)[C@H](O)C[C@@]%13(C)CO", "Cephalostatin-1", "gdKe@h@@K`H@XjKHuYlnoP\\bbdRbbVTLbTrJbRaQRRRbTJTRTrfrfTTOBPHtFODPhLNSMdIERYJmShLfs]aqy|uUMUUUUUUE@UUUUMUUUUUUTQUUTPR`nDdQQKB|RIFbiQeARuQt`rSSMNtGS\\ct@@"}};
        StereoMolecule stereoMolecule = new StereoMolecule();
        for (String[] stringArray2 : stringArrayArray) {
            try {
                new SmilesParser().parse(stereoMolecule, stringArray2[0]);
                String string = new Canonizer(stereoMolecule).getIDCode();
                if (stringArray2[2].equals("error")) {
                    System.out.println("Should create error! " + stringArray2[1] + " smiles:" + stringArray2[0] + " idcode:" + string);
                    continue;
                }
                if (stringArray2[2].equals(string)) continue;
                System.out.println("ERROR! " + stringArray2[1] + " smiles:" + stringArray2[0] + " is:" + string + " must:" + stringArray2[2]);
            }
            catch (Exception exception) {
                if (stringArray2[2].equals("error")) continue;
                System.out.println("ERROR! " + stringArray2[1] + " smiles:" + stringArray2[0] + " exception:" + exception.getMessage());
            }
        }
    }

    private class THParity {
        private static final int PSEUDO_ATOM_HYDROGEN = 0x7FFFFFFE;
        private static final int PSEUDO_ATOM_LONE_PAIR = Integer.MAX_VALUE;
        int mCentralAtom;
        int mCentralAtomPosition;
        boolean mIsClockwise;
        boolean mError;
        ArrayList<ParityNeighbour> mNeighbourList;

        public THParity(int n, int n2, int n3, int n4, int n5, boolean bl) {
            if (n4 != 0 && n4 != 1) {
                this.mError = true;
            } else {
                this.mCentralAtom = n;
                this.mCentralAtomPosition = n2;
                this.mIsClockwise = bl;
                this.mNeighbourList = new ArrayList();
                if (n3 != -1) {
                    this.addNeighbor(n3, n2 - 1, false);
                }
                if (n3 != -1 && n4 == 1) {
                    this.addNeighbor(0x7FFFFFFE, n2 + 1, false);
                }
            }
        }

        public void addNeighbor(int n, int n2, boolean bl) {
            if (!this.mError) {
                if (this.mNeighbourList.size() == 4) {
                    this.mError = true;
                    return;
                }
                this.mNeighbourList.add(new ParityNeighbour(n, n2));
            }
        }

        public int calculateParity(int[] nArray) {
            if (this.mError) {
                return 3;
            }
            for (ParityNeighbour parityNeighbour : this.mNeighbourList) {
                if (parityNeighbour.mAtom == 0x7FFFFFFE || parityNeighbour.mAtom == Integer.MAX_VALUE) continue;
                parityNeighbour.mAtom = nArray[parityNeighbour.mAtom];
            }
            if (this.mNeighbourList.size() == 3) {
                this.mNeighbourList.add(new ParityNeighbour(Integer.MAX_VALUE, this.mCentralAtomPosition));
            } else if (this.mNeighbourList.size() != 4) {
                return 3;
            }
            int n = this.mIsClockwise ^ this.isInverseOrder() ? 1 : 2;
            return n;
        }

        private boolean isInverseOrder() {
            boolean bl = false;
            for (int i = 1; i < this.mNeighbourList.size(); ++i) {
                for (int j = 0; j < i; ++j) {
                    if (this.mNeighbourList.get((int)j).mAtom > this.mNeighbourList.get((int)i).mAtom) {
                        boolean bl2 = bl = !bl;
                    }
                    if (this.mNeighbourList.get((int)j).mPosition <= this.mNeighbourList.get((int)i).mPosition) continue;
                    bl = !bl;
                }
            }
            return bl;
        }
    }

    private class ParityNeighbour {
        int mAtom;
        int mPosition;

        public ParityNeighbour(int n, int n2) {
            this.mAtom = n;
            this.mPosition = n2;
        }
    }
}

