/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.prediction.CLogPPredictor;
import com.actelion.research.chem.prediction.ParameterizedStringList;
import com.actelion.research.chem.prediction.PolarSurfaceAreaPredictor;
import com.actelion.research.chem.prediction.SolubilityPredictor;

public class PropertyCalculator {
    private StereoMolecule mMolecule;

    public PropertyCalculator(StereoMolecule stereoMolecule) {
        this.mMolecule = stereoMolecule;
        stereoMolecule.normalizeAmbiguousBonds();
    }

    public int getAcceptorCount() {
        int n = 0;
        for (int i = 0; i < this.mMolecule.getAllAtoms(); ++i) {
            if (this.mMolecule.getAtomicNo(i) != 7 && this.mMolecule.getAtomicNo(i) != 8) continue;
            ++n;
        }
        return n;
    }

    public int getDonorCount() {
        int n = 0;
        for (int i = 0; i < this.mMolecule.getAllAtoms(); ++i) {
            if (this.mMolecule.getAtomicNo(i) != 7 && this.mMolecule.getAtomicNo(i) != 8 || this.mMolecule.getAllHydrogens(i) <= 0) continue;
            ++n;
        }
        return n;
    }

    public double getLogP() {
        try {
            return new CLogPPredictor().assessCLogP(this.mMolecule);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -999.0;
        }
    }

    public ParameterizedStringList getLogPDetail() {
        return new CLogPPredictor().getDetail(this.mMolecule);
    }

    public double getLogS() {
        return new SolubilityPredictor().assessSolubility(this.mMolecule);
    }

    public ParameterizedStringList getLogSDetail() {
        return new SolubilityPredictor().getDetail(this.mMolecule);
    }

    public double getPolarSurfaceArea() {
        return new PolarSurfaceAreaPredictor().assessPSA(this.mMolecule);
    }

    public ParameterizedStringList getPolarSurfaceAreaDetail() {
        return new PolarSurfaceAreaPredictor().getDetail(this.mMolecule);
    }

    public int getRotatableBondCount() {
        return this.mMolecule.getRotatableBondCount();
    }

    public int getStereoCenterCount() {
        return this.mMolecule.getStereoCenterCount();
    }
}

