/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.AtomTypeCalculator;
import com.actelion.research.chem.AtomTypeList;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Mutation;
import com.actelion.research.chem.MutationBiasProvider;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.ScaffoldHelper;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.coords.CoordinateInventor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class Mutator {
    public static final int MUTATION_GROW = 3;
    public static final int MUTATION_SHRINK = 24600;
    public static final int MUTATION_KEEP_SIZE = 40932;
    public static final int MUTATION_ANY = 65535;
    private static final int cMinRingClosureSize = 3;
    private static final int cMaxRingClosureSize = 7;
    private static final int cDefaultMinAtoms = 4;
    private static final int cDefaultOptAtoms = 9;
    private static final int cDefaultMaxAtoms = 24;
    private static final double cProbabilityFactor = 1.0;
    private static final double BOOST_CHANGE_RING = 1.0;
    private static final double BOOST_TOGGLE_AMID_SULFONAMID = 10.0;
    private static final double BOOST_CLOSE_RING = 1.0;
    private static final double cMinEductProbability = (double)1.0E-5f;
    private Random mRandom;
    private StereoMolecule mMolCopy = new StereoMolecule();
    private StereoMolecule mMol = new StereoMolecule();
    private AtomTypeList mAtomTypeList;
    private Canonizer mCanonizer;
    private boolean[] mIsPrimaryAtom;
    private int mMinAtoms;
    private int mOptAtoms;
    private int mMaxAtoms;
    private double mGrowBoost;
    private MutationBiasProvider mBiasProvider;

    public Mutator(String string) {
        if (string != null) {
            try {
                this.mAtomTypeList = new AtomTypeList(string, 32190);
                this.mAtomTypeList.calculateProbabilities();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.mRandom = new Random();
        this.mGrowBoost = 1.0;
        this.mMinAtoms = 4;
        this.mOptAtoms = 9;
        this.mMaxAtoms = 24;
    }

    public Mutator(AtomTypeList atomTypeList) {
        this.mAtomTypeList = atomTypeList;
        this.mAtomTypeList.calculateProbabilities();
        this.mRandom = new Random();
        this.mGrowBoost = 1.0;
        this.mMinAtoms = 4;
        this.mOptAtoms = 9;
        this.mMaxAtoms = 24;
    }

    public void setBiasProvider(MutationBiasProvider mutationBiasProvider) {
        this.mBiasProvider = mutationBiasProvider;
    }

    public void setGrowBoost(double d) {
        this.mGrowBoost = d;
    }

    public void setPreferredSize(int n, int n2, int n3) {
        this.mMinAtoms = n;
        this.mOptAtoms = n2;
        this.mMaxAtoms = n3;
    }

    public StereoMolecule[] getMutatedSet(StereoMolecule stereoMolecule, int n, boolean bl, int n2) {
        ArrayList<Mutation> arrayList = this.generateMutationList(stereoMolecule, n, bl);
        if (n2 > arrayList.size()) {
            n2 = arrayList.size();
        }
        StereoMolecule[] stereoMoleculeArray = new StereoMolecule[n2];
        for (int i = 0; i < n2; ++i) {
            stereoMoleculeArray[i] = new StereoMolecule(stereoMolecule);
            this.mutate(stereoMoleculeArray[i], arrayList);
        }
        return stereoMoleculeArray;
    }

    public ArrayList<Mutation> mutate(StereoMolecule stereoMolecule) {
        return this.mutate(stereoMolecule, 65535, true);
    }

    public ArrayList<Mutation> mutate(StereoMolecule stereoMolecule, int n, boolean bl) {
        ArrayList<Mutation> arrayList = this.generateMutationList(stereoMolecule, n, bl);
        if (arrayList.size() == 0) {
            System.out.println("no possible mutation found. ID-Code:" + new Canonizer(stereoMolecule, 16).getIDCode());
            return null;
        }
        this.mutate(stereoMolecule, arrayList);
        return arrayList;
    }

    public void mutate(StereoMolecule stereoMolecule, ArrayList<Mutation> arrayList) {
        Mutation mutation;
        if (!arrayList.isEmpty() && (mutation = this.selectLikelyMutation(arrayList)) != null) {
            this.performMutation(stereoMolecule, mutation);
        }
    }

    public ArrayList<Mutation> generateMutationList(StereoMolecule stereoMolecule, int n, boolean bl) {
        this.mMol = stereoMolecule;
        if (this.mBiasProvider != null) {
            this.mBiasProvider.setBiasReference(stereoMolecule);
        }
        this.detectSymmetry();
        ArrayList<Mutation> arrayList = new ArrayList<Mutation>();
        ArrayList<MutatorSubstituent> arrayList2 = this.createSubstituentList();
        if (!bl || this.mRandom.nextDouble() > (double)((float)(this.mMol.getAtoms() - this.mOptAtoms) / (float)(this.mMaxAtoms - this.mOptAtoms))) {
            if ((n & 1) != 0) {
                this.addProbabilitiesForAddAtom(arrayList);
            }
            if ((n & 2) != 0) {
                this.addProbabilitiesForInsertAtom(arrayList);
            }
        }
        if ((n & 4) != 0) {
            this.addProbabilitiesForChangeAtom(arrayList);
        }
        if (!bl || this.mRandom.nextDouble() < (double)((float)(this.mMol.getAtoms() - this.mMinAtoms) / (float)(this.mOptAtoms - this.mMinAtoms))) {
            if ((n & 0x10) != 0) {
                this.addProbabilitiesForDeleteAtom(arrayList);
            }
            if ((n & 8) != 0) {
                this.addProbabilitiesForCutOutAtom(arrayList);
            }
            if ((n & 0x2000) != 0) {
                this.addProbabilitiesForDeleteSubstituent(arrayList, arrayList2);
            }
            if ((n & 0x4000) != 0) {
                this.addProbabilitiesForCutOutFragment(arrayList);
            }
        }
        if ((n & 0x220) != 0) {
            this.addProbabilitiesForCloseRing(arrayList, n);
        }
        if ((n & 0x400) != 0) {
            this.addProbabilitiesForToggleAmidSulfonamid(arrayList);
        }
        if ((n & 0x40) != 0) {
            this.addProbabilitiesForChangeBond(arrayList);
        }
        if ((n & 0x80) != 0) {
            this.addProbabilitiesForDeleteBond(arrayList);
        }
        if ((n & 0x100) != 0) {
            this.addProbabilitiesForChangeRing(arrayList);
        }
        if ((n & 0x800) != 0) {
            this.addProbabilitiesForMigrate(arrayList);
        }
        if ((n & 0x1000) != 0) {
            this.addProbabilitiesForSwapSubstituent(arrayList, arrayList2);
        }
        if ((n & 0x8000) != 0) {
            this.addProbabilitiesForInvertParity(arrayList);
        }
        return arrayList;
    }

    private void tweakProbabilities(ArrayList<Mutation> arrayList) {
        for (Mutation mutation : arrayList) {
            mutation.mProbability = Math.pow(mutation.mProbability, 1.0);
        }
    }

    private void detectSymmetry() {
        this.mCanonizer = new Canonizer(this.mMol, 1);
        this.mIsPrimaryAtom = new boolean[this.mMol.getAtoms()];
        int[] nArray = new int[1 + this.mMol.getAtoms()];
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (this.mMol.isSelectedAtom(i)) continue;
            int n = this.mCanonizer.getSymmetryRank(i);
            nArray[n] = nArray[n] + 1;
        }
        int[] nArray2 = new int[this.mMol.getAtoms()];
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            int n;
            if (this.mMol.isSelectedAtom(i) || nArray[n = this.mCanonizer.getSymmetryRank(i)] == 0) continue;
            this.mIsPrimaryAtom[i] = true;
            nArray[n] = 0;
            int n2 = 0;
            nArray2[0] = i;
            for (int j = 0; j <= n2; ++j) {
                for (int k = 0; k < this.mMol.getConnAtoms(nArray2[j]); ++k) {
                    int n3;
                    int n4 = this.mMol.getConnAtom(nArray2[j], k);
                    if (this.mMol.isSelectedAtom(n4) || nArray[n3 = this.mCanonizer.getSymmetryRank(n4)] == 0) continue;
                    this.mIsPrimaryAtom[n4] = true;
                    nArray[n3] = 0;
                    nArray2[n2++] = n4;
                }
            }
        }
    }

    private void addProbabilitiesForAddAtom(ArrayList<Mutation> arrayList) {
        block0: for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            int n;
            if (!this.mIsPrimaryAtom[i]) continue;
            int n2 = this.mMol.getFreeValence(i);
            int n3 = n = n2 > 3 ? 3 : n2;
            if (n <= 0) continue;
            this.mMol.copyMolecule(this.mMolCopy);
            int n4 = this.mMolCopy.addAtom(6);
            int n5 = this.mMolCopy.addBond(i, n4, 1);
            for (int j = 1; j <= n; ++j) {
                int n6;
                boolean bl = false;
                for (n6 = 0; n6 < Mutation.cAllowedAtomicNo[j - 1].length; ++n6) {
                    if (Mutation.cAllowedAtomicNo[j - 1][n6] != this.mMol.getAtomicNo(i)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue block0;
                for (n6 = 0; n6 < Mutation.cAllowedAtomicNo[j - 1].length; ++n6) {
                    double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, i));
                    int n7 = Mutation.cAllowedAtomicNo[j - 1][n6];
                    int n8 = this.getBondTypeFromOrder(j);
                    this.mMolCopy.setAtomicNo(n4, n7);
                    this.mMolCopy.setBondType(n5, n8);
                    this.mMolCopy.ensureHelperArrays(7);
                    double d2 = this.getFrequency(this.mMolCopy, i);
                    double d3 = this.mGrowBoost * d2 / d * Math.sqrt(this.getFrequency(this.mMolCopy, n4));
                    if (!(d3 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
                    if (this.mBiasProvider != null) {
                        d3 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
                    }
                    arrayList.add(new Mutation(1, i, -1, n7, n8, d3));
                }
            }
        }
    }

    private void addProbabilitiesForInsertAtom(ArrayList<Mutation> arrayList) {
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            if (this.mMol.getBondType(i) != 1 || this.mMol.isAromaticBond(i)) continue;
            for (int j = 0; j < 2; ++j) {
                int n = this.mMol.getBondAtom(j, i);
                int n2 = this.mMol.getBondAtom(1 - j, i);
                if (!this.mIsPrimaryAtom[n] || this.mMol.isSelectedAtom(n2) || this.mCanonizer.getSymmetryRank(n) >= this.mCanonizer.getSymmetryRank(n2)) continue;
                double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n));
                double d2 = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n2));
                this.mMol.copyMolecule(this.mMolCopy);
                this.mMolCopy.deleteBond(i);
                int n3 = this.mMolCopy.addAtom(6);
                this.mMolCopy.addBond(n, n3, 1);
                this.mMolCopy.addBond(n2, n3, 1);
                for (int k = 0; k < Mutation.cAllowedAtomicNo[1].length; ++k) {
                    int n4 = Mutation.cAllowedAtomicNo[1][k];
                    this.mMolCopy.setAtomicNo(n3, n4);
                    double d3 = this.getFrequency(this.mMolCopy, n);
                    double d4 = this.getFrequency(this.mMolCopy, n2);
                    double d5 = this.getFrequency(this.mMolCopy, n3);
                    double d6 = this.mGrowBoost * Math.sqrt(d5 * d3 * d4 / (d * d2));
                    if (!(d6 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
                    if (this.mBiasProvider != null) {
                        d6 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
                    }
                    arrayList.add(new Mutation(2, i, -1, n4, -1, d6));
                }
            }
        }
    }

    private void addProbabilitiesForChangeAtom(ArrayList<Mutation> arrayList) {
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            int n;
            if (!this.mIsPrimaryAtom[i]) continue;
            int n2 = 1;
            for (n = 0; n < this.mMol.getConnAtoms(i); ++n) {
                if (n2 >= this.mMol.getConnBondOrder(i, n)) continue;
                n2 = this.mMol.getConnBondOrder(i, n);
            }
            for (n = 0; n < Mutation.cAllowedAtomicNo[n2 - 1].length; ++n) {
                int n3 = Mutation.cAllowedAtomicNo[n2 - 1][n];
                int n4 = this.mMol.getConnAtoms(i) + this.mMol.getAtomPi(i);
                if (this.mMol.getAtomicNo(i) == n3 || n4 > 1 && (n3 == 9 || n3 == 17 || n3 == 35 || n3 == 53) || n4 > 2 && n3 == 8 || n4 > 3 && n3 == 5 || n4 > 4 && (n3 == 6 || n3 == 7) || n4 > 5 && n3 == 15) continue;
                this.mMol.copyMolecule(this.mMolCopy);
                this.mMolCopy.setAtomicNo(i, n3);
                this.mMolCopy.ensureHelperArrays(7);
                double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, i));
                double d2 = this.getFrequency(this.mMolCopy, i);
                for (int j = 0; j < this.mMol.getConnAtoms(i); ++j) {
                    int n5 = this.mMol.getConnAtom(i, j);
                    d *= Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n5));
                    d2 *= this.getFrequency(this.mMolCopy, n5);
                }
                double d3 = Math.pow(d2 / d, 1.0 / (double)(1 + this.mMol.getConnAtoms(i)));
                if (!(d3 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
                if (this.mBiasProvider != null) {
                    d3 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
                }
                arrayList.add(new Mutation(4, i, -1, n3, -1, d3));
            }
        }
    }

    private void addProbabilitiesForDeleteAtom(ArrayList<Mutation> arrayList) {
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            int n;
            if (!this.mIsPrimaryAtom[i] || this.mMol.getConnAtoms(i) != 1 || this.mMol.isSelectedAtom(n = this.mMol.getConnAtom(i, 0))) continue;
            this.mMol.copyMolecule(this.mMolCopy);
            this.mMolCopy.deleteBond(this.mMol.getConnBond(i, 0));
            double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n));
            double d2 = this.getFrequency(this.mMolCopy, n);
            double d3 = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, i));
            double d4 = d2 / d / Math.sqrt(d3);
            if (!(d4 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
            if (this.mBiasProvider != null) {
                d4 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
            }
            arrayList.add(new Mutation(16, i, -1, -1, -1, d4));
        }
    }

    private void addProbabilitiesForCutOutAtom(ArrayList<Mutation> arrayList) {
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (!this.mIsPrimaryAtom[i] || this.mMol.isAromaticAtom(i) || this.mMol.getConnAtoms(i) != 2 || this.mMol.getAtomPi(i) != 0 || this.mMol.getAtomRingSize(i) == 3) continue;
            int n = this.mMol.getConnAtom(i, 0);
            int n2 = this.mMol.getConnAtom(i, 1);
            double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n));
            double d2 = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n2));
            double d3 = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, i));
            this.mMol.copyMolecule(this.mMolCopy);
            this.mMolCopy.addBond(n, n2, 1);
            this.mMolCopy.deleteAtom(i);
            int n3 = this.mMolCopy.getAllBonds() - 1;
            n = this.mMolCopy.getBondAtom(0, n3);
            n2 = this.mMolCopy.getBondAtom(1, n3);
            double d4 = this.getFrequency(this.mMolCopy, n);
            double d5 = this.getFrequency(this.mMolCopy, n2);
            double d6 = Math.sqrt(d4 * d5 / (d * d2)) / Math.sqrt(d3);
            if (!(d6 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
            if (this.mBiasProvider != null) {
                d6 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
            }
            arrayList.add(new Mutation(8, i, -1, -1, -1, d6));
        }
    }

    private void addProbabilitiesForToggleAmidSulfonamid(ArrayList<Mutation> arrayList) {
        int[] nArray = new int[4];
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            int n;
            int n2;
            if (!this.mIsPrimaryAtom[i] || (n2 = this.mMol.getAtomicNo(i)) != 6 && n2 != 16) continue;
            int n3 = 0;
            for (n = 0; n < this.mMol.getConnAtoms(i); ++n) {
                nArray[n3] = this.mMol.getConnAtom(i, n);
                if (this.mMol.getConnBondOrder(i, n) != 2 || this.mMol.getAtomicNo(nArray[n3]) != 8) continue;
                ++n3;
            }
            if ((n2 != 6 || n3 != 1) && (n2 != 16 || n3 != 2)) continue;
            this.mMol.copyMolecule(this.mMolCopy);
            this.mMolCopy.setAtomicNo(i, n2 == 6 ? 16 : 6);
            if (n2 == 6) {
                n = this.mMolCopy.addAtom(8);
                this.mMolCopy.addBond(i, n, 2);
            } else {
                this.mMolCopy.deleteBond(this.mMol.getBond(i, nArray[1]));
            }
            double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, i));
            double d2 = this.getFrequency(this.mMolCopy, i);
            int n4 = 1;
            for (int j = 0; j < this.mMol.getConnAtoms(i); ++j) {
                int n5 = this.mMol.getConnAtom(i, j);
                boolean bl = false;
                for (int k = 0; k < n3; ++k) {
                    if (n5 == nArray[k]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                d *= Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n5));
                d2 *= this.getFrequency(this.mMolCopy, n5);
                ++n4;
            }
            double d3 = 10.0 * Math.pow(d2 / d, 1.0 / (double)n4);
            if (!(d3 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
            if (this.mBiasProvider != null) {
                d3 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
            }
            arrayList.add(new Mutation(1024, i, nArray[1], -1, -1, d3));
        }
    }

    private void addProbabilitiesForCloseRing(ArrayList<Mutation> arrayList, int n) {
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            int n2;
            int n3;
            if (!this.mIsPrimaryAtom[i]) continue;
            int[] nArray = new int[this.mMol.getAtoms()];
            int[] nArray2 = new int[this.mMol.getAtoms()];
            int[] nArray3 = new int[this.mMol.getAtoms()];
            int[] nArray4 = new int[this.mMol.getAtoms()];
            nArray[0] = i;
            nArray4[i] = 1;
            int n4 = 0;
            for (int j = 0; j <= n4 && nArray4[nArray[j]] < 7; ++j) {
                for (n3 = 0; n3 < this.mMol.getConnAtoms(nArray[j]); ++n3) {
                    n2 = this.mMol.getConnAtom(nArray[j], n3);
                    if (nArray4[n2] != 0) continue;
                    nArray3[n2] = nArray[j];
                    nArray4[n2] = nArray4[nArray[j]] + 1;
                    nArray2[n2] = this.mMol.getConnBond(nArray[j], n3);
                    nArray[++n4] = n2;
                }
            }
            for (n3 = 2; n3 <= n4 && nArray4[n3] < 3; ++n3) {
            }
            while (n3 <= n4) {
                if (this.mMol.isSelectedAtom(n2 = nArray[n3++]) || n2 < i || this.mMol.getBond(i, n2) != -1 || !this.qualifiesForRing(nArray2, nArray4, nArray3, i, n2)) continue;
                for (int j = 1; j <= 2 && this.mMol.getFreeValence(i) >= j && this.mMol.getFreeValence(n2) >= j; ++j) {
                    int[] nArray5;
                    int n5;
                    if ((n & 0x200) != 0 && j == 1 && ((n5 = 1 + this.mMol.getPath(nArray5 = new int[6], i, n2, 5, null)) == 5 || n5 == 6)) {
                        boolean bl = false;
                        for (int k = 1; k < n5 - 1; ++k) {
                            if (!this.mMol.isSelectedAtom(nArray5[k])) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            this.mMol.copyMolecule(this.mMolCopy);
                            this.mMolCopy.addBond(i, n2, 1);
                            if (this.aromatizeRing(this.mMolCopy, nArray5, n5)) {
                                double d = 1.0;
                                double d2 = 1.0;
                                for (int n6 : nArray5) {
                                    d /= Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n6));
                                    d2 *= this.getFrequency(this.mMolCopy, n6);
                                }
                                double d3 = 1.0 * Math.pow(d2 / d, 1.0 / (double)nArray5.length);
                                if (d3 > 0.0 && this.isValidStructure(this.mMolCopy)) {
                                    if (this.mBiasProvider != null) {
                                        d3 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
                                    }
                                    arrayList.add(new Mutation(512, i, n2, n5, nArray5, d3));
                                }
                            }
                        }
                    }
                    if ((n & 0x20) == 0 || j != 1) continue;
                    this.mMol.copyMolecule(this.mMolCopy);
                    this.mMolCopy.addBond(i, n2, this.getBondTypeFromOrder(j));
                    double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, i));
                    double d4 = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n2));
                    double d5 = this.getFrequency(this.mMolCopy, i);
                    double d6 = this.getFrequency(this.mMolCopy, n2);
                    double d7 = this.mAtomTypeList == null ? 1.0 : (double)this.mAtomTypeList.getRingSizeAdjust(nArray4[n2]);
                    d7 *= 1.0 * Math.sqrt(d5 * d6 / (d * d4));
                    if (!(d7 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
                    if (this.mBiasProvider != null) {
                        d7 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
                    }
                    arrayList.add(new Mutation(32, i, n2, this.getBondTypeFromOrder(j), -1, d7));
                }
            }
        }
    }

    private void addProbabilitiesForChangeBond(ArrayList<Mutation> arrayList) {
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            for (int j = 0; j < 2; ++j) {
                int n;
                int n2;
                int n3 = this.mMol.getBondAtom(j, i);
                if (!this.mIsPrimaryAtom[n3] || this.mMol.isSelectedAtom(n2 = this.mMol.getBondAtom(1 - j, i)) || (!this.mIsPrimaryAtom[n2] ? this.mCanonizer.getSymmetryRank(n3) < this.mCanonizer.getSymmetryRank(n2) : n2 < n3)) continue;
                int n4 = this.mMol.getFreeValence(n3);
                if (n4 > this.mMol.getFreeValence(n2)) {
                    n4 = this.mMol.getFreeValence(n2);
                }
                if ((n = this.mMol.getBondOrder(i) + n4) > 3) {
                    n = 3;
                }
                if (this.mMol.isAromaticBond(i)) {
                    if (this.mMol.getBondOrder(i) == 1) continue;
                    n = 2;
                }
                if (this.mMol.isSmallRingBond(i)) {
                    if (this.mMol.getBondOrder(i) == 1 && this.mMol.getAtomPi(n3) + this.mMol.getAtomPi(n2) != 0) {
                        n = 1;
                    } else if (n > 2) {
                        n = 2;
                    }
                }
                if (n == 2 && (this.mMol.getAtomicNo(n3) < 5 || this.mMol.getAtomicNo(n3) > 8 && this.mMol.getAtomicNo(n3) != 15 && this.mMol.getAtomicNo(n3) != 16 || this.mMol.getAtomicNo(n2) < 5 || this.mMol.getAtomicNo(n2) > 8 && this.mMol.getAtomicNo(n2) != 15 && this.mMol.getAtomicNo(n2) != 16)) {
                    n = 1;
                }
                for (int k = 1; k <= n; ++k) {
                    if (k == this.mMol.getBondOrder(i)) continue;
                    this.mMol.copyMolecule(this.mMolCopy);
                    this.mMolCopy.setBondType(i, this.getBondTypeFromOrder(k));
                    double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n3));
                    double d2 = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n2));
                    double d3 = this.getFrequency(this.mMolCopy, n3);
                    double d4 = this.getFrequency(this.mMolCopy, n2);
                    double d5 = Math.sqrt(d3 * d4 / (d * d2));
                    if (!(d5 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
                    if (this.mBiasProvider != null) {
                        d5 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
                    }
                    arrayList.add(new Mutation(64, i, -1, this.getBondTypeFromOrder(k), -1, d5));
                }
            }
        }
    }

    private void addProbabilitiesForDeleteBond(ArrayList<Mutation> arrayList) {
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            if (!this.mMol.isRingBond(i)) continue;
            for (int j = 0; j < 2; ++j) {
                int n;
                int n2 = this.mMol.getBondAtom(j, i);
                if (!this.mIsPrimaryAtom[n2] || this.mMol.isSelectedAtom(n = this.mMol.getBondAtom(1 - j, i)) || (this.mIsPrimaryAtom[n] ? n < n2 : this.mCanonizer.getSymmetryRank(n2) < this.mCanonizer.getSymmetryRank(n))) continue;
                this.mMol.copyMolecule(this.mMolCopy);
                this.mMolCopy.deleteBond(i);
                double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n2));
                double d2 = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n));
                double d3 = this.getFrequency(this.mMolCopy, n2);
                double d4 = this.getFrequency(this.mMolCopy, n);
                double d5 = Math.sqrt(d3 * d4 / (d * d2));
                if (!(d5 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
                if (this.mBiasProvider != null) {
                    d5 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
                }
                arrayList.add(new Mutation(128, i, -1, -1, -1, d5));
            }
        }
    }

    private void addProbabilitiesForChangeRing(ArrayList<Mutation> arrayList) {
        this.mMol.ensureHelperArrays(7);
        RingCollection ringCollection = this.mMol.getRingSet();
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            int[] nArray;
            int n;
            int n2 = ringCollection.getRingSize(i);
            if (n2 != 5 && n2 != 6) continue;
            int[] nArray2 = ringCollection.getRingAtoms(i);
            boolean bl = false;
            for (n = 0; n < n2; ++n) {
                if (!this.mMol.isSelectedAtom(nArray2[n])) continue;
                bl = true;
            }
            if (bl) continue;
            n = 0;
            int n3 = -1;
            for (int j = 0; j < n2; ++j) {
                if (n >= this.mCanonizer.getSymmetryRank(nArray2[j])) continue;
                n = this.mCanonizer.getSymmetryRank(nArray2[j]);
                n3 = nArray2[j];
            }
            if (!this.mIsPrimaryAtom[n3] || this.hasExocyclicPiBond(nArray2, nArray = ringCollection.getRingBonds(i))) continue;
            for (int j = 0; j < n2 && (j <= 0 || n2 != 6 && !ringCollection.isAromatic(i)); ++j) {
                if (n2 == 5 && this.mMol.getAtomicNo(nArray2[j]) != 7 && this.mMol.getAtomicNo(nArray2[j]) != 8 && this.mMol.getAtomicNo(nArray2[j]) != 16) continue;
                this.mMol.copyMolecule(this.mMolCopy);
                this.mMolCopy.ensureHelperArrays(7);
                if (!this.changeAromaticity(this.mMolCopy, i, j)) continue;
                double d = 1.0;
                double d2 = 1.0;
                for (int k = 0; k < n2; ++k) {
                    d *= Math.max((double)1.0E-5f, this.getFrequency(this.mMol, k));
                    d2 *= this.getFrequency(this.mMolCopy, k);
                }
                double d3 = 1.0 * Math.pow(d2 / d, 1.0 / (double)n2);
                if (!(d3 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
                if (this.mBiasProvider != null) {
                    d3 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
                }
                arrayList.add(new Mutation(256, i, -1, j, -1, d3));
            }
        }
    }

    private void addProbabilitiesForMigrate(ArrayList<Mutation> arrayList) {
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (!this.mIsPrimaryAtom[i] || this.mMol.getConnAtoms(i) <= 2) continue;
            for (int j = 0; j < this.mMol.getConnAtoms(i); ++j) {
                int n;
                int n2 = this.mMol.getConnAtom(i, j);
                if (this.mMol.isSelectedAtom(n2) || this.mMol.isRingBond(n = this.mMol.getConnBond(i, j)) || this.mMol.getBondOrder(n) != 1) continue;
                for (int k = 0; k < this.mMol.getConnAtoms(i); ++k) {
                    int n3;
                    if (j == k || !this.mIsPrimaryAtom[n3 = this.mMol.getConnAtom(i, k)] || this.mMol.getFreeValence(n3) <= 0) continue;
                    this.mMol.copyMolecule(this.mMolCopy);
                    for (int i2 = 0; i2 < 2; ++i2) {
                        if (this.mMolCopy.getBondAtom(i2, n) != i) continue;
                        this.mMolCopy.setBondAtom(i2, n, n3);
                    }
                    double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, i)) * Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n2)) * Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n3));
                    double d2 = this.getFrequency(this.mMolCopy, i) * this.getFrequency(this.mMolCopy, n2) * this.getFrequency(this.mMolCopy, n3);
                    double d3 = Math.sqrt(d2 / d);
                    if (!(d3 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
                    if (this.mBiasProvider != null) {
                        d3 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
                    }
                    arrayList.add(new Mutation(2048, n, -1, i, n3, d3));
                }
            }
        }
    }

    private void addProbabilitiesForSwapSubstituent(ArrayList<Mutation> arrayList, ArrayList<MutatorSubstituent> arrayList2) {
        for (MutatorSubstituent mutatorSubstituent : arrayList2) {
            if (!this.mIsPrimaryAtom[mutatorSubstituent.firstAtom]) continue;
            for (MutatorSubstituent mutatorSubstituent2 : arrayList2) {
                if (!this.mIsPrimaryAtom[mutatorSubstituent2.firstAtom] || mutatorSubstituent.coreAtom == mutatorSubstituent2.coreAtom || mutatorSubstituent.bond == mutatorSubstituent2.bond) continue;
                this.mMol.copyMolecule(this.mMolCopy);
                for (int i = 0; i < 2; ++i) {
                    if (this.mMolCopy.getBondAtom(i, mutatorSubstituent.bond) == mutatorSubstituent.firstAtom) {
                        this.mMolCopy.setBondAtom(i, mutatorSubstituent.bond, mutatorSubstituent2.firstAtom);
                    }
                    if (this.mMolCopy.getBondAtom(i, mutatorSubstituent2.bond) != mutatorSubstituent2.firstAtom) continue;
                    this.mMolCopy.setBondAtom(i, mutatorSubstituent2.bond, mutatorSubstituent.firstAtom);
                }
                double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, mutatorSubstituent.coreAtom)) * Math.max((double)1.0E-5f, this.getFrequency(this.mMol, mutatorSubstituent.firstAtom)) * Math.max((double)1.0E-5f, this.getFrequency(this.mMol, mutatorSubstituent2.coreAtom)) * Math.max((double)1.0E-5f, this.getFrequency(this.mMol, mutatorSubstituent2.firstAtom));
                double d2 = this.getFrequency(this.mMolCopy, mutatorSubstituent.coreAtom) * this.getFrequency(this.mMolCopy, mutatorSubstituent.firstAtom) * this.getFrequency(this.mMolCopy, mutatorSubstituent2.coreAtom) * this.getFrequency(this.mMolCopy, mutatorSubstituent2.firstAtom);
                double d3 = Math.sqrt(d2 / d);
                if (!(d3 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
                if (this.mBiasProvider != null) {
                    d3 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
                }
                arrayList.add(new Mutation(4096, mutatorSubstituent.coreAtom, mutatorSubstituent2.coreAtom, mutatorSubstituent.firstAtom, mutatorSubstituent2.firstAtom, d3));
            }
        }
    }

    private void addProbabilitiesForDeleteSubstituent(ArrayList<Mutation> arrayList, ArrayList<MutatorSubstituent> arrayList2) {
        for (MutatorSubstituent mutatorSubstituent : arrayList2) {
            if (!this.mIsPrimaryAtom[mutatorSubstituent.coreAtom]) continue;
            boolean[] blArray = new boolean[this.mMol.getAllAtoms()];
            this.mMol.getSubstituent(mutatorSubstituent.coreAtom, mutatorSubstituent.firstAtom, blArray, null, null);
            boolean bl = false;
            for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                if (!blArray[i] || !this.mMol.isSelectedAtom(i)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.mMol.copyMolecule(this.mMolCopy);
            this.mMolCopy.deleteBond(mutatorSubstituent.bond);
            double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, mutatorSubstituent.coreAtom));
            double d2 = 1.0;
            for (int n : mutatorSubstituent.atoms) {
                d2 *= Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n));
            }
            double d3 = this.getFrequency(this.mMolCopy, mutatorSubstituent.coreAtom);
            double d4 = d3 / (d * Math.pow(d2, 1.0 / (double)mutatorSubstituent.atoms.length));
            if (!(d4 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
            if (this.mBiasProvider != null) {
                d4 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
            }
            arrayList.add(new Mutation(8192, mutatorSubstituent.coreAtom, -1, mutatorSubstituent.firstAtom, -1, d4));
        }
    }

    private void addProbabilitiesForCutOutFragment(ArrayList<Mutation> arrayList) {
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            int n;
            if (!this.mIsPrimaryAtom[i] || this.mMol.getConnAtoms(i) <= 2) continue;
            int n2 = 0;
            for (n = 0; n < this.mMol.getConnAtoms(i); ++n) {
                if (!this.mMol.isRingBond(this.mMol.getConnBond(i, n))) continue;
                ++n2;
            }
            if (n2 > 2) continue;
            for (n = 1; n < this.mMol.getConnAtoms(i); ++n) {
                int n3 = this.mMol.getConnAtom(i, n);
                int n4 = this.mMol.getConnBond(i, n);
                if (this.mMol.getBondOrder(n4) != 1) continue;
                for (int j = 0; j < n; ++j) {
                    int n5;
                    int n6 = this.mMol.getConnAtom(i, j);
                    int n7 = this.mMol.getConnBond(i, j);
                    if (this.mMol.getBondOrder(n7) != 1 || (n5 = (this.mMol.isRingBond(n4) ? 1 : 0) + (this.mMol.isRingBond(n7) ? 1 : 0)) != n2) continue;
                    this.mMol.copyMolecule(this.mMolCopy);
                    this.mMolCopy.setBondAtom(0, n4, n3);
                    this.mMolCopy.setBondAtom(1, n4, n6);
                    this.mMolCopy.deleteBond(n7);
                    int[] nArray = this.mMolCopy.getFragmentAtoms(i);
                    boolean bl = false;
                    for (int n8 : nArray) {
                        if (!this.mMol.isSelectedAtom(n8)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    int[] nArray2 = this.mMolCopy.deleteAtoms(nArray);
                    double d = Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n3)) * Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n6));
                    double d2 = 1.0;
                    for (int n9 : nArray) {
                        d2 *= Math.max((double)1.0E-5f, this.getFrequency(this.mMol, n9));
                    }
                    double d3 = this.getFrequency(this.mMolCopy, nArray2[n3]) * this.getFrequency(this.mMolCopy, nArray2[n6]);
                    double d4 = Math.sqrt(d3 / d) / Math.pow(d2, 1.0 / (double)nArray.length);
                    if (!(d4 > 0.0) || !this.isValidStructure(this.mMolCopy)) continue;
                    if (this.mBiasProvider != null) {
                        d4 *= this.mBiasProvider.getBiasFactor(this.mMolCopy);
                    }
                    arrayList.add(new Mutation(16384, i, -1, n3, n6, d4));
                }
            }
        }
    }

    private void addProbabilitiesForInvertParity(ArrayList<Mutation> arrayList) {
        int n;
        for (n = 0; n < this.mMol.getAtoms(); ++n) {
            if (!this.mIsPrimaryAtom[n] || !this.mMol.isAtomStereoCenter(n)) continue;
            arrayList.add(new Mutation(32768, n, -1, -1, -1, 1.0));
        }
        for (n = 0; n < this.mMol.getBonds(); ++n) {
            if (!this.mIsPrimaryAtom[this.mMol.getBondAtom(0, n)] && !this.mIsPrimaryAtom[this.mMol.getBondAtom(1, n)] || this.mMol.getBondParity(n) == 0) continue;
            arrayList.add(new Mutation(32768, -1, n, -1, -1, 1.0));
        }
    }

    private ArrayList<MutatorSubstituent> createSubstituentList() {
        ArrayList<MutatorSubstituent> arrayList = new ArrayList<MutatorSubstituent>();
        boolean[] blArray = ScaffoldHelper.findMurckoScaffold(this.mMol);
        if (blArray != null) {
            for (int i = 0; i < this.mMol.getBonds(); ++i) {
                for (int j = 0; j < 2; ++j) {
                    int n = this.mMol.getBondAtom(j, i);
                    int n2 = this.mMol.getBondAtom(1 - j, i);
                    if (!blArray[n] || blArray[n2] || this.mMol.isSelectedAtom(n) || this.mMol.isSelectedAtom(n2)) continue;
                    arrayList.add(new MutatorSubstituent(n, n2, i));
                }
            }
        }
        return arrayList;
    }

    private double getFrequency(StereoMolecule stereoMolecule, int n) {
        if (this.mAtomTypeList != null) {
            try {
                long l = AtomTypeCalculator.getAtomType(stereoMolecule, n, 32190);
                return this.mAtomTypeList.getProbabilityFromType(l);
            }
            catch (Exception exception) {
                return 0.0;
            }
        }
        return 1.0;
    }

    private synchronized Mutation selectLikelyMutation(ArrayList<Mutation> arrayList) {
        double d = 0.0;
        for (Mutation mutation : arrayList) {
            d += mutation.mProbability;
        }
        double d2 = this.mRandom.nextDouble() * d;
        d = 0.0;
        for (Mutation mutation : arrayList) {
            if (!(d2 < (d += mutation.mProbability))) continue;
            arrayList.remove(mutation);
            return mutation;
        }
        return null;
    }

    public void performMutation(StereoMolecule stereoMolecule, Mutation mutation) {
        stereoMolecule.ensureHelperArrays(15);
        switch (mutation.mMutationType) {
            case 1: {
                int n = stereoMolecule.addAtom(mutation.mSpecifier1);
                stereoMolecule.addBond(mutation.mWhere1, n, mutation.mSpecifier2);
                break;
            }
            case 2: {
                int n = stereoMolecule.getBondAtom(0, mutation.mWhere1);
                int n2 = stereoMolecule.getBondAtom(1, mutation.mWhere1);
                stereoMolecule.deleteBond(mutation.mWhere1);
                int n3 = stereoMolecule.addAtom(mutation.mSpecifier1);
                stereoMolecule.addBond(n, n3, 1);
                stereoMolecule.addBond(n2, n3, 1);
                break;
            }
            case 4: {
                stereoMolecule.setAtomicNo(mutation.mWhere1, mutation.mSpecifier1);
                break;
            }
            case 16: {
                stereoMolecule.deleteAtom(mutation.mWhere1);
                break;
            }
            case 8: {
                int n = stereoMolecule.getConnAtom(mutation.mWhere1, 0);
                int n4 = stereoMolecule.getConnAtom(mutation.mWhere1, 1);
                stereoMolecule.addBond(n, n4, 1);
                stereoMolecule.deleteAtom(mutation.mWhere1);
                break;
            }
            case 32: {
                stereoMolecule.addBond(mutation.mWhere1, mutation.mWhere2, mutation.mSpecifier1);
                break;
            }
            case 512: {
                stereoMolecule.addBond(mutation.mWhere1, mutation.mWhere2, mutation.mSpecifier1);
                this.aromatizeRing(stereoMolecule, mutation.mAtomList, mutation.mSpecifier1);
                break;
            }
            case 1024: {
                if (stereoMolecule.getAtomicNo(mutation.mWhere1) == 6) {
                    stereoMolecule.setAtomicNo(mutation.mWhere1, 16);
                    stereoMolecule.addBond(mutation.mWhere1, stereoMolecule.addAtom(8), 2);
                    break;
                }
                stereoMolecule.setAtomicNo(mutation.mWhere1, 6);
                stereoMolecule.deleteAtom(mutation.mWhere2);
                break;
            }
            case 64: {
                stereoMolecule.setBondType(mutation.mWhere1, mutation.mSpecifier1);
                break;
            }
            case 128: {
                stereoMolecule.deleteBond(mutation.mWhere1);
                break;
            }
            case 256: {
                this.changeAromaticity(stereoMolecule, mutation.mWhere1, mutation.mSpecifier1);
                break;
            }
            case 2048: {
                for (int i = 0; i < 2; ++i) {
                    if (stereoMolecule.getBondAtom(i, mutation.mWhere1) != mutation.mSpecifier1) continue;
                    stereoMolecule.setBondAtom(i, mutation.mWhere1, mutation.mSpecifier2);
                }
                break;
            }
            case 8192: {
                boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
                stereoMolecule.getSubstituent(mutation.mWhere1, mutation.mSpecifier1, blArray, null, null);
                stereoMolecule.deleteAtoms(blArray);
                break;
            }
            case 16384: {
                int n = mutation.mWhere1;
                int n5 = mutation.mSpecifier1;
                int n6 = mutation.mSpecifier2;
                int n7 = -1;
                int n8 = -1;
                for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
                    if (stereoMolecule.getConnAtom(n, i) == n5) {
                        n7 = stereoMolecule.getConnBond(n, i);
                        continue;
                    }
                    if (stereoMolecule.getConnAtom(n, i) != n6) continue;
                    n8 = stereoMolecule.getConnBond(n, i);
                }
                if (n7 == -1 || n8 == -1) break;
                stereoMolecule.deleteBond(n7);
                stereoMolecule.deleteBond(n8);
                int[] nArray = stereoMolecule.deleteAtoms(stereoMolecule.getFragmentAtoms(n));
                stereoMolecule.addBond(nArray[n5], nArray[n6], 1);
                break;
            }
            case 32768: {
                if (mutation.mWhere1 != -1) {
                    stereoMolecule.setAtomParity(mutation.mWhere1, stereoMolecule.getAtomParity(mutation.mWhere1) != 1 ? 1 : 2, false);
                }
                if (mutation.mWhere2 == -1) break;
                stereoMolecule.setBondParity(mutation.mWhere2, stereoMolecule.getBondParity(mutation.mWhere2) != 1 ? 1 : 2, false);
            }
        }
        this.repairCharges(stereoMolecule);
        new CoordinateInventor().invent(stereoMolecule);
        stereoMolecule.setStereoBondsFromParity();
        stereoMolecule.ensureHelperArrays(15);
        this.repairStereoChemistry(stereoMolecule);
    }

    private int getBondTypeFromOrder(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    private boolean qualifiesForRing(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2) {
        int n3 = nArray2[n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n2;
        while (n9 != n) {
            if (this.mMol.getAtomPi(n9) == 2 && (this.mMol.getConnBondOrder(n9, 0) == 2 ? n3 < 9 : n3 < 10)) {
                return false;
            }
            if (this.mMol.isRingBond(nArray[n9])) {
                if (n7 == 0) {
                    n4 = n9;
                }
                ++n7;
            } else {
                if (n8 < n7) {
                    n8 = n7;
                    n5 = n4;
                    n6 = n9;
                }
                n7 = 0;
            }
            n9 = nArray3[n9];
        }
        if (n8 < n7) {
            n8 = n7;
            n5 = n4;
            n6 = n9;
        }
        int n10 = n8;
        if (n8 > 0 && (this.mMol.isAromaticAtom(n5) || this.mMol.isAromaticAtom(n6) || this.mMol.getAtomPi(n5) > 0 && this.mMol.getAtomPi(n6) > 0)) {
            ++n10;
        }
        return n3 - n10 >= 3;
    }

    private boolean isValidStructure(StereoMolecule stereoMolecule) {
        int[][] nArrayArray = new int[][]{null, null, null, {-1, 2}, {-1, 2, 6}, {-1, 1, 5}, {-1, 1, 4, 6}, {-1, 1, 4, 6}};
        int[][] nArrayArray2 = new int[][]{null, null, null, {-1, 1}, {-1, 1, 5}, {-1, 1, 4}, {-1, 0, 3, 4}, {-1, 0, 2, 3}};
        int[][] nArrayArray3 = new int[][]{null, null, null, {-1, 0}, {-1, -1, 3}, {-1, -1, 0}, {-1, -1, 0, -1}, {-1, -1, 0, -1}};
        stereoMolecule.ensureHelperArrays(7);
        RingCollection ringCollection = stereoMolecule.getRingSet();
        boolean[] blArray = new boolean[stereoMolecule.getAtoms()];
        for (int i = 0; i < ringCollection.getSize() && ringCollection.getRingSize(i) < 8; ++i) {
            int n;
            int n2;
            int n3;
            int[] nArray;
            int[] nArray2 = nArray = ringCollection.getRingAtoms(i);
            int n4 = nArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = nArray2[n3];
                blArray[n2] = true;
            }
            int n5 = ringCollection.getRingSize(i);
            for (n4 = 1; n4 < n5; ++n4) {
                if (stereoMolecule.getConnAtoms(nArray[n4]) <= 2) continue;
                for (n3 = 0; n3 < stereoMolecule.getConnAtoms(nArray[n4]); ++n3) {
                    n2 = stereoMolecule.getConnAtom(nArray[n4], n3);
                    if (!stereoMolecule.isRingAtom(n2) || ringCollection.isAtomMember(i, n2)) continue;
                    for (n = 0; n < n4; ++n) {
                        if (stereoMolecule.getConnAtoms(nArray[n]) <= 2) continue;
                        for (int j = 0; j < stereoMolecule.getConnAtoms(nArray[n]); ++j) {
                            int n6;
                            int n7 = stereoMolecule.getConnAtom(nArray[n], j);
                            if (!stereoMolecule.isRingAtom(n7) || ringCollection.isAtomMember(i, n7)) continue;
                            int n8 = Math.min(n4 - n, n5 - n4 + n);
                            int n9 = stereoMolecule.getAtomPi(nArray[n4]);
                            int n10 = stereoMolecule.getAtomPi(nArray[n]);
                            int n11 = ringCollection.isAromatic(i) || n9 != 0 && n10 != 0 ? nArrayArray[n5][n8] : (n6 = n9 != 0 || n10 != 0 ? nArrayArray2[n5][n8] : nArrayArray3[n5][n8]);
                            if (n6 == -1 || stereoMolecule.getPathLength(n2, n7, n6, blArray) == -1) continue;
                            return false;
                        }
                    }
                }
            }
            int[] nArray3 = nArray;
            n3 = nArray3.length;
            for (n2 = 0; n2 < n3; ++n2) {
                n = nArray3[n2];
                blArray[n] = false;
            }
        }
        return true;
    }

    private boolean hasExocyclicPiBond(int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < this.mMol.getConnAtoms(nArray[i]); ++j) {
                int n = this.mMol.getConnBond(nArray[i], j);
                boolean bl = false;
                for (int k = 0; k < nArray2.length; ++k) {
                    if (n != nArray2[k]) continue;
                    bl = true;
                    break;
                }
                if (bl || !this.mMol.isAromaticBond(n) && this.mMol.getBondOrder(n) <= 1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean changeAromaticity(StereoMolecule stereoMolecule, int n, int n2) {
        int n3;
        stereoMolecule.ensureHelperArrays(7);
        RingCollection ringCollection = stereoMolecule.getRingSet();
        int n4 = ringCollection.getRingSize(n);
        int[] nArray = ringCollection.getRingAtoms(n);
        int[] nArray2 = ringCollection.getRingBonds(n);
        if (ringCollection.isAromatic(n)) {
            for (int i = 0; i < n4; ++i) {
                stereoMolecule.setBondType(nArray2[i], 1);
            }
            return true;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            stereoMolecule.setBondType(nArray2[n3], 1);
        }
        if (n4 == 5) {
            for (n3 = 0; n3 < n4; ++n3) {
                if (n2 == n3) continue;
                if (stereoMolecule.getFreeValence(nArray[n3]) < 1) {
                    return false;
                }
                if (stereoMolecule.getAtomicNo(nArray[n3]) == 6 || stereoMolecule.getAtomicNo(nArray[n3]) == 7) continue;
                return false;
            }
            n3 = n2 + 1;
            int n5 = n2 + 3;
            if (n3 > 4) {
                n3 -= 5;
            }
            if (n5 > 4) {
                n5 -= 5;
            }
            stereoMolecule.setBondType(n3, 2);
            stereoMolecule.setBondType(n5, 2);
            return true;
        }
        if (n4 == 6) {
            for (n3 = 0; n3 < n4; ++n3) {
                if (stereoMolecule.getFreeValence(nArray[n3]) < 1) {
                    return false;
                }
                if (stereoMolecule.getAtomicNo(nArray[n3]) == 6 || stereoMolecule.getAtomicNo(nArray[n3]) == 7) continue;
                return false;
            }
            for (n3 = 0; n3 < n4; n3 += 2) {
                stereoMolecule.setBondType(nArray2[n3], 2);
            }
            return true;
        }
        return false;
    }

    private void repairCharges(StereoMolecule stereoMolecule) {
        int n;
        int n2;
        int n3;
        stereoMolecule.ensureHelperArrays(7);
        for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
            if (stereoMolecule.getAtomicNo(n3) == 7 && stereoMolecule.getConnAtoms(n3) + stereoMolecule.getAtomPi(n3) == 4) {
                stereoMolecule.setAtomCharge(n3, 1);
                for (n2 = 0; n2 < stereoMolecule.getConnAtoms(n3); ++n2) {
                    n = stereoMolecule.getConnAtom(n3, n2);
                    if ((stereoMolecule.getAtomicNo(n) != 7 || stereoMolecule.getConnAtoms(n) + stereoMolecule.getAtomPi(n) >= 3) && (stereoMolecule.getAtomicNo(n) != 8 || stereoMolecule.getConnAtoms(n) + stereoMolecule.getAtomPi(n) >= 2)) continue;
                    stereoMolecule.setAtomCharge(n, -1);
                }
            }
            if (stereoMolecule.getAtomicNo(n3) != 6 || stereoMolecule.getAtomCharge(n3) == 0) continue;
            stereoMolecule.setAtomCharge(n3, 0);
        }
        for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
            int n4;
            if (stereoMolecule.getAtomCharge(n3) == 0) continue;
            n2 = 0;
            for (n = 0; n < stereoMolecule.getConnAtoms(n3); ++n) {
                if (stereoMolecule.getAtomCharge(stereoMolecule.getConnAtom(n3, n)) == 0) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0 || (n = stereoMolecule.getConnAtoms(n3) + stereoMolecule.getAtomPi(n3)) > (n4 = stereoMolecule.getMaxValenceUncharged(n3))) continue;
            stereoMolecule.setAtomCharge(n3, 0);
        }
    }

    private void repairStereoChemistry(StereoMolecule stereoMolecule) {
        boolean bl;
        int n;
        int n2;
        for (n2 = 0; n2 < stereoMolecule.getAllBonds(); ++n2) {
            if (!stereoMolecule.isStereoBond(n2)) continue;
            stereoMolecule.setBondType(n2, 1);
        }
        for (n2 = 0; n2 < stereoMolecule.getAtoms(); ++n2) {
            n = stereoMolecule.getAtomParity(n2);
            if (n == 3) {
                n = this.mRandom.nextDouble() < 0.5 ? 1 : 2;
                bl = stereoMolecule.isAtomParityPseudo(n2);
                stereoMolecule.setAtomParity(n2, n, bl);
                stereoMolecule.setAtomESR(n2, 0, 0);
            }
            if (n == 0) continue;
            stereoMolecule.setStereoBondFromAtomParity(n2);
        }
        for (n2 = 0; n2 < stereoMolecule.getBonds(); ++n2) {
            if (!stereoMolecule.isBINAPChiralityBond(n2)) continue;
            switch (stereoMolecule.getBondParity(n2)) {
                case 3: {
                    n = this.mRandom.nextDouble() < 0.5 ? 1 : 2;
                    bl = stereoMolecule.isBondParityPseudo(n2);
                    stereoMolecule.setBondParity(n2, n, bl);
                }
                case 1: 
                case 2: {
                    stereoMolecule.setStereoBondFromBondParity(n2);
                }
            }
        }
    }

    private boolean aromatizeRing(StereoMolecule stereoMolecule, int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        stereoMolecule.ensureHelperArrays(1);
        int n6 = -1;
        for (n5 = 0; n5 < n; ++n5) {
            n4 = stereoMolecule.getAtomicNo(nArray[n5]);
            if (n4 == 8 || n4 == 16) {
                if (n == 6) {
                    return false;
                }
                if (n6 != -1) {
                    return false;
                }
                n6 = n5;
                continue;
            }
            if (n4 == 7) {
                if (stereoMolecule.getFreeValence(nArray[n5]) != 0 || stereoMolecule.getAtomPi(nArray[n5]) != 0) continue;
                if (n6 != -1) {
                    return false;
                }
                n6 = n5;
                continue;
            }
            if (n4 == 6) continue;
            return false;
        }
        if (n6 == -1 && n == 5) {
            for (n5 = 0; n5 < n; ++n5) {
                if (stereoMolecule.getAtomicNo(nArray[n5]) != 7) continue;
                n6 = n5;
                break;
            }
        }
        int[] nArray2 = new int[n];
        for (n4 = 0; n4 < n; ++n4) {
            nArray2[n4] = stereoMolecule.getBond(nArray[n4], nArray[n4 != 0 ? n4 - 1 : n - 1]);
        }
        for (n4 = 0; n4 < n; ++n4) {
            n3 = nArray[n4 == 0 ? n - 1 : n4 - 1];
            n2 = nArray[n4 == n - 1 ? 0 : n4 + 1];
            for (int i = 0; i < stereoMolecule.getConnAtoms(nArray[n4]); ++i) {
                int n7 = stereoMolecule.getConnAtom(nArray[n4], i);
                if (n7 == n3 || n7 == n2 || stereoMolecule.getConnBondOrder(nArray[n4], i) == 1) continue;
                stereoMolecule.setBondType(stereoMolecule.getConnBond(nArray[n4], i), 1);
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            stereoMolecule.setBondType(nArray2[n4], 1);
        }
        n4 = n6 == -1 ? 0 : n6 + 2;
        n3 = n == 5 ? 2 : 3;
        for (n2 = 0; n2 < n3; ++n2) {
            if (n4 >= n) {
                n4 -= n;
            }
            stereoMolecule.setBondType(nArray2[n4], 2);
            n4 += 2;
        }
        return true;
    }

    public void printMutationList(ArrayList<Mutation> arrayList, boolean bl) {
        Mutation[] mutationArray = arrayList.toArray(new Mutation[0]);
        if (bl) {
            Arrays.sort(mutationArray, new Comparator<Mutation>(){

                @Override
                public int compare(Mutation mutation, Mutation mutation2) {
                    return mutation.mProbability > mutation2.mProbability ? -1 : (mutation.mProbability < mutation2.mProbability ? 1 : 0);
                }
            });
        }
        System.out.println("Mutation list (" + arrayList.size() + " mutations):");
        for (Mutation mutation : mutationArray) {
            System.out.println(mutation.toString());
        }
    }

    class MutatorSubstituent {
        public int coreAtom;
        public int firstAtom;
        public int bond;
        public int[] atoms;

        public MutatorSubstituent(int n, int n2, int n3) {
            this.coreAtom = n;
            this.firstAtom = n2;
            this.bond = n3;
            boolean[] blArray = new boolean[Mutator.this.mMol.getAllAtoms()];
            int n4 = Mutator.this.mMol.getSubstituent(n, n2, blArray, null, null);
            this.atoms = new int[n4];
            int n5 = 0;
            for (int i = 0; i < Mutator.this.mMol.getAllAtoms(); ++i) {
                if (!blArray[i]) continue;
                this.atoms[n5++] = i;
            }
        }
    }
}

