/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.StereoMolecule;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Molecule3D
extends StereoMolecule
implements Comparable<Molecule3D> {
    public static final int RIGID = 1;
    public static final int LIGAND = 2;
    public static final int BACKBONE = 4;
    public static final int FLAG1 = 8;
    public static final int IMPORTANT = 16;
    public static final int PREOPTIMIZED = 32;
    public static final int ATTACHED_HYDROGEN_COUNT = 960;
    public static final int ATTACHED_HYDROGEN_COUNT_SHIFT = 6;
    public static final int INFO_DESCRIPTION = 0;
    public static final int INFO_ATOMSEQUENCE = 1;
    public static final int INFO_INTERACTION_ATOM_TYPE = 2;
    public static final int INFO_ATOMNAME = 3;
    public static final int INFO_AMINO = 4;
    public static final int INFO_PPP = 5;
    public static final int INFO_CHAINID = 6;
    public static final int INFO_BFACTOR = 7;
    public static final int INFO_RESSEQUENCE = 8;
    private static final int MAX_INFOS = 9;
    private int nMovables = -1;
    private final Map<String, Object> auxiliaryInfos = new HashMap<String, Object>();
    private int[] atomFlags;
    private Object[][] infos;
    private double[] partialCharges;

    public Molecule3D(Molecule3D molecule3D) {
        super(molecule3D);
        this.auxiliaryInfos.putAll(molecule3D.auxiliaryInfos);
        this.atomFlags = new int[molecule3D.getMaxAtoms()];
        this.partialCharges = new double[molecule3D.getMaxAtoms()];
        this.infos = new Object[molecule3D.getMaxAtoms()][9];
        for (int i = 0; i < molecule3D.getAllAtoms(); ++i) {
            this.atomFlags[i] = molecule3D.atomFlags[i];
            this.partialCharges[i] = molecule3D.partialCharges[i];
            for (int j = 0; j < 9; ++j) {
                this.infos[i][j] = molecule3D.infos[i][j];
            }
        }
    }

    public Molecule3D(StereoMolecule stereoMolecule) {
        super(stereoMolecule);
        this.atomFlags = new int[stereoMolecule.getMaxAtoms()];
        this.partialCharges = new double[stereoMolecule.getMaxAtoms()];
        this.infos = new Object[stereoMolecule.getMaxAtoms()][9];
    }

    public Molecule3D() {
        this(5, 5);
    }

    public Molecule3D(int n, int n2) {
        super(n, n2);
        this.setName("Molecule");
        this.atomFlags = new int[n];
        this.partialCharges = new double[n];
        this.infos = new Object[n][9];
    }

    @Override
    public int getOccupiedValence(int n) {
        return super.getOccupiedValence(n) + this.getAttachedHydrogenCount(n);
    }

    public int getAttachedHydrogenCount(int n) {
        return (this.atomFlags[n] & 0x3C0) >> 6;
    }

    public void setAttachedHydrogenCount(int n, int n2) {
        int n3 = n;
        this.atomFlags[n3] = this.atomFlags[n3] | n2 << 6;
    }

    public String toString() {
        return this.getName() != null ? this.getName() : "";
    }

    @Override
    public void clear() {
        super.deleteMolecule();
    }

    public final void setAtomFlag(int n, int n2, boolean bl) {
        this.nMovables = -1;
        if (bl) {
            int n3 = n;
            this.atomFlags[n3] = this.atomFlags[n3] | n2;
        } else {
            int n4 = n;
            this.atomFlags[n4] = this.atomFlags[n4] & ~n2;
        }
    }

    public final boolean isAtomFlag(int n, int n2) {
        return (this.atomFlags[n] & n2) != 0;
    }

    public final int getAtomFlags(int n) {
        return this.atomFlags[n];
    }

    public final void setAtomFlags(int n, int n2) {
        this.nMovables = -1;
        this.atomFlags[n] = n2;
    }

    public final void setAllAtomFlag(int n, boolean bl) {
        this.nMovables = -1;
        for (int i = 0; i < this.getAllAtoms(); ++i) {
            this.setAtomFlag(i, n, bl);
        }
    }

    public int fusion(Molecule3D molecule3D) {
        int n;
        if (molecule3D == this) {
            throw new IllegalArgumentException("Cannot fusion a molecule with itself");
        }
        int n2 = this.getAllAtoms();
        int[] nArray = new int[molecule3D.getAllAtoms()];
        for (n = 0; n < molecule3D.getAllAtoms(); ++n) {
            nArray[n] = this.addAtom(molecule3D, n);
        }
        for (n = 0; n < molecule3D.getAllBonds(); ++n) {
            this.addBond(nArray[molecule3D.getBondAtom(0, n)], nArray[molecule3D.getBondAtom(1, n)], molecule3D.getBondOrder(n));
        }
        return n2;
    }

    @Override
    public void setBondOrder(int n, int n2) {
        if (n2 == 1) {
            super.setBondType(n, 1);
        } else if (n2 == 2) {
            super.setBondType(n, 2);
        } else if (n2 == 3) {
            super.setBondType(n, 4);
        } else {
            System.out.println("ERROR: Unusual bond order:" + n2);
        }
    }

    public final void setAtomDescription(int n, String string) {
        this.infos[n][0] = string;
    }

    public final String getAtomDescription(int n) {
        return (String)this.infos[n][0];
    }

    public final void setPPP(int n, int[] nArray) {
        this.infos[n][5] = nArray;
    }

    public final int[] getPPP(int n) {
        return (int[])this.infos[n][5];
    }

    public final void setAtomSequence(int n, int n2) {
        this.infos[n][1] = n2;
    }

    public final void setResSequence(int n, int n2) {
        this.infos[n][8] = n2;
    }

    public final int getResSequence(int n) {
        return this.infos[n][8] == null ? -1 : (Integer)this.infos[n][8];
    }

    public final int getAtomSequence(int n) {
        return this.infos[n][1] == null ? -1 : (Integer)this.infos[n][1];
    }

    public final void setAtomChainId(int n, String string) {
        this.infos[n][6] = string;
    }

    public final String getAtomChainId(int n) {
        return (String)this.infos[n][6];
    }

    public final void setAtomName(int n, String string) {
        this.infos[n][3] = string;
    }

    public final String getAtomName(int n) {
        return (String)this.infos[n][3];
    }

    public final void setAtomAmino(int n, String string) {
        this.infos[n][4] = string;
    }

    public final String getAtomAmino(int n) {
        return (String)this.infos[n][4];
    }

    public final double getAtomBfactor(int n) {
        return (Double)this.infos[n][7];
    }

    public final void setAtomBfactor(int n, double d) {
        this.infos[n][7] = d;
    }

    @Override
    public final int getBond(int n, int n2) {
        for (int i = 0; i < this.getAllConnAtomsPlusMetalBonds(n); ++i) {
            if (this.getConnAtom(n, i) != n2) continue;
            return this.getConnBond(n, i);
        }
        return -1;
    }

    public final Coordinates[] getCoordinates() {
        Coordinates[] coordinatesArray = new Coordinates[this.getAtoms()];
        for (int i = 0; i < this.getAtoms(); ++i) {
            coordinatesArray[i] = this.getCoordinates(i);
        }
        return coordinatesArray;
    }

    public final void deleteAtoms(List<Integer> list) {
        Collections.sort(list);
        for (int i = list.size() - 1; i >= 0; --i) {
            this.deleteAtom(list.get(i));
        }
    }

    @Override
    public String getName() {
        String string = super.getName();
        return string == null ? "" : string;
    }

    public String getShortName() {
        String string = this.getName();
        if (string.indexOf(32) > 0) {
            string = string.substring(0, string.indexOf(32));
        }
        if (string.length() > 12) {
            string = string.substring(0, 12);
        }
        return string;
    }

    public Map<String, Object> getAuxiliaryInfos() {
        return this.auxiliaryInfos;
    }

    public Object getAuxiliaryInfo(String string) {
        return this.auxiliaryInfos.get(string);
    }

    public void setAuxiliaryInfo(String string, Object object) {
        if (object == null) {
            System.err.println("Attempt to set " + string + " to null");
            this.auxiliaryInfos.remove(string);
        } else {
            this.auxiliaryInfos.put(string, object);
        }
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public final void setInteractionAtomType(int n, int n2) {
        this.infos[n][2] = n2;
    }

    public final int getInteractionAtomType(int n) {
        return (Integer)this.infos[n][2];
    }

    @Override
    public void setMaxAtoms(int n) {
        super.setMaxAtoms(n);
        int n2 = this.atomFlags.length;
        this.atomFlags = Arrays.copyOf(this.atomFlags, n);
        this.partialCharges = Arrays.copyOf(this.partialCharges, n);
        this.infos = (Object[][])Arrays.copyOf(this.infos, n);
        for (int i = n2; i < n; ++i) {
            this.infos[i] = new Object[9];
        }
    }

    @Override
    public int copyAtom(Molecule molecule, int n, int n2, int n3) {
        int n4 = super.copyAtom(molecule, n, n2, n3);
        if (molecule instanceof Molecule3D) {
            if (((Molecule3D)molecule).atomFlags != null) {
                ((Molecule3D)molecule).atomFlags[n4] = this.atomFlags[n];
            }
            if (((Molecule3D)molecule).partialCharges != null) {
                ((Molecule3D)molecule).partialCharges[n4] = this.partialCharges[n];
            }
            if (((Molecule3D)molecule).infos != null) {
                ((Molecule3D)molecule).infos[n4] = new Object[9];
                for (int i = 0; i < this.infos[n].length; ++i) {
                    ((Molecule3D)molecule).infos[n4][i] = this.clone(this.infos[n][i]);
                }
            }
        }
        return n4;
    }

    private Object clone(Object object) {
        Object object2 = null;
        if (object != null) {
            if (object instanceof String) {
                object2 = new String((String)object);
            } else if (object instanceof Integer) {
                object2 = new Integer((Integer)object);
            } else if (object instanceof Double) {
                object2 = new Double((Double)object);
            } else {
                System.out.println("ERROR: unexpected Object type. Add support for new type: " + object.toString());
            }
        }
        return object2;
    }

    public void compact() {
        this.setMaxAtoms(this.getAllAtoms());
        this.setMaxBonds(this.getAllBonds());
    }

    @Override
    public void swapAtoms(int n, int n2) {
        super.swapAtoms(n, n2);
        int n3 = this.atomFlags[n];
        this.atomFlags[n] = this.atomFlags[n2];
        this.atomFlags[n2] = n3;
        double d = this.partialCharges[n];
        this.partialCharges[n] = this.partialCharges[n2];
        this.partialCharges[n2] = d;
        Object[] objectArray = this.infos[n];
        this.infos[n] = this.infos[n2];
        this.infos[n2] = objectArray;
    }

    @Override
    public int addAtom(int n) {
        if (this.mAllAtoms > this.mMaxAtoms) {
            this.setMaxAtoms(this.mMaxAtoms * 2);
        }
        int n2 = super.addAtom(n);
        this.atomFlags[n2] = 0;
        this.partialCharges[n2] = 0.0;
        this.infos[n2] = new Object[9];
        return n2;
    }

    public int addAtom(Molecule3D molecule3D, int n) {
        int n2 = this.addAtom(molecule3D.getAtomicNo(n));
        this.atomFlags[n2] = molecule3D.getAtomFlags(n);
        this.partialCharges[n2] = molecule3D.getPartialCharge(n);
        this.infos[n2] = (Object[])molecule3D.infos[n].clone();
        this.setAtomX(n, this.getAtomX(n));
        this.setAtomY(n, this.getAtomY(n));
        this.setAtomZ(n, this.getAtomZ(n));
        return n2;
    }

    @Override
    public void deleteAtom(int n) {
        super.deleteAtom(n);
        this.compressMolTable();
        this.mValidHelperArrays = 0;
    }

    @Override
    protected int[] compressMolTable() {
        int n;
        int n2;
        int n3;
        for (int i = 0; i < this.mAllBonds; ++i) {
            if (this.mBondType[i] != 512 || !(this.mAtomicNo[n3 = this.mBondAtom[0][i]] == -1 ^ this.mAtomicNo[n2 = this.mBondAtom[1][i]] == -1) || this.mAtomCharge[n3] == 0 || this.mAtomCharge[n2] == 0 || !(this.mAtomCharge[n3] < 0 ^ this.mAtomCharge[n2] < 0)) continue;
            if (this.mAtomCharge[n3] < 0) {
                int n4 = n3;
                this.mAtomCharge[n4] = this.mAtomCharge[n4] + 1;
                int n5 = n2;
                this.mAtomCharge[n5] = this.mAtomCharge[n5] - 1;
                continue;
            }
            int n6 = n3;
            this.mAtomCharge[n6] = this.mAtomCharge[n6] - 1;
            int n7 = n2;
            this.mAtomCharge[n7] = this.mAtomCharge[n7] + 1;
        }
        int[] nArray = new int[this.mAllAtoms];
        n3 = 0;
        for (n2 = 0; n2 < this.mAllAtoms; ++n2) {
            if (this.mAtomicNo[n2] == -1) {
                nArray[n2] = -1;
                continue;
            }
            if (n3 < n2) {
                this.mAtomicNo[n3] = this.mAtomicNo[n2];
                this.mAtomCharge[n3] = this.mAtomCharge[n2];
                this.mAtomMass[n3] = this.mAtomMass[n2];
                this.mAtomFlags[n3] = this.mAtomFlags[n2];
                this.mAtomQueryFeatures[n3] = this.mAtomQueryFeatures[n2];
                this.mAtomMapNo[n3] = this.mAtomMapNo[n2];
                this.mCoordinates[n3].set(this.mCoordinates[n2]);
                this.atomFlags[n3] = this.atomFlags[n2];
                if (this.infos[n3] == null) {
                    this.infos[n3] = new Object[9];
                }
                for (n = 0; n < this.infos[n2].length; ++n) {
                    this.infos[n3][n] = this.clone(this.infos[n2][n]);
                }
                this.partialCharges[n3] = this.partialCharges[n2];
                if (this.mAtomList != null) {
                    this.mAtomList[n3] = this.mAtomList[n2];
                }
                if (this.mAtomCustomLabel != null) {
                    this.mAtomCustomLabel[n3] = this.mAtomCustomLabel[n2];
                }
            }
            nArray[n2] = n3++;
        }
        this.mAllAtoms = n3;
        n2 = 0;
        for (n = 0; n < this.mAllBonds; ++n) {
            if (this.mBondType[n] == 512) continue;
            this.mBondType[n2] = this.mBondType[n];
            this.mBondFlags[n2] = this.mBondFlags[n];
            this.mBondQueryFeatures[n2] = this.mBondQueryFeatures[n];
            this.mBondAtom[0][n2] = nArray[this.mBondAtom[0][n]];
            this.mBondAtom[1][n2] = nArray[this.mBondAtom[1][n]];
            ++n2;
        }
        this.mAllBonds = n2;
        return nArray;
    }

    public boolean reorderAtoms() {
        boolean bl = false;
        int n = this.getAllAtoms();
        int n2 = 0;
        int n3 = n - 1;
        if (n == 0) {
            this.nMovables = 0;
            return false;
        }
        while (n2 < n3) {
            while (n2 < n3 && !this.isAtomFlag(n2, 1)) {
                ++n2;
            }
            while (n2 < n3 && this.isAtomFlag(n3, 1)) {
                --n3;
            }
            if (!this.isAtomFlag(n2, 1) || this.isAtomFlag(n3, 1)) continue;
            this.swapAtoms(n2, n3);
            bl = true;
        }
        this.nMovables = this.isAtomFlag(n2, 1) ? n2 : n2 + 1;
        return bl;
    }

    public void setCoordinates(int n, Coordinates coordinates) {
        this.setAtomX(n, coordinates.x);
        this.setAtomY(n, coordinates.y);
        this.setAtomZ(n, coordinates.z);
    }

    public int getNMovables() {
        if (this.nMovables < 0 || this.getAllAtoms() > 0 && !this.isAtomFlag(0, 2)) {
            this.reorderAtoms();
        }
        return this.nMovables;
    }

    public boolean isMoleculeInOrder() {
        return !this.reorderAtoms();
    }

    public double getPartialCharge(int n) {
        return this.partialCharges[n];
    }

    public void setPartialCharge(int n, double d) {
        this.partialCharges[n] = d;
    }

    @Override
    public int compareTo(Molecule3D molecule3D) {
        return molecule3D == null ? 1 : this.getName().compareTo(molecule3D.getName());
    }
}

