/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Molecule;
import com.actelion.research.chem.SmilesAtom;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.reaction.Reaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IsomericSmilesCreator {
    public static final int MODE_CREATE_SMARTS = 1;
    public static final int MODE_INCLUDE_MAPPING = 2;
    public static final int MODE_KEKULIZED_OUTPUT = 4;
    private StereoMolecule mMol;
    private Canonizer mCanonizer;
    private String mSmiles;
    private int mMode;
    private int[] mAtomRank;
    private int[] mClosureNumber;
    private int[] mSmilesIndex;
    private int[][] mKnownTHCountInESRGroup;
    private List<SmilesAtom> mGraphAtomList;
    private boolean[] mAtomUsed;
    private boolean[] mBondUsed;
    private boolean[] mPseudoStereoGroupInversion;
    private boolean[] mPseudoStereoGroupInitialized;
    private int[] mEZHalfParity;

    public static String createSmiles(StereoMolecule stereoMolecule) {
        return new IsomericSmilesCreator(stereoMolecule, 0).getSmiles();
    }

    public static String createSmarts(StereoMolecule stereoMolecule) {
        return new IsomericSmilesCreator(stereoMolecule, 1).getSmiles();
    }

    public static String createReactionSmarts(Reaction reaction) {
        return IsomericSmilesCreator.createReactionSmiles(reaction, 3);
    }

    public static String createReactionSmiles(Reaction reaction) {
        return IsomericSmilesCreator.createReactionSmiles(reaction, 2);
    }

    public static String createReactionSmiles(Reaction reaction, int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = 0; n2 < reaction.getReactants(); ++n2) {
            if (n2 != 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(new IsomericSmilesCreator(reaction.getReactant(n2), n).getSmiles());
        }
        stringBuilder.append('>');
        for (n2 = 0; n2 < reaction.getCatalysts(); ++n2) {
            if (n2 != 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(new IsomericSmilesCreator(reaction.getCatalyst(n2)).getSmiles());
        }
        stringBuilder.append('>');
        for (n2 = 0; n2 < reaction.getProducts(); ++n2) {
            if (n2 != 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(new IsomericSmilesCreator(reaction.getProduct(n2), n).getSmiles());
        }
        return stringBuilder.toString();
    }

    public IsomericSmilesCreator(StereoMolecule stereoMolecule) {
        this(stereoMolecule, false);
    }

    public IsomericSmilesCreator(StereoMolecule stereoMolecule, int n) {
        this.mMol = stereoMolecule;
        this.mMode = n;
    }

    @Deprecated
    public IsomericSmilesCreator(StereoMolecule stereoMolecule, boolean bl) {
        this(stereoMolecule, bl ? 2 : 0);
    }

    public String getSmiles() {
        if (this.mSmiles == null) {
            this.mSmiles = this.createSmiles();
        }
        return this.mSmiles;
    }

    private String createSmiles() {
        if (this.mMol == null || this.mMol.getAllAtoms() == 0) {
            return "";
        }
        this.mMol.ensureHelperArrays(15);
        this.mCanonizer = new Canonizer(this.mMol, 129);
        int n = this.mCanonizer.getPseudoStereoGroupCount();
        this.mPseudoStereoGroupInversion = new boolean[n + 1];
        this.mPseudoStereoGroupInitialized = new boolean[n + 1];
        this.mKnownTHCountInESRGroup = new int[2][32];
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            int n2 = this.mMol.getAtomESRType(i) - 1;
            if (n2 == -1) continue;
            int[] nArray = this.mKnownTHCountInESRGroup[n2];
            int n3 = this.mMol.getAtomESRGroup(i);
            nArray[n3] = nArray[n3] + 1;
        }
        this.generateCanonicalTree();
        this.findRingClosures();
        this.calculateEZBonds();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl = true;
        for (SmilesAtom smilesAtom : this.mGraphAtomList) {
            if (smilesAtom.parent == -1) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append('.');
                }
            }
            this.addAtomString(smilesAtom, stringBuilder, stringBuilder2);
        }
        return stringBuilder.toString();
    }

    private void generateCanonicalTree() {
        int n;
        this.mAtomRank = this.mCanonizer.getFinalRank();
        this.mAtomUsed = new boolean[this.mMol.getAtoms()];
        this.mBondUsed = new boolean[this.mMol.getBonds()];
        this.mGraphAtomList = new ArrayList<SmilesAtom>();
        int n2 = this.findUnusedStartAtom();
        while (n2 != -1) {
            this.addToGraph(new SmilesAtom(n2, -1, -1, false, false), n);
            if (this.mMol.getConnAtoms(n2) != 0) {
                this.addHighestRankingChain(n, false);
                for (n = this.mGraphAtomList.size(); n < this.mGraphAtomList.size() - 1; ++n) {
                    while (this.hasUnusedNeighborAtom(this.mGraphAtomList.get((int)n).atom)) {
                        this.addHighestRankingChain(n, true);
                    }
                }
            }
            n2 = this.findUnusedStartAtom();
        }
        this.mSmilesIndex = new int[this.mMol.getAtoms()];
        n = 0;
        for (SmilesAtom smilesAtom : this.mGraphAtomList) {
            this.mSmilesIndex[smilesAtom.atom] = n++;
        }
    }

    private void findRingClosures() {
        int n;
        int n2;
        for (SmilesAtom object : this.mGraphAtomList) {
            int n3 = 0;
            for (n2 = 0; n2 < this.mMol.getConnAtoms(object.atom); ++n2) {
                if (this.mBondUsed[this.mMol.getConnBond(object.atom, n2)]) continue;
                ++n3;
            }
            if (n3 == 0) continue;
            object.closureNeighbour = new int[n3];
            n3 = 0;
            for (n2 = 0; n2 < this.mMol.getConnAtoms(object.atom); ++n2) {
                if (this.mBondUsed[this.mMol.getConnBond(object.atom, n2)]) continue;
                n = this.mMol.getConnAtom(object.atom, n2);
                object.closureNeighbour[n3++] = this.mSmilesIndex[n] << 16 | n;
            }
            Arrays.sort(object.closureNeighbour);
            for (n2 = 0; n2 < object.closureNeighbour.length; ++n2) {
                object.closureNeighbour[n2] = 0xFFFF & object.closureNeighbour[n2];
            }
        }
        Object object = new boolean[this.mMol.getBonds()];
        this.mClosureNumber = new int[this.mMol.getBonds()];
        for (SmilesAtom smilesAtom : this.mGraphAtomList) {
            if (smilesAtom.closureNeighbour == null) continue;
            smilesAtom.closureOpens = new boolean[smilesAtom.closureNeighbour.length];
            for (n2 = 0; n2 < smilesAtom.closureNeighbour.length; ++n2) {
                for (n = 0; n < this.mMol.getConnAtoms(smilesAtom.atom); ++n) {
                    if (smilesAtom.closureNeighbour[n2] != this.mMol.getConnAtom(smilesAtom.atom, n)) continue;
                    int n4 = this.mMol.getConnBond(smilesAtom.atom, n);
                    if (!this.mBondUsed[n4]) {
                        this.mBondUsed[n4] = true;
                        smilesAtom.closureOpens[n2] = true;
                        this.mClosureNumber[n4] = 1;
                        while (object[this.mClosureNumber[n4]] != false) {
                            int n5 = n4;
                            this.mClosureNumber[n5] = this.mClosureNumber[n5] + 1;
                        }
                        object[this.mClosureNumber[n4]] = true;
                        continue;
                    }
                    object[this.mClosureNumber[n4]] = false;
                }
            }
        }
    }

    private void calculateEZBonds() {
        int n;
        int n2;
        int n3;
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (SmilesAtom smilesAtom : this.mGraphAtomList) {
            int n4;
            int n5;
            int n6;
            int n7;
            if (smilesAtom.parent == -1 || this.mMol.isBINAPChiralityBond(n7 = this.mMol.getBond(smilesAtom.atom, smilesAtom.parent)) || this.mMol.isSmallRingBond(n7) || this.mMol.getBondParity(n7) != 1 && this.mMol.getBondParity(n7) != 2) continue;
            SmilesAtom smilesAtom2 = this.mGraphAtomList.get(this.mSmilesIndex[smilesAtom.parent]);
            int[] nArray = new int[this.mMol.getConnAtoms(smilesAtom.atom) + this.mMol.getConnAtoms(smilesAtom2.atom) - 2];
            n3 = 0;
            int n8 = 0;
            if (smilesAtom2.parent != -1) {
                nArray[n3++] = smilesAtom2.bond;
            } else {
                n6 = -1;
                n5 = -1;
                n4 = Integer.MAX_VALUE;
                for (n2 = 0; n2 < this.mMol.getConnAtoms(smilesAtom2.atom); ++n2) {
                    n = this.mMol.getConnAtom(smilesAtom2.atom, n2);
                    if (n == smilesAtom.atom) continue;
                    if (n6 == -1) {
                        n6 = n2;
                        n4 = this.mSmilesIndex[n];
                        continue;
                    }
                    if (n4 < this.mSmilesIndex[n]) {
                        n5 = n2;
                        continue;
                    }
                    n5 = n6;
                    n6 = n2;
                }
                if (n5 == -1) {
                    n2 = this.mMol.getConnAtom(smilesAtom2.atom, n6);
                    n = this.mMol.getConnBond(smilesAtom2.atom, n6);
                    nArray[n3++] = n | (this.isBondFromTo(smilesAtom2.atom, n2) ? 0x40000000 : 0);
                } else {
                    n2 = this.mMol.getConnAtom(smilesAtom2.atom, n6);
                    n = this.mMol.getConnBond(smilesAtom2.atom, n6);
                    int n9 = this.mMol.getConnAtom(smilesAtom2.atom, n5);
                    int n10 = this.mMol.getConnBond(smilesAtom2.atom, n5);
                    nArray[n3++] = n | (this.isBondFromTo(smilesAtom2.atom, n2) ? 0x40000000 : 0);
                    nArray[n3++] = n10 | (this.isBondFromTo(smilesAtom2.atom, n9) ? 0 : 0x40000000);
                }
            }
            if (this.mMol.getConnAtoms(smilesAtom2.atom) == 3 && smilesAtom2.parent != -1) {
                for (n6 = 0; n6 < this.mMol.getConnAtoms(smilesAtom2.atom); ++n6) {
                    n5 = this.mMol.getConnAtom(smilesAtom2.atom, n6);
                    if (n5 == smilesAtom2.parent || n5 == smilesAtom.atom) continue;
                    n4 = this.mMol.getConnBond(smilesAtom2.atom, n6);
                    nArray[n3++] = n4 | (this.isBondFromTo(smilesAtom2.atom, n5) ? 0x40000000 : 0);
                    if (n5 >= smilesAtom2.parent) break;
                    n8 = n8 == 0 ? 1 : 0;
                    break;
                }
            }
            if (this.mMol.getBondParity(n7) == 2) {
                n8 = n8 == 0 ? 1 : 0;
            }
            for (n6 = 0; n6 < this.mMol.getConnAtoms(smilesAtom.atom); ++n6) {
                n5 = this.mMol.getConnAtom(smilesAtom.atom, n6);
                if (n5 == smilesAtom.parent) continue;
                n4 = n8;
                if (this.mMol.getConnAtoms(smilesAtom.atom) == 3) {
                    for (n2 = 0; n2 < this.mMol.getConnAtoms(smilesAtom.atom); ++n2) {
                        n = this.mMol.getConnAtom(smilesAtom.atom, n2);
                        if (n == smilesAtom.parent || n == n5) continue;
                        if (n >= n5) break;
                        n4 = n4 == 0 ? 1 : 0;
                        break;
                    }
                }
                if (this.mMol.isBondParityPseudo(n7)) {
                    n2 = this.mCanonizer.getPseudoEZGroup(n7);
                    if (!this.mPseudoStereoGroupInitialized[n2]) {
                        this.mPseudoStereoGroupInitialized[n2] = true;
                        this.mPseudoStereoGroupInversion[n2] = n4;
                    }
                    if (this.mPseudoStereoGroupInversion[n2]) {
                        n4 = n4 == 0 ? 1 : 0;
                    }
                }
                n2 = this.mMol.getBond(smilesAtom.atom, n5);
                nArray[n3++] = n2 | ((n4 ^ this.isBondFromTo(smilesAtom.atom, n5)) != 0 ? 0 : 0x40000000);
            }
            arrayList.add(nArray);
        }
        this.mEZHalfParity = new int[this.mMol.getBonds()];
        if (arrayList.size() != 0) {
            this.addRelativeBondHalfParities((int[])arrayList.remove(0), false);
        }
        while (arrayList.size() != 0) {
            int n11 = arrayList.size();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                int[] nArray = (int[])arrayList.get(i);
                int n12 = 0;
                int n13 = 0;
                n3 = 0;
                for (int n4 : nArray) {
                    n2 = n4 & 0x3FFFFFFF;
                    if (this.mEZHalfParity[n2] == 0) continue;
                    n = ((n4 & 0x40000000) != 0 ? 1 : 0) ^ (this.mEZHalfParity[n2] == 2 ? 1 : 0);
                    if (n12 == 0) {
                        n13 = n;
                    } else if (n13 != n) {
                        n3 = 1;
                    }
                    ++n12;
                }
                if (n12 == 0) continue;
                nArray = (int[])arrayList.remove(i);
                if (n3 != 0) continue;
                this.addRelativeBondHalfParities(nArray, n13 != 0);
            }
            if (n11 != arrayList.size()) continue;
            this.addRelativeBondHalfParities((int[])arrayList.remove(0), false);
        }
    }

    private void addRelativeBondHalfParities(int[] nArray, boolean bl) {
        for (int n : nArray) {
            this.mEZHalfParity[n & 0x3FFFFFFF] = (n & 0x40000000) != 0 ^ bl ? 2 : 1;
        }
    }

    private boolean isBondFromTo(int n, int n2) {
        SmilesAtom smilesAtom = this.mGraphAtomList.get(this.mSmilesIndex[n]);
        if (smilesAtom.parent == n2) {
            return false;
        }
        SmilesAtom smilesAtom2 = this.mGraphAtomList.get(this.mSmilesIndex[n2]);
        if (smilesAtom2.parent == n) {
            return true;
        }
        return smilesAtom2.isOpeningClosureTo(n);
    }

    private int findUnusedStartAtom() {
        int n = -1;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (this.mAtomUsed[i]) continue;
            int n3 = this.mAtomRank[i];
            if ((this.mMol.getAtomQueryFeatures(i) & 0x20000000L) != 0L) {
                n3 += 0x40000000;
            }
            n3 = this.mMol.getConnAtoms(i) == 0 ? (n3 += 0x3F000000) : (n3 += this.mMol.getConnAtoms(i) << 24);
            if (n2 <= n3) continue;
            n2 = n3;
            n = i;
        }
        return n;
    }

    private boolean hasUnusedNeighborAtom(int n) {
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            if (this.mAtomUsed[this.mMol.getConnAtom(n, i)]) continue;
            return true;
        }
        return false;
    }

    private void addHighestRankingChain(int n, boolean bl) {
        boolean bl2 = true;
        int n2 = this.mGraphAtomList.get((int)n).atom;
        int n3 = this.getUnusedConnAtomIndex(n2);
        while (n3 != -1) {
            int n4 = this.mMol.getConnAtom(n2, n3);
            int n5 = this.mMol.getConnBond(n2, n3);
            n3 = this.getUnusedConnAtomIndex(n4);
            this.addToGraph(new SmilesAtom(n4, n5, n2, bl && bl2, bl && n3 == -1), ++n);
            n2 = n4;
            bl2 = false;
        }
    }

    private int getUnusedConnAtomIndex(int n) {
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
            int n4 = this.mMol.getConnAtom(n, i);
            int n5 = (this.mMol.getConnBondOrder(n, i) << 24) + this.mAtomRank[n4];
            if (this.mAtomUsed[n4] || n2 != -1 && n3 >= n5) continue;
            n2 = i;
            n3 = n5;
        }
        return n2;
    }

    private void addToGraph(SmilesAtom smilesAtom, int n) {
        this.mGraphAtomList.add(n, smilesAtom);
        this.mAtomUsed[smilesAtom.atom] = true;
        if (smilesAtom.parent != -1) {
            this.mBondUsed[this.mMol.getBond((int)smilesAtom.atom, (int)smilesAtom.parent)] = true;
        }
    }

    private void addAtomString(SmilesAtom smilesAtom, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        boolean bl;
        int n;
        String string;
        int n2 = smilesAtom.atom;
        int n3 = smilesAtom.parent;
        boolean bl2 = (this.mMol.getAtomQueryFeatures(n2) & 1L) != 0L;
        int[] nArray = this.mMol.getAtomList(n2);
        String string2 = nArray != null ? this.createMultiAtomLabel(n2, nArray, stringBuilder2) : (string = bl2 ? "*" : this.mMol.getAtomLabel(n2));
        if (!bl2 && nArray == null && this.mMol.isAromaticAtom(n2) && (this.mMode & 4) == 0 && (this.mMol.getAtomPi(n2) != 0 || this.mMol.getAtomAbnormalValence(n2) == -1 && this.mMol.getAtomRadical(n2) == 0)) {
            string = string.toLowerCase();
        }
        if (smilesAtom.isSideChainStart) {
            stringBuilder.append('(');
        }
        if (n3 != -1) {
            this.appendBondOrderSymbol(this.mMol.getBond(smilesAtom.atom, smilesAtom.parent), smilesAtom.parent, stringBuilder);
        }
        if ((n = this.mMol.getAtomCharge(n2)) == 0 && (this.mMode & 1) != 0) {
            long l = this.mMol.getAtomQueryFeatures(n2) & 0xE000000L;
            if (l == 0xC000000L) {
                n = -1;
            } else if (l == 0x6000000L) {
                n = 1;
            }
        }
        int n4 = this.mMol.getAtomMass(n2);
        int n5 = (this.mMode & 2) != 0 ? this.mMol.getAtomMapNo(n2) : 0;
        String string3 = (this.mMode & 1) != 0 ? this.getAtomSMARTSFeatures(n2, stringBuilder2) : null;
        boolean bl3 = bl = !bl2 && !this.isOrganic(this.mMol.getAtomicNo(n2)) || nArray != null || this.qualifiesForAtomParity(n2) || this.mMol.isAromaticAtom(n2) && this.mMol.getAtomPi(n2) == 0 && (this.mMode & 4) == 0 || n != 0 || n4 != 0 || n5 != 0 || this.mMol.getAtomAbnormalValence(n2) != -1 || this.mMol.getAtomRadical(n2) != 0 || string3 != null;
        if (bl) {
            stringBuilder.append('[');
        }
        if (n4 != 0) {
            stringBuilder.append(n4);
        }
        stringBuilder.append(string);
        if (this.qualifiesForAtomParity(n2)) {
            stringBuilder.append(this.getAtomParitySymbol(n2, n3));
        }
        if ((this.mMode & 1) == 0 && bl) {
            int n6 = this.mMol.getPlainHydrogens(n2);
            if (n6 == 1) {
                stringBuilder.append("H");
            } else if (n6 > 1) {
                stringBuilder.append("H" + n6);
            }
        }
        if (n != 0) {
            stringBuilder.append(n > 0 ? (char)'+' : '-');
            if (Math.abs(n) > 1) {
                stringBuilder.append(Math.abs(n));
            }
        }
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        if (n5 != 0) {
            stringBuilder.append(':');
            stringBuilder.append(n5);
        }
        if (bl) {
            stringBuilder.append(']');
        }
        this.appendClosureBonds(smilesAtom, stringBuilder);
        if (smilesAtom.isSideChainEnd) {
            stringBuilder.append(')');
        }
    }

    private String createMultiAtomLabel(int n, int[] nArray, StringBuilder stringBuilder) {
        stringBuilder.setLength(0);
        boolean bl = this.mMol.isAromaticAtom(n) && (this.mMode & 4) == 0;
        for (int n2 : nArray) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(',');
            }
            String string = Molecule.cAtomLabel[n2];
            stringBuilder.append(bl ? string.toLowerCase() : string);
        }
        return stringBuilder.toString();
    }

    private String getAtomSMARTSFeatures(int n, StringBuilder stringBuilder) {
        long l;
        long l2;
        stringBuilder.setLength(0);
        long l3 = this.mMol.getAtomQueryFeatures(n);
        int n2 = (int)((l3 & 0xE000000L) >> 3);
        switch (n2) {
            case 0x1400000: {
                stringBuilder.append("+0");
                break;
            }
            case 0x1800000: {
                if (this.mMol.getAtomCharge(n) != 0) break;
                stringBuilder.append("-");
                break;
            }
            case 0xC00000: {
                if (this.mMol.getAtomCharge(n) != 0) break;
                stringBuilder.append("+");
            }
        }
        long l4 = l3 & 0x400000000006L;
        if (l4 == 2L) {
            stringBuilder.append(";a");
        } else if (l4 == 4L) {
            stringBuilder.append(";A");
        }
        long l5 = l3 & 0x780L;
        if (l5 != 0L) {
            if (l5 == 1792L) {
                stringBuilder.append(";H0");
            } else if (l5 == 1664L) {
                stringBuilder.append(";H1");
            } else if (l5 == 1408L) {
                stringBuilder.append(";H2");
            } else if (l5 == 896L) {
                stringBuilder.append(";H3");
            } else if (l5 == 128L) {
                stringBuilder.append(";!H0");
            } else if (l5 == 384L) {
                stringBuilder.append(";!H0;!H1");
            } else if (l5 == 1536L) {
                stringBuilder.append(";!H2;!H3");
            } else if (l5 == 1024L) {
                stringBuilder.append(";!H3");
            }
        }
        if ((l2 = l3 & 0x78L) == 8L) {
            stringBuilder.append(";!R0");
        } else if (l2 == 16L) {
            stringBuilder.append(";!R1");
        } else if (l2 == 32L) {
            stringBuilder.append(";!R2");
        } else if (l2 == 64L) {
            stringBuilder.append(";!R3");
        } else if (l2 == 112L) {
            stringBuilder.append(";R0");
        } else if (l2 == 104L) {
            stringBuilder.append(";R1");
        } else if (l2 == 88L) {
            stringBuilder.append(";R2");
        } else if (l2 == 56L) {
            stringBuilder.append(";R3");
        }
        long l6 = l3 & 0x7F00000000L;
        if (l6 == 0x100000000L) {
            stringBuilder.append(";!r" + l6);
        } else if (l6 == 0x7E00000000L) {
            stringBuilder.append(";r" + l6);
        } else if (l6 != 0L) {
            if ((l6 & 0x4000000000L) != 0L) {
                if ((l6 & 0x100000000L) == 0L) {
                    stringBuilder.append(";!r0" + l6);
                }
                if ((l6 & 0x200000000L) == 0L) {
                    stringBuilder.append(";!r3" + l6);
                }
                if ((l6 & 0x400000000L) == 0L) {
                    stringBuilder.append(";!r4" + l6);
                }
                if ((l6 & 0x800000000L) == 0L) {
                    stringBuilder.append(";!r5" + l6);
                }
                if ((l6 & 0x1000000000L) == 0L) {
                    stringBuilder.append(";!r6" + l6);
                }
                if ((l6 & 0x2000000000L) == 0L) {
                    stringBuilder.append(";!r7" + l6);
                }
            } else {
                stringBuilder.append(";");
                if ((l6 & 0x100000000L) != 0L) {
                    stringBuilder.append("r0," + l6);
                }
                if ((l6 & 0x200000000L) != 0L) {
                    stringBuilder.append("r3," + l6);
                }
                if ((l6 & 0x400000000L) != 0L) {
                    stringBuilder.append("r4," + l6);
                }
                if ((l6 & 0x800000000L) != 0L) {
                    stringBuilder.append("r5," + l6);
                }
                if ((l6 & 0x1000000000L) != 0L) {
                    stringBuilder.append("r6," + l6);
                }
                if ((l6 & 0x2000000000L) != 0L) {
                    stringBuilder.append("r7," + l6);
                }
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
        }
        if (l6 == 0L && (l6 = (l3 & 0x1C00000L) >> 22) != 0L) {
            stringBuilder.append(";r" + l6);
        }
        if ((l = l3 & 0x3E0000L) == 0x3A0000L) {
            stringBuilder.append(";D1");
        }
        if (l == 0x360000L) {
            stringBuilder.append(";D2");
        }
        if (l == 0x2E0000L) {
            stringBuilder.append(";D3");
        }
        if (l == 0x300000L) {
            stringBuilder.append(";!D3;!D4");
        }
        if (l == 0x200000L) {
            stringBuilder.append(";!D4");
        }
        if (l == 393216L) {
            stringBuilder.append(";!D0;!D1");
        }
        if (l == 917504L) {
            stringBuilder.append(";!D0;!D1;!D2");
        }
        if (l == 0x1E0000L) {
            stringBuilder.append(";!D0;!D1;!D2;!D3");
        }
        if ((l3 & 0x800L) != 0L) {
            stringBuilder.append(";D" + this.mMol.getConnAtoms(n));
        }
        if ((l3 & 0x1000L) != 0L) {
            stringBuilder.append(";!D" + this.mMol.getConnAtoms(n));
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    private boolean qualifiesForAtomParity(int n) {
        return !(this.mMol.getAtomParity(n) != 1 && this.mMol.getAtomParity(n) != 2 || this.isSingleKnownStereoCenterInESRGroup(n) || this.mMol.getAtomicNo(n) == 7 && this.mMol.getAtomCharge(n) <= 0);
    }

    private boolean isSingleKnownStereoCenterInESRGroup(int n) {
        int n2 = this.mMol.getAtomESRType(n) - 1;
        return n2 == -1 ? false : this.mKnownTHCountInESRGroup[n2][this.mMol.getAtomESRGroup(n)] <= 1;
    }

    private void appendClosureBonds(SmilesAtom smilesAtom, StringBuilder stringBuilder) {
        if (smilesAtom.closureNeighbour != null) {
            for (int i = 0; i < smilesAtom.closureNeighbour.length; ++i) {
                for (int j = 0; j < this.mMol.getConnAtoms(smilesAtom.atom); ++j) {
                    if (smilesAtom.closureNeighbour[i] != this.mMol.getConnAtom(smilesAtom.atom, j)) continue;
                    int n = this.mMol.getConnBond(smilesAtom.atom, j);
                    if (!smilesAtom.closureOpens[i]) {
                        this.appendBondOrderSymbol(n, smilesAtom.atom, stringBuilder);
                    }
                    if (this.mClosureNumber[n] > 9) {
                        stringBuilder.append('%');
                    }
                    stringBuilder.append(this.mClosureNumber[n]);
                }
            }
        }
    }

    private void appendBondOrderSymbol(int n, int n2, StringBuilder stringBuilder) {
        int n3;
        int n4 = stringBuilder.length();
        if (this.mEZHalfParity[n] != 0) {
            stringBuilder.append(this.mEZHalfParity[n] == 1 ? (char)'/' : '\\');
        }
        if (this.mMode == 1 && (n3 = this.mMol.getBondQueryFeatures(127)) != 0) {
            if ((n3 & 1) != 0 && this.mEZHalfParity[n] == 0) {
                stringBuilder.append('-');
            }
            if ((n3 & 2) != 0) {
                if (stringBuilder.length() != n4) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('=');
            }
            if ((n3 & 4) != 0) {
                if (stringBuilder.length() != n4) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('#');
            }
            if ((n3 & 8) != 0) {
                if (stringBuilder.length() != n4) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('$');
            }
            if ((n3 & 0x10) != 0) {
                if (stringBuilder.length() != n4) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('$');
            }
            if ((n3 & 0x40) != 0) {
                if (stringBuilder.length() != n4) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(':');
            }
            if ((n3 & 0x20) != 0) {
                if (stringBuilder.length() != n4) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.mMol.isMetalAtom(n2) ? "<-" : "->");
            }
        }
        if (!(n4 != stringBuilder.length() || this.mMol.isAromaticBond(n) && (this.mMode & 4) == 0)) {
            n3 = this.mMol.getBondType(n) & 0x7F;
            if (n3 == 1) {
                if (this.mMol.isAromaticAtom(this.mMol.getBondAtom(0, n)) && this.mMol.isAromaticAtom(this.mMol.getBondAtom(1, n)) && (this.mMode & 4) == 0 && this.mEZHalfParity[n] == 0) {
                    stringBuilder.append('-');
                }
            } else if (n3 == 2) {
                stringBuilder.append('=');
            } else if (n3 == 4) {
                stringBuilder.append('#');
            } else if (n3 == 8) {
                stringBuilder.append('$');
            } else if (n3 == 16) {
                stringBuilder.append('$');
            } else if (n3 == 64) {
                stringBuilder.append(':');
            } else if (n3 == 32) {
                stringBuilder.append(this.mMol.isMetalAtom(n2) ? "<-" : "->");
            }
        }
        if (this.mMode == 1) {
            String string = n4 == stringBuilder.length() ? "" : ";";
            int n5 = this.mMol.getBondQueryFeatures(n) & 0x180;
            if (n5 == 256) {
                stringBuilder.append(string + "@");
            } else if (n5 == 128) {
                stringBuilder.append(string + "!@");
            }
        }
    }

    private String getAtomParitySymbol(int n, int n2) {
        int n3;
        int n4 = 0;
        if (this.mMol.getAtomPi(n) != 0 && this.mMol.getConnAtoms(n) == 2 && this.mMol.getConnBondOrder(n, 0) == 2 && this.mMol.getConnBondOrder(n, 1) == 2) {
            for (n3 = 0; n3 < this.mMol.getConnAtoms(n); ++n3) {
                int n5 = this.mMol.getConnAtom(n, n3);
                int n6 = 0;
                int[] nArray = new int[3];
                for (int i = 0; i < this.mMol.getConnAtoms(n5); ++i) {
                    nArray[n6] = this.mMol.getConnAtom(n5, i);
                    if (nArray[n6] == n) continue;
                    ++n6;
                }
                if (n6 != 2 || !(this.mSmilesIndex[nArray[0]] < this.mSmilesIndex[nArray[1]] ^ nArray[0] < nArray[1])) continue;
                n4 = n4 == 0 ? 1 : 0;
            }
        } else {
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            int n7 = 0;
            if (n2 != -1) {
                nArray[n7] = n2;
                nArray2[n7++] = 8 * this.mSmilesIndex[n2];
            }
            if (this.mMol.getImplicitHydrogens(n) != 0) {
                nArray[n7] = Integer.MAX_VALUE;
                nArray2[n7++] = 8 * this.mSmilesIndex[n];
            } else if (this.mMol.getConnAtoms(n) == 3) {
                nArray[n7] = Integer.MAX_VALUE;
                nArray2[n7++] = 8 * this.mSmilesIndex[n];
            }
            for (int i = 0; i < this.mMol.getConnAtoms(n); ++i) {
                int n8 = this.mMol.getConnAtom(n, i);
                if (n8 == n2) continue;
                nArray[n7] = n8;
                nArray2[n7++] = this.getSmilesRank(n, i);
            }
            n4 = this.isInverseOrder(nArray, nArray2);
        }
        n3 = (this.mMol.getAtomParity(n) == 1 ? 1 : 0) ^ n4;
        if (this.mMol.isAtomParityPseudo(n)) {
            int n9 = this.mCanonizer.getPseudoTHGroup(n);
            if (!this.mPseudoStereoGroupInitialized[n9]) {
                this.mPseudoStereoGroupInitialized[n9] = true;
                this.mPseudoStereoGroupInversion[n9] = n3;
            }
            if (this.mPseudoStereoGroupInversion[n9]) {
                n3 = n3 == 0 ? 1 : 0;
            }
        }
        return n3 != 0 ? "@@" : "@";
    }

    private boolean isInverseOrder(int[] nArray, int[] nArray2) {
        boolean bl = false;
        for (int i = 1; i < 4; ++i) {
            for (int j = 0; j < i; ++j) {
                if (nArray[j] > nArray[i]) {
                    boolean bl2 = bl = !bl;
                }
                if (nArray2[j] <= nArray2[i]) continue;
                bl = !bl;
            }
        }
        return bl;
    }

    private int getSmilesRank(int n, int n2) {
        int n3 = this.mMol.getConnBond(n, n2);
        int n4 = this.mMol.getConnAtom(n, n2);
        if (this.mClosureNumber[n3] != 0) {
            int n5 = 8 * this.mSmilesIndex[n] + 1;
            int[] nArray = this.mGraphAtomList.get((int)this.mSmilesIndex[n]).closureNeighbour;
            for (int i = 0; i < nArray.length && n4 != nArray[i]; ++i) {
                ++n5;
            }
            return n5;
        }
        return 8 * this.mSmilesIndex[n4];
    }

    private boolean isOrganic(int n) {
        return n >= 5 && n <= 9 || n >= 15 && n <= 17 || n == 35 || n == 53;
    }
}

