/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.chem;

import com.actelion.research.chem.CanonizerRankListComparator;
import com.actelion.research.chem.ESRGroupNormalizationInfo;
import com.actelion.research.chem.ExtendedMolecule;
import com.actelion.research.chem.MesoFragmentBranch;
import com.actelion.research.chem.MesoFragmentMembers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;

public class CanonizerMesoHelper {
    private static final int REMOVE_ESR_GROUP = 1;
    private static final int SWAP_ESR_GROUPS = 2;
    private ExtendedMolecule mMol;
    private int[] mCanRankWithoutStereo;
    private byte[] mTHParity;
    private byte[] mEZParity;
    private byte[] mTHESRType;
    private byte[] mTHESRGroup;
    private int[][] mMesoFragmentAtom;
    private boolean[] mIsStereoCenter;
    private boolean[] mIsMesoFragmentMember;
    private boolean[] mTHParityRoundIsOdd;
    private boolean[] mEZParityRoundIsOdd;
    private boolean[] mTHESRTypeNeedsNormalization;
    private ArrayList<ESRGroupNormalizationInfo> mESRGroupNormalizationInfoList;

    protected CanonizerMesoHelper(ExtendedMolecule extendedMolecule, int[] nArray, boolean[] blArray, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6, boolean[] blArray2, boolean[] blArray3, boolean[] blArray4) {
        this.mMol = extendedMolecule;
        this.mCanRankWithoutStereo = nArray;
        this.mIsStereoCenter = blArray;
        this.mTHParity = byArray;
        this.mEZParity = byArray2;
        this.mTHESRType = byArray3;
        this.mTHESRGroup = byArray4;
        this.mTHParityRoundIsOdd = blArray2;
        this.mEZParityRoundIsOdd = blArray3;
        this.mTHESRTypeNeedsNormalization = blArray4;
        this.findMesoFragments();
    }

    protected boolean isMeso() {
        boolean bl = true;
        for (int i = 0; i < this.mMol.getAtoms(); ++i) {
            if (this.mTHParity[i] == 0 || this.mIsMesoFragmentMember[i]) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected boolean isInMesoFragment(int n) {
        return this.mIsMesoFragmentMember[n];
    }

    private boolean mayBeMirrorAtoms(int n, int n2) {
        int n3;
        if (n == n2) {
            return false;
        }
        if (this.mCanRankWithoutStereo[n] != this.mCanRankWithoutStereo[n2]) {
            return false;
        }
        if (this.mTHParity[n] != 0) {
            if (this.mTHParity[n] == 3 || this.mTHParity[n2] == 3) {
                return false;
            }
            if (this.mTHParityRoundIsOdd[n] ^ this.mTHParity[n] != this.mTHParity[n2]) {
                return false;
            }
            if (this.mTHESRType[n] != this.mTHESRType[n2] || this.mTHESRGroup[n] != this.mTHESRGroup[n2]) {
                return false;
            }
        }
        if ((n3 = this.mMol.getBond(n, n2)) != -1) {
            if (this.mMol.getBondOrder(n3) == 1 && this.mEZParity[n3] != 0) {
                return false;
            }
            if (this.mMol.getBondOrder(n3) == 2 && this.mEZParity[n3] == 1) {
                return false;
            }
        }
        if (this.mMol.getAtomPi(n) == 1 && !this.mMol.isAromaticAtom(n)) {
            int n4;
            int n5 = -1;
            for (n4 = 0; n4 < this.mMol.getConnAtoms(n); ++n4) {
                if (this.mMol.getConnAtom(n, n4) == n2 || this.mMol.getConnBondOrder(n, n4) != 2) continue;
                n5 = this.mMol.getConnBond(n, n4);
                break;
            }
            n4 = -1;
            for (int i = 0; i < this.mMol.getConnAtoms(n2); ++i) {
                if (this.mMol.getConnAtom(n2, i) == n || this.mMol.getConnBondOrder(n2, i) != 2) continue;
                n4 = this.mMol.getConnBond(n2, i);
                break;
            }
            if (n5 != -1 && this.mEZParity[n5] != 0 && this.mEZParityRoundIsOdd[n5] ^ this.mEZParity[n5] == this.mEZParity[n4]) {
                return false;
            }
        }
        return true;
    }

    private void findMesoFragments() {
        int n;
        int n2;
        int n3;
        int n4;
        TreeSet<MesoFragmentMembers> treeSet = new TreeSet<MesoFragmentMembers>();
        for (n4 = 0; n4 < this.mMol.getAtoms(); ++n4) {
            if (this.mMol.getAtomPi(n4) >= 2 && this.mMol.getConnAtoms(n4) <= 2) continue;
            for (n3 = 1; n3 < this.mMol.getConnAtoms(n4); ++n3) {
                n2 = this.mMol.getConnAtom(n4, n3);
                for (n = 0; n < n3; ++n) {
                    int n5 = this.mMol.getConnAtom(n4, n);
                    if (!this.mayBeMirrorAtoms(n2, n5)) continue;
                    this.tryAddNewMesoFragment(n2, n5, treeSet);
                }
            }
        }
        for (n4 = 0; n4 < this.mMol.getBonds(); ++n4) {
            if (this.mEZParity[n4] != 0 && (this.mMol.getBondOrder(n4) != 2 || this.mEZParity[n4] != 2) || !this.mayBeMirrorAtoms(n3 = this.mMol.getBondAtom(0, n4), n2 = this.mMol.getBondAtom(1, n4))) continue;
            this.tryAddNewMesoFragment(n3, n2, treeSet);
        }
        this.mMesoFragmentAtom = new int[treeSet.size()][];
        this.mIsMesoFragmentMember = new boolean[this.mMol.getAtoms()];
        n4 = 0;
        for (MesoFragmentMembers mesoFragmentMembers : treeSet) {
            this.mMesoFragmentAtom[n4++] = mesoFragmentMembers.memberAtom;
            for (n = 0; n < mesoFragmentMembers.memberAtom.length; ++n) {
                this.mIsMesoFragmentMember[mesoFragmentMembers.memberAtom[n]] = true;
            }
        }
    }

    private void tryAddNewMesoFragment(int n, int n2, TreeSet<MesoFragmentMembers> treeSet) {
        MesoFragmentMembers mesoFragmentMembers = this.tryFindMesoFragment(n, n2);
        if (mesoFragmentMembers != null && mesoFragmentMembers.hasStereoCenters(this.mIsStereoCenter)) {
            treeSet.add(mesoFragmentMembers);
        }
    }

    private MesoFragmentMembers tryFindMesoFragment(int n, int n2) {
        int[] nArray = new int[this.mMol.getAtoms()];
        int[] nArray2 = new int[this.mMol.getAtoms()];
        boolean[] blArray = new boolean[this.mMol.getAtoms()];
        boolean[] blArray2 = new boolean[this.mMol.getAtoms()];
        MesoFragmentBranch[] mesoFragmentBranchArray = new MesoFragmentBranch[this.mMol.getAtoms()];
        MesoFragmentMembers mesoFragmentMembers = new MesoFragmentMembers(this.mMol.getAtoms());
        nArray[0] = n;
        nArray2[n] = n2;
        nArray2[n2] = -2;
        mesoFragmentMembers.add(n);
        mesoFragmentMembers.add(n2);
        int n3 = 0;
        for (int i = 0; i <= n3; ++i) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = nArray[i];
            if (nArray2[n8] == n8) {
                for (int j = 0; j < this.mMol.getConnAtoms(n8); ++j) {
                    int n9 = this.mMol.getConnAtom(n8, j);
                    if (mesoFragmentMembers.isMember[n9]) continue;
                    if (this.mMol.getConnBondOrder(n8, j) == 2 && this.mMol.getAtomicNo(n9) < 10) {
                        nArray[++n3] = n9;
                        nArray2[n9] = n9;
                        boolean bl = blArray2[n9] = blArray2[n8] || this.mMol.getAtomPi(n9) == 2;
                        blArray[n9] = blArray2[n8] ? !blArray[n8] : false;
                        mesoFragmentMembers.add(n9);
                        continue;
                    }
                    if (blArray2[n8] && blArray[n8]) {
                        n7 = this.findMirrorAtom(n9, nArray2[n8], mesoFragmentMembers.isMember);
                        if (n7 == -1) {
                            return null;
                        }
                        nArray[++n3] = n9;
                        nArray2[n9] = n7;
                        nArray2[n7] = -2;
                        blArray2[n9] = false;
                        mesoFragmentMembers.add(n9);
                        mesoFragmentMembers.add(n7);
                        continue;
                    }
                    if (!this.mMol.isRingBond(this.mMol.getConnBond(n8, j))) continue;
                    nArray[++n3] = n9;
                    nArray2[n9] = n9;
                    blArray2[n9] = false;
                    mesoFragmentMembers.add(n9);
                    if (!this.isTetrahedral(n9) || this.mMol.getConnAtoms(n9) <= 2) continue;
                    n7 = 0;
                    for (n6 = 1; n6 < this.mMol.getConnAtoms(n9); ++n6) {
                        n5 = this.mMol.getConnAtom(n9, n6);
                        if (mesoFragmentMembers.isMember[n5]) continue;
                        for (int k = 0; k < n6; ++k) {
                            int n10 = this.mMol.getConnAtom(n9, k);
                            if (mesoFragmentMembers.isMember[n10] || !this.mayBeMirrorAtoms(n5, n10)) continue;
                            nArray[++n3] = n5;
                            nArray2[n5] = n10;
                            nArray2[n10] = -2;
                            blArray2[n5] = false;
                            mesoFragmentMembers.add(n5);
                            mesoFragmentMembers.add(n10);
                            n7 = 1;
                        }
                    }
                    if (n7 != 0) continue;
                    return null;
                }
                continue;
            }
            boolean[] blArray3 = new boolean[this.mMol.getConnAtoms(n8)];
            block4: for (n4 = 0; n4 < this.mMol.getConnAtoms(n8); ++n4) {
                n7 = this.mMol.getConnAtom(n8, n4);
                if (mesoFragmentMembers.isMember[n7]) {
                    blArray3[n4] = nArray2[n7] == n7;
                    continue;
                }
                for (n6 = 0; n6 < this.mMol.getConnAtoms(n7); ++n6) {
                    if (this.mMol.getConnAtom(n7, n6) != nArray2[n8]) continue;
                    blArray3[n4] = true;
                    continue block4;
                }
            }
            for (n4 = 0; n4 < this.mMol.getConnAtoms(n8); ++n4) {
                if (!blArray3[n4]) continue;
                n7 = this.mMol.getConnAtom(n8, n4);
                if (mesoFragmentMembers.isMember[n7]) {
                    if (this.mMol.getBond(n7, nArray2[n8]) != -1) continue;
                    return null;
                }
                nArray[++n3] = n7;
                nArray2[n7] = n7;
                blArray[n7] = false;
                blArray2[n7] = true;
                mesoFragmentMembers.add(n7);
            }
            MesoFragmentBranch mesoFragmentBranch = mesoFragmentBranchArray[n8];
            int n11 = n7 = mesoFragmentBranch == null ? 0 : mesoFragmentBranch.neighbourIndex;
            while (n7 < this.mMol.getConnAtoms(n8)) {
                if (!blArray3[n7] && !mesoFragmentMembers.isMember[n6 = this.mMol.getConnAtom(n8, n7)]) {
                    n5 = this.findMirrorAtom(n6, nArray2[n8], mesoFragmentMembers.isMember);
                    if (n5 == -1) {
                        return null;
                    }
                    nArray[++n3] = n6;
                    nArray2[n6] = n5;
                    nArray2[n5] = -2;
                    blArray2[n6] = false;
                    mesoFragmentMembers.add(n6);
                    mesoFragmentMembers.add(n5);
                }
                ++n7;
            }
        }
        return mesoFragmentMembers;
    }

    private boolean isTetrahedral(int n) {
        return this.mMol.getAtomicNo(n) == 6 && this.mMol.getAtomPi(n) == 0 || this.mMol.getAtomicNo(n) == 7 && this.mMol.getAtomCharge(n) == 1 || this.mMol.getAtomicNo(n) == 14 || this.mMol.getAtomicNo(n) == 15 && this.mMol.getConnAtoms(n) > 2 || this.mMol.getAtomicNo(n) == 16 && this.mMol.getConnAtoms(n) > 2;
    }

    private int findMirrorAtom(int n, int n2, boolean[] blArray) {
        int n3;
        int[] nArray = new int[this.mMol.getConnAtoms(n2)];
        int n4 = 0;
        for (n3 = 0; n3 < this.mMol.getConnAtoms(n2); ++n3) {
            nArray[n4] = this.mMol.getConnAtom(n2, n3);
            if (blArray[nArray[n4]] || !this.mayBeMirrorAtoms(n, nArray[n4])) continue;
            ++n4;
        }
        if (n4 == 0) {
            return -1;
        }
        if (n4 == 1) {
            return nArray[0];
        }
        n3 = -1;
        int n5 = Integer.MAX_VALUE;
        for (int i = 0; i < n4; ++i) {
            int n6 = this.mMol.getPathLength(n, nArray[i], Integer.MAX_VALUE, blArray);
            if (n6 >= n5) continue;
            n5 = n6;
            n3 = nArray[i];
        }
        return n3;
    }

    protected void normalizeESRGroups() {
        if (this.mMesoFragmentAtom != null) {
            ESRGroupFragmentMatrix eSRGroupFragmentMatrix = new ESRGroupFragmentMatrix();
            this.mESRGroupNormalizationInfoList = new ArrayList();
            for (int i = 0; i < this.mMesoFragmentAtom.length; ++i) {
                int n;
                int n2;
                int n3 = eSRGroupFragmentMatrix.getDependentGroupCount(i);
                if (n3 == 0) {
                    eSRGroupFragmentMatrix.cutTiesOfIndependentGroups(i);
                    n2 = this.countESRGroups(i, 2);
                    n = this.countESRGroups(i, 1);
                    boolean bl = this.containsTypeABSParity1Or2(i);
                    if (n2 == 1 && n == 1 && !bl) {
                        this.putORAtomsIntoANDGroup(i, eSRGroupFragmentMatrix.newESRGroup(1));
                        this.mESRGroupNormalizationInfoList.add(new ESRGroupNormalizationInfo(i, 1, -1, -1));
                    }
                    if (n2 > 0) {
                        if (bl) {
                            this.putABSAtomsIntoESRGroup(i, eSRGroupFragmentMatrix.newESRGroup(2), 2);
                            ++n2;
                        }
                        this.mESRGroupNormalizationInfoList.add(new ESRGroupNormalizationInfo(i, 1, -1, -1));
                        continue;
                    }
                    if (n > 0) {
                        if (bl) {
                            this.putABSAtomsIntoESRGroup(i, eSRGroupFragmentMatrix.newESRGroup(1), 1);
                        }
                        this.mESRGroupNormalizationInfoList.add(new ESRGroupNormalizationInfo(i, 1, -1, -1));
                        continue;
                    }
                    if (!bl) continue;
                    this.putABSAtomsIntoESRGroup(i, eSRGroupFragmentMatrix.newESRGroup(1), 1);
                    this.mESRGroupNormalizationInfoList.add(new ESRGroupNormalizationInfo(i, 1, -1, -1));
                    continue;
                }
                if (n3 != 1) continue;
                if (this.containsTypeABSParity1Or2(i)) {
                    n2 = eSRGroupFragmentMatrix.getDependentGroup(i);
                    n = eSRGroupFragmentMatrix.getDependentType(i);
                    this.mESRGroupNormalizationInfoList.add(new ESRGroupNormalizationInfo(i, 2, n2, n));
                    continue;
                }
                eSRGroupFragmentMatrix.cutTiesOfIndependentGroups(i);
                this.mESRGroupNormalizationInfoList.add(new ESRGroupNormalizationInfo(i, 1, -1, -1));
            }
        }
    }

    private boolean containsTypeABSParity1Or2(int n) {
        for (int i = 0; i < this.mMesoFragmentAtom[n].length; ++i) {
            int n2 = this.mMesoFragmentAtom[n][i];
            if (!this.hasParity1or2(n2) || this.mTHESRType[n2] != 0) continue;
            return true;
        }
        return false;
    }

    private int countESRGroups(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < this.mMesoFragmentAtom[n].length; ++i) {
            int n5;
            int n6 = this.mMesoFragmentAtom[n][i];
            if (this.mTHESRType[n6] != n2 || (n4 & (n5 = 1 << this.mTHESRGroup[n6])) != 0) continue;
            n4 |= n5;
            ++n3;
        }
        return n3;
    }

    private boolean hasParity1or2(int n) {
        return this.mIsStereoCenter[n] && (this.mTHParity[n] == 1 || this.mTHParity[n] == 2);
    }

    private void putABSAtomsIntoESRGroup(int n, int n2, int n3) {
        for (int i = 0; i < this.mMesoFragmentAtom[n].length; ++i) {
            int n4 = this.mMesoFragmentAtom[n][i];
            if (!this.hasParity1or2(n4) || this.mTHESRType[n4] != 0) continue;
            this.mTHESRType[n4] = (byte)n3;
            this.mTHESRGroup[n4] = (byte)n2;
        }
    }

    private void putORAtomsIntoANDGroup(int n, int n2) {
        for (int i = 0; i < this.mMesoFragmentAtom[n].length; ++i) {
            int n3 = this.mMesoFragmentAtom[n][i];
            if (this.mTHESRType[n3] != 2) continue;
            this.mTHESRType[n3] = 1;
            this.mTHESRGroup[n3] = (byte)n2;
        }
    }

    protected boolean normalizeESRGroupSwappingAndRemoval(int[] nArray) {
        if (this.mESRGroupNormalizationInfoList == null) {
            return false;
        }
        boolean bl = false;
        for (int i = this.mESRGroupNormalizationInfoList.size() - 1; i >= 0; --i) {
            boolean bl2 = false;
            ESRGroupNormalizationInfo eSRGroupNormalizationInfo = this.mESRGroupNormalizationInfoList.get(i);
            if (eSRGroupNormalizationInfo.action == 2) {
                bl2 = this.normalizeESRGroupSwapping(eSRGroupNormalizationInfo.fragment, eSRGroupNormalizationInfo.group, eSRGroupNormalizationInfo.type, nArray);
            } else if (eSRGroupNormalizationInfo.action == 1) {
                bl2 = this.removeESRGroupFromFragment(eSRGroupNormalizationInfo.fragment, nArray);
            }
            if (!bl2) continue;
            this.mESRGroupNormalizationInfoList.remove(eSRGroupNormalizationInfo);
            for (int j = 0; j < this.mMesoFragmentAtom[eSRGroupNormalizationInfo.fragment].length; ++j) {
                int n = this.mMesoFragmentAtom[eSRGroupNormalizationInfo.fragment][j];
                this.mTHESRTypeNeedsNormalization[n] = false;
            }
            bl = true;
        }
        return bl;
    }

    private boolean normalizeESRGroupSwapping(int n, int n2, int n3, int[] nArray) {
        int n4;
        int n5;
        int[] nArray2 = null;
        int[] nArray3 = null;
        for (n5 = 0; n5 < this.mMesoFragmentAtom[n].length; ++n5) {
            n4 = this.mMesoFragmentAtom[n][n5];
            if (!this.hasParity1or2(n4)) continue;
            if (this.mTHESRType[n4] == 0) {
                nArray3 = CanonizerMesoHelper.addToIntArray(nArray3, (nArray[n4] << 16) + n4);
                continue;
            }
            if (this.mTHESRType[n4] != n3 || this.mTHESRGroup[n4] != n2) continue;
            nArray2 = CanonizerMesoHelper.addToIntArray(nArray2, (nArray[n4] << 16) + n4);
        }
        n5 = new CanonizerRankListComparator().compare(nArray2, nArray3);
        if (n5 == 0) {
            return false;
        }
        if (n5 < 0) {
            for (n4 = 0; n4 < this.mMesoFragmentAtom[n].length; ++n4) {
                int n6 = this.mMesoFragmentAtom[n][n4];
                if (!this.hasParity1or2(n6)) continue;
                if (this.mTHESRType[n6] == 0) {
                    this.mTHESRType[n6] = (byte)n3;
                    this.mTHESRGroup[n6] = (byte)n2;
                    continue;
                }
                if (this.mTHESRType[n6] != n3 || this.mTHESRGroup[n6] != n2) continue;
                this.mTHESRType[n6] = 0;
                this.mTHESRGroup[n6] = -1;
            }
        }
        return true;
    }

    private boolean removeESRGroupFromFragment(int n, int[] nArray) {
        int n2;
        int n3;
        int[] nArray2 = this.mMesoFragmentAtom[n];
        byte by = 1;
        for (int i = 0; i < nArray2.length; ++i) {
            n3 = nArray2[i];
            if (!this.mIsStereoCenter[n3] || this.mTHESRType[n3] != 2) continue;
            by = 2;
            break;
        }
        int[][] nArrayArray = new int[32][];
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            n2 = nArray2[n3];
            if (!this.mIsStereoCenter[n2] || this.mTHESRType[n2] != by) continue;
            nArrayArray[this.mTHESRGroup[n2]] = CanonizerMesoHelper.addToIntArray(nArrayArray[this.mTHESRGroup[n2]], (nArray[n2] << 16) + n2);
        }
        for (n3 = 0; n3 < 32; ++n3) {
            if (nArrayArray[n3] == null) continue;
            Arrays.sort(nArrayArray[n3]);
        }
        Arrays.sort(nArrayArray, new CanonizerRankListComparator());
        if (new CanonizerRankListComparator().compare(nArrayArray[0], nArrayArray[1]) == 0) {
            return false;
        }
        for (n3 = 0; n3 < nArrayArray[0].length; ++n3) {
            n2 = nArrayArray[0][n3] & 0xFFFF;
            this.mTHESRType[n2] = 0;
            this.mTHESRGroup[n2] = -1;
        }
        return true;
    }

    protected static int[] addToIntArray(int[] nArray, int n) {
        int[] nArray2 = new int[nArray == null ? 1 : nArray.length + 1];
        for (int i = 0; i < nArray2.length - 1; ++i) {
            nArray2[i] = nArray[i];
        }
        nArray2[nArray2.length - 1] = n;
        return nArray2;
    }

    private class ESRGroupFragmentMatrix {
        private int mAndGroupCount;
        private int mOrGroupCount;
        private int mGroupCount;
        private int mNewAndGroupCount;
        private int mNewOrGroupCount;
        private boolean[][] mMatrix;
        private int[] mGroupDependence;
        private int[][] mGroupNeighbour;

        public ESRGroupFragmentMatrix() {
            int n;
            int n2;
            int n3;
            for (n3 = 0; n3 < CanonizerMesoHelper.this.mMol.getAtoms(); ++n3) {
                if (!CanonizerMesoHelper.this.hasParity1or2(n3)) continue;
                if (CanonizerMesoHelper.this.mTHESRType[n3] == 1) {
                    if (this.mAndGroupCount > CanonizerMesoHelper.this.mTHESRGroup[n3]) continue;
                    this.mAndGroupCount = 1 + CanonizerMesoHelper.this.mTHESRGroup[n3];
                    continue;
                }
                if (CanonizerMesoHelper.this.mTHESRType[n3] != 2 || this.mOrGroupCount > CanonizerMesoHelper.this.mTHESRGroup[n3]) continue;
                this.mOrGroupCount = 1 + CanonizerMesoHelper.this.mTHESRGroup[n3];
            }
            this.mGroupCount = this.mAndGroupCount + this.mOrGroupCount;
            this.mMatrix = new boolean[this.mGroupCount + 1][CanonizerMesoHelper.this.mMesoFragmentAtom.length + 1];
            for (n3 = 0; n3 < CanonizerMesoHelper.this.mMol.getAtoms(); ++n3) {
                if (!CanonizerMesoHelper.this.hasParity1or2(n3) || CanonizerMesoHelper.this.mIsMesoFragmentMember[n3]) continue;
                this.mMatrix[this.groupIndex((int)n3)][((CanonizerMesoHelper)CanonizerMesoHelper.this).mMesoFragmentAtom.length] = true;
            }
            for (n3 = 0; n3 < CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++n3) {
                for (n2 = 0; n2 < CanonizerMesoHelper.this.mMesoFragmentAtom[n3].length; ++n2) {
                    n = CanonizerMesoHelper.this.mMesoFragmentAtom[n3][n2];
                    if (!CanonizerMesoHelper.this.hasParity1or2(n)) continue;
                    this.mMatrix[this.groupIndex((int)n)][n3] = true;
                }
            }
            this.mGroupNeighbour = new int[this.mGroupCount][];
            for (n3 = 0; n3 < CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++n3) {
                for (n2 = 1; n2 < this.mGroupCount; ++n2) {
                    if (!this.mMatrix[n2][n3]) continue;
                    for (n = 0; n < n2; ++n) {
                        if (!this.mMatrix[n][n3]) continue;
                        this.mGroupNeighbour[n2] = CanonizerMesoHelper.addToIntArray(this.mGroupNeighbour[n2], n);
                        this.mGroupNeighbour[n] = CanonizerMesoHelper.addToIntArray(this.mGroupNeighbour[n], n2);
                    }
                }
            }
            this.mGroupDependence = new int[this.mGroupCount + 1];
            for (n3 = 0; n3 < this.mGroupCount; ++n3) {
                this.mGroupDependence[n3] = this.mMatrix[n3][CanonizerMesoHelper.this.mMesoFragmentAtom.length] ? -1 : -2;
            }
            for (n3 = 0; n3 < CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++n3) {
                if (!this.mMatrix[this.mGroupCount][n3]) continue;
                for (n2 = 0; n2 < this.mGroupCount; ++n2) {
                    if (!this.mMatrix[n2][n3] || this.mGroupDependence[n2] == n3) continue;
                    this.mGroupDependence[n2] = this.mGroupDependence[n2] == -2 ? n3 : -3;
                }
            }
            for (n3 = 0; n3 < this.mGroupCount; ++n3) {
                int[] nArray;
                if (this.mGroupDependence[n3] < -1 || !this.extendAnchorChain(nArray = new int[this.mGroupCount], n3)) continue;
                for (n = 0; n < this.mGroupCount; ++n) {
                    if (nArray[n] == 0) continue;
                    this.mGroupDependence[n] = -3;
                }
            }
            for (n3 = 0; n3 < CanonizerMesoHelper.this.mMesoFragmentAtom.length - 1; ++n3) {
                block13: for (int i = 1; i < this.mGroupCount; ++i) {
                    if (!this.mMatrix[i][n3] || this.mGroupDependence[i] == -3) continue;
                    for (n = 0; n < i; ++n) {
                        int[] nArray;
                        if (!this.mMatrix[n][n3] || this.mGroupDependence[n] == -3 || (nArray = this.getDependencyCycle(i, n, n3)) == null) continue;
                        for (int j = 0; j < nArray.length; ++j) {
                            this.mGroupDependence[nArray[j]] = -3;
                        }
                        this.removeOneGroupFromCycle(nArray);
                        continue block13;
                    }
                }
            }
        }

        private boolean extendAnchorChain(int[] nArray, int n) {
            int n2;
            boolean bl = false;
            nArray[n] = n2 = 1;
            boolean bl2 = true;
            while (bl2) {
                bl2 = false;
                for (int i = 0; i < this.mGroupCount; ++i) {
                    if (nArray[i] != n2) continue;
                    for (int j = 0; j < this.mGroupCount; ++j) {
                        if (nArray[j] != 0 || !this.groupsShareFragment(i, j)) continue;
                        if (this.mGroupDependence[j] == -2) {
                            nArray[j] = n2 + 1;
                            bl2 = true;
                            continue;
                        }
                        if (this.mGroupDependence[j] == this.mGroupDependence[n]) continue;
                        nArray[j] = n2 + 1;
                        bl = true;
                    }
                }
                ++n2;
            }
            return bl;
        }

        private int[] getDependencyCycle(int n, int n2, int n3) {
            for (int i = n3 + 1; i < CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++i) {
                if (i == n3 || !this.mMatrix[n][i] || !this.mMatrix[n2][i]) continue;
                int[] nArray = new int[]{n2, n};
                return nArray;
            }
            int[] nArray = new int[this.mGroupCount];
            int[] nArray2 = new int[this.mGroupCount];
            int[] nArray3 = new int[this.mGroupCount];
            int n4 = 0;
            nArray3[0] = n;
            nArray2[n] = 1;
            for (int i = 0; i <= n4; ++i) {
                for (int j = 0; j < this.mGroupNeighbour[nArray3[i]].length; ++j) {
                    int n5 = this.mGroupNeighbour[nArray3[i]][j];
                    if (n5 == n2) {
                        if (i == 0) continue;
                        int n6 = nArray2[nArray3[i]] + 1;
                        int[] nArray4 = new int[n6];
                        nArray4[0] = n5;
                        nArray4[1] = nArray3[i];
                        for (int k = 2; k < n6; ++k) {
                            nArray4[k] = nArray[nArray4[k - 1]];
                        }
                        return nArray4;
                    }
                    if (nArray2[n5] != 0 || this.mGroupDependence[n5] == -3) continue;
                    nArray2[n5] = nArray2[nArray3[i]] + 1;
                    nArray3[++n4] = n5;
                    nArray[n5] = nArray3[i];
                }
            }
            return null;
        }

        private void removeOneGroupFromCycle(int[] nArray) {
            int n;
            int n2 = Integer.MAX_VALUE;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            for (n = 0; n < CanonizerMesoHelper.this.mMol.getAtoms(); ++n) {
                if (!CanonizerMesoHelper.this.hasParity1or2(n) || CanonizerMesoHelper.this.mTHESRType[n] == 0) continue;
                for (int i = 0; i < nArray.length; ++i) {
                    int n6 = this.getESRGroup(nArray[i]);
                    int n7 = this.getESRType(nArray[i]);
                    if (CanonizerMesoHelper.this.mTHESRType[n] != n7 || CanonizerMesoHelper.this.mTHESRGroup[n] != n6 || n2 <= CanonizerMesoHelper.this.mCanRankWithoutStereo[n] + (n7 == 1 ? 65536 : 0)) continue;
                    n2 = CanonizerMesoHelper.this.mCanRankWithoutStereo[n] + (n7 == 1 ? 65536 : 0);
                    n3 = n6;
                    n4 = n7;
                    n5 = nArray[i];
                }
            }
            for (n = 0; n < CanonizerMesoHelper.this.mMol.getAtoms(); ++n) {
                if (!CanonizerMesoHelper.this.hasParity1or2(n) || CanonizerMesoHelper.this.mTHESRType[n] != n4 || CanonizerMesoHelper.this.mTHESRGroup[n] != n3) continue;
                ((CanonizerMesoHelper)CanonizerMesoHelper.this).mTHESRType[n] = 0;
                ((CanonizerMesoHelper)CanonizerMesoHelper.this).mTHESRGroup[n] = -1;
            }
            for (n = 0; n < CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++n) {
                this.mMatrix[n5][n] = false;
            }
        }

        private boolean groupsShareFragment(int n, int n2) {
            for (int i = 0; i < CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++i) {
                if (!this.mMatrix[n][i] || !this.mMatrix[n2][i]) continue;
                return true;
            }
            return false;
        }

        private int getDependentGroupCount(int n) {
            int n2 = 0;
            for (int i = 0; i < this.mGroupCount; ++i) {
                if (!this.mMatrix[i][n] || this.mGroupDependence[i] != -3) continue;
                ++n2;
            }
            return n2;
        }

        private int getDependentType(int n) {
            for (int i = 0; i < this.mGroupCount; ++i) {
                if (!this.mMatrix[i][n] || this.mGroupDependence[i] != -3) continue;
                return this.getESRType(i);
            }
            return -1;
        }

        private int getDependentGroup(int n) {
            for (int i = 0; i < this.mGroupCount; ++i) {
                if (!this.mMatrix[i][n] || this.mGroupDependence[i] != -3) continue;
                return this.getESRGroup(i);
            }
            return -1;
        }

        private int getESRType(int n) {
            return n < this.mAndGroupCount ? 1 : (n < this.mGroupCount ? 2 : 0);
        }

        private int getESRGroup(int n) {
            return n < this.mAndGroupCount ? n : (n < this.mGroupCount ? n - this.mAndGroupCount : -1);
        }

        private int groupIndex(int n) {
            byte by = CanonizerMesoHelper.this.mTHESRType[n];
            int n2 = CanonizerMesoHelper.this.mTHESRGroup[n];
            return by == 0 ? this.mGroupCount : (by == 1 ? n2 : this.mAndGroupCount + n2);
        }

        private void cutTiesOfIndependentGroups(int n) {
            for (int i = 0; i < this.mGroupCount; ++i) {
                if (!this.mMatrix[i][n] || this.mGroupDependence[i] == -3) continue;
                for (int j = 0; j <= CanonizerMesoHelper.this.mMesoFragmentAtom.length; ++j) {
                    if (j == n || !this.mMatrix[i][j]) continue;
                    this.mMatrix[i][n] = false;
                    int n2 = this.getESRGroup(i);
                    int n3 = this.newESRGroup(this.getESRType(i));
                    for (int k = 0; k < CanonizerMesoHelper.this.mMesoFragmentAtom[n].length; ++k) {
                        int n4 = CanonizerMesoHelper.this.mMesoFragmentAtom[n][k];
                        if (!CanonizerMesoHelper.this.hasParity1or2(n4) || CanonizerMesoHelper.this.mTHESRGroup[n4] != n2) continue;
                        ((CanonizerMesoHelper)CanonizerMesoHelper.this).mTHESRGroup[n4] = (byte)n3;
                    }
                }
            }
        }

        private int newESRGroup(int n) {
            return n == 1 ? this.mAndGroupCount + this.mNewAndGroupCount++ : this.mOrGroupCount + this.mNewOrGroupCount++;
        }
    }
}

