/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.statistics.median;

import com.actelion.research.calc.statistics.median.ModelMedianDouble;
import com.actelion.research.calc.statistics.median.ModelMedianInteger;
import com.actelion.research.calc.statistics.median.ModelMedianLong;
import java.util.Collections;
import java.util.List;

public class MedianStatisticFunctions {
    public static double getPercentileFromSorted(List<Double> list, double d) {
        if (list.size() == 1) {
            return list.get(0);
        }
        double d2 = 0.0;
        int n = list.size();
        if ((double)((int)((double)n * d)) == (double)n * d) {
            int n2 = (int)((double)n * d) - 1;
            int n3 = n2 + 1;
            if (n2 < 0) {
                throw new RuntimeException("Fraction to small.");
            }
            d2 = (list.get(n2) + list.get(n3)) / 2.0;
        } else {
            int n4 = (int)((double)n * d);
            d2 = list.get(n4);
        }
        return d2;
    }

    public static double getPercentileFromSorted(double[] dArray, double d) {
        return MedianStatisticFunctions.getPercentileFromSorted(dArray, d, 0, dArray.length);
    }

    public static double getPercentileFromSorted(float[] fArray, double d) {
        return MedianStatisticFunctions.getPercentileFromSorted(fArray, d, 0, fArray.length);
    }

    public static double getPercentileFromSorted(double[] dArray, double d, int n, int n2) {
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d2 = 0.0;
        if ((double)((int)((double)n2 * d)) == (double)n2 * d) {
            int n3 = (int)((double)n2 * d) - 1 + n;
            int n4 = n3 + 1 + n;
            if (n3 < 0) {
                throw new RuntimeException("Fraction to small.");
            }
            d2 = (dArray[n3] + dArray[n4]) / 2.0;
        } else {
            int n5 = (int)((double)n2 * d) + n;
            d2 = dArray[n5];
        }
        return d2;
    }

    public static double getPercentileFromSorted(float[] fArray, double d, int n, int n2) {
        if (fArray.length == 1) {
            return fArray[0];
        }
        double d2 = 0.0;
        if ((double)((int)((double)n2 * d)) == (double)n2 * d) {
            int n3 = (int)((double)n2 * d) - 1 + n;
            int n4 = n3 + 1 + n;
            if (n3 < 0) {
                throw new RuntimeException("Fraction to small.");
            }
            d2 = (double)(fArray[n3] + fArray[n4]) / 2.0;
        } else {
            int n5 = (int)((double)n2 * d) + n;
            d2 = fArray[n5];
        }
        return d2;
    }

    public static double getPercentileFromSortedInt(List<Integer> list, double d) {
        if (list.size() == 1) {
            return list.get(0).intValue();
        }
        double d2 = 0.0;
        int n = list.size();
        if ((double)((int)((double)n * d)) == (double)n * d) {
            int n2 = (int)((double)n * d + 0.5) - 1;
            int n3 = n2 + 1;
            if (n2 < 0) {
                n2 = 0;
            }
            d2 = (double)(list.get(n2) + list.get(n3)) / 2.0;
        } else {
            int n4 = (int)((double)n * d);
            d2 = list.get(n4).intValue();
        }
        return d2;
    }

    public static double getPercentileFromSortedLong(List<Long> list, double d) {
        if (list.size() == 1) {
            return list.get(0).longValue();
        }
        long l = 0L;
        int n = list.size();
        if ((double)((int)((double)n * d)) == (double)n * d) {
            int n2 = (int)((double)n * d + 0.5) - 1;
            int n3 = n2 + 1;
            if (n2 < 0) {
                n2 = 0;
            }
            l = (long)((double)(list.get(n2) + list.get(n3)) / 2.0);
        } else {
            int n4 = (int)((double)n * d);
            l = list.get(n4);
        }
        return l;
    }

    public static ModelMedianInteger getMedianForInteger(List<Integer> list) {
        Collections.sort(list);
        ModelMedianInteger modelMedianInteger = new ModelMedianInteger();
        modelMedianInteger.lowerQuartile = (int)(MedianStatisticFunctions.getPercentileFromSortedInt(list, 0.25) + 0.5);
        modelMedianInteger.median = (int)(MedianStatisticFunctions.getPercentileFromSortedInt(list, 0.5) + 0.5);
        modelMedianInteger.upperQuartile = (int)(MedianStatisticFunctions.getPercentileFromSortedInt(list, 0.75) + 0.5);
        modelMedianInteger.size = list.size();
        return modelMedianInteger;
    }

    public static ModelMedianLong getMedianForLong(List<Long> list) {
        Collections.sort(list);
        ModelMedianLong modelMedianLong = new ModelMedianLong();
        modelMedianLong.lowerQuartile = (long)(MedianStatisticFunctions.getPercentileFromSortedLong(list, 0.25) + 0.5);
        modelMedianLong.median = (long)(MedianStatisticFunctions.getPercentileFromSortedLong(list, 0.5) + 0.5);
        modelMedianLong.upperQuartile = (long)(MedianStatisticFunctions.getPercentileFromSortedLong(list, 0.75) + 0.5);
        modelMedianLong.size = list.size();
        return modelMedianLong;
    }

    public static ModelMedianDouble getMedianForDouble(List<Double> list) {
        Collections.sort(list);
        ModelMedianDouble modelMedianDouble = new ModelMedianDouble();
        modelMedianDouble.lowerQuartile = MedianStatisticFunctions.getPercentileFromSorted(list, 0.25);
        modelMedianDouble.median = MedianStatisticFunctions.getPercentileFromSorted(list, 0.5);
        modelMedianDouble.upperQuartile = MedianStatisticFunctions.getPercentileFromSorted(list, 0.75);
        modelMedianDouble.size = list.size();
        return modelMedianDouble;
    }
}

