/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc.regression.svm;

import org.machinelearning.svm.libsvm.svm_parameter;

public class SVMParameterHelper {
    public static final String SVM_TYPE_C = "C_SVC";
    public static final String SVM_TYPE_NU = "NU_SVC";
    public static final String SVM_TYPE_ONE_CLASS = "OneClass";
    public static final String SVM_TYPE_EPSILON_SVR = "EpsSVR";
    public static final String SVM_TYPE_NU_SVR = "NU_SVR";
    public static final String KERNEL_TYPE_LINEAR = "Linear";
    public static final String KERNEL_TYPE_POLY = "Poly";
    public static final String KERNEL_TYPE_RBF = "RBF";
    public static final String KERNEL_TYPE_SIGMOID = "Sigmoid";
    public static final String KERNEL_TYPE_PRECOMPUTED = "Precomputed";
    public static final int DEGREE_ANALYTICALLY_PARAMETER_CALC = -1;

    public static svm_parameter standard() {
        svm_parameter svm_parameter2 = new svm_parameter();
        svm_parameter2.svm_type = 0;
        svm_parameter2.kernel_type = 2;
        svm_parameter2.degree = 3;
        svm_parameter2.gamma = 0.0;
        svm_parameter2.coef0 = 0.0;
        svm_parameter2.nu = 0.5;
        svm_parameter2.cache_size = 100.0;
        svm_parameter2.C = 1.0;
        svm_parameter2.eps = 0.001;
        svm_parameter2.p = 0.1;
        svm_parameter2.shrinking = 1;
        svm_parameter2.probability = 0;
        svm_parameter2.nr_weight = 0;
        svm_parameter2.weight_label = new int[0];
        svm_parameter2.weight = new double[0];
        return svm_parameter2;
    }

    public static svm_parameter regressionEpsilonSVR() {
        svm_parameter svm_parameter2 = new svm_parameter();
        svm_parameter2.svm_type = 3;
        svm_parameter2.kernel_type = 2;
        svm_parameter2.degree = -1;
        svm_parameter2.gamma = 0.0;
        svm_parameter2.coef0 = 0.0;
        svm_parameter2.nu = 0.5;
        svm_parameter2.cache_size = 100.0;
        svm_parameter2.C = 130.0;
        svm_parameter2.eps = 5.0;
        svm_parameter2.p = 0.1;
        svm_parameter2.shrinking = 1;
        svm_parameter2.probability = 0;
        svm_parameter2.nr_weight = 0;
        svm_parameter2.weight_label = new int[0];
        svm_parameter2.weight = new double[0];
        return svm_parameter2;
    }

    public static svm_parameter regressionNuSVR(double d) {
        svm_parameter svm_parameter2 = new svm_parameter();
        svm_parameter2.svm_type = 4;
        svm_parameter2.kernel_type = 2;
        svm_parameter2.degree = 3;
        svm_parameter2.gamma = 1.0;
        svm_parameter2.coef0 = 0.0;
        svm_parameter2.nu = d;
        svm_parameter2.cache_size = 100.0;
        svm_parameter2.C = 1.0;
        svm_parameter2.eps = 0.001;
        svm_parameter2.p = 0.1;
        svm_parameter2.shrinking = 1;
        svm_parameter2.probability = 0;
        svm_parameter2.nr_weight = 0;
        svm_parameter2.weight_label = new int[0];
        svm_parameter2.weight = new double[0];
        return svm_parameter2;
    }

    public static String getSVMType(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = SVM_TYPE_C;
                break;
            }
            case 1: {
                string = SVM_TYPE_NU;
                break;
            }
            case 2: {
                string = SVM_TYPE_ONE_CLASS;
                break;
            }
            case 4: {
                string = SVM_TYPE_NU_SVR;
                break;
            }
            case 3: {
                string = SVM_TYPE_EPSILON_SVR;
            }
        }
        return string;
    }

    public static int getSVMType(String string) {
        int n = -1;
        if (SVM_TYPE_C.equals(string)) {
            n = 0;
        } else if (SVM_TYPE_NU.equals(string)) {
            n = 1;
        } else if (SVM_TYPE_ONE_CLASS.equals(string)) {
            n = 2;
        } else if (SVM_TYPE_NU_SVR.equals(string)) {
            n = 4;
        } else if (SVM_TYPE_EPSILON_SVR.equals(string)) {
            n = 3;
        } else {
            throw new RuntimeException("Unknown svm type " + string + ".");
        }
        return n;
    }

    public static String getKernelType(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = KERNEL_TYPE_LINEAR;
                break;
            }
            case 1: {
                string = KERNEL_TYPE_POLY;
                break;
            }
            case 2: {
                string = KERNEL_TYPE_RBF;
                break;
            }
            case 3: {
                string = KERNEL_TYPE_SIGMOID;
                break;
            }
            case 4: {
                string = KERNEL_TYPE_PRECOMPUTED;
            }
        }
        return string;
    }

    public static int getKernelType(String string) {
        int n = -1;
        if (KERNEL_TYPE_LINEAR.equals(string)) {
            n = 0;
        } else if (KERNEL_TYPE_POLY.equals(string)) {
            n = 1;
        } else if (KERNEL_TYPE_RBF.equals(string)) {
            n = 2;
        } else if (KERNEL_TYPE_SIGMOID.equals(string)) {
            n = 3;
        } else if (KERNEL_TYPE_PRECOMPUTED.equals(string)) {
            n = 4;
        } else {
            throw new RuntimeException("Unknown kernel type " + string + ".");
        }
        return n;
    }
}

