/*
 * Decompiled with CFR 0.152.
 */
package com.actelion.research.calc;

import com.actelion.research.util.DoubleVec;

public class VectorSimilarity {
    public static double getTanimotoSimilarity(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = VectorSimilarity.mult(dArray, dArray2);
        double d3 = VectorSimilarity.mult(dArray, dArray);
        double d4 = VectorSimilarity.mult(dArray2, dArray2);
        d = d2 / (d3 + d4 - d2);
        return d;
    }

    private static double mult(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double getTanimotoSimilarity(float[] fArray, float[] fArray2) {
        double d = 0.0;
        double d2 = VectorSimilarity.mult(fArray, fArray2);
        double d3 = VectorSimilarity.mult(fArray, fArray);
        double d4 = VectorSimilarity.mult(fArray2, fArray2);
        d = d2 / (d3 + d4 - d2);
        return d;
    }

    private static double mult(float[] fArray, float[] fArray2) {
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            d += (double)(fArray[i] * fArray2[i]);
        }
        return d;
    }

    public static double getTanimotoSimilarity(int[] nArray, int[] nArray2) {
        double d = 0.0;
        double d2 = VectorSimilarity.mult(nArray, nArray2);
        double d3 = VectorSimilarity.mult(nArray, nArray);
        double d4 = VectorSimilarity.mult(nArray2, nArray2);
        d = d2 / (d3 + d4 - d2);
        return d;
    }

    public static double getCosine(int[] nArray, int[] nArray2) {
        DoubleVec doubleVec = new DoubleVec(nArray);
        DoubleVec doubleVec2 = new DoubleVec(nArray2);
        doubleVec.norm2One();
        doubleVec2.norm2One();
        return DoubleVec.getCosine(doubleVec, doubleVec2);
    }

    private static double mult(int[] nArray, int[] nArray2) {
        double d = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            d += (double)(nArray[i] * nArray2[i]);
        }
        return d;
    }

    public static double getMinMaxSimilarity(int[] nArray, int[] nArray2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            int n2 = nArray2[i];
            d += (double)Math.min(n, n2);
            d2 += (double)Math.max(n, n2);
        }
        double d3 = d / d2;
        return d3;
    }
}

