/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.actelion.research.chem.MolfileCreator;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.moreparsers.CDXParser;
import com.actelion.research.chem.moreparsers.InChIKeyParser;
import com.actelion.research.chem.moreparsers.InChIParser;
import com.actelion.research.chem.moreparsers.ParserUtils;
import com.actelion.research.gui.FileHelper;
import com.actelion.research.gui.JStructureView;
import com.actelion.research.gui.editor.SwingEditorArea;
import com.actelion.research.gui.editor.SwingEditorPanel;
import com.actelion.research.gui.swing.SwingDialog;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class OCLSwingTest {
    public static int nFrame;
    static int frameY;

    public static void main(String[] stringArray) {
        String string = null;
        OCLSwingTest.testCDXParsers(string);
        OCLSwingTest.testInChIParsers(string);
        OCLSwingTest.testSmilesParser(string);
        SwingUtilities.invokeLater(() -> OCLSwingTest.showDialogTest(stringArray));
    }

    private static void testSmilesParser(String string) {
        String string2 = "N12C(=O)OC(C)(C)C.C1CC[C@H]2C(=O)[N](CCC)C1=CC=CC2=CC=CC=C12";
        String string3 = "tsmiles.png";
        System.out.println(string2 + " => " + string3);
        StereoMolecule stereoMolecule = new SmilesParser().parseMolecule(string2);
        JStructureView jStructureView = JStructureView.getStandardView(stereoMolecule);
        OCLSwingTest.writeViewImage(jStructureView, string3, string);
        jStructureView.showInFrame(string2, OCLSwingTest.nextLoc());
    }

    private static void testInChIParsers(String string) {
        JStructureView jStructureView;
        String string2 = "tinchi.png";
        String string3 = "InChI=1S/C4H11N/c1-3-5-4-2/h5H,3-4H2,1-2H3";
        string3 = "InChI=1S/C17H19NO3/c1-18-7-6-17-10-3-5-13(20)16(17)21-15-12(19)4-2-9(14(15)17)8-11(10)18/h2-5,10-11,13,16,19-20H,6-8H2,1H3/t10-,11+,13-,16-,17-/m0/s1";
        System.out.println(string3 + " => " + string2);
        StereoMolecule stereoMolecule = new StereoMolecule();
        if (new InChIParser().parse(stereoMolecule, string3)) {
            jStructureView = JStructureView.getStandardView(stereoMolecule);
            OCLSwingTest.writeViewImage(jStructureView, string2, string);
            jStructureView.showInFrame(string3, OCLSwingTest.nextLoc());
            OCLSwingTest.writeMolFile(stereoMolecule, string2 + ".mol", string);
        }
        string2 = "tinchipc.png";
        string3 = "PubChem:" + string3;
        System.out.println(string3 + " => " + string2);
        stereoMolecule = new StereoMolecule();
        if (new InChIParser().parse(stereoMolecule, string3)) {
            jStructureView = JStructureView.getStandardView(stereoMolecule);
            OCLSwingTest.writeViewImage(jStructureView, string2, string);
            jStructureView.showInFrame(string3, OCLSwingTest.nextLoc());
        }
        string2 = "tinchikey.png";
        String string4 = "BQJCRHHNABKAKU-KBQPJGBKSA-N";
        System.out.println(string4 + " => " + string2);
        stereoMolecule = new StereoMolecule();
        if (new InChIKeyParser().parse(stereoMolecule, string4)) {
            jStructureView = JStructureView.getStandardView(stereoMolecule);
            OCLSwingTest.writeViewImage(jStructureView, string2, string);
            jStructureView.showInFrame(string4, OCLSwingTest.nextLoc());
        }
    }

    private static void testCDXParsers(String string) {
        String string2 = "3aa.cdxml";
        String string3 = "t3aa.png";
        OCLSwingTest.testCDXML(string2, string3, string);
        string2 = "t.cdxml";
        string3 = "tcdxml.png";
        OCLSwingTest.testCDXML(string2, string3, string);
        string2 = "t.cdx";
        string3 = "tcdx.png";
        OCLSwingTest.testCDX(string2, string3, string);
        string2 = "tout.cdxml";
        string3 = "tout.png";
        OCLSwingTest.testCDX(string2, string3, string);
        string2 = "t-acs.cdxml";
        string3 = "t-acs-cdxml.png";
        OCLSwingTest.testCDXML(string2, string3, string);
        string2 = "t-acs.cdx";
        string3 = "t-acs-cdx.png";
        OCLSwingTest.testCDX(string2, string3, string);
    }

    private static void testCDXML(String string, String string2, String string3) {
        System.out.println(string + " => " + string2);
        StereoMolecule stereoMolecule = new StereoMolecule();
        String string4 = OCLSwingTest.getString(string, string3);
        if (new CDXParser().parse(stereoMolecule, string4)) {
            JStructureView jStructureView = JStructureView.getStandardView(stereoMolecule);
            jStructureView.showInFrame(string, OCLSwingTest.nextLoc());
            OCLSwingTest.writeViewImage(jStructureView, string2, string3);
        }
    }

    private static void testCDX(String string, String string2, String string3) {
        System.out.println(string + " => " + string2);
        StereoMolecule stereoMolecule = new StereoMolecule();
        byte[] byArray = OCLSwingTest.getBytes(string, string3);
        if (new CDXParser().parse(stereoMolecule, byArray)) {
            JStructureView jStructureView = JStructureView.getStandardView(stereoMolecule);
            jStructureView.showInFrame(string, OCLSwingTest.nextLoc());
            OCLSwingTest.writeViewImage(jStructureView, string2, string3);
            OCLSwingTest.writeMolFile(stereoMolecule, string + ".mol", string3);
        }
    }

    private static void writeViewImage(JStructureView jStructureView, String string, String string2) {
        OCLSwingTest.writeImage(jStructureView.getSizedImage(), string, string2);
    }

    private static byte[] getBytes(String string, String string2) {
        try {
            if (string2 == null) {
                return ParserUtils.getResourceBytes(OCLSwingTest.class, string);
            }
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            return ParserUtils.getURLContentsAsBytes(string2 + string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String getString(String string, String string2) {
        try {
            return new String(OCLSwingTest.getBytes(string, string2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void writeMolFile(StereoMolecule stereoMolecule, String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2 + string), "UTF-8"));
            new MolfileCreator(stereoMolecule).writeMolfile(bufferedWriter);
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Point nextLoc() {
        if (nFrame % 5 == 0) {
            frameY += 200;
            nFrame = 0;
        }
        return new Point(150 * nFrame++, frameY);
    }

    private static void writeImage(BufferedImage bufferedImage, String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        string = string2 + string;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ImageIO.write((RenderedImage)bufferedImage, "png", fileOutputStream);
            fileOutputStream.close();
            System.out.println("Created " + string + " " + new File(string).length());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void showDialogTest(String[] stringArray) {
        new FileHelper(null).readStructuresFromFileAsync(false, arrayList -> {
            StereoMolecule stereoMolecule;
            if (arrayList == null || arrayList.isEmpty()) {
                String string;
                String string2 = string = JOptionPane.showInputDialog("enter a SMILES", (Object)"N12C(=O)OC(C)(C)C.C1CC[C@H]2C(=O)[NH]C1=CC=CC2=CC=CC=C12");
                stereoMolecule = new SmilesParser().parseMolecule(string);
            } else {
                String string = "mol";
                stereoMolecule = (StereoMolecule)arrayList.get(0);
            }
            OCLSwingTest.showEditFrame(stereoMolecule);
        });
    }

    private static void showEditFrame(StereoMolecule stereoMolecule) {
        SwingEditorPanel swingEditorPanel = new SwingEditorPanel(stereoMolecule);
        swingEditorPanel.setSize(new Dimension(500, 500));
        int n = 224;
        SwingEditorArea swingEditorArea = (SwingEditorArea)swingEditorPanel.getComponent(0);
        swingEditorArea.getGenericDrawArea().setDisplayMode(n);
        SwingDialog swingDialog = new SwingDialog(null, "testing2", Dialog.ModalityType.MODELESS);
        swingEditorPanel.setPreferredSize(new Dimension(500, 500));
        swingDialog.add(swingEditorPanel);
        swingDialog.showDialog(() -> {
            System.out.println("OK");
            System.exit(0);
        }, () -> {
            System.out.println("cancel");
            System.exit(1);
        });
    }

    static {
        frameY = 0;
    }

    static class OclCodeCheck {
        private int nAvail = 6;
        private int pt;
        private byte[] idcode;
        private int mData;
        private int abits;
        private int bbits;
        private int nBytes;

        OclCodeCheck() {
        }

        public boolean checkOCL(String string) {
            this.nBytes = string.indexOf(33);
            if (this.nBytes < 0) {
                this.nBytes = string.indexOf(35);
            }
            if (this.nBytes < 0) {
                this.nBytes = string.length();
            }
            if (this.nBytes < 10 || this.nBytes > 1000) {
                return false;
            }
            this.idcode = string.substring(0, this.nBytes).getBytes();
            this.mData = (this.idcode[0] & 0x3F) << 11;
            try {
                if (this.idcode == null || this.idcode.length == 0) {
                    return false;
                }
                this.abits = this.decodeBits(4);
                this.bbits = this.decodeBits(4);
                int n = 8;
                if (this.abits > 8) {
                    n = this.abits;
                    this.abits = this.bbits;
                }
                if (n != 8 && n != 9) {
                    return false;
                }
                int n2 = this.decodeBits(this.abits);
                int n3 = this.decodeBits(this.bbits);
                int n4 = 1 + n3 - n2;
                if (n2 == 0 || n4 < 0 || n4 > n2 - 2) {
                    return false;
                }
                int n5 = this.decodeBits(this.abits);
                int n6 = this.decodeBits(this.abits);
                int n7 = this.decodeBits(this.abits);
                int n8 = this.decodeBits(this.abits);
                this.checkBits(n5);
                this.checkBits(n6);
                this.checkBits(n7);
                this.checkBits(n8);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        private void checkBits(int n) {
            if (n != 0) {
                int n2 = -1;
                for (int i = 0; i < n; ++i) {
                    int n3 = this.decodeBits(this.abits);
                    if (n3 <= n2) {
                        throw new NullPointerException();
                    }
                    n2 = n3;
                }
            }
        }

        private int decodeBits(int n) {
            int n2 = n;
            int n3 = 0;
            while (n != 0) {
                if (this.nAvail == 0) {
                    if (++this.pt >= this.idcode.length) {
                        throw new NullPointerException();
                    }
                    this.mData = (this.idcode[this.pt] & 0x3F) << 11;
                    this.nAvail = 6;
                }
                n3 |= (0x10000 & this.mData) >> 16 - n2 + n;
                this.mData <<= 1;
                --n;
                --this.nAvail;
            }
            return n3;
        }
    }
}

