/*
 * Decompiled with CFR 0.152.
 */
package swingjs;

import com.actelion.research.chem.MolfileCreator;
import com.actelion.research.chem.SmilesParser;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.moreparsers.CDXParser;
import com.actelion.research.chem.moreparsers.InChIKeyParser;
import com.actelion.research.chem.moreparsers.InChIParser;
import com.actelion.research.gui.FileHelper;
import com.actelion.research.gui.JStructureView;
import com.actelion.research.gui.editor.SwingEditorArea;
import com.actelion.research.gui.editor.SwingEditorPanel;
import com.actelion.research.gui.swing.SwingDialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class OCLSwingJS {
    private static int nFrame = 0;

    public static void main(String[] stringArray) {
        OCLSwingJS.showDialogTest(null);
        System.exit(0);
    }

    private static void showDialogTest(String[] stringArray) {
        new FileHelper(null).readStructuresFromFileAsync(false, arrayList -> {
            StereoMolecule stereoMolecule;
            if (arrayList == null || arrayList.isEmpty()) {
                String string;
                String string2 = string = JOptionPane.showInputDialog("enter a SMILES", (Object)"N12C(=O)OC(C)(C)C.C1CC[C@H]2C(=O)[NH]C1=CC=CC2=CC=CC=C12");
                stereoMolecule = new SmilesParser().parseMolecule(string);
            } else {
                String string = "mol";
                stereoMolecule = (StereoMolecule)arrayList.get(0);
            }
            OCLSwingJS.showEditFrame(stereoMolecule);
        });
    }

    private static void showEditFrame(StereoMolecule stereoMolecule) {
        SwingEditorPanel swingEditorPanel = new SwingEditorPanel(stereoMolecule);
        swingEditorPanel.setSize(new Dimension(500, 500));
        int n = 224;
        SwingEditorArea swingEditorArea = (SwingEditorArea)swingEditorPanel.getComponent(0);
        swingEditorArea.getGenericDrawArea().setDisplayMode(n);
        SwingDialog swingDialog = new SwingDialog(null, "testing2");
        swingDialog.setSize(new Dimension(500, 500));
        swingDialog.add(swingEditorPanel);
        swingDialog.setVisible(true);
        swingDialog.setDefaultCloseOperation(2);
    }

    private static void testSmilesParser(String string) {
        String string2 = "N12C(=O)OC(C)(C)C.C1CC[C@H]2C(=O)[N](CCC)C1=CC=CC2=CC=CC=C12";
        String string3 = string + "tsmiles.png";
        System.out.println(string2 + " => " + string3);
        StereoMolecule stereoMolecule = new SmilesParser().parseMolecule(string2);
        JStructureView jStructureView = JStructureView.getStandardView(stereoMolecule);
        BufferedImage bufferedImage = jStructureView.getSizedImage();
        OCLSwingJS.writeImage(bufferedImage, string3);
        jStructureView.showInFrame(string2, OCLSwingJS.nextLoc());
    }

    private static void testInChIParsers(String string) {
        String string2 = string + "tinchi.png";
        String string3 = "InChI=1S/C4H11N/c1-3-5-4-2/h5H,3-4H2,1-2H3";
        string3 = "InChI=1S/C17H19NO3/c1-18-7-6-17-10-3-5-13(20)16(17)21-15-12(19)4-2-9(14(15)17)8-11(10)18/h2-5,10-11,13,16,19-20H,6-8H2,1H3/t10-,11+,13-,16-,17-/m0/s1";
        System.out.println(string3 + " => " + string2);
        StereoMolecule stereoMolecule = new StereoMolecule();
        string3 = "PubChem:" + string3;
        System.out.println(string3 + " => " + string2);
        stereoMolecule = new StereoMolecule();
        new InChIParser().parse(stereoMolecule, string3);
        JStructureView jStructureView = JStructureView.getStandardView(stereoMolecule);
        BufferedImage bufferedImage = jStructureView.getSizedImage();
        OCLSwingJS.writeImage(bufferedImage, string2);
        jStructureView.showInFrame(string3, OCLSwingJS.nextLoc());
        string2 = string + "tinchikey.png";
        String string4 = "BQJCRHHNABKAKU-KBQPJGBKSA-N";
        System.out.println(string4 + " => " + string2);
        stereoMolecule = new StereoMolecule();
        new InChIKeyParser().parse(stereoMolecule, string4);
        jStructureView = JStructureView.getStandardView(stereoMolecule);
        bufferedImage = jStructureView.getSizedImage();
        OCLSwingJS.writeImage(bufferedImage, string4);
        jStructureView.showInFrame(string4, OCLSwingJS.nextLoc());
    }

    private static void testCDXParsers(String string) {
        BufferedImage bufferedImage;
        JStructureView jStructureView;
        String string2 = string + "3aa.cdxml";
        String string3 = string + "t3aa.png";
        System.out.println(string2 + " => " + string3);
        StereoMolecule stereoMolecule = CDXParser.parseFile(string2);
        if (stereoMolecule != null) {
            jStructureView = JStructureView.getStandardView(stereoMolecule);
            jStructureView.showInFrame(string2, OCLSwingJS.nextLoc());
            bufferedImage = jStructureView.getSizedImage();
            OCLSwingJS.writeImage(bufferedImage, string3);
            OCLSwingJS.showEditFrame(stereoMolecule);
            OCLSwingJS.writeMolFile(stereoMolecule, string2 + ".mol");
        }
        string2 = string + "t.cdxml";
        string3 = string + "tcdxml.png";
        System.out.println(string2 + " => " + string3);
        stereoMolecule = CDXParser.parseFile(string2);
        if (stereoMolecule != null) {
            jStructureView = JStructureView.getStandardView(stereoMolecule);
            jStructureView.showInFrame(string2, OCLSwingJS.nextLoc());
            bufferedImage = jStructureView.getSizedImage();
            OCLSwingJS.writeImage(bufferedImage, string3);
        }
        string2 = string + "t.cdx";
        string3 = string + "tcdx.png";
        System.out.println(string2 + " => " + string3);
        stereoMolecule = CDXParser.parseFile(string2);
        if (stereoMolecule != null) {
            jStructureView = JStructureView.getStandardView(stereoMolecule);
            jStructureView.showInFrame(string2, OCLSwingJS.nextLoc());
            bufferedImage = jStructureView.getSizedImage();
            OCLSwingJS.writeImage(bufferedImage, string3);
        }
        string2 = string + "tout.cdxml";
        string3 = string + "tout.png";
        System.out.println(string2 + " => " + string3);
        stereoMolecule = CDXParser.parseFile(string2);
        if (stereoMolecule != null) {
            jStructureView = JStructureView.getStandardView(stereoMolecule);
            jStructureView.showInFrame(string2, OCLSwingJS.nextLoc());
            bufferedImage = jStructureView.getSizedImage();
            OCLSwingJS.writeImage(bufferedImage, string3);
        }
        string2 = string + "t-acs.cdxml";
        string3 = string + "t-acs-cdxml.png";
        System.out.println(string2 + " => " + string3);
        stereoMolecule = CDXParser.parseFile(string2);
        if (stereoMolecule != null) {
            jStructureView = JStructureView.getStandardView(stereoMolecule);
            jStructureView.showInFrame(string2, OCLSwingJS.nextLoc());
            bufferedImage = jStructureView.getSizedImage();
            OCLSwingJS.writeImage(bufferedImage, string3);
        }
        string2 = string + "t-acs.cdx";
        string3 = string + "t-acs-cdx.png";
        System.out.println(string2 + " => " + string3);
        stereoMolecule = CDXParser.parseFile(string2);
        if (stereoMolecule != null) {
            jStructureView = JStructureView.getStandardView(stereoMolecule);
            jStructureView.showInFrame(string2, OCLSwingJS.nextLoc());
            bufferedImage = jStructureView.getSizedImage();
            OCLSwingJS.writeImage(bufferedImage, string3);
        }
    }

    private static void writeMolFile(StereoMolecule stereoMolecule, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
            new MolfileCreator(stereoMolecule).writeMolfile(bufferedWriter);
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Point nextLoc() {
        return new Point(150 * nFrame++, 0);
    }

    private static void writeImage(BufferedImage bufferedImage, String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ImageIO.write((RenderedImage)bufferedImage, "png", fileOutputStream);
            fileOutputStream.close();
            System.out.println("Created " + string + " " + new File(string).length());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

