/*
 * Decompiled with CFR 0.152.
 */
package smile.util;

import java.util.Arrays;
import smile.clustering.CLARANS;
import smile.clustering.KMeans;
import smile.data.Attribute;
import smile.math.Math;
import smile.math.distance.Metric;
import smile.math.rbf.GaussianRadialBasis;
import smile.sort.QuickSort;

public class SmileUtils {
    private SmileUtils() {
    }

    public static int[][] sort(Attribute[] attributeArray, double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[] dArray2 = new double[n];
        int[][] nArrayArray = new int[n2][];
        for (int i = 0; i < n2; ++i) {
            if (attributeArray[i].getType() != Attribute.Type.NUMERIC) continue;
            for (int j = 0; j < n; ++j) {
                dArray2[j] = dArray[j][i];
            }
            nArrayArray[i] = QuickSort.sort(dArray2);
        }
        return nArrayArray;
    }

    public static GaussianRadialBasis learnGaussianRadialBasis(double[][] dArray, double[][] dArray2) {
        int n = dArray2.length;
        KMeans kMeans = new KMeans(dArray, n, 10);
        System.arraycopy(kMeans.centroids(), 0, dArray2, 0, n);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double d2 = Math.distance(dArray2[i], dArray2[j]);
                if (!(d < d2)) continue;
                d = d2;
            }
        }
        return new GaussianRadialBasis(d /= Math.sqrt(2 * n));
    }

    public static GaussianRadialBasis[] learnGaussianRadialBasis(double[][] dArray, double[][] dArray2, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid number of nearest neighbors: " + n);
        }
        int n2 = dArray2.length;
        KMeans kMeans = new KMeans(dArray, n2, 10);
        System.arraycopy(kMeans.centroids(), 0, dArray2, 0, n2);
        n = Math.min(n, n2 - 1);
        double[] dArray3 = new double[n2];
        GaussianRadialBasis[] gaussianRadialBasisArray = new GaussianRadialBasis[n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray3[j] = Math.distance(dArray2[i], dArray2[j]);
            }
            Arrays.sort(dArray3);
            double d = 0.0;
            for (int j = 1; j <= n; ++j) {
                d += dArray3[j];
            }
            gaussianRadialBasisArray[i] = new GaussianRadialBasis(d /= (double)n);
        }
        return gaussianRadialBasisArray;
    }

    public static GaussianRadialBasis[] learnGaussianRadialBasis(double[][] dArray, double[][] dArray2, double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Invalid scaling parameter: " + d);
        }
        int n = dArray2.length;
        KMeans kMeans = new KMeans(dArray, n, 10);
        System.arraycopy(kMeans.centroids(), 0, dArray2, 0, n);
        int n2 = dArray.length;
        int[] nArray = kMeans.getClusterLabel();
        double[] dArray3 = new double[n];
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            dArray3[n3] = dArray3[n3] + Math.squaredDistance(dArray[i], dArray2[nArray[i]]);
        }
        int[] nArray2 = kMeans.getClusterSize();
        GaussianRadialBasis[] gaussianRadialBasisArray = new GaussianRadialBasis[n];
        for (int i = 0; i < n; ++i) {
            if (nArray2[i] >= 5 || dArray3[i] != 0.0) {
                dArray3[i] = Math.sqrt(dArray3[i] / (double)nArray2[i]);
            } else {
                dArray3[i] = Double.POSITIVE_INFINITY;
                for (int j = 0; j < n; ++j) {
                    double d2;
                    if (i == j || !((d2 = Math.distance(dArray2[i], dArray2[j])) < dArray3[i])) continue;
                    dArray3[i] = d2;
                }
                int n4 = i;
                dArray3[n4] = dArray3[n4] / 2.0;
            }
            gaussianRadialBasisArray[i] = new GaussianRadialBasis(d * dArray3[i]);
        }
        return gaussianRadialBasisArray;
    }

    public static <T> GaussianRadialBasis learnGaussianRadialBasis(T[] TArray, T[] TArray2, Metric<T> metric) {
        int n = TArray2.length;
        CLARANS<T> cLARANS = new CLARANS<T>(TArray, metric, n, Math.min(100, (int)Math.round(0.01 * (double)n * (double)(TArray.length - n))));
        System.arraycopy(cLARANS.medoids(), 0, TArray2, 0, n);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                double d2 = metric.d(TArray2[i], TArray2[j]);
                if (!(d < d2)) continue;
                d = d2;
            }
        }
        return new GaussianRadialBasis(d /= Math.sqrt(2 * n));
    }

    public static <T> GaussianRadialBasis[] learnGaussianRadialBasis(T[] TArray, T[] TArray2, Metric<T> metric, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid number of nearest neighbors: " + n);
        }
        int n2 = TArray2.length;
        CLARANS<T> cLARANS = new CLARANS<T>(TArray, metric, n2, Math.min(100, (int)Math.round(0.01 * (double)n2 * (double)(TArray.length - n2))));
        System.arraycopy(cLARANS.medoids(), 0, TArray2, 0, n2);
        n = Math.min(n, n2 - 1);
        double[] dArray = new double[n2];
        GaussianRadialBasis[] gaussianRadialBasisArray = new GaussianRadialBasis[n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[j] = metric.d(TArray2[i], TArray2[j]);
            }
            Arrays.sort(dArray);
            double d = 0.0;
            for (int j = 1; j <= n; ++j) {
                d += dArray[j];
            }
            gaussianRadialBasisArray[i] = new GaussianRadialBasis(d /= (double)n);
        }
        return gaussianRadialBasisArray;
    }

    public static <T> GaussianRadialBasis[] learnGaussianRadialBasis(T[] TArray, T[] TArray2, Metric<T> metric, double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Invalid scaling parameter: " + d);
        }
        int n = TArray2.length;
        CLARANS<T> cLARANS = new CLARANS<T>(TArray, metric, n, Math.min(100, (int)Math.round(0.01 * (double)n * (double)(TArray.length - n))));
        System.arraycopy(cLARANS.medoids(), 0, TArray2, 0, n);
        int n2 = TArray.length;
        int[] nArray = cLARANS.getClusterLabel();
        double[] dArray = new double[n];
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            dArray[n3] = dArray[n3] + Math.sqr(metric.d(TArray[i], TArray2[nArray[i]]));
        }
        int[] nArray2 = cLARANS.getClusterSize();
        GaussianRadialBasis[] gaussianRadialBasisArray = new GaussianRadialBasis[n];
        for (int i = 0; i < n; ++i) {
            if (nArray2[i] >= 5 || dArray[i] == 0.0) {
                dArray[i] = Math.sqrt(dArray[i] / (double)nArray2[i]);
            } else {
                dArray[i] = Double.POSITIVE_INFINITY;
                for (int j = 0; j < n; ++j) {
                    double d2;
                    if (i == j || !((d2 = metric.d(TArray2[i], TArray2[j])) < dArray[i])) continue;
                    dArray[i] = d2;
                }
                int n4 = i;
                dArray[n4] = dArray[n4] / 2.0;
            }
            gaussianRadialBasisArray[i] = new GaussianRadialBasis(d * dArray[i]);
        }
        return gaussianRadialBasisArray;
    }
}

