/*
 * Decompiled with CFR 0.152.
 */
package smile.stat.distribution;

import smile.math.special.Erf;
import smile.stat.distribution.AbstractDistribution;
import smile.stat.distribution.ExponentialFamily;
import smile.stat.distribution.Mixture;

public class GaussianDistribution
extends AbstractDistribution
implements ExponentialFamily {
    private static final long serialVersionUID = 1L;
    private static final double LOG2PIE_2 = smile.math.Math.log(17.079468445347132) / 2.0;
    private static final double LOG2PI_2 = smile.math.Math.log(Math.PI * 2) / 2.0;
    private static final GaussianDistribution singleton = new GaussianDistribution(0.0, 1.0);
    private double mu;
    private double sigma;
    private double variance;
    private double entropy;
    private double pdfConstant;
    private Double boxMuller;

    public GaussianDistribution(double d, double d2) {
        this.mu = d;
        this.sigma = d2;
        this.variance = d2 * d2;
        this.entropy = smile.math.Math.log(d2) + LOG2PIE_2;
        this.pdfConstant = smile.math.Math.log(d2) + LOG2PI_2;
    }

    public GaussianDistribution(double[] dArray) {
        this.mu = smile.math.Math.mean(dArray);
        this.sigma = smile.math.Math.sd(dArray);
        this.variance = this.sigma * this.sigma;
        this.entropy = smile.math.Math.log(this.sigma) + LOG2PIE_2;
        this.pdfConstant = smile.math.Math.log(this.sigma) + LOG2PI_2;
    }

    public static GaussianDistribution getInstance() {
        return singleton;
    }

    @Override
    public int npara() {
        return 2;
    }

    @Override
    public double mean() {
        return this.mu;
    }

    @Override
    public double var() {
        return this.variance;
    }

    @Override
    public double sd() {
        return this.sigma;
    }

    @Override
    public double entropy() {
        return this.entropy;
    }

    public String toString() {
        return String.format("Gaussian Distribution(%.4f, %.4f)", this.mu, this.sigma);
    }

    @Override
    public double rand() {
        double d;
        if (this.boxMuller != null) {
            d = this.boxMuller;
            this.boxMuller = null;
        } else {
            double d2;
            double d3;
            double d4;
            while ((d4 = (d3 = smile.math.Math.random(-1.0, 1.0)) * d3 + (d2 = smile.math.Math.random(-1.0, 1.0)) * d2) >= 1.0) {
            }
            double d5 = smile.math.Math.sqrt(-2.0 * smile.math.Math.log(d4) / d4);
            this.boxMuller = new Double(d3 * d5);
            d = d2 * d5;
        }
        return this.mu + this.sigma * d;
    }

    public double randInverseCDF() {
        double d;
        double d2 = smile.math.Math.random();
        while (d2 == 0.0) {
            d2 = smile.math.Math.random();
        }
        double d3 = d2 - 0.5;
        if (smile.math.Math.abs(d3) < 0.42) {
            double d4 = d3 * d3;
            d = d3 * (((-25.44106049637 * d4 + 41.39119773534) * d4 + -18.61500062529) * d4 + 2.50662823884) / ((((3.13082909833 * d4 + -21.06224101826) * d4 + 23.08336743743) * d4 + -8.4735109309) * d4 + 1.0);
        } else {
            double d5 = d2;
            if (d3 > 0.0) {
                d5 = 1.0 - d2;
            }
            d5 = smile.math.Math.log(-smile.math.Math.log(d5));
            d = 0.3374754822726147 + d5 * (0.9761690190917186 + d5 * (0.1607979714918209 + d5 * (0.0276438810333863 + d5 * (0.0038405729373609 + d5 * (3.951896511919E-4 + d5 * (3.21767881768E-5 + d5 * (2.888167364E-7 + d5 * 3.960315187E-7)))))));
            if (d3 < 0.0) {
                d = -d;
            }
        }
        return this.mu + this.sigma * d;
    }

    @Override
    public double p(double d) {
        if (this.sigma == 0.0) {
            if (d == this.mu) {
                return 1.0;
            }
            return 0.0;
        }
        return smile.math.Math.exp(this.logp(d));
    }

    @Override
    public double logp(double d) {
        if (this.sigma == 0.0) {
            if (d == this.mu) {
                return 0.0;
            }
            return Double.NEGATIVE_INFINITY;
        }
        double d2 = d - this.mu;
        return -0.5 * d2 * d2 / this.variance - this.pdfConstant;
    }

    @Override
    public double cdf(double d) {
        if (this.sigma == 0.0) {
            if (d < this.mu) {
                return 0.0;
            }
            return 1.0;
        }
        return 0.5 * Erf.erfc(-0.7071067811865476 * (d - this.mu) / this.sigma);
    }

    @Override
    public double quantile(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Invalid p: " + d);
        }
        if (this.sigma == 0.0) {
            if (d < 1.0) {
                return this.mu - 1.0E-10;
            }
            return this.mu;
        }
        return -1.4142135623730951 * this.sigma * Erf.inverfc(2.0 * d) + this.mu;
    }

    @Override
    public Mixture.Component M(double[] dArray, double[] dArray2) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d += dArray2[n];
            d2 += dArray[n] * dArray2[n];
        }
        d2 /= d;
        for (n = 0; n < dArray.length; ++n) {
            double d4 = dArray[n] - d2;
            d3 += d4 * d4 * dArray2[n];
        }
        d3 = smile.math.Math.sqrt(d3 / d);
        Mixture.Component component = new Mixture.Component();
        component.priori = d;
        component.distribution = new GaussianDistribution(d2, d3);
        return component;
    }
}

