/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.Cholesky;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;

public class SVD {
    protected DenseMatrix U;
    protected DenseMatrix V;
    protected double[] s;
    protected boolean full;
    protected int m;
    protected int n;
    protected double tol;

    public SVD(DenseMatrix denseMatrix, DenseMatrix denseMatrix2, double[] dArray) {
        this.U = denseMatrix;
        this.V = denseMatrix2;
        this.s = dArray;
        this.m = denseMatrix.nrows();
        this.n = denseMatrix2.nrows();
        this.full = dArray.length == Math.min(this.m, this.n);
        this.tol = 0.5 * Math.sqrt((double)(this.m + this.n) + 1.0) * dArray[0] * Math.EPSILON;
    }

    public DenseMatrix getU() {
        return this.U;
    }

    public DenseMatrix getV() {
        return this.V;
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public DenseMatrix getS() {
        DenseMatrix denseMatrix = Matrix.zeros(this.U.nrows(), this.V.nrows());
        for (int i = 0; i < this.s.length; ++i) {
            denseMatrix.set(i, i, this.s[i]);
        }
        return denseMatrix;
    }

    public double norm() {
        return this.s[0];
    }

    public int rank() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int n = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] > this.tol)) continue;
            ++n;
        }
        return n;
    }

    public int nullity() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int n = 0;
        for (int i = 0; i < this.s.length; ++i) {
            if (!(this.s[i] <= this.tol)) continue;
            ++n;
        }
        return n;
    }

    public double condition() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        return this.s[0] <= 0.0 || this.s[this.n - 1] <= 0.0 ? Double.POSITIVE_INFINITY : this.s[0] / this.s[this.n - 1];
    }

    public DenseMatrix range() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int n = 0;
        DenseMatrix denseMatrix = Matrix.zeros(this.m, this.rank());
        for (int i = 0; i < this.n; ++i) {
            if (!(this.s[i] > this.tol)) continue;
            for (int j = 0; j < this.m; ++j) {
                denseMatrix.set(j, n, this.U.get(j, i));
            }
            ++n;
        }
        return denseMatrix;
    }

    public DenseMatrix nullspace() {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        int n = 0;
        DenseMatrix denseMatrix = Matrix.zeros(this.n, this.nullity());
        for (int i = 0; i < this.n; ++i) {
            if (!(this.s[i] <= this.tol)) continue;
            for (int j = 0; j < this.n; ++j) {
                denseMatrix.set(j, n, this.V.get(j, i));
            }
            ++n;
        }
        return denseMatrix;
    }

    public Cholesky CholeskyOfAtA() {
        DenseMatrix denseMatrix = Matrix.zeros(this.V.nrows(), this.V.ncols());
        for (int i = 0; i < this.V.nrows(); ++i) {
            for (int j = 0; j < this.V.ncols(); ++j) {
                denseMatrix.set(i, j, this.V.get(i, j) * this.s[j]);
            }
        }
        return new Cholesky(denseMatrix.aat());
    }

    public void solve(double[] dArray, double[] dArray2) {
        int n;
        double d;
        int n2;
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        if (dArray.length != this.m || dArray2.length != this.n) {
            throw new IllegalArgumentException("Dimensions do not agree.");
        }
        double[] dArray3 = new double[this.n];
        for (n2 = 0; n2 < this.n; ++n2) {
            d = 0.0;
            if (this.s[n2] > this.tol) {
                for (n = 0; n < this.m; ++n) {
                    d += this.U.get(n, n2) * dArray[n];
                }
                d /= this.s[n2];
            }
            dArray3[n2] = d;
        }
        for (n2 = 0; n2 < this.n; ++n2) {
            d = 0.0;
            for (n = 0; n < this.n; ++n) {
                d += this.V.get(n2, n) * dArray3[n];
            }
            dArray2[n2] = d;
        }
    }

    public void solve(DenseMatrix denseMatrix) {
        if (!this.full) {
            throw new IllegalStateException("This is not a FULL singular value decomposition.");
        }
        if (denseMatrix.nrows() != this.m) {
            throw new IllegalArgumentException("Dimensions do not agree.");
        }
        double[] dArray = new double[this.m];
        double[] dArray2 = new double[this.n];
        int n = denseMatrix.ncols();
        for (int i = 0; i < n; ++i) {
            int n2;
            for (n2 = 0; n2 < this.m; ++n2) {
                dArray[n2] = denseMatrix.get(n2, i);
            }
            this.solve(dArray, dArray2);
            for (n2 = 0; n2 < this.n; ++n2) {
                denseMatrix.set(n2, i, dArray2[n2]);
            }
        }
    }
}

