/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.Math;
import smile.math.matrix.Cholesky;
import smile.math.matrix.EVD;
import smile.math.matrix.LU;
import smile.math.matrix.Matrix;
import smile.math.matrix.MatrixMultiplication;
import smile.math.matrix.QR;
import smile.math.matrix.SVD;

public interface DenseMatrix
extends Matrix,
MatrixMultiplication<DenseMatrix, DenseMatrix> {
    public double[] data();

    public int ld();

    public double set(int var1, int var2, double var3);

    default public double update(int n, int n2, double d) {
        return this.set(n, n2, d);
    }

    public LU lu();

    default public LU lu(boolean bl) {
        DenseMatrix denseMatrix = bl ? this : this.copy();
        return denseMatrix.lu();
    }

    public Cholesky cholesky();

    default public Cholesky cholesky(boolean bl) {
        DenseMatrix denseMatrix = bl ? this : this.copy();
        return denseMatrix.cholesky();
    }

    public QR qr();

    default public QR qr(boolean bl) {
        DenseMatrix denseMatrix = bl ? this : this.copy();
        return denseMatrix.qr();
    }

    public SVD svd();

    default public SVD svd(boolean bl) {
        DenseMatrix denseMatrix = bl ? this : this.copy();
        return denseMatrix.svd();
    }

    public EVD eigen();

    default public EVD eigen(boolean bl) {
        DenseMatrix denseMatrix = bl ? this : this.copy();
        return denseMatrix.eigen();
    }

    public double[] eig();

    default public double[] eig(boolean bl) {
        DenseMatrix denseMatrix = bl ? this : this.copy();
        return denseMatrix.eig();
    }

    @Override
    public DenseMatrix transpose();

    default public DenseMatrix inverse() {
        return this.inverse(false);
    }

    default public DenseMatrix inverse(boolean bl) {
        if (this.nrows() != this.ncols()) {
            throw new UnsupportedOperationException("Call inverse() on a non-square matrix");
        }
        LU lU = this.lu(bl);
        return lU.inverse();
    }

    default public double norm1() {
        int n = this.nrows();
        int n2 = this.ncols();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n; ++j) {
                d2 += Math.abs(this.get(j, i));
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    default public double norm2() {
        return this.svd(false).norm();
    }

    default public double norm() {
        return this.norm2();
    }

    default public double normInf() {
        int n = this.nrows();
        int n2 = this.ncols();
        double[] dArray = new double[n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = j;
                dArray[n3] = dArray[n3] + Math.abs(this.get(j, i));
            }
        }
        return Math.max(dArray);
    }

    default public double normFro() {
        int n = this.nrows();
        int n2 = this.ncols();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                d = Math.hypot(d, this.get(j, i));
            }
        }
        return d;
    }

    default public double xax(double[] dArray) {
        if (this.nrows() != this.ncols()) {
            throw new IllegalArgumentException("The matrix is not square");
        }
        if (this.nrows() != dArray.length) {
            throw new IllegalArgumentException("Matrix and vector size doesn't match for x' * A * x");
        }
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                d += this.get(j, i) * dArray[j] * dArray[i];
            }
        }
        return d;
    }

    default public double[] rowSums() {
        int n = this.nrows();
        int n2 = this.ncols();
        double[] dArray = new double[n];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = j;
                dArray[n3] = dArray[n3] + this.get(j, i);
            }
        }
        return dArray;
    }

    default public double[] rowMeans() {
        int n;
        int n2 = this.nrows();
        int n3 = this.ncols();
        double[] dArray = new double[n2];
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                int n4 = i;
                dArray[n4] = dArray[n4] + this.get(i, n);
            }
        }
        n = 0;
        while (n < n2) {
            int n5 = n++;
            dArray[n5] = dArray[n5] / (double)n3;
        }
        return dArray;
    }

    default public double[] colSums() {
        int n = this.nrows();
        int n2 = this.ncols();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n3 = i;
                dArray[n3] = dArray[n3] + this.get(j, i);
            }
        }
        return dArray;
    }

    default public double[] colMeans() {
        int n = this.nrows();
        int n2 = this.ncols();
        double[] dArray = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            for (int i = 0; i < n; ++i) {
                int n4 = n3;
                dArray[n4] = dArray[n4] + this.get(i, n3);
            }
            int n5 = n3++;
            dArray[n5] = dArray[n5] / (double)n;
        }
        return dArray;
    }

    public DenseMatrix copy();

    @Override
    public DenseMatrix ata();

    @Override
    public DenseMatrix aat();

    public double add(int var1, int var2, double var3);

    public double sub(int var1, int var2, double var3);

    public double mul(int var1, int var2, double var3);

    public double div(int var1, int var2, double var3);

    default public DenseMatrix add(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != denseMatrix2.nrows() || this.ncols() != denseMatrix2.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix2.set(j, i, this.get(j, i) + denseMatrix.get(j, i));
            }
        }
        return denseMatrix2;
    }

    default public DenseMatrix add(DenseMatrix denseMatrix) {
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.add(j, i, denseMatrix.get(j, i));
            }
        }
        return this;
    }

    default public DenseMatrix sub(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != denseMatrix2.nrows() || this.ncols() != denseMatrix2.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix2.set(j, i, this.get(j, i) - denseMatrix.get(j, i));
            }
        }
        return denseMatrix2;
    }

    default public DenseMatrix sub(DenseMatrix denseMatrix) {
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.sub(j, i, denseMatrix.get(j, i));
            }
        }
        return this;
    }

    default public DenseMatrix mul(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != denseMatrix2.nrows() || this.ncols() != denseMatrix2.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix2.set(j, i, this.get(j, i) * denseMatrix.get(j, i));
            }
        }
        return denseMatrix2;
    }

    default public DenseMatrix mul(DenseMatrix denseMatrix) {
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.mul(j, i, denseMatrix.get(j, i));
            }
        }
        return this;
    }

    default public DenseMatrix div(DenseMatrix denseMatrix, DenseMatrix denseMatrix2) {
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        if (this.nrows() != denseMatrix2.nrows() || this.ncols() != denseMatrix2.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix2.set(j, i, this.get(j, i) / denseMatrix.get(j, i));
            }
        }
        return denseMatrix2;
    }

    default public DenseMatrix div(DenseMatrix denseMatrix) {
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.div(j, i, denseMatrix.get(j, i));
            }
        }
        return this;
    }

    default public DenseMatrix add(double d, DenseMatrix denseMatrix) {
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix.set(j, i, this.get(j, i) + d);
            }
        }
        return denseMatrix;
    }

    default public DenseMatrix add(double d) {
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.add(j, i, d);
            }
        }
        return this;
    }

    default public DenseMatrix sub(double d, DenseMatrix denseMatrix) {
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix.set(j, i, this.get(j, i) - d);
            }
        }
        return denseMatrix;
    }

    default public DenseMatrix sub(double d) {
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.sub(j, i, d);
            }
        }
        return this;
    }

    default public DenseMatrix mul(double d, DenseMatrix denseMatrix) {
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix.set(j, i, this.get(j, i) * d);
            }
        }
        return denseMatrix;
    }

    default public DenseMatrix mul(double d) {
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.mul(j, i, d);
            }
        }
        return this;
    }

    default public DenseMatrix div(double d, DenseMatrix denseMatrix) {
        if (this.nrows() != denseMatrix.nrows() || this.ncols() != denseMatrix.ncols()) {
            throw new IllegalArgumentException("Matrix is not of same size.");
        }
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                denseMatrix.set(j, i, this.get(j, i) / d);
            }
        }
        return denseMatrix;
    }

    default public DenseMatrix div(double d) {
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.div(j, i, d);
            }
        }
        return this;
    }

    default public DenseMatrix replaceNaN(double d) {
        int n = this.nrows();
        int n2 = this.ncols();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!Double.isNaN(this.get(j, i))) continue;
                this.set(j, i, d);
            }
        }
        return this;
    }

    default public double sum() {
        int n = this.nrows();
        int n2 = this.ncols();
        double d = 0.0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                d += this.get(j, i);
            }
        }
        return d;
    }

    default public double[][] array() {
        int n = this.nrows();
        int n2 = this.ncols();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[j][i] = this.get(j, i);
            }
        }
        return dArray;
    }
}

