/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import smile.data.Attribute;

public class NominalAttribute
extends Attribute {
    private boolean open = true;
    private List<String> values = new ArrayList<String>();
    private HashMap<String, Integer> map = new HashMap();

    public NominalAttribute(String string) {
        this(string, 1.0);
    }

    public NominalAttribute(String string, double d) {
        this(string, null, d);
    }

    public NominalAttribute(String string, String string2) {
        this(string, string2, 1.0);
    }

    public NominalAttribute(String string, String string2, double d) {
        super(Attribute.Type.NOMINAL, string, string2, d);
        this.open = true;
    }

    public NominalAttribute(String string, String[] stringArray) {
        this(string, 1.0, stringArray);
    }

    public NominalAttribute(String string, double d, String[] stringArray) {
        this(string, null, d, stringArray);
    }

    public NominalAttribute(String string, String string2, String[] stringArray) {
        this(string, string2, 1.0, stringArray);
    }

    public NominalAttribute(String string, String string2, double d, String[] stringArray) {
        super(Attribute.Type.NOMINAL, string, string2, d);
        this.open = false;
        for (int i = 0; i < stringArray.length; ++i) {
            this.values.add(stringArray[i]);
            this.map.put(stringArray[i], i);
        }
    }

    public int size() {
        return this.values.size();
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean bl) {
        this.open = bl;
    }

    public String[] values() {
        return this.values.toArray(new String[this.values.size()]);
    }

    @Override
    public double valueOf(String string) throws ParseException {
        Integer n = this.map.get(string);
        if (n == null) {
            if (this.open) {
                n = this.values.size();
                this.map.put(string, n);
                this.values.add(string);
            } else {
                throw new ParseException("Invalid string value: " + string, 0);
            }
        }
        return n.intValue();
    }

    @Override
    public String toString(double d) {
        if (Double.isNaN(d)) {
            return null;
        }
        if (Math.floor(d) != d) {
            throw new IllegalArgumentException("The input nominal value is not an integer: " + d);
        }
        if (d < 0.0 || d >= (double)this.values.size()) {
            throw new IllegalArgumentException("Invalid nominal value: " + d);
        }
        return this.values.get((int)d);
    }
}

