/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import smile.data.Attribute;
import smile.data.AttributeVector;
import smile.data.Datum;

public class Dataset<E>
implements Iterable<Datum<E>> {
    protected static final String DATASET_HAS_NO_RESPONSE = "The dataset has no response values.";
    protected static final String RESPONSE_NOT_NOMINAL = "The response variable is not nominal.";
    protected static final String RESPONSE_NOT_NUMERIC = "The response variable is not numeric.";
    protected String name;
    protected String description = "";
    protected Attribute response = null;
    protected List<Datum<E>> data = new ArrayList<Datum<E>>();

    public Dataset() {
        this("Dataset");
    }

    public Dataset(String string) {
        this.name = string;
    }

    public Dataset(Attribute attribute) {
        this("Dataset", attribute);
    }

    public Dataset(String string, Attribute attribute) {
        this.name = string;
        this.response = attribute;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public Attribute responseAttribute() {
        return this.response;
    }

    public AttributeVector response() {
        double[] dArray = new double[this.data.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.data.get((int)i).y;
        }
        return new AttributeVector(this.response, dArray);
    }

    public int size() {
        return this.data.size();
    }

    public List<Datum<E>> data() {
        return this.data;
    }

    public Datum<E> add(Datum<E> datum) {
        this.data.add(datum);
        return datum;
    }

    public Datum<E> add(E e) {
        return this.add((E)new Datum<E>(e));
    }

    public Datum<E> add(E e, int n) {
        if (this.response == null) {
            throw new IllegalArgumentException(DATASET_HAS_NO_RESPONSE);
        }
        if (this.response.getType() != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException(RESPONSE_NOT_NOMINAL);
        }
        return this.add((E)new Datum<E>(e, n));
    }

    public Datum<E> add(E e, int n, double d) {
        if (this.response == null) {
            throw new IllegalArgumentException(DATASET_HAS_NO_RESPONSE);
        }
        if (this.response.getType() != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException(RESPONSE_NOT_NOMINAL);
        }
        return this.add((E)new Datum<E>(e, n, d));
    }

    public Datum<E> add(E e, double d) {
        if (this.response == null) {
            throw new IllegalArgumentException(DATASET_HAS_NO_RESPONSE);
        }
        if (this.response.getType() != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException(RESPONSE_NOT_NUMERIC);
        }
        return this.add((E)new Datum<E>(e, d));
    }

    public Datum<E> add(E e, double d, double d2) {
        if (this.response == null) {
            throw new IllegalArgumentException(DATASET_HAS_NO_RESPONSE);
        }
        if (this.response.getType() != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException(RESPONSE_NOT_NUMERIC);
        }
        return this.add((E)new Datum<E>(e, d, d2));
    }

    public Datum<E> remove(int n) {
        return this.data.remove(n);
    }

    public Datum<E> get(int n) {
        return this.data.get(n);
    }

    @Override
    public Iterator<Datum<E>> iterator() {
        return this.data.iterator();
    }

    public double[] y() {
        double[] dArray = new double[this.size()];
        this.toArray(dArray);
        return dArray;
    }

    public int[] labels() {
        int[] nArray = new int[this.size()];
        this.toArray(nArray);
        return nArray;
    }

    public E[] toArray(E[] objectArray) {
        int n;
        int n2 = this.data.size();
        if (objectArray.length < n2) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        }
        for (n = 0; n < n2; ++n) {
            objectArray[n] = this.get((int)n).x;
        }
        for (n = n2; n < objectArray.length; ++n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    public int[] toArray(int[] nArray) {
        int n;
        if (this.response == null) {
            throw new IllegalArgumentException(DATASET_HAS_NO_RESPONSE);
        }
        if (this.response.getType() != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException(RESPONSE_NOT_NOMINAL);
        }
        int n2 = this.data.size();
        if (nArray.length < n2) {
            nArray = new int[n2];
        }
        for (n = 0; n < n2; ++n) {
            Datum<E> datum = this.get(n);
            nArray[n] = Double.isNaN(datum.y) ? Integer.MIN_VALUE : (int)this.get((int)n).y;
        }
        for (n = n2; n < nArray.length; ++n) {
            nArray[n] = Integer.MIN_VALUE;
        }
        return nArray;
    }

    public double[] toArray(double[] dArray) {
        int n;
        if (this.response == null) {
            throw new IllegalArgumentException(DATASET_HAS_NO_RESPONSE);
        }
        if (this.response.getType() != Attribute.Type.NUMERIC) {
            throw new IllegalArgumentException(RESPONSE_NOT_NUMERIC);
        }
        int n2 = this.data.size();
        if (dArray.length < n2) {
            dArray = new double[n2];
        }
        for (n = 0; n < n2; ++n) {
            dArray[n] = this.get((int)n).y;
        }
        for (n = n2; n < dArray.length; ++n) {
            dArray[n] = Double.NaN;
        }
        return dArray;
    }

    public String[] toArray(String[] stringArray) {
        int n;
        int n2 = this.data.size();
        if (stringArray.length < n2) {
            stringArray = new String[n2];
        }
        for (n = 0; n < n2; ++n) {
            stringArray[n] = this.data.get((int)n).name;
        }
        for (n = n2; n < stringArray.length; ++n) {
            stringArray[n] = null;
        }
        return stringArray;
    }

    public Timestamp[] toArray(Timestamp[] timestampArray) {
        int n;
        int n2 = this.data.size();
        if (timestampArray.length < n2) {
            timestampArray = new Timestamp[n2];
        }
        for (n = 0; n < n2; ++n) {
            timestampArray[n] = this.data.get((int)n).timestamp;
        }
        for (n = n2; n < timestampArray.length; ++n) {
            timestampArray[n] = null;
        }
        return timestampArray;
    }
}

