/*
 * Decompiled with CFR 0.152.
 */
package smile.data;

import java.util.Date;
import java.util.HashSet;
import java.util.stream.IntStream;
import smile.data.Attribute;
import smile.data.AttributeVector;
import smile.data.Dataset;
import smile.data.DateAttribute;
import smile.data.Datum;
import smile.data.NumericAttribute;
import smile.math.Math;

public class AttributeDataset
extends Dataset<double[]> {
    private Attribute[] attributes;

    public AttributeDataset(String string, Attribute[] attributeArray) {
        super(string);
        this.attributes = attributeArray;
    }

    public AttributeDataset(String string, Attribute[] attributeArray, Attribute attribute) {
        super(string, attribute);
        this.attributes = attributeArray;
    }

    public AttributeDataset(String string, double[][] dArray, double[] dArray2) {
        this(string, (Attribute[])IntStream.range(0, dArray[0].length).mapToObj(n -> new NumericAttribute("Var " + (n + 1))).toArray(NumericAttribute[]::new), dArray, new NumericAttribute("response"), dArray2);
    }

    public AttributeDataset(String string, Attribute[] attributeArray, double[][] dArray, Attribute attribute, double[] dArray2) {
        this(string, attributeArray, attribute);
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", dArray.length, dArray2.length));
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.add(dArray[i], dArray2[i]);
        }
    }

    public Attribute[] attributes() {
        return this.attributes;
    }

    public double[][] x() {
        double[][] dArrayArray = new double[this.size()][];
        this.toArray((E[])dArrayArray);
        return dArrayArray;
    }

    @Override
    public Datum<double[]> add(Datum<double[]> datum) {
        if (!(datum instanceof Row)) {
            throw new IllegalArgumentException("The added Datum is not of type AttributeDataset.Row");
        }
        return super.add(datum);
    }

    public Row add(Row row) {
        this.data.add(row);
        return row;
    }

    public Row add(double[] dArray) {
        return this.add(new Row(dArray));
    }

    public Row add(double[] dArray, int n) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.getType() != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException("The response variable is not nominal.");
        }
        return this.add(new Row(dArray, (double)n));
    }

    public Row add(double[] dArray, int n, double d) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        if (this.response.getType() != Attribute.Type.NOMINAL) {
            throw new IllegalArgumentException("The response variable is not nominal.");
        }
        return this.add(new Row(dArray, n, d));
    }

    public Row add(double[] dArray, double d) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        return this.add(new Row(dArray, d));
    }

    public Row add(double[] dArray, double d, double d2) {
        if (this.response == null) {
            throw new IllegalArgumentException("The dataset has no response values.");
        }
        return this.add(new Row(dArray, d, d2));
    }

    public String toString() {
        int n = 10;
        String string = this.toString(0, n);
        if (this.size() <= n) {
            return string;
        }
        return string + "\n" + (this.size() - n) + " more rows...";
    }

    public AttributeDataset head(int n) {
        return this.range(0, n);
    }

    public AttributeDataset tail(int n) {
        return this.range(this.size() - n, this.size());
    }

    public AttributeDataset range(int n, int n2) {
        AttributeDataset attributeDataset = new AttributeDataset(this.name + '[' + n + ", " + n2 + ']', this.attributes, this.response);
        attributeDataset.description = this.description;
        for (int i = n; i < n2; ++i) {
            attributeDataset.add(this.get(i));
        }
        return attributeDataset;
    }

    public String toString(int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            stringBuilder.append(this.name);
            stringBuilder.append(System.getProperty("line.separator"));
        }
        if (this.description != null && !this.description.isEmpty()) {
            stringBuilder.append(this.description);
            stringBuilder.append(System.getProperty("line.separator"));
        }
        stringBuilder.append('\t');
        if (this.response != null) {
            stringBuilder.append(this.response.getName());
        }
        int n4 = this.attributes.length;
        for (n3 = 0; n3 < n4; ++n3) {
            stringBuilder.append('\t');
            stringBuilder.append(this.attributes[n3].getName());
        }
        n3 = Math.min(this.data.size(), n2);
        for (int i = n; i < n3; ++i) {
            stringBuilder.append(System.getProperty("line.separator"));
            Datum datum = (Datum)this.data.get(i);
            if (datum.name != null) {
                stringBuilder.append(datum.name);
            } else {
                stringBuilder.append('[');
                stringBuilder.append(i + 1);
                stringBuilder.append(']');
            }
            stringBuilder.append('\t');
            if (this.response != null) {
                double d = ((Datum)this.data.get((int)i)).y;
                if (this.response.getType() == Attribute.Type.NUMERIC) {
                    stringBuilder.append(String.format("%1.4f", d));
                } else {
                    stringBuilder.append(this.response.toString(d));
                }
            }
            double[] dArray = (double[])datum.x;
            for (int j = 0; j < n4; ++j) {
                stringBuilder.append('\t');
                Attribute attribute = this.attributes[j];
                if (attribute.getType() == Attribute.Type.NUMERIC) {
                    stringBuilder.append(String.format("%1.4f", dArray[j]));
                    continue;
                }
                stringBuilder.append(attribute.toString(dArray[j]));
            }
        }
        return stringBuilder.toString();
    }

    public AttributeVector column(int n) {
        if (n < 0 || n >= this.attributes.length) {
            throw new IllegalArgumentException("Invalid column index: " + n);
        }
        double[] dArray = new double[this.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = ((double[])((Datum)this.data.get((int)i)).x)[n];
        }
        return new AttributeVector(this.attributes[n], dArray);
    }

    public AttributeVector column(String string) {
        int n = -1;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (!this.attributes[i].getName().equals(string)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException("Invalid column name: " + string);
        }
        return this.column(n);
    }

    public AttributeDataset columns(String ... stringArray) {
        Attribute[] attributeArray = new Attribute[stringArray.length];
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < this.attributes.length; ++j) {
                if (!this.attributes[j].getName().equals(stringArray[i])) continue;
                nArray[i] = j;
                attributeArray[i] = this.attributes[j];
                break;
            }
            if (attributeArray[i] != null) continue;
            throw new IllegalArgumentException("Unknown column: " + stringArray[i]);
        }
        AttributeDataset attributeDataset = new AttributeDataset(this.name, attributeArray, this.response);
        for (Datum datum : this.data) {
            double[] dArray = new double[nArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = ((double[])datum.x)[nArray[i]];
            }
            Row row = this.response == null ? attributeDataset.add(dArray) : attributeDataset.add(dArray, datum.y);
            row.name = datum.name;
            row.weight = datum.weight;
            row.description = datum.description;
            row.timestamp = datum.timestamp;
        }
        return attributeDataset;
    }

    /*
     * WARNING - void declaration
     */
    public AttributeDataset remove(String ... stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Attribute object : this.attributes) {
            hashSet.add(object.getName());
        }
        for (String string : stringArray) {
            hashSet.remove(string);
        }
        Object[] objectArray = new Attribute[hashSet.size()];
        int[] nArray = new int[hashSet.size()];
        boolean bl = false;
        for (int i = 0; i < this.attributes.length; ++i) {
            void var6_12;
            if (!hashSet.contains(this.attributes[i].getName())) continue;
            nArray[var6_12] = i;
            objectArray[var6_12] = this.attributes[i];
            ++var6_12;
        }
        AttributeDataset attributeDataset = new AttributeDataset(this.name, (Attribute[])objectArray, this.response);
        for (Datum datum : this.data) {
            double[] dArray = new double[nArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = ((double[])datum.x)[nArray[i]];
            }
            Row row = this.response == null ? attributeDataset.add(dArray) : attributeDataset.add(dArray, datum.y);
            row.name = datum.name;
            row.weight = datum.weight;
            row.description = datum.description;
            row.timestamp = datum.timestamp;
        }
        return attributeDataset;
    }

    public AttributeDataset summary() {
        Attribute[] attributeArray = new Attribute[]{new NumericAttribute("min"), new NumericAttribute("q1"), new NumericAttribute("median"), new NumericAttribute("mean"), new NumericAttribute("q3"), new NumericAttribute("max")};
        AttributeDataset attributeDataset = new AttributeDataset(this.name + " Summary", attributeArray);
        for (int i = 0; i < this.attributes.length; ++i) {
            double[] dArray = this.column(i).vector();
            double[] dArray2 = new double[attributeArray.length];
            dArray2[0] = Math.min(dArray);
            dArray2[1] = Math.q1(dArray);
            dArray2[2] = Math.median(dArray);
            dArray2[3] = Math.mean(dArray);
            dArray2[4] = Math.q3(dArray);
            dArray2[5] = Math.max(dArray);
            Row row = new Row(dArray2);
            row.name = this.attributes[i].getName();
            row.description = this.attributes[i].getDescription();
            attributeDataset.add(row);
        }
        return attributeDataset;
    }

    public class Row
    extends Datum<double[]> {
        public Row(double[] dArray) {
            super(dArray);
        }

        public Row(double[] dArray, double d) {
            super(dArray, d);
        }

        public Row(double[] dArray, double d, double d2) {
            super(dArray, d, d2);
        }

        public String label() {
            if (AttributeDataset.this.response.getType() != Attribute.Type.NOMINAL) {
                throw new IllegalStateException("The response is not of nominal type");
            }
            return AttributeDataset.this.response.toString(this.y);
        }

        public String string(int n) {
            return AttributeDataset.this.attributes[n].toString(((double[])this.x)[n]);
        }

        public Date date(int n) {
            if (AttributeDataset.this.attributes[n].getType() != Attribute.Type.DATE) {
                throw new IllegalStateException("Attribute is not of date type");
            }
            return ((DateAttribute)AttributeDataset.this.attributes[n]).toDate(((double[])this.x)[n]);
        }

        public String toString() {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.name != null) {
                stringBuilder.append('\t');
            }
            if (AttributeDataset.this.response != null) {
                stringBuilder.append(AttributeDataset.this.response.getName());
            }
            int n2 = AttributeDataset.this.attributes.length;
            for (n = 0; n < n2; ++n) {
                stringBuilder.append('\t');
                stringBuilder.append(AttributeDataset.this.attributes[n].getName());
            }
            stringBuilder.append(System.getProperty("line.separator"));
            if (this.name != null) {
                stringBuilder.append(this.name);
                stringBuilder.append('\t');
            }
            if (AttributeDataset.this.response != null) {
                if (AttributeDataset.this.response.getType() == Attribute.Type.NUMERIC) {
                    stringBuilder.append(String.format("%1.4f", this.y));
                } else {
                    stringBuilder.append(AttributeDataset.this.response.toString(this.y));
                }
            }
            for (n = 0; n < n2; ++n) {
                stringBuilder.append('\t');
                Attribute attribute = AttributeDataset.this.attributes[n];
                if (attribute.getType() == Attribute.Type.NUMERIC) {
                    stringBuilder.append(String.format("%1.4f", ((double[])this.x)[n]));
                    continue;
                }
                stringBuilder.append(attribute.toString(((double[])this.x)[n]));
            }
            return stringBuilder.toString();
        }
    }
}

