/*
 * Decompiled with CFR 0.152.
 */
package smile.clustering;

import smile.clustering.linkage.Linkage;

class FastPair {
    private int[] points;
    private int[] index;
    private int npoints;
    private int[] neighbor;
    private float[] distance;
    private Linkage linkage;

    public FastPair(int[] nArray, Linkage linkage) {
        int n;
        this.points = nArray;
        this.linkage = linkage;
        this.npoints = nArray.length;
        this.neighbor = new int[this.npoints];
        this.index = new int[this.npoints];
        this.distance = new float[this.npoints];
        for (n = 0; n < this.npoints - 1; ++n) {
            int n2 = n + 1;
            float f = Float.MAX_VALUE;
            for (int i = n + 1; i < this.npoints; ++i) {
                float f2 = linkage.d(nArray[n], nArray[i]);
                if (!(f2 < f)) continue;
                n2 = i;
                f = f2;
            }
            this.distance[nArray[n]] = f;
            this.neighbor[nArray[n]] = nArray[n2];
            nArray[n2] = nArray[n + 1];
            nArray[n + 1] = this.neighbor[nArray[n]];
        }
        this.neighbor[nArray[this.npoints - 1]] = nArray[this.npoints - 1];
        this.distance[nArray[this.npoints - 1]] = Float.MAX_VALUE;
        for (n = 0; n < this.npoints; ++n) {
            this.index[nArray[n]] = n;
        }
    }

    private void findNeighbor(int n) {
        if (this.npoints == 1) {
            this.neighbor[n] = n;
            this.distance[n] = Float.MAX_VALUE;
            return;
        }
        int n2 = 0;
        if (n == this.points[n2]) {
            n2 = 1;
        }
        this.neighbor[n] = this.points[n2];
        this.distance[n] = this.linkage.d(n, this.neighbor[n]);
        for (int i = n2 + 1; i < this.npoints; ++i) {
            float f;
            int n3 = this.points[i];
            if (n3 == n || !((f = this.linkage.d(n, n3)) < this.distance[n])) continue;
            this.distance[n] = f;
            this.neighbor[n] = n3;
        }
    }

    public void add(int n) {
        this.findNeighbor(n);
        ++this.npoints;
        this.points[this.index[n]] = n;
    }

    public void remove(int n) {
        --this.npoints;
        int n2 = this.index[n];
        this.points[n2] = this.points[this.npoints];
        this.index[this.points[n2]] = n2;
        for (int i = 0; i < this.npoints; ++i) {
            if (this.neighbor[this.points[i]] != n) continue;
            this.findNeighbor(this.points[i]);
        }
    }

    public double getNearestPair(int[] nArray) {
        int n;
        if (this.npoints < 2) {
            throw new IllegalStateException("FastPair: not enough points to form pair");
        }
        double d = this.distance[this.points[0]];
        int n2 = 0;
        for (n = 1; n < this.npoints; ++n) {
            if (!((double)this.distance[this.points[n]] < d)) continue;
            d = this.distance[this.points[n]];
            n2 = n;
        }
        nArray[0] = this.points[n2];
        nArray[1] = this.neighbor[nArray[0]];
        if (nArray[0] > nArray[1]) {
            n = nArray[0];
            nArray[0] = nArray[1];
            nArray[1] = n;
        }
        return d;
    }

    public void updatePoint(int n) {
        this.neighbor[n] = n;
        this.distance[n] = Float.MAX_VALUE;
        for (int i = 0; i < this.npoints; ++i) {
            int n2 = this.points[i];
            if (n2 == n) continue;
            float f = this.linkage.d(n, n2);
            if (f < this.distance[n]) {
                this.distance[n] = f;
                this.neighbor[n] = n2;
            }
            if (this.neighbor[n2] != n) continue;
            if (f > this.distance[n2]) {
                this.findNeighbor(n2);
                continue;
            }
            this.distance[n2] = f;
        }
    }

    public void updateDistance(int n, int n2) {
        float f = this.linkage.d(n, n2);
        if (f < this.distance[n]) {
            this.distance[n] = n2;
            this.neighbor[n] = n2;
        } else if (this.neighbor[n] == n2 && f > this.distance[n]) {
            this.findNeighbor(n);
        }
        if (f < this.distance[n2]) {
            this.distance[n2] = n;
            this.neighbor[n2] = n;
        } else if (this.neighbor[n2] == n && f > this.distance[n2]) {
            this.findNeighbor(n2);
        }
    }
}

