/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.surfacetool;

import org.jmol.shape.Mesh;
import org.jmol.util.C;
import org.openscience.jmol.app.surfacetool.Slice;

public class SurfaceStatus {
    String id;
    int kind;
    int color;
    boolean fillOn;
    int translucency;
    boolean meshOn;
    int meshColor;
    int meshTranslucency;
    int lighting;
    boolean frontonly;
    boolean show;
    boolean beenSliced;
    boolean capOn;
    boolean ghostOn;
    boolean foundDuringLastSync;
    Slice slice;

    public SurfaceStatus(Mesh m, int type) {
        this.id = m.thisID;
        this.kind = type;
        this.color = m.color;
        this.fillOn = m.fillTriangles;
        this.translucency = C.getColixTranslucencyLevel(m.colix);
        this.meshOn = m.drawTriangles;
        this.meshColor = C.getArgb(m.meshColix);
        this.meshTranslucency = 0;
        this.lighting = m.lighting;
        this.frontonly = m.frontOnly;
        this.beenSliced = false;
        this.capOn = false;
        this.ghostOn = false;
        this.foundDuringLastSync = true;
        this.slice = new Slice();
    }

    public void updateExisting(Mesh m) {
        this.color = m.color;
        this.fillOn = m.fillTriangles;
        this.translucency = C.getColixTranslucencyLevel(m.colix);
        this.meshOn = m.drawTriangles;
        this.meshColor = C.getArgb(m.meshColix);
        this.meshTranslucency = 0;
        this.lighting = m.lighting;
        this.frontonly = m.frontOnly;
        this.foundDuringLastSync = true;
    }
}

