/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.so;

import com.actelion.research.calc.SingularValueDecomposition;
import com.actelion.research.chem.RingCollection;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import java.util.ArrayList;
import org.openmolecules.chem.conf.so.ConformationRule;

public class PlaneRule
extends ConformationRule {
    private int[] mPlaneAtom;

    public PlaneRule(int[] nArray, StereoMolecule stereoMolecule) {
        super(nArray);
        int n;
        int n2 = 0;
        for (n = 0; n < nArray.length; ++n) {
            if (stereoMolecule.getConnAtoms(nArray[n]) == 1) continue;
            ++n2;
        }
        if (n2 > 2) {
            this.mPlaneAtom = new int[n2];
            n2 = 0;
            for (n = 0; n < nArray.length; ++n) {
                if (stereoMolecule.getConnAtoms(nArray[n]) == 1) continue;
                this.mPlaneAtom[n2++] = nArray[n];
            }
        } else {
            this.mPlaneAtom = nArray;
        }
    }

    @Override
    public int getRuleType() {
        return 1;
    }

    public static void calculateRules(ArrayList<ConformationRule> arrayList, StereoMolecule stereoMolecule) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean[] blArray = new boolean[stereoMolecule.getBonds()];
        RingCollection ringCollection = stereoMolecule.getRingSet();
        boolean[] blArray2 = new boolean[ringCollection.getSize()];
        ringCollection.determineAromaticity(blArray2, new boolean[ringCollection.getSize()], new int[ringCollection.getSize()], true);
        for (int i = 0; i < ringCollection.getSize(); ++i) {
            if (!blArray2[i]) continue;
            for (n5 = 0; n5 < ringCollection.getRingSize(i); ++n5) {
                blArray[ringCollection.getRingBonds((int)i)[n5]] = true;
            }
        }
        int[] nArray = new int[2];
        for (n5 = 0; n5 < stereoMolecule.getBonds(); ++n5) {
            n4 = stereoMolecule.getBondAtom(0, n5);
            n3 = stereoMolecule.getBondAtom(1, n5);
            nArray[0] = stereoMolecule.getAtomicNo(n4);
            nArray[1] = stereoMolecule.getAtomicNo(n3);
            int n6 = n5;
            blArray[n6] = blArray[n6] | (stereoMolecule.isAromaticBond(n5) || stereoMolecule.getBondOrder(n5) == 2 && nArray[0] <= 8 && nArray[1] <= 8 && stereoMolecule.getAtomPi(n4) == 1 && stereoMolecule.getAtomPi(n3) == 1 && stereoMolecule.getAllConnAtoms(n4) > 1 && stereoMolecule.getAllConnAtoms(n3) > 1);
            if (blArray[n5] || stereoMolecule.getBondOrder(n5) != 1) continue;
            block3: for (n2 = 0; n2 < 2; ++n2) {
                if (nArray[n2] != 7 && nArray[n2] != 8 || nArray[1 - n2] != 6) continue;
                int n7 = stereoMolecule.getBondAtom(1 - n2, n5);
                for (n = 0; n < stereoMolecule.getConnAtoms(n7); ++n) {
                    int n8;
                    if (stereoMolecule.getConnBondOrder(n7, n) != 2 || stereoMolecule.getAtomicNo(n8 = stereoMolecule.getConnAtom(n7, n)) != 7 && stereoMolecule.getAtomicNo(n8) != 8 && stereoMolecule.getAtomicNo(n8) != 16) continue;
                    blArray[n5] = true;
                    continue block3;
                }
            }
        }
        boolean[] blArray3 = new boolean[stereoMolecule.getAtoms()];
        for (n4 = 0; n4 < stereoMolecule.getBonds(); ++n4) {
            if (!blArray[n4]) continue;
            blArray3[stereoMolecule.getBondAtom((int)0, (int)n4)] = true;
            blArray3[stereoMolecule.getBondAtom((int)1, (int)n4)] = true;
        }
        int[] nArray2 = new int[stereoMolecule.getAllAtoms()];
        for (n3 = 0; n3 < stereoMolecule.getBonds(); ++n3) {
            if (!blArray[n3]) continue;
            nArray2[0] = stereoMolecule.getBondAtom(0, n3);
            n2 = PlaneRule.getFlatFragmentAtoms(nArray2, blArray, stereoMolecule);
            int[] nArray3 = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray3[n] = nArray2[n];
            }
            arrayList.add(new PlaneRule(nArray3, stereoMolecule));
        }
        for (n3 = 0; n3 < stereoMolecule.getAtoms(); ++n3) {
            if (blArray3[n3] || !(stereoMolecule.getAtomicNo(n3) == 5 && stereoMolecule.getAtomCharge(n3) == 0 && stereoMolecule.getAllConnAtoms(n3) <= 3 || stereoMolecule.getAtomicNo(n3) <= 8 && stereoMolecule.getAtomPi(n3) == 1 && stereoMolecule.getAllConnAtoms(n3) > 1) && (!stereoMolecule.isFlatNitrogen(n3) || stereoMolecule.getAtomPi(n3) == 2 || stereoMolecule.getAllConnAtoms(n3) <= 1)) continue;
            int[] nArray4 = new int[1 + stereoMolecule.getAllConnAtoms(n3)];
            for (int i = 0; i < stereoMolecule.getAllConnAtoms(n3); ++i) {
                nArray4[i] = stereoMolecule.getConnAtom(n3, i);
            }
            nArray4[stereoMolecule.getAllConnAtoms((int)n3)] = n3;
            arrayList.add(new PlaneRule(nArray4, stereoMolecule));
        }
    }

    private static int getFlatFragmentAtoms(int[] nArray, boolean[] blArray, StereoMolecule stereoMolecule) {
        int n;
        int n2;
        int n3;
        boolean[] blArray2 = new boolean[stereoMolecule.getAllAtoms()];
        blArray2[nArray[0]] = true;
        int n4 = 0;
        for (int i = 0; i <= n4 && stereoMolecule.getAtomPi(nArray[i]) < 2; ++i) {
            for (n3 = 0; n3 < stereoMolecule.getConnAtoms(nArray[i]); ++n3) {
                n2 = stereoMolecule.getConnAtom(nArray[i], n3);
                n = stereoMolecule.getConnBond(nArray[i], n3);
                if (!blArray[n]) continue;
                if (!blArray2[n2]) {
                    nArray[++n4] = n2;
                    blArray2[n2] = true;
                }
                blArray[n] = false;
            }
        }
        for (n3 = n4; n3 >= 0; --n3) {
            if (stereoMolecule.getAtomicNo(nArray[n3]) > 8) continue;
            for (n2 = 0; n2 < stereoMolecule.getAllConnAtoms(nArray[n3]); ++n2) {
                n = stereoMolecule.getConnAtom(nArray[n3], n2);
                if (blArray2[n] || stereoMolecule.getConnBondOrder(nArray[n3], n2) == 0) continue;
                nArray[++n4] = n;
                blArray2[n] = true;
            }
        }
        return n4 + 1;
    }

    @Override
    public boolean apply(Conformer conformer, double d) {
        int n;
        int n2;
        int n3;
        double[] dArray = new double[3];
        for (n3 = 0; n3 < this.mPlaneAtom.length; ++n3) {
            dArray[0] = dArray[0] + conformer.getX(this.mPlaneAtom[n3]);
            dArray[1] = dArray[1] + conformer.getY(this.mPlaneAtom[n3]);
            dArray[2] = dArray[2] + conformer.getZ(this.mPlaneAtom[n3]);
        }
        n3 = 0;
        while (n3 < 3) {
            int n4 = n3++;
            dArray[n4] = dArray[n4] / (double)this.mPlaneAtom.length;
        }
        double[][] dArray2 = new double[this.mPlaneAtom.length][3];
        for (int i = 0; i < this.mPlaneAtom.length; ++i) {
            dArray2[i][0] = conformer.getX(this.mPlaneAtom[i]) - dArray[0];
            dArray2[i][1] = conformer.getY(this.mPlaneAtom[i]) - dArray[1];
            dArray2[i][2] = conformer.getZ(this.mPlaneAtom[i]) - dArray[2];
        }
        double[][] dArray3 = new double[3][3];
        for (int i = 0; i < this.mPlaneAtom.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (n2 = 0; n2 < 3; ++n2) {
                    double[] dArray4 = dArray3[j];
                    int n5 = n2;
                    dArray4[n5] = dArray4[n5] + dArray2[i][j] * dArray2[i][n2];
                }
            }
        }
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(dArray3, null, null);
        double[] dArray5 = singularValueDecomposition.getSingularValues();
        n2 = 0;
        for (int i = 1; i < 3; ++i) {
            if (!(dArray5[i] < dArray5[n2])) continue;
            n2 = i;
        }
        double[][] dArray6 = singularValueDecomposition.getU();
        double[] dArray7 = new double[3];
        for (n = 0; n < 3; ++n) {
            dArray7[n] = dArray6[n][n2];
        }
        for (n = 0; n < this.mAtom.length; ++n) {
            double d2 = -(dArray7[0] * (conformer.getX(this.mAtom[n]) - dArray[0]) + dArray7[1] * (conformer.getY(this.mAtom[n]) - dArray[1]) + dArray7[2] * (conformer.getZ(this.mAtom[n]) - dArray[2]));
            this.moveGroup(conformer, this.mAtom[n], this.mAtom, 0.5 * d2 * d * dArray7[0], 0.5 * d2 * d * dArray7[1], 0.5 * d2 * d * dArray7[2]);
        }
        return true;
    }

    @Override
    public double addStrain(Conformer conformer, double[] dArray) {
        int n;
        int n2;
        double[] dArray2 = new double[3];
        for (n2 = 0; n2 < this.mAtom.length; ++n2) {
            dArray2[0] = dArray2[0] + conformer.getX(this.mAtom[n2]);
            dArray2[1] = dArray2[1] + conformer.getY(this.mAtom[n2]);
            dArray2[2] = dArray2[2] + conformer.getZ(this.mAtom[n2]);
        }
        n2 = 0;
        while (n2 < 3) {
            int n3 = n2++;
            dArray2[n3] = dArray2[n3] / (double)this.mAtom.length;
        }
        double[][] dArray3 = new double[this.mAtom.length][3];
        for (int i = 0; i < this.mAtom.length; ++i) {
            dArray3[i][0] = conformer.getX(this.mAtom[i]) - dArray2[0];
            dArray3[i][1] = conformer.getY(this.mAtom[i]) - dArray2[1];
            dArray3[i][2] = conformer.getZ(this.mAtom[i]) - dArray2[2];
        }
        double[][] dArray4 = new double[3][3];
        for (int i = 0; i < this.mAtom.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (n = 0; n < 3; ++n) {
                    double[] dArray5 = dArray4[j];
                    int n4 = n;
                    dArray5[n4] = dArray5[n4] + dArray3[i][j] * dArray3[i][n];
                }
            }
        }
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(dArray4, null, null);
        double[] dArray6 = singularValueDecomposition.getSingularValues();
        n = 0;
        for (int i = 1; i < 3; ++i) {
            if (!(dArray6[i] < dArray6[n])) continue;
            n = i;
        }
        double[][] dArray7 = singularValueDecomposition.getU();
        double[] dArray8 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray8[i] = dArray7[i][n];
        }
        double d = 0.0;
        for (int i = 0; i < this.mAtom.length; ++i) {
            double d2 = -(dArray8[0] * dArray3[i][0] + dArray8[1] * dArray3[i][1] + dArray8[2] * dArray3[i][2]);
            double d3 = d2 * d2;
            int n5 = this.mAtom[i];
            dArray[n5] = dArray[n5] + d3;
            d += d3;
        }
        return d;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("plane rule:");
        super.addAtomList(stringBuilder);
        return stringBuilder.toString();
    }
}

