/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.so;

import com.actelion.research.calc.ThreadMaster;
import com.actelion.research.chem.Canonizer;
import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.TorsionDescriptorHelper;
import com.actelion.research.util.DoubleFormat;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.openmolecules.chem.conf.so.AxialStereoRule;
import org.openmolecules.chem.conf.so.ConformationRule;
import org.openmolecules.chem.conf.so.DistanceRule;
import org.openmolecules.chem.conf.so.PlaneRule;
import org.openmolecules.chem.conf.so.SelfOrganizedConformer;
import org.openmolecules.chem.conf.so.StraightLineRule;
import org.openmolecules.chem.conf.so.TetrahedralStereoRule;
import org.openmolecules.chem.conf.so.TorsionRule;

public class ConformationSelfOrganizer {
    private static final int INITIAL_POOL_SIZE = 4;
    private static final int MAX_CONFORMER_TRIES = 6;
    private static final int MAX_BREAKOUT_ROUNDS = 3;
    private static final int PREPARATION_CYCLES = 40;
    private static final int PRE_OPTIMIZATION_CYCLES = 20;
    private static final int BREAKOUT_CYCLES = 20;
    private static final int OPTIMIZATION_CYCLES = 100;
    private static final int MINIMIZATION_CYCLES = 20;
    private static final double STANDARD_CYCLE_FACTOR = 1.0;
    private static final double MINIMIZATION_REDUCTION = 20.0;
    private static final double ATOM_FLAT_RING_BREAKOUT_STRAIN = 0.25;
    private static final double ATOM_CAGE_BREAKOUT_STRAIN = 2.0;
    private static final double BREAKOUT_DISTANCE = 8.0;
    private static final double MAX_AVERAGE_ATOM_STRAIN = 0.025;
    private static final double MAX_HIGHEST_ATOM_STRAIN = 0.05;
    private static final double MAX_STRAIN_TOLERANCE = 1.5;
    public static boolean KEEP_INITIAL_COORDINATES = false;
    public static boolean WRITE_DW_FILE = false;
    private static final String DATAWARRIOR_DEBUG_FILE = "/home/thomas/data/debug/conformationSampler.dwar";
    private BufferedWriter mDWWriter;
    private Conformer mLastDWConformer;
    private int mDWCycle;
    private double[] mDWStrain;
    private StereoMolecule mMol;
    private Random mRandom;
    private int mMaxConformers;
    private boolean mPoolIsClosed;
    private ArrayList<ConformationRule> mRuleList;
    private ArrayList<SelfOrganizedConformer> mConformerList;
    private double mMinAverageAtomStrainInPool;
    private double mMinHighestAtomStrainInPool;
    private int[] mRuleCount;
    private boolean[] mSkipRule;
    private int[] mRotatableBondForDescriptor;
    private ThreadMaster mThreadMaster;

    public ConformationSelfOrganizer(StereoMolecule stereoMolecule, boolean bl) {
        this.mMol = stereoMolecule;
        if (!bl) {
            this.mMol.removeExplicitHydrogens();
        }
        this.mMol.ensureHelperArrays(15);
        this.mRuleList = new ArrayList();
        this.mSkipRule = new boolean[ConformationRule.RULE_NAME.length];
        this.mRuleCount = new int[ConformationRule.RULE_NAME.length];
        DistanceRule.calculateRules(this.mRuleList, stereoMolecule);
        this.mRuleCount[0] = this.mRuleList.size();
        this.mRuleCount[1] = -this.mRuleList.size();
        PlaneRule.calculateRules(this.mRuleList, stereoMolecule);
        this.mRuleCount[1] = this.mRuleCount[1] + this.mRuleList.size();
        this.mRuleCount[2] = -this.mRuleList.size();
        StraightLineRule.calculateRules(this.mRuleList, stereoMolecule);
        this.mRuleCount[2] = this.mRuleCount[2] + this.mRuleList.size();
        this.mRuleCount[4] = -this.mRuleList.size();
        TetrahedralStereoRule.calculateRules(this.mRuleList, stereoMolecule);
        this.mRuleCount[4] = this.mRuleCount[4] + this.mRuleList.size();
        this.mRuleCount[5] = -this.mRuleList.size();
        AxialStereoRule.calculateRules(this.mRuleList, stereoMolecule);
        this.mRuleCount[5] = this.mRuleCount[5] + this.mRuleList.size();
        this.mRuleCount[3] = -this.mRuleList.size();
        TorsionRule.calculateRules(this.mRuleList, stereoMolecule);
        this.mRuleCount[3] = this.mRuleCount[3] + this.mRuleList.size();
    }

    public ArrayList<ConformationRule> getRuleList() {
        return this.mRuleList;
    }

    public StereoMolecule getMolecule() {
        return this.mMol;
    }

    public void setThreadMaster(ThreadMaster threadMaster) {
        this.mThreadMaster = threadMaster;
    }

    public StereoMolecule generateOneConformerInPlace(long l) {
        SelfOrganizedConformer selfOrganizedConformer = this.generateOneConformer(l);
        return selfOrganizedConformer == null ? null : selfOrganizedConformer.toMolecule(this.mMol);
    }

    public SelfOrganizedConformer generateOneConformer(long l) {
        this.mRandom = l == 0L ? new Random() : new Random(l);
        SelfOrganizedConformer selfOrganizedConformer = new SelfOrganizedConformer(this.mMol);
        if (WRITE_DW_FILE) {
            try {
                this.writeDWFileStart();
                this.mDWCycle = 0;
                this.mLastDWConformer = null;
                this.tryGenerateConformer(selfOrganizedConformer);
                this.writeDWFileEnd();
                this.mDWWriter.close();
                return selfOrganizedConformer;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        SelfOrganizedConformer selfOrganizedConformer2 = null;
        for (int i = 0; !(i >= 6 || this.mThreadMaster != null && this.mThreadMaster.threadMustDie()); ++i) {
            if (this.tryGenerateConformer(selfOrganizedConformer) || l != 0L) {
                return selfOrganizedConformer;
            }
            if (selfOrganizedConformer2 == null) {
                selfOrganizedConformer2 = selfOrganizedConformer;
                selfOrganizedConformer = new SelfOrganizedConformer(this.mMol);
                continue;
            }
            if (!selfOrganizedConformer2.isWorseThan(selfOrganizedConformer)) continue;
            SelfOrganizedConformer selfOrganizedConformer3 = selfOrganizedConformer2;
            selfOrganizedConformer2 = selfOrganizedConformer;
            selfOrganizedConformer = selfOrganizedConformer3;
        }
        return selfOrganizedConformer2;
    }

    public void initializeConformers(long l, int n) {
        this.mRandom = l == 0L ? new Random() : new Random(l);
        this.mConformerList = new ArrayList();
        this.mMinHighestAtomStrainInPool = 0.07500000000000001;
        this.mMinAverageAtomStrainInPool = 0.037500000000000006;
        this.mPoolIsClosed = false;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.mMol.getBonds(); ++i) {
            if (this.mMol.isAromaticBond(i) || this.mMol.getBondOrder(i) != 1 || this.mMol.getAllConnAtoms(this.mMol.getBondAtom(0, i)) <= 1 || this.mMol.getAllConnAtoms(this.mMol.getBondAtom(1, i)) <= 1) continue;
            if (!this.mMol.isRingBond(i)) {
                ++n2;
                continue;
            }
            if (this.mMol.getBondRingSize(i) <= 4) continue;
            ++n3;
        }
        this.mMaxConformers = n == -1 ? 1 << 1 + n2 + n3 / 2 : n;
        this.increaseConformerPool(Math.min(4, this.mMaxConformers));
    }

    private void increaseConformerPool(int n) {
        SelfOrganizedConformer selfOrganizedConformer = null;
        SelfOrganizedConformer selfOrganizedConformer2 = null;
        int n2 = this.mConformerList.size() + n;
        int n3 = n * 6;
        for (int i = 0; !(i >= n3 || this.mConformerList.size() >= n2 || this.mThreadMaster != null && this.mThreadMaster.threadMustDie()); ++i) {
            if (selfOrganizedConformer2 == null) {
                selfOrganizedConformer2 = new SelfOrganizedConformer(this.mMol);
            }
            if (this.tryGenerateConformer(selfOrganizedConformer2)) {
                if (!this.addConformerIfNew(selfOrganizedConformer2)) continue;
                selfOrganizedConformer2 = null;
                continue;
            }
            if (selfOrganizedConformer2.getTotalStrain() / (double)selfOrganizedConformer2.getSize() < 1.5 * this.mMinAverageAtomStrainInPool && selfOrganizedConformer2.getHighestAtomStrain() < 1.5 * this.mMinHighestAtomStrainInPool) {
                if (!this.addConformerIfNew(selfOrganizedConformer2)) continue;
                selfOrganizedConformer2 = null;
                continue;
            }
            if (selfOrganizedConformer == null) {
                selfOrganizedConformer = selfOrganizedConformer2;
                selfOrganizedConformer2 = null;
                continue;
            }
            if (!selfOrganizedConformer.isWorseThan(selfOrganizedConformer2)) continue;
            SelfOrganizedConformer selfOrganizedConformer3 = selfOrganizedConformer;
            selfOrganizedConformer = selfOrganizedConformer2;
            selfOrganizedConformer2 = selfOrganizedConformer3;
        }
        if (this.mConformerList.isEmpty() && selfOrganizedConformer != null) {
            this.mConformerList.add(selfOrganizedConformer);
        }
        if (this.mConformerList.size() < n2 || this.mConformerList.size() == this.mMaxConformers) {
            this.mPoolIsClosed = true;
        }
    }

    private boolean addConformerIfNew(SelfOrganizedConformer selfOrganizedConformer) {
        if (this.mRotatableBondForDescriptor == null) {
            this.mRotatableBondForDescriptor = TorsionDescriptorHelper.findRotatableBonds(this.getMolecule());
        }
        selfOrganizedConformer.calculateDescriptor(this.mRotatableBondForDescriptor);
        boolean bl = true;
        for (SelfOrganizedConformer selfOrganizedConformer2 : this.mConformerList) {
            if (!selfOrganizedConformer.equals(selfOrganizedConformer2)) continue;
            bl = false;
            break;
        }
        if (!bl) {
            return false;
        }
        this.mConformerList.add(selfOrganizedConformer);
        double d = selfOrganizedConformer.getTotalStrain() / (double)selfOrganizedConformer.getSize();
        double d2 = selfOrganizedConformer.getHighestAtomStrain();
        if (this.mMinAverageAtomStrainInPool > d || this.mMinHighestAtomStrainInPool > d2) {
            if (this.mMinAverageAtomStrainInPool > d) {
                this.mMinAverageAtomStrainInPool = d;
            }
            if (this.mMinHighestAtomStrainInPool > d2) {
                this.mMinHighestAtomStrainInPool = d2;
            }
            for (int i = this.mConformerList.size() - 1; i >= 0; --i) {
                SelfOrganizedConformer selfOrganizedConformer3 = this.mConformerList.get(i);
                if (selfOrganizedConformer3.isAcceptable(this.mRuleList) || !(selfOrganizedConformer3.getTotalStrain() / (double)selfOrganizedConformer3.getSize() > 1.5 * this.mMinAverageAtomStrainInPool) && !(selfOrganizedConformer3.getHighestAtomStrain() > 1.5 * this.mMinHighestAtomStrainInPool)) continue;
                this.mConformerList.remove(i);
            }
        }
        return true;
    }

    public SelfOrganizedConformer getNextConformer() {
        if (this.mConformerList == null) {
            return null;
        }
        if (!this.mPoolIsClosed) {
            this.increaseConformerPool(1);
        }
        SelfOrganizedConformer selfOrganizedConformer = null;
        for (SelfOrganizedConformer selfOrganizedConformer2 : this.mConformerList) {
            if (selfOrganizedConformer2.isUsed() || selfOrganizedConformer != null && !selfOrganizedConformer.isWorseThan(selfOrganizedConformer2)) continue;
            selfOrganizedConformer = selfOrganizedConformer2;
        }
        if (selfOrganizedConformer != null) {
            selfOrganizedConformer.setUsed(true);
        } else {
            this.mConformerList = null;
        }
        return selfOrganizedConformer;
    }

    private void writeDWFileStart() throws IOException {
        this.mDWWriter = new BufferedWriter(new FileWriter(DATAWARRIOR_DEBUG_FILE));
        this.mDWWriter.write("<column properties>");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<columnName=\"Structure\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<columnProperty=\"specialType\tidcode\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<columnName=\"before\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<columnProperty=\"specialType\tidcoordinates3D\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<columnProperty=\"parent\tStructure\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<columnName=\"after\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<columnProperty=\"specialType\tidcoordinates3D\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<columnProperty=\"parent\tStructure\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("</column properties>");
        this.mDWWriter.newLine();
        this.mDWWriter.write("Structure\tbefore\tafter\tcycle\truleName\truleAtoms\truleDetail");
        for (int i = 0; i < ConformationRule.RULE_NAME.length; ++i) {
            this.mDWWriter.write("\t" + ConformationRule.RULE_NAME[i]);
        }
        this.mDWWriter.write("\ttotalStrain\tstrainGain\truleStrainBefore\truleStrainAfter\truleStrainGain");
        this.mDWWriter.newLine();
    }

    private void writeDWFileEnd() throws IOException {
        this.mDWWriter.write("<datawarrior properties>");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<axisColumn_2D View_0=\"cycle\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<axisColumn_2D View_1=\"totalStrain\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<chartType_2D View=\"scatter\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<colorColumn_2D View=\"ruleName\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<colorCount_2D View=\"3\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<colorListMode_2D View=\"Categories\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<color_2D View_0=\"-11992833\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<color_2D View_1=\"-65494\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<color_2D View_2=\"-16732826\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<detailView=\"height[Data]=0.4;height[before]=0.3;height[after]=0.3\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<mainSplitting=\"0.71712\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<mainView=\"2D View\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<mainViewCount=\"2\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<mainViewDockInfo0=\"root\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<mainViewDockInfo1=\"Table\tcenter\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<mainViewName0=\"Table\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<mainViewName1=\"2D View\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<mainViewType0=\"tableView\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<mainViewType1=\"2Dview\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<rightSplitting=\"0\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<rowHeight_Table=\"80\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<filter0=\"#category#\truleName\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<connectionColumn_2D View=\"<connectAll>\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<connectionLineWidth_2D View=\"0.17640000581741333\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<logarithmicView=\"totalStrain\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<markersize_2D View=\"0.1936\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("<sizeAdaption_2D View=\"false\">");
        this.mDWWriter.newLine();
        this.mDWWriter.write("</datawarrior properties>");
        this.mDWWriter.newLine();
    }

    private boolean tryGenerateConformer(SelfOrganizedConformer selfOrganizedConformer) {
        if (this.mMol.getAllAtoms() < 2) {
            return true;
        }
        if (!KEEP_INITIAL_COORDINATES) {
            this.jumbleAtoms(selfOrganizedConformer);
        }
        this.mSkipRule[3] = true;
        this.optimize(selfOrganizedConformer, 40, 1.0, 1.0);
        boolean bl = false;
        if (this.mRuleCount[3] != 0) {
            this.mSkipRule[3] = false;
            bl = this.optimize(selfOrganizedConformer, 20, 1.0, 1.0);
        }
        for (int i = 0; !(bl || i >= 3 || this.mThreadMaster != null && this.mThreadMaster.threadMustDie() || this.jumbleStrainedAtoms(selfOrganizedConformer) == 0); ++i) {
            bl = this.optimize(selfOrganizedConformer, 20, 1.0, 1.0);
        }
        if (!bl) {
            bl = this.optimize(selfOrganizedConformer, 100, 1.0, 1.0);
        }
        if (!bl) {
            bl = this.optimize(selfOrganizedConformer, 20, 1.0, 20.0);
        }
        return bl;
    }

    public boolean optimize(SelfOrganizedConformer selfOrganizedConformer, int n, double d, double d2) {
        int n2 = this.mMol.getAllAtoms() * this.mMol.getAllAtoms();
        double d3 = Math.log(d2) / (double)n;
        for (int i = 0; !(i >= n || this.mThreadMaster != null && this.mThreadMaster.threadMustDie()); ++i) {
            double d4 = d * Math.exp(-d3 * (double)i);
            for (int j = 0; !(j >= n2 || this.mThreadMaster != null && this.mThreadMaster.threadMustDie()); ++j) {
                ConformationRule conformationRule = this.mRuleList.get((int)(this.mRandom.nextDouble() * (double)this.mRuleList.size()));
                if (!conformationRule.isEnabled() || this.mSkipRule[conformationRule.getRuleType()]) continue;
                boolean bl = conformationRule.apply(selfOrganizedConformer, d4);
                if (bl) {
                    selfOrganizedConformer.invalidateStrain();
                }
                if (this.mDWWriter == null || !bl) continue;
                try {
                    double[] dArray = new double[this.mMol.getAllAtoms()];
                    double d5 = this.mLastDWConformer == null ? 0.0 : conformationRule.addStrain(this.mLastDWConformer, dArray);
                    double d6 = conformationRule.addStrain(selfOrganizedConformer, dArray);
                    this.writeStrains(selfOrganizedConformer, conformationRule, null, d5, d6);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (!selfOrganizedConformer.isAcceptable(this.mRuleList)) continue;
            return true;
        }
        return false;
    }

    private void writeStrains(SelfOrganizedConformer selfOrganizedConformer, ConformationRule conformationRule, String string, double d, double d2) throws Exception {
        Object object;
        selfOrganizedConformer.calculateStrain(this.mRuleList);
        double[] dArray = new double[ConformationRule.RULE_NAME.length];
        double d3 = 0.0;
        for (int i = 0; i < ConformationRule.RULE_NAME.length; ++i) {
            dArray[i] = selfOrganizedConformer.getRuleStrain(i);
            d3 += dArray[i];
        }
        double d4 = 0.0;
        if (this.mDWStrain != null) {
            for (int i = 0; i < this.mDWStrain.length; ++i) {
                d4 += this.mDWStrain[i];
            }
        }
        String string2 = conformationRule != null ? ConformationRule.RULE_NAME[conformationRule.getRuleType()] : string;
        StereoMolecule stereoMolecule = this.mMol.getCompactCopy();
        for (int i = 0; i < stereoMolecule.getAllAtoms(); ++i) {
            if (stereoMolecule.getAtomicNo(i) != 1) continue;
            stereoMolecule.setAtomicNo(i, 9);
        }
        String string3 = "";
        if (conformationRule != null) {
            object = conformationRule.getAtomList();
            for (int i = 0; i < ((int[])object).length; ++i) {
                if (i != 0) {
                    string3 = string3 + ",";
                }
                string3 = string3 + (int)object[i];
                if (object[i] == -1) continue;
                stereoMolecule.setAtomicNo((int)object[i], 5);
            }
        }
        selfOrganizedConformer.toMolecule(stereoMolecule);
        object = new Canonizer(stereoMolecule);
        String string4 = ((Canonizer)object).getEncodedCoordinates();
        if (this.mLastDWConformer != null) {
            this.mLastDWConformer.toMolecule(stereoMolecule);
            Canonizer canonizer = new Canonizer(stereoMolecule);
            String string5 = canonizer.getIDCode();
            String string6 = canonizer.getEncodedCoordinates();
            this.mDWWriter.write(string5 + "\t" + string6 + "\t" + string4 + "\t" + this.mDWCycle + "\t" + string2 + "\t" + string3 + "\t" + (conformationRule != null ? conformationRule.toString() : string));
            for (double d5 : dArray) {
                this.mDWWriter.write("\t" + d5);
            }
            this.mDWWriter.write("\t" + d3 + "\t" + (d4 - d3) + "\t" + DoubleFormat.toString(d) + "\t" + DoubleFormat.toString(d2) + "\t" + DoubleFormat.toString(d - d2));
            this.mDWWriter.newLine();
            this.mDWStrain = dArray;
            ++this.mDWCycle;
        }
        this.mLastDWConformer = new Conformer(selfOrganizedConformer);
    }

    private void jumbleAtoms(SelfOrganizedConformer selfOrganizedConformer) {
        double d = 1.0 + 3.0 * Math.sqrt(this.mMol.getAllAtoms());
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            selfOrganizedConformer.setX(i, d * this.mRandom.nextDouble() - d / 2.0);
            selfOrganizedConformer.setY(i, d * this.mRandom.nextDouble() - d / 2.0);
            selfOrganizedConformer.setZ(i, d * this.mRandom.nextDouble() - d / 2.0);
        }
        selfOrganizedConformer.invalidateStrain();
    }

    private int jumbleStrainedAtoms(SelfOrganizedConformer selfOrganizedConformer) {
        selfOrganizedConformer.calculateStrain(this.mRuleList);
        int n = 0;
        for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
            double d = selfOrganizedConformer.getAtomStrain(i);
            if (d > 0.25 && this.tryEscapeFromFlatRingTrap(selfOrganizedConformer, i)) {
                ++n;
                continue;
            }
            if (!(d > 2.0)) continue;
            if (this.mDWWriter != null) {
                try {
                    this.writeStrains(selfOrganizedConformer, null, "escapeCage", d, Double.NaN);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            Coordinates coordinates = selfOrganizedConformer.getCoordinates(i);
            coordinates.add(8.0 * this.mRandom.nextDouble() - 4.0, 8.0 * this.mRandom.nextDouble() - 4.0, 8.0 * this.mRandom.nextDouble() - 4.0);
            ++n;
        }
        if (n != 0) {
            selfOrganizedConformer.invalidateStrain();
        }
        return n;
    }

    private boolean tryEscapeFromFlatRingTrap(SelfOrganizedConformer selfOrganizedConformer, int n) {
        int n2;
        if (this.mMol.getAllConnAtoms(n) == 1 && this.mMol.isSmallRingAtom(n2 = this.mMol.getConnAtom(n, 0))) {
            Coordinates coordinates = selfOrganizedConformer.getCoordinates(n);
            Coordinates coordinates2 = selfOrganizedConformer.getCoordinates(n2);
            Coordinates coordinates3 = coordinates2.subC(coordinates);
            for (int i = 0; i < this.mMol.getConnAtoms(n2); ++i) {
                Coordinates coordinates4;
                int n3 = this.mMol.getConnAtom(n2, i);
                if (!this.mMol.isRingAtom(n3) || !(coordinates3.getAngle(coordinates4 = coordinates2.subC(selfOrganizedConformer.getCoordinates(n3))) > 1.5707963267948966)) continue;
                return false;
            }
            coordinates.add(coordinates3).add(coordinates3);
            if (this.mDWWriter != null) {
                try {
                    this.writeStrains(selfOrganizedConformer, null, "escapeFlatRing", selfOrganizedConformer.getAtomStrain(n), Double.NaN);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public boolean disableCollidingTorsionRules(SelfOrganizedConformer selfOrganizedConformer) {
        boolean bl = false;
        selfOrganizedConformer.calculateStrain(this.mRuleList);
        StereoMolecule stereoMolecule = this.mMol;
        boolean[] blArray = new boolean[stereoMolecule.getAllAtoms()];
        for (ConformationRule conformationRule : this.mRuleList) {
            if (!(conformationRule instanceof TorsionRule) || !((TorsionRule)conformationRule).disableIfColliding(selfOrganizedConformer)) continue;
            int[] nArray = conformationRule.getAtomList();
            for (int i = 1; i <= 2; ++i) {
                for (int j = 0; j < stereoMolecule.getAllConnAtoms(nArray[i]); ++j) {
                    int n = stereoMolecule.getConnAtom(nArray[i], j);
                    if (n == nArray[3 - i]) continue;
                    blArray[n] = true;
                }
            }
            bl = true;
        }
        if (bl) {
            for (int i = 0; i < this.mMol.getAllAtoms(); ++i) {
                if (!blArray[i]) continue;
                selfOrganizedConformer.getCoordinates(i).add(0.6 * this.mRandom.nextDouble() - 0.3, 0.6 * this.mRandom.nextDouble() - 0.3, 0.6 * this.mRandom.nextDouble() - 0.3);
            }
        }
        return bl;
    }

    public void disableTorsionRules() {
        for (ConformationRule conformationRule : this.mRuleList) {
            if (!(conformationRule instanceof TorsionRule)) continue;
            conformationRule.setEnabled(false);
        }
    }

    public boolean disablePlaneRules() {
        boolean bl = false;
        for (ConformationRule conformationRule : this.mRuleList) {
            if (!(conformationRule instanceof PlaneRule)) continue;
            conformationRule.setEnabled(false);
            bl = true;
        }
        return bl;
    }

    public void enableTorsionRules() {
        for (ConformationRule conformationRule : this.mRuleList) {
            if (!(conformationRule instanceof TorsionRule)) continue;
            conformationRule.setEnabled(true);
        }
    }
}

