/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.so;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;

public abstract class ConformationRule {
    public static final int RULE_TYPE_DISTANCE = 0;
    public static final int RULE_TYPE_PLANE = 1;
    public static final int RULE_TYPE_LINE = 2;
    public static final int RULE_TYPE_TORSION = 3;
    public static final int RULE_TYPE_STEREO = 4;
    public static final int RULE_TYPE_BINAP = 5;
    public static final String[] RULE_NAME = new String[]{"distance", "plane", "line", "torsion", "stereo", "binap"};
    protected int[] mAtom;
    protected boolean mIsEnabled;

    public ConformationRule(int[] nArray) {
        this.mAtom = nArray;
        this.mIsEnabled = true;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public void setEnabled(boolean bl) {
        this.mIsEnabled = bl;
    }

    public abstract boolean apply(Conformer var1, double var2);

    public abstract double addStrain(Conformer var1, double[] var2);

    public abstract int getRuleType();

    public abstract String toString();

    protected int[] getAtomList() {
        return this.mAtom;
    }

    protected void addAtomList(StringBuilder stringBuilder) {
        if (this.mAtom == null) {
            stringBuilder.append(" atoms:<null>");
        } else {
            stringBuilder.append(" atoms:" + this.mAtom[0]);
            for (int i = 1; i < this.mAtom.length; ++i) {
                stringBuilder.append("," + this.mAtom[i]);
            }
        }
    }

    protected void moveGroup(Conformer conformer, int n, int[] nArray, double d, double d2, double d3) {
        conformer.getCoordinates(n).add(d, d2, d3);
        StereoMolecule stereoMolecule = conformer.getMolecule();
        for (int i = 0; i < stereoMolecule.getAllConnAtoms(n); ++i) {
            int n2 = stereoMolecule.getConnAtom(n, i);
            boolean bl = false;
            if (nArray != null) {
                for (int j = 0; j < nArray.length; ++j) {
                    if (n2 != nArray[j]) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) continue;
            if (stereoMolecule.getAllConnAtoms(n2) == 1) {
                conformer.getCoordinates(n2).add(d, d2, d3);
                continue;
            }
            if (stereoMolecule.isRingBond(stereoMolecule.getConnBond(n, i))) {
                conformer.getCoordinates(n2).add(d / 3.0, d2 / 3.0, d3 / 3.0);
                continue;
            }
            this.moveSubstituent(conformer, n, n2, d, d2, d3);
        }
    }

    protected void moveSubstituent(Conformer conformer, int n, int n2, double d, double d2, double d3) {
        conformer.getCoordinates(n2).add(d, d2, d3);
        StereoMolecule stereoMolecule = conformer.getMolecule();
        boolean[] blArray = new boolean[stereoMolecule.getAllAtoms()];
        int[] nArray = new int[stereoMolecule.getAllAtoms()];
        nArray[0] = n2;
        blArray[n] = true;
        blArray[n2] = true;
        int n3 = 0;
        for (int i = 0; i <= n3; ++i) {
            for (int j = 0; j < stereoMolecule.getAllConnAtoms(nArray[i]); ++j) {
                int n4 = stereoMolecule.getConnAtom(nArray[i], j);
                if (blArray[n4]) continue;
                blArray[n4] = true;
                nArray[++n3] = n4;
                conformer.getCoordinates(n4).add(d, d2, d3);
            }
        }
    }

    protected void moveAtomWithUnboundedNeighbors(Conformer conformer, int n, double d, double d2, double d3) {
        conformer.getCoordinates(n).add(d, d2, d3);
        StereoMolecule stereoMolecule = conformer.getMolecule();
        for (int i = 0; i < stereoMolecule.getAllConnAtoms(n); ++i) {
            int n2 = stereoMolecule.getConnAtom(n, i);
            if (stereoMolecule.getAllConnAtoms(n2) != 1) continue;
            conformer.getCoordinates(n2).add(d, d2, d3);
        }
    }

    protected void rotateAtom(Conformer conformer, int n, int n2, Coordinates coordinates, double d) {
        double d2 = coordinates.x;
        double d3 = coordinates.y;
        double d4 = coordinates.z;
        double d5 = Math.cos(d);
        double d6 = Math.sin(d);
        double d7 = 1.0 - d5;
        double d8 = conformer.getX(n) - conformer.getX(n2);
        double d9 = conformer.getY(n) - conformer.getY(n2);
        double d10 = conformer.getZ(n) - conformer.getZ(n2);
        conformer.setX(n, conformer.getX(n2) + (d7 * d2 * d2 + d5) * d8 + (d7 * d2 * d3 + d6 * d4) * d9 + (d7 * d2 * d4 - d6 * d3) * d10);
        conformer.setY(n, conformer.getY(n2) + (d7 * d2 * d3 - d6 * d4) * d8 + (d7 * d3 * d3 + d5) * d9 + (d7 * d3 * d4 + d6 * d2) * d10);
        conformer.setZ(n, conformer.getZ(n2) + (d7 * d2 * d4 + d6 * d3) * d8 + (d7 * d4 * d3 - d6 * d2) * d9 + (d7 * d4 * d4 + d5) * d10);
    }
}

