/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.gen;

import java.util.Arrays;
import org.openmolecules.chem.conf.gen.RigidFragment;
import org.openmolecules.chem.conf.gen.RotatableBond;
import org.openmolecules.chem.conf.gen.TorsionSet;
import org.openmolecules.chem.conf.gen.TorsionSetStrategy;

public class TorsionSetStrategyLikelySystematic
extends TorsionSetStrategy {
    private int[] mCurrentMaxTorsionIndex;
    private int[] mCurrentMaxConformerIndex;
    private TorsionSet[] mAvailableTorsionSet;
    private int mAvailableTorsionSetIndex;

    public TorsionSetStrategyLikelySystematic(RotatableBond[] rotatableBondArray, RigidFragment[] rigidFragmentArray) {
        super(rotatableBondArray, rigidFragmentArray);
        this.mCurrentMaxTorsionIndex = new int[rotatableBondArray.length];
        this.mCurrentMaxConformerIndex = new int[rigidFragmentArray.length];
        this.mAvailableTorsionSet = new TorsionSet[1];
        this.mAvailableTorsionSet[0] = this.createTorsionSet(new int[rotatableBondArray.length], new int[rigidFragmentArray.length]);
        this.mAvailableTorsionSetIndex = -1;
    }

    @Override
    public TorsionSet createTorsionSet(TorsionSet torsionSet) {
        if (this.mAvailableTorsionSet == null) {
            return null;
        }
        if (this.mAvailableTorsionSetIndex + 1 == this.mAvailableTorsionSet.length) {
            this.createNextAvailableSet();
        }
        if (this.mAvailableTorsionSet == null) {
            return null;
        }
        ++this.mAvailableTorsionSetIndex;
        return this.mAvailableTorsionSet[this.mAvailableTorsionSetIndex];
    }

    private void createNextAvailableSet() {
        int n;
        double d;
        int n2;
        int n3 = -1;
        boolean bl = false;
        double d2 = Double.MAX_VALUE;
        for (n2 = 0; n2 < this.mCurrentMaxTorsionIndex.length; ++n2) {
            if (this.mCurrentMaxTorsionIndex[n2] >= this.mRotatableBond[n2].getTorsionCount() - 1 || !(d2 > (d = this.mRotatableBond[n2].getTorsionLikelyhood(this.mCurrentMaxTorsionIndex[n2]) / this.mRotatableBond[n2].getTorsionLikelyhood(this.mCurrentMaxTorsionIndex[n2] + 1)))) continue;
            d2 = d;
            n3 = n2;
        }
        for (n2 = 0; n2 < this.mCurrentMaxConformerIndex.length; ++n2) {
            if (this.mCurrentMaxConformerIndex[n2] >= this.mRigidFragment[n2].getConformerCount() - 1 || !(d2 > (d = this.mRigidFragment[n2].getConformerLikelihood(this.mCurrentMaxConformerIndex[n2]) / this.mRigidFragment[n2].getConformerLikelihood(this.mCurrentMaxConformerIndex[n2] + 1)))) continue;
            d2 = d;
            n3 = n2;
            bl = true;
        }
        if (n3 == -1) {
            this.mAvailableTorsionSet = null;
            return;
        }
        n2 = 1;
        for (n = 0; n < this.mCurrentMaxTorsionIndex.length; ++n) {
            if (!bl && n == n3) continue;
            n2 *= this.mCurrentMaxTorsionIndex[n] + 1;
        }
        for (n = 0; n < this.mCurrentMaxConformerIndex.length; ++n) {
            if (bl && n == n3) continue;
            n2 *= this.mCurrentMaxConformerIndex[n] + 1;
        }
        this.mAvailableTorsionSet = new TorsionSet[n2];
        if (bl) {
            int n4 = n3;
            this.mCurrentMaxConformerIndex[n4] = this.mCurrentMaxConformerIndex[n4] + 1;
        } else {
            int n5 = n3;
            this.mCurrentMaxTorsionIndex[n5] = this.mCurrentMaxTorsionIndex[n5] + 1;
        }
        for (n = 0; n < n2; ++n) {
            int n6;
            int n7 = n;
            int[] nArray = new int[this.mCurrentMaxTorsionIndex.length];
            for (int i = 0; i < this.mCurrentMaxTorsionIndex.length; ++i) {
                if (!bl && i == n3 || (n6 = this.mCurrentMaxTorsionIndex[i] + 1) == 1) continue;
                nArray[i] = n7 % n6;
                n7 /= n6;
            }
            int[] nArray2 = new int[this.mCurrentMaxConformerIndex.length];
            for (n6 = 0; n6 < this.mCurrentMaxConformerIndex.length; ++n6) {
                int n8;
                if (bl && n6 == n3 || (n8 = this.mCurrentMaxConformerIndex[n6] + 1) == 1) continue;
                nArray2[n6] = n7 % n8;
                n7 /= n8;
            }
            if (bl) {
                nArray2[n3] = this.mCurrentMaxConformerIndex[n3];
            } else {
                nArray[n3] = this.mCurrentMaxTorsionIndex[n3];
            }
            this.mAvailableTorsionSet[n] = this.createTorsionSet(nArray, nArray2);
        }
        Arrays.sort(this.mAvailableTorsionSet, (torsionSet, torsionSet2) -> Double.compare(torsionSet2.getLikelihood(), torsionSet.getLikelihood()));
        this.mAvailableTorsionSetIndex = -1;
    }
}

