/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.gen;

import java.util.Arrays;
import org.openmolecules.chem.conf.gen.TorsionSetEliminationRule;

public class TorsionSet
implements Comparable<TorsionSet> {
    private long[] mEncodedBits;
    private double mLikelihood;
    private int[] mTorsionIndex;
    private int[] mConformerIndex;
    private double mCollisionIntensitySum;
    private double[][] mCollisionIntensityMatrix;
    private boolean mIsUsed;

    public TorsionSet(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, double d) {
        this.mTorsionIndex = nArray;
        this.mConformerIndex = nArray2;
        this.mLikelihood = d;
        this.mEncodedBits = new long[1 + nArray4[nArray4.length - 1]];
        int n = 0;
        for (int n2 : nArray) {
            int n3 = nArray4[n];
            this.mEncodedBits[n3] = this.mEncodedBits[n3] + (long)(n2 << nArray3[n]);
            ++n;
        }
        for (int n2 : nArray2) {
            int n4 = nArray4[n];
            this.mEncodedBits[n4] = this.mEncodedBits[n4] + (long)(n2 << nArray3[n]);
            ++n;
        }
    }

    public TorsionSet(TorsionSet torsionSet) {
        this.mTorsionIndex = Arrays.copyOf(torsionSet.mTorsionIndex, torsionSet.mTorsionIndex.length);
        this.mConformerIndex = Arrays.copyOf(torsionSet.mConformerIndex, torsionSet.mConformerIndex.length);
        this.mLikelihood = torsionSet.mLikelihood;
        this.mEncodedBits = Arrays.copyOf(torsionSet.mEncodedBits, torsionSet.mEncodedBits.length);
    }

    public int[] getTorsionIndexes() {
        return this.mTorsionIndex;
    }

    public int[] getConformerIndexes() {
        return this.mConformerIndex;
    }

    public double getLikelihood() {
        return this.mLikelihood;
    }

    public double getCollisionIntensitySum() {
        return this.mCollisionIntensitySum;
    }

    public double[][] getCollisionIntensityMatrix() {
        return this.mCollisionIntensityMatrix;
    }

    public void setCollisionIntensity(double d, double[][] dArray) {
        this.mCollisionIntensitySum = d;
        this.mCollisionIntensityMatrix = dArray;
    }

    public boolean isUsed() {
        return this.mIsUsed;
    }

    public void setUsed() {
        this.mIsUsed = true;
    }

    private boolean matches(long[] lArray, long[] lArray2) {
        for (int i = 0; i < lArray.length; ++i) {
            if ((this.mEncodedBits[i] & lArray[i]) == (lArray2[i] & lArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean matches(TorsionSetEliminationRule torsionSetEliminationRule, double d) {
        return this.mCollisionIntensitySum > d && this.matches(torsionSetEliminationRule.getMask(), torsionSetEliminationRule.getData());
    }

    @Override
    public int compareTo(TorsionSet torsionSet) {
        for (int i = 0; i < this.mEncodedBits.length; ++i) {
            if (this.mEncodedBits[i] == torsionSet.mEncodedBits[i]) continue;
            return this.mEncodedBits[i] < torsionSet.mEncodedBits[i] ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        return this.compareTo((TorsionSet)object) == 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : this.mTorsionIndex) {
            stringBuilder.append(n);
            stringBuilder.append(',');
        }
        if (this.mTorsionIndex.length != 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        stringBuilder.append(';');
        for (int n : this.mConformerIndex) {
            stringBuilder.append(n);
            stringBuilder.append(',');
        }
        if (this.mConformerIndex.length != 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

