/*
 * Decompiled with CFR 0.152.
 */
package org.openmolecules.chem.conf.gen;

import com.actelion.research.chem.Coordinates;
import com.actelion.research.chem.StereoMolecule;
import com.actelion.research.chem.conf.Conformer;
import com.actelion.research.chem.conf.TorsionDB;
import com.actelion.research.chem.conf.TorsionDetail;
import com.actelion.research.chem.conf.TorsionPrediction;
import java.util.Random;
import org.openmolecules.chem.conf.gen.ConformerGenerator;
import org.openmolecules.chem.conf.gen.RigidFragment;

public class RotatableBond {
    private static final double ANGLE_TOLERANCE = (double)0.001f;
    private static final double ACCEPTABLE_CENTER_STRAIN = (double)0.05f;
    private static final double NECESSARY_EDGE_STRAIN_IMPROVEMENT = (double)0.02f;
    private static final double MAXIMUM_CENTER_STRAIN = (double)0.2f;
    private static final int ESCAPE_ANGLE = 8;
    private static final int ESCAPE_STEPS = 4;
    private static final double MIN_ESCAPE_GAIN_PER_STEP = 0.05;
    private static final short[] SIXTY_DEGREE_TORSION = new short[]{0, 60, 120, 180, 240, 300};
    private static final short[] SIXTY_DEGREE_FREQUENCY = new short[]{17, 17, 17, 17, 17, 17};
    private static final short[][] SIXTY_DEGREE_RANGE = new short[][]{{-20, 20}, {40, 80}, {100, 140}, {160, 200}, {220, 260}, {280, 320}};
    private RigidFragment mFragment1;
    private RigidFragment mFragment2;
    private Random mRandom;
    private int mRotationCenter;
    private int mBond;
    private int mFragmentNo1;
    private int mFragmentNo2;
    private boolean mBondAtomsInFragmentOrder;
    private float mBondRelevance;
    private short[] mTorsion;
    private short[] mFrequency;
    private short[][] mTorsionRange;
    private double[] mLikelyhood;
    private int[] mTorsionAtom;
    private int[] mRearAtom;
    private int[] mSmallerSideAtomList;

    public RotatableBond(StereoMolecule stereoMolecule, int n, int[] nArray, int[] nArray2, int n2, RigidFragment[] rigidFragmentArray, Random random) {
        this(stereoMolecule, n, nArray, nArray2, n2, rigidFragmentArray, random, false);
    }

    public RotatableBond(StereoMolecule stereoMolecule, int n, int[] nArray, int[] nArray2, int n2, RigidFragment[] rigidFragmentArray, Random random, boolean bl) {
        this.mBond = n;
        this.mRandom = random;
        this.mTorsionAtom = new int[4];
        this.mRearAtom = new int[2];
        TorsionDetail torsionDetail = new TorsionDetail();
        if (TorsionDB.getTorsionID(stereoMolecule, n, this.mTorsionAtom, torsionDetail) != null) {
            this.mRearAtom[0] = torsionDetail.getRearAtom(0);
            this.mRearAtom[1] = torsionDetail.getRearAtom(1);
        } else {
            this.predictAtomSequence(stereoMolecule);
        }
        this.mFragmentNo1 = nArray[this.mTorsionAtom[1]];
        this.mFragmentNo2 = nArray[this.mTorsionAtom[2]];
        this.mFragment1 = rigidFragmentArray[this.mFragmentNo1];
        this.mFragment2 = rigidFragmentArray[this.mFragmentNo2];
        boolean bl2 = this.mBondAtomsInFragmentOrder = nArray[stereoMolecule.getBondAtom(0, n)] == this.mFragmentNo1;
        if (bl) {
            this.mTorsion = SIXTY_DEGREE_TORSION;
            this.mFrequency = SIXTY_DEGREE_FREQUENCY;
            this.mTorsionRange = SIXTY_DEGREE_RANGE;
        } else {
            this.mTorsion = TorsionDB.getTorsions(torsionDetail.getID());
            if (this.mTorsion == null) {
                TorsionPrediction torsionPrediction = new TorsionPrediction(stereoMolecule, this.mTorsionAtom);
                this.mTorsion = torsionPrediction.getTorsions();
                this.mFrequency = torsionPrediction.getTorsionFrequencies();
                this.mTorsionRange = torsionPrediction.getTorsionRanges();
            } else {
                this.mFrequency = TorsionDB.getTorsionFrequencies(torsionDetail.getID());
                this.mTorsionRange = TorsionDB.getTorsionRanges(torsionDetail.getID());
            }
        }
        this.removeIllegalTorsions(stereoMolecule);
        this.removeEquivalentTorsions(stereoMolecule);
        this.mLikelyhood = new double[this.mTorsion.length];
        this.findSmallerSideAtomList(stereoMolecule, nArray2, n2);
    }

    public RigidFragment getFragment(int n) {
        return n == 0 ? this.mFragment1 : this.mFragment2;
    }

    public int getFragmentNo(int n) {
        return n == 0 ? this.mFragmentNo1 : this.mFragmentNo2;
    }

    private void predictAtomSequence(StereoMolecule stereoMolecule) {
        int n;
        int n2;
        for (n2 = 0; n2 < 2; ++n2) {
            n = stereoMolecule.getBondAtom(n2, this.mBond);
            int n3 = stereoMolecule.getBondAtom(1 - n2, this.mBond);
            block1: while (stereoMolecule.getAtomPi(n) == 2 && stereoMolecule.getConnAtoms(n) == 2 && stereoMolecule.getAtomicNo(n) < 10) {
                for (int i = 0; i < 2; ++i) {
                    int n4 = stereoMolecule.getConnAtom(n, i);
                    if (n4 == n3) continue;
                    n3 = n;
                    n = n4;
                    continue block1;
                }
            }
            this.mTorsionAtom[n2 + 1] = n;
            this.mRearAtom[n2] = n3;
        }
        if (stereoMolecule.getAtomPi(this.mTorsionAtom[1]) == 0 && stereoMolecule.getConnAtoms(this.mTorsionAtom[1]) == 3) {
            this.mTorsionAtom[0] = -1;
        } else {
            for (n2 = 0; n2 < stereoMolecule.getConnAtoms(this.mTorsionAtom[1]); ++n2) {
                n = stereoMolecule.getConnAtom(this.mTorsionAtom[1], n2);
                if (n == this.mTorsionAtom[2]) continue;
                this.mTorsionAtom[0] = n;
                break;
            }
        }
        if (stereoMolecule.getAtomPi(this.mTorsionAtom[2]) == 0 && stereoMolecule.getConnAtoms(this.mTorsionAtom[2]) == 3) {
            this.mTorsionAtom[3] = -1;
        } else {
            for (n2 = 0; n2 < stereoMolecule.getConnAtoms(this.mTorsionAtom[2]); ++n2) {
                n = stereoMolecule.getConnAtom(this.mTorsionAtom[2], n2);
                if (n == this.mTorsionAtom[1]) continue;
                this.mTorsionAtom[3] = n;
                break;
            }
        }
    }

    private void findSmallerSideAtomList(StereoMolecule stereoMolecule, int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        boolean[] blArray = new boolean[stereoMolecule.getAllAtoms()];
        int n5 = stereoMolecule.getSubstituent(this.mRearAtom[0], this.mTorsionAtom[1], blArray, null, null);
        int n6 = 0;
        if (this.mRearAtom[0] != this.mTorsionAtom[2]) {
            n6 = stereoMolecule.getPathLength(this.mRearAtom[0], this.mTorsionAtom[2]);
        }
        boolean bl = false;
        if (n5 > n - n6 - n5) {
            n5 = n - n6 - n5;
            bl = true;
        }
        if (bl && n6 != 0) {
            n4 = this.mRearAtom[0];
            n3 = this.mTorsionAtom[1];
            block0: while (stereoMolecule.getAtomPi(n4) == 2 && stereoMolecule.getConnAtoms(n4) == 2 && stereoMolecule.getAtomicNo(n4) < 10) {
                blArray[n4] = true;
                for (n2 = 0; n2 < 2; ++n2) {
                    int n7 = stereoMolecule.getConnAtom(n4, n2);
                    if (n7 == n3) continue;
                    n3 = n4;
                    n4 = n7;
                    continue block0;
                }
            }
        }
        n4 = 0;
        n3 = nArray[this.mTorsionAtom[1]];
        this.mSmallerSideAtomList = new int[n5];
        for (n2 = 0; n2 < stereoMolecule.getAllAtoms(); ++n2) {
            if (nArray[n2] != n3 || !(blArray[n2] ^ bl)) continue;
            this.mSmallerSideAtomList[n4++] = n2;
        }
        this.mBondRelevance = (float)(n5 == 1 ? 1 : 2 * n5) / (float)stereoMolecule.getAtoms();
        this.mRotationCenter = this.mTorsionAtom[bl ? 2 : 1];
    }

    public int getBond() {
        return this.mBond;
    }

    public int getTorsionCount() {
        return this.mTorsion.length;
    }

    public int getLikelyRandomTorsionIndex(double d, double d2) {
        double d3 = 0.0;
        for (int i = 0; i < this.mTorsion.length; ++i) {
            double d4 = (1.0 - d2) * this.mLikelyhood[i] + d2 / (double)this.mTorsion.length;
            if (!(d <= (d3 += d4))) continue;
            return i;
        }
        return this.mTorsion.length - 1;
    }

    public short getTorsion(int n) {
        return this.mTorsion[n];
    }

    public double getTorsionLikelyhood(int n) {
        return this.mLikelyhood[n];
    }

    public int getSmallerSideAtomCount() {
        return this.mSmallerSideAtomList.length;
    }

    public float getRelevance() {
        return this.mBondRelevance;
    }

    public void connectFragments(Conformer conformer, boolean[] blArray, int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        RigidFragment rigidFragment;
        int n7;
        int n8;
        int n9;
        if (!blArray[this.mFragmentNo1] && !blArray[this.mFragmentNo2]) {
            RigidFragment rigidFragment2 = this.mFragment1.getCoreSize() > this.mFragment2.getCoreSize() ? this.mFragment1 : this.mFragment2;
            n9 = this.mFragment1.getCoreSize() > this.mFragment2.getCoreSize() ? this.mFragmentNo1 : this.mFragmentNo2;
            blArray[n9] = true;
            n8 = nArray == null ? 0 : nArray[n9];
            for (n7 = 0; n7 < rigidFragment2.getExtendedSize(); ++n7) {
                int n10 = rigidFragment2.extendedToOriginalAtom(n7);
                conformer.setCoordinates(n10, rigidFragment2.getExtendedCoordinates(n8, n7));
            }
        }
        assert (blArray[this.mFragmentNo1] ^ blArray[this.mFragmentNo2]);
        if (blArray[this.mFragmentNo1]) {
            n8 = this.mFragmentNo2;
            rigidFragment = this.mFragment2;
            n7 = this.mBondAtomsInFragmentOrder ? 1 : 0;
        } else {
            n8 = this.mFragmentNo1;
            rigidFragment = this.mFragment1;
            n7 = this.mBondAtomsInFragmentOrder ? 0 : 1;
        }
        int n11 = conformer.getMolecule().getBondAtom(n7, this.mBond);
        n9 = conformer.getMolecule().getBondAtom(1 - n7, this.mBond);
        int n12 = nArray == null ? 0 : nArray[n8];
        int n13 = rigidFragment.originalToExtendedAtom(n11);
        int n14 = rigidFragment.originalToExtendedAtom(n9);
        Coordinates coordinates = rigidFragment.getExtendedCoordinates(n12, n13);
        Coordinates coordinates2 = conformer.getCoordinates(n11);
        Coordinates coordinates3 = coordinates.subC(rigidFragment.getExtendedCoordinates(n12, n14)).unit();
        Coordinates coordinates4 = coordinates2.subC(conformer.getCoordinates(n9)).unit();
        double d = coordinates3.getAngle(coordinates4);
        Coordinates[] coordinatesArray = new Coordinates[rigidFragment.getExtendedSize()];
        if (d < (double)0.001f) {
            for (n6 = 0; n6 < rigidFragment.getExtendedSize(); ++n6) {
                int n15 = rigidFragment.extendedToOriginalAtom(n6);
                if (n15 == n11 || n15 == n9) continue;
                coordinatesArray[n6] = d > 1.5707963267948966 ? coordinates.subC(rigidFragment.getExtendedCoordinates(n12, n6)) : rigidFragment.getExtendedCoordinates(n12, n6).subC(coordinates);
            }
        } else {
            Coordinates coordinates5 = d < 3.1405926535422957 ? coordinates4.cross(coordinates3) : (Math.abs(coordinates4.x) >= Math.abs(coordinates4.y) && Math.abs(coordinates4.x) >= Math.abs(coordinates4.z) ? new Coordinates(-(coordinates4.y + coordinates4.z) / coordinates4.x, 1.0, 1.0) : (Math.abs(coordinates4.y) >= Math.abs(coordinates4.x) && Math.abs(coordinates4.y) >= Math.abs(coordinates4.z) ? new Coordinates(1.0, -(coordinates4.x + coordinates4.z) / coordinates4.y, 1.0) : new Coordinates(1.0, 1.0, -(coordinates4.x + coordinates4.y) / coordinates4.z)));
            double[][] dArray = RotatableBond.getRotationMatrix(coordinates5.unit(), d);
            for (n5 = 0; n5 < rigidFragment.getExtendedSize(); ++n5) {
                n4 = rigidFragment.extendedToOriginalAtom(n5);
                if (n4 == n11 || n4 == n9) continue;
                coordinatesArray[n5] = rigidFragment.getExtendedCoordinates(n12, n5).subC(coordinates).rotate(dArray);
            }
        }
        blArray[n8] = true;
        for (n6 = 0; n6 < conformer.getMolecule().getConnAtoms(n11); ++n6) {
            int n16 = conformer.getMolecule().getConnAtom(n11, n6);
            if (n16 == n9) continue;
            n5 = rigidFragment.originalToExtendedAtom(n16);
            conformer.setCoordinatesReplace(n16, coordinatesArray[n5].addC(coordinates2));
        }
        double d2 = TorsionDB.calculateTorsionExtended(conformer, this.mTorsionAtom);
        n5 = this.mFragment1.getConformerCount() > 1 || this.mFragment2.getConformerCount() > 1 ? 1 : 0;
        n4 = -1;
        int n17 = 0;
        int n18 = 0;
        double d3 = 0.0;
        for (int i = 0; i < this.mTorsion.length; ++i) {
            double d4;
            n4 = this.mTorsion[i];
            double[][] dArray = RotatableBond.getRotationMatrix(coordinates4, Math.PI * (double)n4 / 180.0 - d2);
            for (int j = 0; j < rigidFragment.getExtendedSize(); ++j) {
                n3 = rigidFragment.extendedToOriginalAtom(j);
                if (n3 == n11 || n3 == n9) continue;
                conformer.setCoordinates(n3, coordinatesArray[j]);
                conformer.getCoordinates(n3).rotate(dArray).add(coordinates2);
            }
            double d5 = d4 = this.calculateCollisionStrain(conformer);
            n2 = 0;
            if (n5 != 0) {
                this.mLikelyhood[i] = this.mFrequency[i];
            } else if (d4 < (double)0.05f) {
                double d6 = d4 / (double)0.2f;
                this.mLikelyhood[i] = (double)this.mFrequency[i] * (1.0 - d6 * d6);
            } else {
                boolean bl = false;
                boolean bl2 = true;
                for (int j = 0; j < 2; ++j) {
                    double d7;
                    n4 = this.mTorsionRange[i][j];
                    dArray = RotatableBond.getRotationMatrix(coordinates4, Math.PI * (double)n4 / 180.0 - d2);
                    for (int k = 0; k < rigidFragment.getExtendedSize(); ++k) {
                        int n19 = rigidFragment.extendedToOriginalAtom(k);
                        if (n19 == n11 || n19 == n9) continue;
                        conformer.setCoordinates(n19, coordinatesArray[k]);
                        conformer.getCoordinates(n19).rotate(dArray).add(coordinates2);
                    }
                    double d8 = this.calculateCollisionStrain(conformer);
                    if (!(d4 - d8 > (double)0.02f)) continue;
                    if (bl2) {
                        this.mTorsion[i] = this.mTorsionRange[i][j];
                        this.mFrequency[i] = (short)((this.mFrequency[i] + 1) / 2);
                        d7 = d8 / (double)0.2f;
                        this.mLikelyhood[i] = (double)this.mFrequency[i] * (1.0 - d7 * d7);
                        d5 = d8;
                        n2 = j + 1;
                        bl2 = false;
                    } else {
                        d7 = d8 / (double)0.2f;
                        this.insertTorsion(i, j, d7);
                        if (this.mLikelyhood[i + 1] > this.mLikelyhood[i]) {
                            d5 = d8;
                            n2 = j + 1;
                        }
                        ++i;
                    }
                    bl = true;
                }
                if (!bl) {
                    double d9 = d4 / (double)0.2f;
                    this.mLikelyhood[i] = (double)this.mFrequency[i] * (1.0 - d9 * d9);
                }
            }
            if (!(this.mLikelyhood[n17] < this.mLikelyhood[i])) continue;
            n17 = i;
            n18 = n2;
            d3 = d5;
        }
        double d10 = 0.0;
        for (n = 0; n < this.mTorsion.length; ++n) {
            if (!(this.mLikelyhood[n] > 0.0)) continue;
            d10 += this.mLikelyhood[n];
        }
        if (this.mLikelyhood[n17] <= 0.0) {
            this.mLikelyhood[n17] = 1.0;
            n = n18 == 1 ? -8 : (n18 == 2 ? 8 : (this.mRandom.nextDouble() < 0.5 ? -8 : 8));
            for (n3 = 1; n3 <= 4; ++n3) {
                n4 = (short)(this.mTorsion[n17] + n * n3);
                double[][] dArray = RotatableBond.getRotationMatrix(coordinates4, Math.PI * (double)n4 / 180.0 - d2);
                for (int i = 0; i < rigidFragment.getExtendedSize(); ++i) {
                    n2 = rigidFragment.extendedToOriginalAtom(i);
                    if (n2 == n11 || n2 == n9) continue;
                    conformer.setCoordinates(n2, coordinatesArray[i]);
                    conformer.getCoordinates(n2).rotate(dArray).add(coordinates2);
                }
                double d11 = this.calculateCollisionStrain(conformer);
                if (!(d3 - d11 < 0.05)) {
                    this.mTorsion[n17] = n4;
                    continue;
                }
                break;
            }
        } else {
            n = 0;
            while (n < this.mTorsion.length) {
                int n20 = n++;
                this.mLikelyhood[n20] = this.mLikelyhood[n20] / d10;
            }
        }
        if (n4 != this.mTorsion[n17 = this.removeUnlikelyTorsions(n17)]) {
            double[][] dArray = RotatableBond.getRotationMatrix(coordinates4, Math.PI * (double)this.mTorsion[n17] / 180.0 - d2);
            for (n3 = 0; n3 < rigidFragment.getExtendedSize(); ++n3) {
                int n21 = rigidFragment.extendedToOriginalAtom(n3);
                if (n21 == n11 || n21 == n9) continue;
                conformer.setCoordinates(n21, coordinatesArray[n3]);
                conformer.getCoordinates(n21).rotate(dArray).add(coordinates2);
            }
        }
        conformer.setBondTorsion(this.mBond, this.mTorsion[n17]);
    }

    private double calculateCollisionStrain(Conformer conformer) {
        double d = 0.0;
        int n = conformer.getMolecule().getBondAtom(0, this.mBond);
        int n2 = conformer.getMolecule().getBondAtom(1, this.mBond);
        for (int i = 0; i < this.mFragment1.getCoreSize(); ++i) {
            int n3 = this.mFragment1.coreToOriginalAtom(i);
            if (n3 == n || n3 == n2) continue;
            double d2 = ConformerGenerator.getToleratedVDWRadius(conformer.getMolecule().getAtomicNo(n3));
            for (int j = 0; j < this.mFragment2.getCoreSize(); ++j) {
                double d3;
                double d4;
                double d5;
                int n4 = this.mFragment2.coreToOriginalAtom(j);
                if (n4 == n || n4 == n2) continue;
                double d6 = d2 + ConformerGenerator.getToleratedVDWRadius(conformer.getMolecule().getAtomicNo(n4));
                double d7 = Math.abs(conformer.getX(n3) - conformer.getX(n4));
                if (!(d7 < d6) || !((d5 = Math.abs(conformer.getY(n3) - conformer.getY(n4))) < d6) || !((d4 = Math.abs(conformer.getZ(n3) - conformer.getZ(n4))) < d6) || !((d3 = Math.sqrt(d7 * d7 + d5 * d5 + d4 * d4)) < d6)) continue;
                double d8 = (d6 - d3) / d6;
                d += d8 * d8;
            }
        }
        return d;
    }

    private int removeUnlikelyTorsions(int n) {
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < this.mTorsion.length; ++i) {
            if (!(this.mLikelyhood[i] > 0.0)) continue;
            ++n3;
        }
        short[] sArray = new short[n3];
        short[] sArray2 = new short[n3];
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            double d = 0.0;
            int n4 = -1;
            for (int j = 0; j < this.mTorsion.length; ++j) {
                if (!(d < this.mLikelyhood[j])) continue;
                d = this.mLikelyhood[j];
                n4 = j;
            }
            sArray[i] = this.mTorsion[n4];
            sArray2[i] = this.mFrequency[n4];
            dArray[i] = this.mLikelyhood[n4];
            if (n4 == n) {
                n2 = i;
            }
            this.mLikelyhood[n4] = 0.0;
        }
        this.mTorsion = sArray;
        this.mFrequency = sArray2;
        this.mLikelyhood = dArray;
        return n2;
    }

    private void insertTorsion(int n, int n2, double d) {
        short[] sArray = new short[this.mTorsion.length + 1];
        short[][] sArrayArray = new short[this.mTorsion.length + 1][];
        short[] sArray2 = new short[this.mTorsion.length + 1];
        double[] dArray = new double[this.mTorsion.length + 1];
        int n3 = 0;
        short s = this.mTorsionRange[n][n2];
        short s2 = (short)((this.mFrequency[n] + 1) / 2);
        double d2 = (double)this.mFrequency[n] * (1.0 - d * d);
        for (int i = 0; i <= this.mTorsion.length; ++i) {
            if (i == n + 1) {
                sArray[i] = s;
                sArrayArray[i] = new short[2];
                sArrayArray[i][0] = s;
                sArrayArray[i][1] = s;
                sArray2[i] = s2;
                dArray[i] = d2;
                continue;
            }
            sArray[i] = this.mTorsion[n3];
            sArrayArray[i] = this.mTorsionRange[n3];
            sArray2[i] = this.mFrequency[n3];
            dArray[i] = this.mLikelyhood[n3];
            ++n3;
        }
        this.mTorsion = sArray;
        this.mTorsionRange = sArrayArray;
        this.mFrequency = sArray2;
        this.mLikelyhood = dArray;
    }

    private static double[][] getRotationMatrix(Coordinates coordinates, double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        double d4 = 1.0 - d3;
        double[][] dArray = new double[3][3];
        dArray[0][0] = coordinates.x * coordinates.x * d4 + d3;
        dArray[1][1] = coordinates.y * coordinates.y * d4 + d3;
        dArray[2][2] = coordinates.z * coordinates.z * d4 + d3;
        dArray[0][1] = coordinates.x * coordinates.y * d4 - coordinates.z * d2;
        dArray[1][2] = coordinates.y * coordinates.z * d4 - coordinates.x * d2;
        dArray[2][0] = coordinates.z * coordinates.x * d4 - coordinates.y * d2;
        dArray[0][2] = coordinates.x * coordinates.z * d4 + coordinates.y * d2;
        dArray[1][0] = coordinates.y * coordinates.x * d4 + coordinates.z * d2;
        dArray[2][1] = coordinates.z * coordinates.y * d4 + coordinates.x * d2;
        return dArray;
    }

    public void rotateToIndex(Conformer conformer, int n) {
        this.rotateTo(conformer, this.mTorsion[n]);
    }

    public void rotateTo(Conformer conformer, short s) {
        if (s != conformer.getBondTorsion(this.mBond)) {
            int n = s - conformer.getBondTorsion(this.mBond);
            this.rotateSmallerSide(conformer, Math.PI * (double)n / 180.0);
            conformer.setBondTorsion(this.mBond, s);
        }
    }

    private void removeIllegalTorsions(StereoMolecule stereoMolecule) {
        if (stereoMolecule.getBondOrder(this.mBond) == 1 && (stereoMolecule.getBondParity(this.mBond) == 1 || stereoMolecule.getBondParity(this.mBond) == 2)) {
            int n;
            int n2;
            int n3;
            int n4;
            boolean bl = false;
            block0: for (n4 = 0; n4 < 2; ++n4) {
                n3 = this.mTorsionAtom[3 * n4];
                n2 = this.mTorsionAtom[1 + n4];
                int n5 = this.mTorsionAtom[2 - n4];
                for (int i = 0; i < stereoMolecule.getConnAtoms(n2); ++i) {
                    n = stereoMolecule.getConnAtom(n2, i);
                    if (n == n5 || n == n3) continue;
                    if (n >= n3) continue block0;
                    bl = !bl;
                    continue block0;
                }
            }
            if (stereoMolecule.getBondParity(this.mBond) == 1) {
                bl = !bl;
            }
            n4 = 0;
            n3 = 0;
            for (n2 = 0; n2 < this.mTorsion.length; ++n2) {
                if (!(this.mTorsion[n2] < 180 ^ bl)) continue;
                n3 += this.mFrequency[n2];
                ++n4;
            }
            if (n4 < this.mTorsion.length) {
                short[] sArray = new short[n4];
                short[] sArray2 = new short[n4];
                short[][] sArrayArray = new short[n4][];
                n4 = 0;
                for (n = 0; n < this.mTorsion.length; ++n) {
                    if (!(this.mTorsion[n] < 180 ^ bl)) continue;
                    sArray[n4] = this.mTorsion[n];
                    sArray2[n4] = (short)(this.mFrequency[n] * 100 / n3);
                    sArrayArray[n4] = this.mTorsionRange[n];
                    ++n4;
                }
                this.mTorsion = sArray;
                this.mFrequency = sArray2;
                this.mTorsionRange = sArrayArray;
            }
        }
    }

    private void removeEquivalentTorsions(StereoMolecule stereoMolecule) {
        int n;
        int[][] nArrayArray = new int[][]{{1, 2, 3}, {2, 4, 12}, {3, 12, 6}};
        int n2 = this.mFragment1.getConnectionPointCount() != 1 ? 1 : this.countSymmetricalTerminalNeighbors(stereoMolecule, this.mTorsionAtom[1], this.mRearAtom[0]);
        int n3 = n = this.mFragment2.getConnectionPointCount() != 1 ? 1 : this.countSymmetricalTerminalNeighbors(stereoMolecule, this.mTorsionAtom[2], this.mRearAtom[1]);
        if (n2 == 1 && n == 1) {
            return;
        }
        int n4 = 360 / Math.max(n2, n);
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < this.mTorsion.length && this.mTorsion[i] < n4; ++i) {
            n6 += this.mFrequency[i];
            ++n5;
        }
        if (n5 == 0) {
            return;
        }
        short[] sArray = new short[n5];
        short[] sArray2 = new short[n5];
        short[][] sArrayArray = new short[n5][];
        for (int i = 0; i < n5; ++i) {
            sArray[i] = this.mTorsion[i];
            sArray2[i] = (short)(this.mFrequency[i] * 100 / n6);
            sArrayArray[i] = this.mTorsionRange[i];
        }
        this.mTorsion = sArray;
        this.mFrequency = sArray2;
        this.mTorsionRange = sArrayArray;
    }

    private int countSymmetricalTerminalNeighbors(StereoMolecule stereoMolecule, int n, int n2) {
        if (stereoMolecule.getAtomPi(n) == 2) {
            return 1;
        }
        if ((stereoMolecule.getAtomPi(n) == 1 || stereoMolecule.isFlatNitrogen(n)) && stereoMolecule.getConnAtoms(n) != 3) {
            return 1;
        }
        if (stereoMolecule.getAtomPi(n) == 0 && stereoMolecule.getConnAtoms(n) != 4) {
            return 1;
        }
        int n3 = -2;
        for (int i = 0; i < stereoMolecule.getConnAtoms(n); ++i) {
            int n4 = stereoMolecule.getConnAtom(n, i);
            if (n4 == n2) continue;
            if (n3 == -2) {
                n3 = stereoMolecule.getSymmetryRank(n4);
                continue;
            }
            if (n3 == stereoMolecule.getSymmetryRank(n4)) continue;
            return 1;
        }
        return stereoMolecule.getConnAtoms(n) - 1;
    }

    private void rotateSmallerSide(Conformer conformer, double d) {
        Coordinates coordinates = conformer.getCoordinates(this.mTorsionAtom[2]);
        Coordinates coordinates2 = coordinates.subC(conformer.getCoordinates(this.mTorsionAtom[1])).unit();
        double[][] dArray = RotatableBond.getRotationMatrix(coordinates2, this.mRotationCenter == this.mTorsionAtom[1] ? d : -d);
        for (int n : this.mSmallerSideAtomList) {
            if (n == this.mRotationCenter) continue;
            double d2 = conformer.getX(n) - coordinates.x;
            double d3 = conformer.getY(n) - coordinates.y;
            double d4 = conformer.getZ(n) - coordinates.z;
            conformer.setX(n, d2 * dArray[0][0] + d3 * dArray[0][1] + d4 * dArray[0][2] + coordinates.x);
            conformer.setY(n, d2 * dArray[1][0] + d3 * dArray[1][1] + d4 * dArray[1][2] + coordinates.y);
            conformer.setZ(n, d2 * dArray[2][0] + d3 * dArray[2][1] + d4 * dArray[2][2] + coordinates.z);
        }
    }
}

