/*
 * Decompiled with CFR 0.152.
 */
package org.machinelearning.svm.libsvm;

import org.machinelearning.svm.libsvm.Cache;
import org.machinelearning.svm.libsvm.Kernel;
import org.machinelearning.svm.libsvm.svm_parameter;
import org.machinelearning.svm.libsvm.svm_problem;

class SVR_Q
extends Kernel {
    private final int l;
    private final Cache cache;
    private final byte[] sign;
    private final int[] index;
    private int next_buffer;
    private float[][] buffer;
    private final double[] QD;

    SVR_Q(svm_problem svm_problem2, svm_parameter svm_parameter2) {
        super(svm_problem2.l, svm_problem2.x, svm_parameter2);
        this.l = svm_problem2.l;
        this.cache = new Cache(this.l, (long)(svm_parameter2.cache_size * 1048576.0));
        this.QD = new double[2 * this.l];
        this.sign = new byte[2 * this.l];
        this.index = new int[2 * this.l];
        for (int i = 0; i < this.l; ++i) {
            this.sign[i] = 1;
            this.sign[i + this.l] = -1;
            this.index[i] = i;
            this.index[i + this.l] = i;
            this.QD[i] = this.kernel_function(i, i);
            this.QD[i + this.l] = this.QD[i];
        }
        this.buffer = new float[2][2 * this.l];
        this.next_buffer = 0;
    }

    @Override
    void swap_index(int n, int n2) {
        int n3 = this.sign[n];
        this.sign[n] = this.sign[n2];
        this.sign[n2] = n3;
        n3 = this.index[n];
        this.index[n] = this.index[n2];
        this.index[n2] = n3;
        double d = this.QD[n];
        this.QD[n] = this.QD[n2];
        this.QD[n2] = d;
    }

    @Override
    float[] get_Q(int n, int n2) {
        int n3;
        int n4 = this.index[n];
        float[][] fArrayArray = new float[1][];
        if (this.cache.get_data(n4, fArrayArray, this.l) < this.l) {
            for (n3 = 0; n3 < this.l; ++n3) {
                fArrayArray[0][n3] = (float)this.kernel_function(n4, n3);
            }
        }
        float[] fArray = this.buffer[this.next_buffer];
        this.next_buffer = 1 - this.next_buffer;
        byte by = this.sign[n];
        for (n3 = 0; n3 < n2; ++n3) {
            fArray[n3] = (float)by * (float)this.sign[n3] * fArrayArray[0][this.index[n3]];
        }
        return fArray;
    }

    @Override
    double[] get_QD() {
        return this.QD;
    }
}

