/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M3d;
import javajs.util.Matrix;
import javajs.util.P3d;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Modulation;
import org.jmol.util.Vibration;

public class ModulationSet
extends Vibration
implements JmolModulationSet {
    String id;
    private P3d r0;
    private SymmetryInterface symmetry;
    double[] axesLengths;
    private int nOps;
    private int iop;
    private String strop;
    private int spinOp;
    private Matrix rsvs;
    public Vibration vib;
    private Lst<Modulation> mods;
    private boolean isSubsystem;
    private boolean isCommensurate;
    private double fileOcc;
    private double[] occParams;
    private double occSiteMultiplicity;
    boolean occAbsolute;
    private ModulationSet modCalc;
    public V3d mxyz;
    public Map<String, Double> htUij;
    public double vOcc = Double.NaN;
    private P3d qtOffset = new P3d();
    private boolean isQ;
    private boolean enabled;
    private double scale = 1.0;
    private M3d gammaE;
    private Matrix gammaIinv;
    private Matrix sigma;
    private Matrix tau;
    private Matrix rI;
    private Matrix tFactorInv;
    P3d ptTemp = new P3d();
    private V3d v0;

    @Override
    public SymmetryInterface getSubSystemUnitCell() {
        return this.isSubsystem ? this.symmetry : null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    public ModulationSet setMod(String id, P3d r00, P3d r0, int d, Lst<Modulation> mods, M3d gammaE, Matrix[] factors, SymmetryInterface symmetry, int nOps, int iop, Vibration v, boolean isCommensurate) {
        this.id = id;
        this.symmetry = symmetry;
        this.strop = symmetry.getSpaceGroupXyz(iop, false);
        this.iop = iop;
        this.nOps = nOps;
        this.r0 = r0;
        this.modDim = d;
        this.rI = new Matrix(null, d, 1);
        this.mods = mods;
        this.gammaE = gammaE;
        this.sigma = factors[0];
        if (factors[1] != null) {
            this.isSubsystem = true;
            this.tFactorInv = factors[1].inverse();
        }
        if (v != null) {
            this.vib = v;
            this.vib.modScale = 1.0;
            this.mxyz = new V3d();
            this.axesLengths = symmetry.getUnitCellParams();
        }
        Matrix vR00 = Matrix.newT(r00, true);
        Matrix vR0 = Matrix.newT(r0, true);
        this.rsvs = symmetry.getOperationRsVs(iop);
        this.gammaIinv = this.rsvs.getSubmatrix(3, 3, d, d).inverse();
        Matrix gammaM = this.rsvs.getSubmatrix(3, 0, d, 3);
        Matrix sI = this.rsvs.getSubmatrix(3, 3 + d, d, 1);
        this.spinOp = symmetry.getSpinOp(iop);
        this.tau = this.gammaIinv.mul(this.sigma.mul(vR0).sub(gammaM.mul(vR00)).sub(sI));
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET create " + id + " r0=" + Escape.eP(r0) + " tau=" + this.tau.toString().replace('\n', ' '));
        }
        return this;
    }

    public synchronized ModulationSet calculate(T3d tuv, boolean isQ) {
        double[][] a;
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.htUij = null;
        this.vOcc = Double.NaN;
        if (this.mxyz != null) {
            this.mxyz.set(0.0, 0.0, 0.0);
        }
        if (isQ && this.qtOffset != null) {
            Matrix q = new Matrix(null, 3, 1);
            a = q.getArray();
            a[0][0] = this.qtOffset.x;
            a[1][0] = this.qtOffset.y;
            a[2][0] = this.qtOffset.z;
            this.rI = this.sigma.mul(q);
            a = this.rI.getArray();
        } else {
            a = this.rI.getArray();
            for (int i = 0; i < this.modDim; ++i) {
                a[i][0] = 0.0;
            }
        }
        if (tuv != null) {
            switch (this.modDim) {
                default: {
                    double[] dArray = a[2];
                    dArray[0] = dArray[0] + tuv.z;
                }
                case 2: {
                    double[] dArray = a[1];
                    dArray[0] = dArray[0] + tuv.y;
                }
                case 1: 
            }
            double[] dArray = a[0];
            dArray[0] = dArray[0] + tuv.x;
        }
        if (this.isSubsystem) {
            this.rI = this.tFactorInv.mul(this.rI);
        }
        this.rI = this.tau.add(this.gammaIinv.mul(this.rI));
        double[][] arI = this.rI.getArray();
        int i = this.mods.size();
        while (--i >= 0) {
            ((Modulation)this.mods.get(i)).apply(this, arI);
        }
        this.gammaE.rotate(this);
        if (this.mxyz != null) {
            this.gammaE.rotate(this.mxyz);
            if (this.spinOp < 0) {
                this.mxyz.scale(this.spinOp);
            }
        }
        return this;
    }

    public void addUTens(String utens, double v) {
        if (this.htUij == null) {
            this.htUij = new Hashtable<String, Double>();
        }
        Double f = this.htUij.get(utens);
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET " + this.id + " utens=" + utens + " f=" + f + " v=" + v);
        }
        if (f != null) {
            v += f.doubleValue();
        }
        this.htUij.put(utens, v);
    }

    @Override
    public synchronized void setModTQ(T3d a, boolean isOn, T3d qtOffset, boolean isQ, double scale) {
        if (this.enabled) {
            this.addTo(a, Double.NaN);
        }
        this.enabled = false;
        this.scale = scale;
        if (qtOffset != null) {
            this.qtOffset.setT(qtOffset);
            this.isQ = isQ;
            if (isQ) {
                qtOffset = null;
            }
            this.calculate(qtOffset, isQ);
            if (!Double.isNaN(this.vOcc)) {
                this.getOccupancy(true);
            }
        }
        if (isOn) {
            this.addTo(a, 1.0);
            this.enabled = true;
        }
    }

    @Override
    public void addTo(T3d a, double scale) {
        boolean isReset = Double.isNaN(scale);
        if (isReset) {
            scale = -1.0;
        }
        this.ptTemp.setT(a);
        this.ptTemp.setT(this);
        this.ptTemp.scale(this.scale * scale);
        if (a != null) {
            this.symmetry.toCartesian(this.ptTemp, true);
            a.add(this.ptTemp);
            this.ptTemp.setT(a);
        }
        if (this.mxyz != null) {
            this.setVib(isReset, scale);
        }
    }

    private void setVib(boolean isReset, double modulationScale) {
        if (isReset) {
            this.vib.setT(this.v0);
            return;
        }
        this.ptTemp.setT(this.mxyz);
        this.symmetry.toCartesian(this.ptTemp, true);
        this.ptTemp.add(this.v0);
        this.ptTemp.scale(this.vib.modScale * modulationScale * this.scale);
        this.vib.setT(this.ptTemp);
    }

    @Override
    public String getState() {
        String s = "";
        if (this.qtOffset != null && this.qtOffset.length() > 0.0) {
            s = s + "; modulation " + Escape.eP(this.qtOffset) + " " + this.isQ + ";\n";
        }
        s = s + "modulation {selected} " + (this.enabled ? "ON" : "OFF");
        return s;
    }

    @Override
    public T3d getModPoint(boolean asEnabled) {
        return asEnabled ? this : this.r0;
    }

    @Override
    public Object getModulation(char type, T3d tuv, boolean occ100) {
        this.getModCalc();
        switch (type) {
            case 'D': {
                return P3d.newP(tuv == null ? this.r0 : this.modCalc.calculate(tuv, false));
            }
            case 'M': {
                return P3d.newP(tuv == null ? this.v0 : this.modCalc.calculate((T3d)tuv, (boolean)false).mxyz);
            }
            case 'T': {
                this.modCalc.calculate(tuv, false);
                double[][] ta = this.modCalc.rI.getArray();
                return P3d.new3(ta[0][0], this.modDim > 1 ? ta[1][0] : 0.0, this.modDim > 2 ? ta[2][0] : 0.0);
            }
            case 'O': {
                if (tuv == null) {
                    return occ100 ? (double)this.getOccupancy100(false) : this.getOccupancy(false);
                }
                this.modCalc.calculate(tuv, false);
                double f = this.modCalc.getOccupancy(occ100);
                if (occ100) {
                    f = this.modCalc.getOccupancy100(false);
                }
                return Math.abs(f);
            }
        }
        return null;
    }

    @Override
    public T3d setCalcPoint(T3d pt, T3d t456, double vibScale, double scale) {
        if (this.enabled) {
            this.addTo(pt, Double.NaN);
            this.getModCalc().calculate(t456, false).addTo(pt, scale);
        }
        return pt;
    }

    private ModulationSet getModCalc() {
        if (this.modCalc == null) {
            this.modCalc = new ModulationSet();
            this.modCalc.axesLengths = this.axesLengths;
            this.modCalc.enabled = true;
            this.modCalc.fileOcc = this.fileOcc;
            this.modCalc.gammaE = this.gammaE;
            this.modCalc.gammaIinv = this.gammaIinv;
            this.modCalc.id = this.id;
            this.modCalc.modDim = this.modDim;
            this.modCalc.mods = this.mods;
            this.modCalc.nOps = this.nOps;
            this.modCalc.isSubsystem = this.isSubsystem;
            this.modCalc.tFactorInv = this.tFactorInv;
            this.modCalc.occParams = this.occParams;
            this.modCalc.occSiteMultiplicity = this.occSiteMultiplicity;
            this.modCalc.r0 = this.r0;
            this.modCalc.rI = this.rI;
            this.modCalc.sigma = this.sigma;
            this.modCalc.spinOp = this.spinOp;
            this.modCalc.symmetry = this.symmetry;
            this.modCalc.tau = this.tau;
            this.modCalc.v0 = this.v0;
            this.modCalc.vib = this.vib;
            if (this.mxyz != null) {
                this.modCalc.mxyz = new V3d();
            }
        }
        return this.modCalc;
    }

    @Override
    public void getInfo(Map<String, Object> info) {
        Hashtable<String, Object> modInfo = new Hashtable<String, Object>();
        modInfo.put("id", this.id);
        modInfo.put("r0", this.r0);
        modInfo.put("tau", this.tau.getArray());
        modInfo.put("modDim", this.modDim);
        modInfo.put("rsvs", this.rsvs);
        modInfo.put("sigma", this.sigma.getArray());
        modInfo.put("symop", this.iop + 1);
        modInfo.put("strop", this.strop);
        modInfo.put("unitcell", this.symmetry.getUnitCellInfo(true));
        Lst<Hashtable<String, Object>> mInfo = new Lst<Hashtable<String, Object>>();
        for (int i = 0; i < this.mods.size(); ++i) {
            mInfo.addLast(((Modulation)this.mods.get(i)).getInfo());
        }
        modInfo.put("mods", mInfo);
        info.put("modulation", modInfo);
    }

    @Override
    public void setXYZ(T3d v) {
        if (this.vib == null) {
            return;
        }
        if (this.vib.modDim == -2 && v.x == Double.MIN_VALUE && v.y == Double.MIN_VALUE) {
            this.vib.modScale = v.z;
            return;
        }
        this.vib.setT(v);
    }

    @Override
    public Vibration getVibration(boolean forceNew) {
        if (this.vib == null && forceNew) {
            this.vib = new Vibration();
        }
        return this.vib;
    }

    @Override
    public V3d getV3() {
        return this.mxyz == null ? this : this.mxyz;
    }

    @Override
    public void scaleVibration(double m) {
        if (this.vib == null) {
            return;
        }
        if (m == 0.0) {
            m = 1.0 / this.vib.modScale;
        }
        this.vib.scale(m);
        this.vib.modScale *= m;
    }

    @Override
    public void setMoment() {
        if (this.mxyz == null) {
            return;
        }
        this.symmetry.toCartesian(this.vib, true);
        this.v0 = V3d.newV(this.vib);
    }

    @Override
    public boolean isNonzero() {
        return this.x != 0.0 || this.y != 0.0 || this.z != 0.0 || this.mxyz != null && (this.mxyz.x != 0.0 || this.mxyz.y != 0.0 || this.mxyz.z != 0.0) || this.occAbsolute;
    }

    public double setOccupancy(double[] pt, double foccupancy, double siteMult) {
        this.occParams = pt;
        this.fileOcc = foccupancy;
        this.occSiteMultiplicity = siteMult;
        return this.getOccupancy(true);
    }

    @Override
    public int getOccupancy100(boolean forVibVis) {
        if (this.isCommensurate || Double.isNaN(this.vOcc)) {
            return Integer.MIN_VALUE;
        }
        if (forVibVis) {
            if (this.modCalc != null) {
                this.modCalc.getOccupancy(true);
                return this.modCalc.getOccupancy100(false);
            }
        } else if (!this.enabled) {
            return (int)(-this.fileOcc * 100.0);
        }
        return (int)(this.getOccupancy(forVibVis) * 100.0);
    }

    private double getOccupancy(boolean checkCutoff) {
        double occ;
        if (this.occAbsolute) {
            occ = this.vOcc;
        } else if (this.occParams == null) {
            occ = this.fileOcc + this.vOcc;
        } else if (this.occSiteMultiplicity > 0.0) {
            double o_site = 1.0 / this.occSiteMultiplicity;
            occ = o_site * this.occSiteMultiplicity * (this.fileOcc + this.vOcc);
        } else {
            occ = this.occParams[0] * (this.occParams[1] + this.vOcc);
        }
        if (checkCutoff) {
            // empty if block
        }
        return occ;
    }
}

