/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.V3d;

public class Geodesic {
    private static final double halfRoot5 = 0.5 * Math.sqrt(5.0);
    private static final double oneFifth = 1.2566370614359172;
    private static final double oneTenth = 0.6283185307179586;
    private static final short[] faceVertexesIcosahedron = new short[]{0, 1, 2, 0, 2, 3, 0, 3, 4, 0, 4, 5, 0, 5, 1, 1, 6, 2, 2, 7, 3, 3, 8, 4, 4, 9, 5, 5, 10, 1, 6, 1, 10, 7, 2, 6, 8, 3, 7, 9, 4, 8, 10, 5, 9, 11, 6, 10, 11, 7, 6, 11, 8, 7, 11, 9, 8, 11, 10, 9};
    private static final short[] neighborVertexesIcosahedron = new short[]{1, 2, 3, 4, 5, -1, 0, 5, 10, 6, 2, -1, 0, 1, 6, 7, 3, -1, 0, 2, 7, 8, 4, -1, 0, 3, 8, 9, 5, -1, 0, 4, 9, 10, 1, -1, 1, 10, 11, 7, 2, -1, 2, 6, 11, 8, 3, -1, 3, 7, 11, 9, 4, -1, 4, 8, 11, 10, 5, -1, 5, 9, 11, 6, 1, -1, 6, 7, 8, 9, 10, -1};
    public static final int standardLevel = 3;
    private static final int maxLevel = 3;
    private static short[] vertexCounts;
    private static V3d[] vertexVectors;
    private static short[][] faceVertexesArrays;
    private static short[][] neighborVertexesArrays;
    private static int currentLevel;
    private static short vertexNext;
    private static Map<Integer, Short> htVertex;
    private static final boolean VALIDATE = true;

    public static short[][] getNeighborVertexesArrays() {
        if (vertexCounts == null) {
            Geodesic.createGeodesic(3);
        }
        return neighborVertexesArrays;
    }

    public static short getVertexCount(int level) {
        if (vertexCounts == null) {
            Geodesic.createGeodesic(3);
        }
        return vertexCounts[level];
    }

    public static V3d[] getVertexVectors() {
        if (vertexCounts == null) {
            Geodesic.createGeodesic(3);
        }
        return vertexVectors;
    }

    public static V3d getVertexVector(int i) {
        return vertexVectors[i];
    }

    public static short[] getFaceVertexes(int level) {
        return faceVertexesArrays[level];
    }

    public static synchronized void createGeodesic(int lvl) {
        int i;
        if (lvl <= currentLevel) {
            return;
        }
        currentLevel = lvl;
        short[] v = new short[lvl + 1];
        neighborVertexesArrays = AU.newShort2(lvl + 1);
        faceVertexesArrays = AU.newShort2(lvl + 1);
        vertexVectors = new V3d[12];
        Geodesic.vertexVectors[0] = V3d.new3(0.0, 0.0, halfRoot5);
        for (i = 0; i < 5; ++i) {
            Geodesic.vertexVectors[i + 1] = V3d.new3(Math.cos((double)i * 1.2566370614359172), Math.sin((double)i * 1.2566370614359172), 0.5);
            Geodesic.vertexVectors[i + 6] = V3d.new3(Math.cos((double)i * 1.2566370614359172 + 0.6283185307179586), Math.sin((double)i * 1.2566370614359172 + 0.6283185307179586), -0.5);
        }
        Geodesic.vertexVectors[11] = V3d.new3(0.0, 0.0, -halfRoot5);
        i = 12;
        while (--i >= 0) {
            vertexVectors[i].normalize();
        }
        Geodesic.faceVertexesArrays[0] = faceVertexesIcosahedron;
        Geodesic.neighborVertexesArrays[0] = neighborVertexesIcosahedron;
        v[0] = 12;
        for (i = 0; i < lvl; ++i) {
            Geodesic.quadruple(i, v);
        }
        vertexCounts = v;
    }

    private static void quadruple(int level, short[] counts) {
        int i;
        htVertex = new Hashtable<Integer, Short>();
        int oldVertexCount = vertexVectors.length;
        short[] oldFaceVertexes = faceVertexesArrays[level];
        int oldFaceVertexesLength = oldFaceVertexes.length;
        int oldFaceCount = oldFaceVertexesLength / 3;
        int oldEdgesCount = oldVertexCount + oldFaceCount - 2;
        int newVertexCount = oldVertexCount + oldEdgesCount;
        int newFaceCount = 4 * oldFaceCount;
        vertexVectors = (V3d[])AU.arrayCopyObject(vertexVectors, newVertexCount);
        short[] newFacesVertexes = new short[3 * newFaceCount];
        Geodesic.faceVertexesArrays[level + 1] = newFacesVertexes;
        short[] neighborVertexes = new short[6 * newVertexCount];
        Geodesic.neighborVertexesArrays[level + 1] = neighborVertexes;
        int i2 = neighborVertexes.length;
        while (--i2 >= 0) {
            neighborVertexes[i2] = -1;
        }
        counts[level + 1] = (short)newVertexCount;
        vertexNext = (short)oldVertexCount;
        int iFaceNew = 0;
        int i3 = 0;
        while (i3 < oldFaceVertexesLength) {
            short iA = oldFaceVertexes[i3++];
            short iB = oldFaceVertexes[i3++];
            short iC = oldFaceVertexes[i3++];
            short iAB = Geodesic.getVertex(iA, iB);
            short iBC = Geodesic.getVertex(iB, iC);
            short iCA = Geodesic.getVertex(iC, iA);
            newFacesVertexes[iFaceNew++] = iA;
            newFacesVertexes[iFaceNew++] = iAB;
            newFacesVertexes[iFaceNew++] = iCA;
            newFacesVertexes[iFaceNew++] = iB;
            newFacesVertexes[iFaceNew++] = iBC;
            newFacesVertexes[iFaceNew++] = iAB;
            newFacesVertexes[iFaceNew++] = iC;
            newFacesVertexes[iFaceNew++] = iCA;
            newFacesVertexes[iFaceNew++] = iBC;
            newFacesVertexes[iFaceNew++] = iCA;
            newFacesVertexes[iFaceNew++] = iAB;
            newFacesVertexes[iFaceNew++] = iBC;
            Geodesic.addNeighboringVertexes(neighborVertexes, iAB, iA);
            Geodesic.addNeighboringVertexes(neighborVertexes, iAB, iCA);
            Geodesic.addNeighboringVertexes(neighborVertexes, iAB, iBC);
            Geodesic.addNeighboringVertexes(neighborVertexes, iAB, iB);
            Geodesic.addNeighboringVertexes(neighborVertexes, iBC, iB);
            Geodesic.addNeighboringVertexes(neighborVertexes, iBC, iCA);
            Geodesic.addNeighboringVertexes(neighborVertexes, iBC, iC);
            Geodesic.addNeighboringVertexes(neighborVertexes, iCA, iC);
            Geodesic.addNeighboringVertexes(neighborVertexes, iCA, iA);
        }
        int vertexCount = vertexVectors.length;
        if (iFaceNew != newFacesVertexes.length) {
            throw new NullPointerException();
        }
        if (vertexNext != newVertexCount) {
            throw new NullPointerException();
        }
        for (i = 0; i < 12; ++i) {
            for (int j = 0; j < 5; ++j) {
                short neighbor = neighborVertexes[i * 6 + j];
                if (neighbor < 0) {
                    throw new NullPointerException();
                }
                if (neighbor >= vertexCount) {
                    throw new NullPointerException();
                }
                if (neighborVertexes[i * 6 + 5] == -1) continue;
                throw new NullPointerException();
            }
        }
        for (i = 72; i < neighborVertexes.length; ++i) {
            short neighbor = neighborVertexes[i];
            if (neighbor < 0) {
                throw new NullPointerException();
            }
            if (neighbor < vertexCount) continue;
            throw new NullPointerException();
        }
        for (i = 0; i < newVertexCount; ++i) {
            int neighborCount = 0;
            int j = neighborVertexes.length;
            while (--j >= 0) {
                if (neighborVertexes[j] != i) continue;
                ++neighborCount;
            }
            if (i < 12 && neighborCount != 5 || i >= 12 && neighborCount != 6) {
                throw new NullPointerException();
            }
            int faceCount = 0;
            int j2 = newFacesVertexes.length;
            while (--j2 >= 0) {
                if (newFacesVertexes[j2] != i) continue;
                ++faceCount;
            }
            if ((i >= 12 || faceCount == 5) && (i < 12 || faceCount == 6)) continue;
            throw new NullPointerException();
        }
        htVertex = null;
    }

    private static void addNeighboringVertexes(short[] neighborVertexes, short v1, short v2) {
        int i;
        int iMax = i + 6;
        for (i = v1 * 6; i < iMax; ++i) {
            int j;
            if (neighborVertexes[i] == v2) {
                return;
            }
            if (neighborVertexes[i] >= 0) continue;
            neighborVertexes[i] = v2;
            int jMax = j + 6;
            for (j = v2 * 6; j < jMax; ++j) {
                if (neighborVertexes[j] == v1) {
                    return;
                }
                if (neighborVertexes[j] >= 0) continue;
                neighborVertexes[j] = v1;
                return;
            }
        }
        throw new NullPointerException();
    }

    private static short getVertex(short v1, short v2) {
        Integer hashKey;
        Short iv;
        if (v1 > v2) {
            short t = v1;
            v1 = v2;
            v2 = t;
        }
        if ((iv = htVertex.get(hashKey = Integer.valueOf((v1 << 16) + v2))) != null) {
            return iv;
        }
        V3d newVertexVector = Geodesic.vertexVectors[Geodesic.vertexNext] = new V3d();
        newVertexVector.add2(vertexVectors[v1], vertexVectors[v2]);
        newVertexVector.normalize();
        htVertex.put(hashKey, vertexNext);
        short s = vertexNext;
        vertexNext = (short)(s + 1);
        return s;
    }
}

