/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import javajs.util.Lst;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.P4d;
import javajs.util.V3d;
import org.jmol.bspt.PointIterator;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.Viewer;

public class BZone {
    Object[] ret = new Object[1];
    static P3d ptInner = P3d.new3(Double.NaN, 0.0, 0.0);
    protected BZ bz;
    static final double slop = 1.0E-4;
    static final String[] bzColors = new String[]{"red", "green", "skyblue", "orange", "yellow", "blue", "violet"};
    protected String id;
    protected int index;
    protected String color;
    protected P3d center;
    protected Lst<Subzone> subzones;
    protected Lst<BZPoint> newLatticePts;
    protected Lst<P4d> newPlanes;
    protected double volume;

    public void createBZ(Viewer vwr, int n, Object[] array, boolean isK, String id, double scale, double foffset, P3d offset) {
        BZ bz = new BZ(vwr, id, n);
        bz.createAllZones(scale, foffset, offset);
    }

    protected void create(BZone zonePrev) {
        this.getNewLatticePoints();
        this.getSubzones(zonePrev);
        for (int i = 0; i < this.subzones.size(); ++i) {
            Subzone subzone = (Subzone)this.subzones.get(i);
            if (!subzone.getPmeshes()) continue;
            subzone.createSubzonePolyhedron(this.id);
        }
        this.finalizeZone();
    }

    private void getSubzones(BZone zonePrev) {
        this.subzones = new Lst();
        if (this.index == 1) {
            new Subzone(this, "", 1);
            return;
        }
        int len = zonePrev.id.length();
        for (int i = 0; i < zonePrev.subzones.size(); ++i) {
            int j;
            Subzone prev = (Subzone)zonePrev.subzones.get(i);
            String id = prev.id.substring(len);
            boolean isZone2 = zonePrev.index == 1;
            int n = j = isZone2 ? 0 : 1;
            while (j < prev.planes.size()) {
                if (isZone2 || BZone.within(1.0E-4, (P3d)prev.faceCenters.get(j), this.bz.bzFaceCenters).size() <= 1) {
                    Subzone subzone = new Subzone(this, id, isZone2 ? j + 1 : j);
                    subzone.addPlanes(prev.planes, prev.latticePts, j);
                    subzone.addPlanes(prev.planesUnused, prev.ptsUnused, -1);
                    subzone.addPlanes(this.newPlanes, this.newLatticePts, -1);
                }
                ++j;
            }
        }
    }

    private void getNewLatticePoints() {
        this.newLatticePts = new Lst();
        this.newPlanes = new Lst();
        Lst<P3d> unusedPts = new Lst<P3d>();
        Lst unusedLatticePts = new Lst();
        for (int i = 0; i < this.bz.bzPlanePts.size(); ++i) {
            Lst<BZPoint> al;
            P3d p = (P3d)this.bz.bzPlanePts.get(i);
            P3d center = P3d.newP(p);
            center.scale(0.5);
            double radius = 0.501 * p.length();
            Lst<P3d> inSphere = BZone.within(radius, center, this.bz.bzPlanePts);
            if (inSphere.size() == 1) {
                al = this.newLatticePts;
                this.newPlanes.addLast(BZone.newLatticePlane(p, 1.0, this.bz.bzGamma));
            } else {
                unusedPts.addLast(p);
                al = unusedLatticePts;
            }
            al.addLast((BZPoint)this.bz.bzLatticePts.get(i));
        }
        this.bz.bzPlanePts = unusedPts;
        this.bz.bzLatticePts = unusedLatticePts;
    }

    private static P4d newLatticePlane(P3d pt2, double f, P3d bzGamma) {
        V3d norm = V3d.newVsub(pt2, bzGamma);
        P3d pt3 = new P3d();
        pt3.scaleAdd2(f, norm, bzGamma);
        norm.normalize();
        P4d plane = new P4d();
        MeasureD.getPlaneThroughPoint(pt3, norm, plane);
        return plane;
    }

    protected static Lst<P3d> within(double radius, P3d center, Lst<P3d> pts) {
        Lst<P3d> ret = new Lst<P3d>();
        double r2 = radius * radius;
        int n = pts.size();
        for (int i = 0; i < n; ++i) {
            P3d pt = (P3d)pts.get(i);
            if (!(center.distanceSquared(pt) < r2)) continue;
            ret.addLast(pt);
        }
        return ret;
    }

    private void finalizeZone() {
        this.volume = 0.0;
        int i = this.subzones.size();
        while (--i >= 0) {
            Subzone subzone = (Subzone)this.subzones.get(i);
            if (subzone.isValid) {
                this.volume += subzone.volume;
                if (!(subzone.volume < 0.05)) continue;
                System.out.println("draw id d" + subzone.id + " points " + BZone.esc(subzone.faceCenters) + ";draw id dc" + subzone.id + " width 0.1 color red " + subzone.center);
                continue;
            }
            this.subzones.removeItemAt(i);
        }
    }

    static String esc(Lst<P3d> pts) {
        String s = "[";
        String sep = "";
        int i = pts.size();
        while (--i >= 0) {
            s = s + sep + ((P3d)pts.get(i)).toString();
            sep = " ";
        }
        return s + "]";
    }

    public void drawHKL(Viewer vwr, String id, P4d plane, P3d[] pts) {
        this.bz = new BZ(vwr, id, -2);
        this.bz.drawMillerPlanes(plane, pts);
    }

    private static class Subzone
    extends BZone {
        BZone zone;
        protected boolean isValid;
        protected Lst<P3d[]> faces;
        protected Lst<int[]> faceIndices;
        protected Lst<P3d> faceCenters;
        protected Lst<BZPoint> latticePts;
        protected Lst<P4d> planes;
        protected Lst<BZPoint> ptsUnused;
        protected Lst<P4d> planesUnused;

        public Subzone(BZone zone, String id, int index) {
            this.zone = zone;
            this.bz = zone.bz;
            this.id = zone.id + id + index + "_";
            this.index = index;
            this.newLatticePts = zone.newLatticePts;
            this.planes = zone.index == 1 ? zone.newPlanes : new Lst();
            this.latticePts = zone.index == 1 ? zone.newLatticePts : new Lst();
            this.planesUnused = new Lst();
            this.ptsUnused = new Lst();
            this.faces = new Lst();
            this.faceIndices = new Lst();
            this.faceCenters = new Lst();
            this.volume = 0.0;
            this.color = zone.color;
            this.center = new P3d();
            zone.subzones.addLast(this);
        }

        void addPlanes(Lst<P4d> planes0, Lst<BZPoint> pts0, int j) {
            if (j >= 0) {
                P4d pt4 = P4d.newPt((P4d)planes0.get(j));
                pt4.scale4(-1.0);
                this.planes.addLast(pt4);
                this.latticePts.addLast((BZPoint)pts0.get(j));
            }
            int n = planes0.size();
            for (int k = 0; k < n; ++k) {
                if (k == j) continue;
                this.planes.addLast((P4d)planes0.get(k));
                this.latticePts.addLast((BZPoint)pts0.get(k));
            }
        }

        void createSubzonePolyhedron(String id) {
            int i;
            id = id + this.id;
            P3d[] apts = Subzone.join(this.faces);
            P3d[] pts = this.cleanFace(apts);
            if (pts.length == 0) {
                return;
            }
            this.center = Subzone.average(pts);
            this.faceIndices = new Lst();
            int n = this.faces.size();
            for (i = 0; i < n; ++i) {
                this.faceIndices.addLast(this.cleanFaceIndices((P3d[])this.faces.get(i), pts));
            }
            i = this.faceIndices.size();
            while (--i >= 0) {
                if (((int[])this.faceIndices.get(i)).length >= 3) continue;
                this.faces.removeItemAt(i);
                this.faceIndices.removeItemAt(i);
                this.faceCenters.removeItemAt(i);
                this.planes.removeItemAt(i);
            }
            this.volume = this.bz.addPolyhedron(this, pts);
        }

        private int[] cleanFaceIndices(P3d[] P3ds, P3d[] pts) {
            PointIterator.withinDistPoints(0.0, null, pts, P3ds, null, this.ret);
            return (int[])this.ret[0];
        }

        P3d[] cleanFace(P3d[] face) {
            PointIterator.withinDistPoints(1.0E-4, ptInner, face, null, null, this.ret);
            Lst l = (Lst)this.ret[0];
            return l.toArray(new P3d[l.size()]);
        }

        static P3d average(P3d[] face) {
            P3d a = new P3d();
            int i = face.length;
            while (--i >= 0) {
                a.add(face[i]);
            }
            a.scale(1.0 / (double)face.length);
            return a;
        }

        private static P3d[] join(Lst<P3d[]> faces) {
            int n = 0;
            int i = faces.size();
            while (--i >= 0) {
                n += ((P3d[])faces.get(i)).length;
            }
            P3d[] pts = new P3d[n];
            n = 0;
            int i2 = faces.size();
            while (--i2 >= 0) {
                P3d[] face = (P3d[])faces.get(i2);
                int j = face.length;
                while (--j >= 0) {
                    pts[n++] = face[j];
                }
            }
            return pts;
        }

        protected boolean getPmeshes() {
            int i;
            int nPlanes = this.planes.size();
            Lst planesUsed = new Lst();
            Lst ptsUsed = new Lst();
            boolean haveValidPlane = false;
            for (i = 0; i < nPlanes; ++i) {
                String pid = "f" + this.id + i;
                boolean isValid = true;
                this.bz.createPMesh(pid, (P4d)this.planes.get(i));
                for (int j = 0; j < nPlanes; ++j) {
                    if (j == i) continue;
                    isValid = this.bz.slab(pid, (P4d)this.planes.get(j));
                    if (!isValid) break;
                    haveValidPlane = true;
                }
                if (isValid) {
                    isValid = this.bz.slab(pid, null);
                }
                P3d a = null;
                P3d[] face = null;
                if (isValid) {
                    face = (P3d[])this.bz.getProperty(pid, "face");
                    a = Subzone.average(face);
                    if (i == 0 && Subzone.within(1.0E-4, a, this.bz.bzFaceCenters).size() >= 2) {
                        isValid = false;
                        i = nPlanes;
                    }
                }
                if (isValid) {
                    this.isValid = true;
                    face = this.cleanFace(face);
                    this.faces.addLast(face);
                    this.faceCenters.addLast(a);
                    this.bz.bzFaceCenters.addLast(a);
                    planesUsed.addLast(this.planes.get(i));
                    ptsUsed.addLast(this.latticePts.get(i));
                } else if (i < nPlanes) {
                    this.planesUnused.addLast((P4d)this.planes.get(i));
                    this.ptsUnused.addLast((BZPoint)this.latticePts.get(i));
                }
                this.bz.clearPMesh(pid);
            }
            this.planes = planesUsed;
            this.latticePts = ptsUsed;
            if (this.zone.index == 1) {
                for (i = 0; i < ptsUsed.size(); ++i) {
                    BZPoint bp = (BZPoint)ptsUsed.get(i);
                    System.out.println("#BZ pt[" + i + "]=" + ptsUsed.get(i));
                    System.out.println("draw id d" + i + " intersection unitcell hkl " + bp.hkl() + " all;");
                }
            }
            return haveValidPlane;
        }
    }

    private static class BZ {
        public P3d offset;
        Viewer vwr;
        P3d[] pmeshBox;
        P3d b1;
        P3d b2;
        P3d b3;
        P4d[] wedgePlanes;
        final P3d bzGamma = new P3d();
        Lst<BZPoint> bzLatticePts;
        Lst<P3d> bzFaceCenters;
        Lst<P3d> bzPlanePts;
        double explodeOffset;
        double scale;
        String id;
        int n;
        boolean isWignerSeitz;
        private P3d centerOffset;

        BZ(Viewer vwr, String id, int n) {
            this.vwr = vwr;
            if (n == -2) {
                if (id == null) {
                    id = "hkl";
                }
            } else if (n == -1) {
                this.isWignerSeitz = true;
                n = 1;
                if (id == null) {
                    id = "pws";
                }
            } else if (id == null) {
                id = "pbz";
            }
            this.n = n;
            this.id = id;
        }

        public void createAllZones(double scale, double explodeOffset, P3d offset) {
            if (this.isWignerSeitz) {
                this.isWignerSeitz = true;
                this.offset = offset;
            } else {
                if (this.n > 1) {
                    this.explodeOffset = explodeOffset;
                }
                this.scale = scale;
            }
            boolean wasPrecise = this.vwr.getBoolean(603979831);
            this.vwr.setBooleanPropertyTok("doublePrecision", 603979831, true);
            this.initializeBZ(this.n);
            String cmd = "";
            double volume1 = 0.0;
            BZone zone = null;
            for (int i = 1; i <= this.n; ++i) {
                BZone prev = zone;
                zone = new BZone();
                zone.bz = this;
                zone.index = i;
                zone.id = this.id + "_" + i + "_";
                zone.color = bzColors[(i - 1) % bzColors.length];
                zone.create(prev);
                if (i == 1) {
                    volume1 = zone.volume;
                }
                if (!this.isWignerSeitz) {
                    this.vwr.showString("Brillouin Zone " + zone.index + " volume = " + (double)Math.round(zone.volume / volume1 * 1000.0) / 1000.0 + " subzones:" + zone.subzones.size() + " new k-points:" + zone.newLatticePts.size(), false);
                }
                if (i <= 1 || explodeOffset != 0.0) continue;
                cmd = cmd + "polyhedra id " + this.id + (i - 1) + "_* delete;";
            }
            if (!this.isWignerSeitz) {
                // empty if block
            }
            this.cmd(cmd + ";restore unitcell _bz;");
            this.vwr.setBooleanPropertyTok("doublePrecision", 603979831, wasPrecise);
        }

        void initializeBZ(int n) {
            this.centerOffset = this.vwr.getCurrentUnitCell().getCartesianOffset();
            if (this.offset != null) {
                this.offset.add(this.centerOffset);
            } else {
                this.offset = P3d.newP(this.centerOffset);
            }
            if (this.offset.length() == 0.0) {
                this.offset = null;
            }
            this.bzLatticePts = new Lst();
            this.bzPlanePts = new Lst();
            this.bzFaceCenters = new Lst();
            String cmd = "save unitcell _bz;";
            if (this.isWignerSeitz) {
                cmd = cmd + "unitcell conventional;unitcell primitive;";
            } else {
                if (n == 0) {
                    n = 1;
                }
                if (Double.isNaN(this.scale)) {
                    this.scale = -1.0;
                }
                cmd = cmd + "unitcell conventional;unitcell 'reciprocal' " + new Double(this.scale).toString() + ";";
            }
            cmd = cmd + "polyhedra " + this.id + "* delete;";
            this.cmd(cmd);
            this.pmeshBox = new P3d[]{this.newCartesian(-2, -2, -2, new P3d()), this.newCartesian(2, 2, 2, new P3d())};
            double[] dArray = new double[3];
            this.b1 = this.newCartesian(1, 0, 0, new P3d());
            dArray[0] = this.b1.length();
            this.b2 = this.newCartesian(0, 1, 0, new P3d());
            dArray[1] = this.b2.length();
            this.b3 = this.newCartesian(0, 0, 1, new P3d());
            dArray[2] = this.b3.length();
            double[] abc = dArray;
            double abcmax = Math.max(abc[0], Math.max(abc[1], abc[2]));
            int[][] minmax = new int[3][3];
            for (int i = 0; i < 3; ++i) {
                int m = (int)((double)(n + 1) * abcmax / abc[i]);
                minmax[i] = new int[]{-m, m};
            }
            Lst<P3d> pts = new Lst<P3d>();
            for (int h = minmax[0][0]; h <= minmax[0][1]; ++h) {
                for (int k = minmax[1][0]; k <= minmax[1][1]; ++k) {
                    for (int l = minmax[2][0]; l <= minmax[2][1]; ++l) {
                        if (h == 0 && k == 0 && l == 0) continue;
                        BZPoint lppt = new BZPoint(h, k, l);
                        this.newCartesian(h, k, l, lppt);
                        pts.addLast(P3d.newP(lppt));
                        this.bzLatticePts.addLast(lppt);
                        P3d ppt = P3d.newP(lppt);
                        ppt.scale(0.5);
                        this.bzPlanePts.addLast(ppt);
                    }
                }
            }
        }

        private P3d newCartesian(int h, int k, int l, P3d ret) {
            ret.x = h;
            ret.y = k;
            ret.z = l;
            this.vwr.toCartesian(ret, true);
            return ret;
        }

        void cmd(String cmd) {
            try {
                this.vwr.eval.runScript(cmd);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void createPMesh(String pid, P4d plane) {
            this.vwr.shm.setShapeProperties(29, {"init", "cmd"}, {"thisID", pid}, {"newObject", null}, {"fileType", "Pmesh"}, {"silent", null}, {"resolution", 0.001}, {"boundingBox", this.pmeshBox}, {"plane", plane}, {"nomap", 0.0}, {"hidden", Boolean.TRUE}, {"finalize", "cmd"}, {"clear", null});
        }

        boolean slab(String pid, P4d plane) {
            if (plane == null) {
                if (this.wedgePlanes != null) {
                    int n = this.wedgePlanes.length;
                    for (int w = 0; w < n; ++w) {
                        if (this.slab(pid, this.wedgePlanes[w])) continue;
                        return false;
                    }
                }
                return true;
            }
            this.vwr.shm.setShapePropertyBs(29, "slab", MeshSurface.getSlabObjectType(134217750, plane, false, null), null);
            double[] a = (double[])this.getProperty(pid, "area");
            return a != null && a[0] != 0.0;
        }

        void clearPMesh(String pid) {
            this.vwr.setShapeProperty(29, "clear", null);
            this.vwr.setShapeProperty(29, "delete", pid);
        }

        Object getProperty(String name, String key) {
            Object[] data = new Object[3];
            data[0] = name;
            this.vwr.shm.getShapePropertyData(29, "index", data);
            if (data[1] != null && !key.equals("index")) {
                int index = (Integer)data[1];
                data[1] = this.vwr.shm.getShapePropertyIndex(29, key.intern(), index);
            }
            return data[1];
        }

        double addPolyhedron(Subzone subzone, P3d[] pts) {
            if (this.offset != null) {
                subzone.center.add(this.offset);
                int i = pts.length;
                while (--i >= 0) {
                    pts[i].add(this.offset);
                }
            }
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("id", subzone.id);
            info.put("center", subzone.center);
            Lst<P3d> lst = new Lst<P3d>();
            int n = pts.length;
            for (int i = 0; i < n; ++i) {
                lst.addLast(pts[i]);
            }
            info.put("vertices", lst);
            info.put("faces", subzone.faceIndices);
            if (subzone.index > 1 && this.explodeOffset != 0.0) {
                info.put("explodeOffset", this.explodeOffset * (double)(subzone.index - 1));
            }
            info.put("color", subzone.color);
            info.put("volume", 0.0);
            this.vwr.setShapeProperty(21, "init", Boolean.TRUE);
            this.vwr.setShapeProperty(21, "info", info);
            this.vwr.setShapeProperty(21, "generate", null);
            this.vwr.setShapeProperty(21, "init", Boolean.FALSE);
            return ((Number)info.get("volume")).doubleValue();
        }

        public void drawMillerPlanes(P4d plane, P3d[] pts) {
            this.cmd("draw id " + this.id + "* delete");
            double d = Math.abs(plane.w);
            if (d == 0.0) {
                return;
            }
            P4d p = P4d.newPt(plane);
            p.w = d * 10.0;
            boolean n = false;
            int i = 1;
            while (true) {
                p.w -= d;
                System.out.println(p);
                Lst<Object> list = this.vwr.getTriangulator().intersectPlane(p, pts, 0);
                if (list == null) {
                    if (n || i >= 20) break;
                } else {
                    this.createHKL(this.id + "_" + i, list);
                }
                ++i;
            }
        }

        void createHKL(String id, Lst<Object> list) {
            this.vwr.shm.setShapeProperties(22, {"init", "hkl"}, {"thisID", id}, {"points", 0}, {"polygon", list}, {"set", null});
        }
    }

    private static class BZPoint
    extends P3d {
        int h;
        int k;
        int l;

        BZPoint(int h, int k, int l) {
            this.h = h;
            this.k = k;
            this.l = l;
        }

        @Override
        public String toString() {
            return "[" + this.h + " " + this.k + " " + this.l + "] " + super.toString();
        }

        String hkl() {
            return "{" + this.h + " " + this.k + " " + this.l + "}";
        }
    }
}

