/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import javajs.util.A4d;
import javajs.util.M3d;
import javajs.util.P3d;
import javajs.util.V3d;
import org.jmol.thread.JmolThread;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class MoveToThread
extends JmolThread {
    private boolean isMove;
    private final V3d aaStepCenter = new V3d();
    private final V3d aaStepNavCenter = new V3d();
    private final A4d aaStep = new A4d();
    private final A4d aaTotal = new A4d();
    private final M3d matrixStart = new M3d();
    private final M3d matrixStartInv = new M3d();
    private M3d matrixStep = new M3d();
    private final M3d matrixEnd = new M3d();
    private P3d center;
    private P3d navCenter;
    private P3d ptMoveToCenter;
    private Slider zoom;
    private Slider xTrans;
    private Slider yTrans;
    private Slider xNav;
    private Slider yNav;
    private Slider navDepth;
    private Slider cameraDepth;
    private Slider cameraX;
    private Slider cameraY;
    private Slider rotationRadius;
    private Slider pixelScale;
    private int fps;
    private long frameTimeMillis;
    private boolean doEndMove;
    private double fStep;
    private TransformManager transformManager;
    private double floatSecondsTotal;
    private int totalSteps;
    private int iStep;
    private int timePerStep;
    private double radiansXStep;
    private double radiansYStep;
    private double radiansZStep;
    private V3d dRot;
    private V3d dTrans;
    private double dZoom;
    private double dSlab;
    private double zoomPercent0;
    private int slab;
    private double transX;
    private double transY;

    @Override
    public int setManager(Object manager, Viewer vwr, Object params) {
        Object[] options = (Object[])params;
        this.isMove = options[0] instanceof V3d;
        this.setViewer(vwr, this.isMove ? "moveThread" : "MoveToThread");
        this.transformManager = (TransformManager)manager;
        return this.isMove ? this.setManagerMove(options) : this.setManagerMoveTo(options);
    }

    @Override
    protected void run1(int mode) throws InterruptedException {
        if (this.isMove) {
            this.run1Move(mode);
        } else {
            this.run1MoveTo(mode);
        }
    }

    @Override
    public void interrupt() {
        this.doEndMove = false;
        super.interrupt();
    }

    private int setManagerMove(Object[] options) {
        this.dRot = (V3d)options[0];
        this.dTrans = (V3d)options[1];
        double[] f = (double[])options[2];
        this.dZoom = f[0];
        this.dSlab = f[1];
        this.floatSecondsTotal = f[2];
        int fps = (int)f[3];
        this.slab = this.transformManager.getSlabPercentSetting();
        this.transX = this.transformManager.getTranslationXPercent();
        this.transY = this.transformManager.getTranslationYPercent();
        this.timePerStep = 1000 / fps;
        this.totalSteps = (int)((double)fps * this.floatSecondsTotal);
        if (this.totalSteps <= 0) {
            this.totalSteps = 1;
        }
        double radiansPerDegreePerStep = Math.PI / 180 / (double)this.totalSteps;
        this.radiansXStep = radiansPerDegreePerStep * this.dRot.x;
        this.radiansYStep = radiansPerDegreePerStep * this.dRot.y;
        this.radiansZStep = radiansPerDegreePerStep * this.dRot.z;
        this.zoomPercent0 = this.transformManager.zmPct;
        this.iStep = 0;
        return this.totalSteps;
    }

    private int setManagerMoveTo(Object[] options) {
        this.center = (P3d)options[0];
        this.matrixEnd.setM3((M3d)options[1]);
        double[] f = (double[])options[3];
        this.ptMoveToCenter = this.center == null ? this.transformManager.fixedRotationCenter : this.center;
        this.floatSecondsTotal = f[0];
        this.zoom = this.newSlider(this.transformManager.zmPct, f[1]);
        this.xTrans = this.newSlider(this.transformManager.getTranslationXPercent(), f[2]);
        this.yTrans = this.newSlider(this.transformManager.getTranslationYPercent(), f[3]);
        this.rotationRadius = this.newSlider(this.transformManager.modelRadius, this.center == null || Double.isNaN(f[4]) ? this.transformManager.modelRadius : (f[4] <= 0.0 ? this.vwr.ms.calcRotationRadius(this.vwr.am.cmi, this.center, false) : f[4]));
        this.pixelScale = this.newSlider(this.transformManager.scaleDefaultPixelsPerAngstrom, f[5]);
        if (f[6] != 0.0) {
            this.navCenter = (P3d)options[2];
            this.navDepth = this.newSlider(this.transformManager.navigationDepthPercent, f[6]);
            this.xNav = this.newSlider(this.transformManager.getNavigationOffsetPercent('X'), f[7]);
            this.yNav = this.newSlider(this.transformManager.getNavigationOffsetPercent('Y'), f[8]);
        }
        this.cameraDepth = this.newSlider(this.transformManager.getCameraDepth(), f[9]);
        this.cameraX = this.newSlider(this.transformManager.camera.x, f[10]);
        this.cameraY = this.newSlider(this.transformManager.camera.y, f[11]);
        this.transformManager.getRotation(this.matrixStart);
        this.matrixStartInv.invertM(this.matrixStart);
        this.matrixStep.mul2(this.matrixEnd, this.matrixStartInv);
        this.aaTotal.setM(this.matrixStep);
        this.fps = 30;
        this.totalSteps = (int)(this.floatSecondsTotal * (double)this.fps);
        this.frameTimeMillis = 1000 / this.fps;
        this.targetTime = System.currentTimeMillis();
        this.aaStepCenter.sub2(this.ptMoveToCenter, this.transformManager.fixedRotationCenter);
        this.aaStepCenter.scale(1.0 / (double)this.totalSteps);
        if (this.navCenter != null && this.transformManager.mode == 1) {
            this.aaStepNavCenter.sub2(this.navCenter, this.transformManager.navigationCenter);
            this.aaStepNavCenter.scale(1.0 / (double)this.totalSteps);
        }
        this.iStep = 0;
        return this.totalSteps;
    }

    private Slider newSlider(double start, double value) {
        return Double.isNaN(value) || value == Double.MAX_VALUE ? null : new Slider(start, value);
    }

    private void run1Move(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    if (this.floatSecondsTotal > 0.0) {
                        this.vwr.setInMotion(true);
                    }
                    mode = 0;
                    break;
                }
                case 0: {
                    int timeAllowed;
                    if (this.stopped || this.iStep >= this.totalSteps) {
                        mode = -2;
                        break;
                    }
                    ++this.iStep;
                    if (this.dRot.x != 0.0) {
                        this.transformManager.rotateXRadians(this.radiansXStep, null);
                    }
                    if (this.dRot.y != 0.0) {
                        this.transformManager.rotateYRadians(this.radiansYStep, null);
                    }
                    if (this.dRot.z != 0.0) {
                        this.transformManager.rotateZRadians(this.radiansZStep);
                    }
                    if (this.dZoom != 0.0) {
                        this.transformManager.zoomToPercent(this.zoomPercent0 + this.dZoom * (double)this.iStep / (double)this.totalSteps);
                    }
                    if (this.dTrans.x != 0.0) {
                        this.transformManager.translateToPercent('x', this.transX + this.dTrans.x * (double)this.iStep / (double)this.totalSteps);
                    }
                    if (this.dTrans.y != 0.0) {
                        this.transformManager.translateToPercent('y', this.transY + this.dTrans.y * (double)this.iStep / (double)this.totalSteps);
                    }
                    if (this.dTrans.z != 0.0) {
                        this.transformManager.translateToPercent('z', this.dTrans.z * (double)this.iStep / (double)this.totalSteps);
                    }
                    if (this.dSlab != 0.0) {
                        this.transformManager.slabToPercent((int)Math.floor((double)this.slab + this.dSlab * (double)this.iStep / (double)this.totalSteps));
                    }
                    if (this.iStep == this.totalSteps) {
                        mode = -2;
                        break;
                    }
                    int timeSpent = (int)(System.currentTimeMillis() - this.startTime);
                    if (timeSpent >= (timeAllowed = this.iStep * this.timePerStep)) break;
                    this.vwr.requestRepaintAndWait("moveThread");
                    if (!this.isJS && !this.vwr.isScriptExecuting()) {
                        mode = -2;
                        break;
                    }
                    timeSpent = (int)(System.currentTimeMillis() - this.startTime);
                    this.sleepTime = timeAllowed - timeSpent;
                    if (this.runSleep(this.sleepTime, 0)) break;
                    return;
                }
                case -2: {
                    if (this.floatSecondsTotal > 0.0) {
                        this.vwr.setInMotion(false);
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }

    private void run1MoveTo(int mode) throws InterruptedException {
        while (true) {
            switch (mode) {
                case -1: {
                    if (this.totalSteps > 0) {
                        this.vwr.setInMotion(true);
                    }
                    mode = 0;
                    break;
                }
                case 0: {
                    boolean doRender;
                    if (this.stopped || ++this.iStep >= this.totalSteps) {
                        mode = -2;
                        break;
                    }
                    this.doStepTransform();
                    this.doEndMove = true;
                    this.targetTime += this.frameTimeMillis;
                    this.currentTime = System.currentTimeMillis();
                    boolean bl = doRender = this.currentTime < this.targetTime;
                    if (!doRender && this.isJS) {
                        this.targetTime = this.currentTime;
                        doRender = true;
                    }
                    if (doRender) {
                        this.vwr.requestRepaintAndWait("movetoThread");
                    }
                    if (this.transformManager.movetoThread == null || !this.transformManager.movetoThread.name.equals(this.name) || !this.isJS && this.eval != null && !this.vwr.isScriptExecuting()) {
                        this.stopped = true;
                        break;
                    }
                    this.currentTime = System.currentTimeMillis();
                    int sleepTime = (int)(this.targetTime - this.currentTime);
                    if (!this.runSleep(sleepTime, 0)) {
                        return;
                    }
                    mode = 0;
                    break;
                }
                case -2: {
                    if (this.totalSteps <= 0 || this.doEndMove && !this.stopped) {
                        this.doFinalTransform();
                    }
                    if (this.totalSteps > 0) {
                        this.vwr.setInMotion(false);
                    }
                    this.vwr.moveUpdate(this.floatSecondsTotal);
                    if (this.transformManager.movetoThread != null && !this.stopped) {
                        this.transformManager.movetoThread = null;
                        this.vwr.finalizeTransformParameters();
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }

    private void doStepTransform() {
        if (!Double.isNaN(this.matrixEnd.m00)) {
            this.transformManager.getRotation(this.matrixStart);
            this.matrixStartInv.invertM(this.matrixStart);
            this.matrixStep.mul2(this.matrixEnd, this.matrixStartInv);
            this.aaTotal.setM(this.matrixStep);
            this.aaStep.setAA(this.aaTotal);
            this.aaStep.angle /= (double)(this.totalSteps - this.iStep);
            if (this.aaStep.angle == 0.0) {
                this.matrixStep.setScale(1.0);
            } else {
                this.matrixStep.setAA(this.aaStep);
            }
            this.matrixStep.mul(this.matrixStart);
        }
        this.fStep = (double)this.iStep / ((double)this.totalSteps - 1.0);
        if (this.center != null) {
            this.transformManager.fixedRotationCenter.add(this.aaStepCenter);
        }
        if (this.navCenter != null && this.transformManager.mode == 1) {
            P3d pt = P3d.newP(this.transformManager.navigationCenter);
            pt.add(this.aaStepNavCenter);
            this.transformManager.setNavigatePt(pt);
        }
        this.setValues(this.matrixStep, null, null);
    }

    private void doFinalTransform() {
        this.fStep = -1.0;
        this.setValues(this.matrixEnd, this.center, this.navCenter);
    }

    private void setValues(M3d m, P3d center, P3d navCenter) {
        this.transformManager.setAll(center, m, navCenter, this.getVal(this.zoom), this.getVal(this.xTrans), this.getVal(this.yTrans), this.getVal(this.rotationRadius), this.getVal(this.pixelScale), this.getVal(this.navDepth), this.getVal(this.xNav), this.getVal(this.yNav), this.getVal(this.cameraDepth), this.getVal(this.cameraX), this.getVal(this.cameraY));
    }

    private double getVal(Slider s) {
        return s == null ? Double.NaN : s.getVal(this.fStep);
    }

    private class Slider {
        double start;
        double delta;
        double value;

        Slider(double start, double value) {
            this.start = start;
            this.value = value;
            this.delta = value - start;
        }

        double getVal(double fStep) {
            return fStep < 0.0 ? this.value : this.start + fStep * this.delta;
        }
    }
}

