/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.MeasureD;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.symmetry.CIPChirality;
import org.jmol.symmetry.CIPData;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Node;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.Viewer;

public class CIPDataSmiles
extends CIPData {
    String smiles = null;
    private Node[] nodes = new Node[6];

    @Override
    boolean isSmiles() {
        return true;
    }

    public CIPDataSmiles setAtomsForSmiles(Viewer vwr, String smiles) throws Exception {
        this.vwr = vwr;
        this.smiles = smiles;
        this.atoms = vwr.getSmilesAtoms(smiles);
        this.bsAtoms = BSUtil.newBitSet2(0, this.atoms.length);
        this.bsMolecule = (BS)this.bsAtoms.clone();
        this.init();
        return this;
    }

    @Override
    protected BS[] getList(String smarts) throws Exception {
        return this.vwr.getSubstructureSetArrayForNodes(smarts, (Node[])this.atoms, 2);
    }

    @Override
    protected BS match(String smarts) throws Exception {
        return this.vwr.getSmartsMatchForNodes(smarts, (Node[])this.atoms);
    }

    @Override
    int getBondOrder(SimpleEdge bond) {
        return ((SmilesBond)bond).getRealCovalentOrder();
    }

    @Override
    int isCis(CIPChirality.CIPAtom a, CIPChirality.CIPAtom b, CIPChirality.CIPAtom c, CIPChirality.CIPAtom d) {
        int stereo1 = this.getStereoEdge(b.atom, a.atom);
        int stereo2 = this.getStereoEdge(c.atom, d.atom);
        return stereo1 == 0 || stereo2 == 0 ? 0 : (stereo1 != stereo2 ? 14 : 13);
    }

    private int getStereoEdge(SimpleNode atom, SimpleNode winner) {
        SimpleEdge[] edges = atom.getEdges();
        int order = 0;
        int i = edges.length;
        while (--i >= 0) {
            SmilesBond edge = (SmilesBond)edges[i];
            order = edge.getCovalentOrder();
            switch (order) {
                case 1025: {
                    return edge.getOtherNode(atom) == winner == (edge.getAtom1() == atom) ? 1041 : order;
                }
                case 1041: {
                    return edges[i].getOtherNode(atom) == winner == (edge.getAtom1() == atom) ? 1025 : order;
                }
            }
        }
        return 0;
    }

    @Override
    int isPositiveTorsion(CIPChirality.CIPAtom a, CIPChirality.CIPAtom b, CIPChirality.CIPAtom c, CIPChirality.CIPAtom d) {
        SmilesAtom center = this.findCumulativeCenter(b, c);
        if (center == null) {
            return 0;
        }
        Node[] jn = center.stereo.getAlleneAtoms(false, null, center, (SmilesAtom)b.atom);
        if (jn == null) {
            return 0;
        }
        center.stereo.setTopoCoordinates(center, null, null, jn, false);
        double angle = MeasureD.computeTorsion(jn[0].getXYZ(), jn[1].getXYZ(), jn[2].getXYZ(), jn[3].getXYZ(), true);
        return angle > 0.0 == (a.atom.getIndex() == jn[0].getIndex() && d.atom.getIndex() == jn[3].getIndex() || a.atom.getIndex() == jn[1].getIndex() && d.atom.getIndex() == jn[2].getIndex()) ? 18 : 17;
    }

    private SmilesAtom findCumulativeCenter(CIPChirality.CIPAtom a, CIPChirality.CIPAtom a2) {
        SimpleNode center = a.atom;
        SimpleNode c = null;
        SimpleNode b = null;
        while (center != null && center != a2.atom) {
            SimpleEdge[] edges = center.getEdges();
            int i = edges.length;
            while (--i >= 0) {
                if (edges[i].getCovalentOrder() != 2 || (c = edges[i].getOtherNode(center)) == b) continue;
                SmilesAtom sa = (SmilesAtom)c;
                if (sa.stereo == null) continue;
                return sa;
            }
            b = center;
            center = c;
        }
        return null;
    }

    @Override
    boolean setCoord(SimpleNode atom, CIPChirality.CIPAtom[] atoms) {
        SmilesAtom a = (SmilesAtom)atom;
        if (a.stereo == null) {
            return false;
        }
        Edge[] edges = a.getEdges();
        int i = edges.length;
        while (--i >= 0) {
            this.nodes[i] = (Node)edges[i].getOtherNode(a);
        }
        a.stereo.setTopoCoordinates(a, null, null, this.nodes, false);
        return true;
    }

    public String[] getSmilesChiralityArray() {
        Lst<String> chirality = new Lst<String>();
        for (int i = 0; i < this.atoms.length; ++i) {
            SmilesAtom a = (SmilesAtom)this.atoms[i];
            int pt = a.getPatternIndex();
            if (pt < 0) continue;
            String c = a.getCIPChirality(false);
            chirality.addLast(c);
        }
        return chirality.toArray(new String[chirality.size()]);
    }
}

