/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.Hashtable;
import javajs.util.MeasureD;
import javajs.util.P3d;
import javajs.util.T3d;
import javajs.util.V3d;
import org.jmol.shape.Mesh;
import org.jmol.shapesurface.Isosurface;

public class Pmesh
extends Isosurface {
    @Override
    public void initShape() {
        super.initShape();
        this.myType = "pmesh";
    }

    @Override
    public Object getProperty(String property, int index) {
        if (property == "face") {
            Mesh m = this.currentMesh;
            if (index >= 0 && (index >= this.meshCount || (m = this.meshes[index]) == null)) {
                return null;
            }
            return m == null ? null : this.getFace(m);
        }
        return this.getPropI(property, index);
    }

    private P3d[] getFace(Mesh m) {
        int[] edge;
        int v0;
        if (m.haveQuads) {
            return null;
        }
        T3d[] vs = m.vs;
        Hashtable<String, int[]> htEdges = new Hashtable<String, int[]>();
        int v1 = 0;
        int n = 0;
        int[] edge0 = null;
        int i = m.pc;
        while (--i >= 0) {
            if (m.bsSlabDisplay != null && !m.bsSlabDisplay.get(i)) continue;
            int[] triangle = m.pis[i];
            int mask = triangle[3];
            for (int j = 0; j < 3; ++j) {
                if ((mask & 1 << j) == 0) continue;
                v1 = triangle[j];
                int v2 = triangle[(j + 1) % 3];
                String key = v2 + "_" + v1;
                if (htEdges.containsKey(key)) {
                    htEdges.remove(key);
                    --n;
                    continue;
                }
                ++n;
                edge0 = new int[]{v1, v2};
                htEdges.put(v1 + "_" + v2, edge0);
                htEdges.put("" + v1, edge0);
            }
        }
        if (n == 0) {
            return null;
        }
        int[][] a = new int[n][2];
        a[0] = edge0;
        V3d vectorBA = new V3d();
        V3d vectorBC = new V3d();
        int v01 = v0 = a[0][0];
        v1 = a[0][1];
        int pt = 0;
        double min = 1.0E-4f;
        while (v1 != v0 && (edge = (int[])htEdges.get("" + v1)) != null) {
            double angle = MeasureD.computeAngle(vs[v01], vs[v1], vs[edge[1]], vectorBA, vectorBC, true);
            double d2 = vs[v1].distanceSquared(vs[edge[1]]);
            v1 = edge[1];
            if (angle < 179.0 && d2 > min) {
                a[++pt] = edge;
                v01 = edge[0];
                continue;
            }
            a[pt][1] = v1;
        }
        if (MeasureD.computeAngle(vs[v01], vs[v1], vs[a[0][1]], vectorBA, vectorBC, true) >= 179.0 || vs[v1].distanceSquared(vs[a[0][1]]) <= min) {
            a[0][0] = a[pt--][0];
        }
        n = pt < 0 ? 1 : ++pt;
        P3d[] pts = new P3d[n];
        for (int i2 = 0; i2 < n; ++i2) {
            pts[i2] = P3d.newP(vs[a[i2][0]]);
        }
        return pts;
    }
}

